/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.util.List;
import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.calculos.CalculosRendIsentos;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.Valor;

public class RendIsentos
extends ObjetoNegocio {
    public static final String LIMITE_ISENCAO_APOSENTADORIA = "24.751,74";
    private ColecaoItemQuadroOutrosRendimentos bolsaEstudosQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos residenciaPronatecQuadroAuxiliar;
    private Valor capitalApolices = new Valor();
    private Valor totalIndenizacoes = new Valor();
    private ColecaoItemQuadroOutrosRendimentos indenizacoesQuadroAuxiliar;
    private Valor bensPequenoValorInformado = new Valor(this, "");
    private Valor bensPequenoValorTransportado = new Valor(this, "");
    private Valor unicoImovelInformado = new Valor(this, "");
    private Valor unicoImovelTransportado = new Valor(this, "");
    private Valor outrosBensImoveisInformado = new Valor(this, "");
    private Valor outrosBensImoveisTransportado = new Valor(this, "");
    private Valor moedaEstrangeiraEspecieInformado = new Valor(this, "");
    private Valor moedaEstrangeiraEspecieTransportado = new Valor(this, "");
    private Valor totalLucroAlienacaoInformado = new Valor();
    private Valor totalLucroAlienacaoTransportado = new Valor();
    private Valor totalLucroAlienacao = new Valor();
    private ColecaoItemQuadroOutrosRendimentos lucroRecebidoQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos parcIsentaAposentadoriaQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos pensaoQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos poupancaQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos rendSocioQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos transferenciasQuadroAuxiliar;
    private Valor parcIsentaAtivRural = new Valor();
    private ColecaoItemQuadroOutrosRendimentos IRPFAntCompJudQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos rendAssalMoedaEstrangQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos incorpReservasCapitalQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos meacaoDissolucaoQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos ganhosLiqAcoesQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos ganhosCapOuroQuadroAuxiliar;
    private Valor recuperacaoPrejuizosBolsaValores = new Valor();
    private Valor transporteCargas = new Valor();
    private Valor transportePassageiros = new Valor();
    private Valor restitIRPFAnt = new Valor();
    private ColecaoItemQuadroOutrosRendimentos outrosQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos pensaoAlimenticiaQuadroAuxiliar;
    private Valor total = new Valor();
    private Valor totalTitular = new Valor();
    private Valor totalDependentes = new Valor();

    public RendIsentos(DeclaracaoIRPF declaracaoIRPF) {
        this.bolsaEstudosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Bolsas de Estudos");
        this.residenciaPronatecQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Bolsas de resid\u00eancia m\u00e9dica ou Pronatec");
        this.indenizacoesQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Indeniza\u00e7\u00f5es trabalhistas");
        this.lucroRecebidoQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Lucros e Dividendos");
        this.parcIsentaAposentadoriaQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Parcela isenta da aposentadoria");
        this.pensaoQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Pens\u00e3o, aposentadoria, por mol\u00e9stia grave ou acidente");
        this.poupancaQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Cadernetas de Poupan\u00e7a e Letras Hipotec\u00e1rias");
        this.rendSocioQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "S\u00f3cio ou titular de empresa simples");
        this.transferenciasQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Doa\u00e7oes e heran\u00e7as");
        this.IRPFAntCompJudQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Imposto de anos anteriores compensado judicialmente");
        this.rendAssalMoedaEstrangQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "75% do rendimento assalariado em moeda estrangeira");
        this.incorpReservasCapitalQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Incorpora\u00e7\u00e3o de reservas de capital / bonifica\u00e7\u00f5es em a\u00e7\u00f5es");
        this.meacaoDissolucaoQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Transfer\u00eancia patrimonial por mea\u00e7\u00e3o e div\u00f3rcio");
        this.ganhosLiqAcoesQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Ganhos l\u00edquidos de a\u00e7\u00f5es");
        this.ganhosCapOuroQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Ganhos l\u00edquidos em opera\u00e7\u00f5es com ouro");
        this.outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Outros rendimentos isentos");
        this.pensaoAlimenticiaQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Pens\u00e3o aliment\u00edcia");
        this.getTotal().setReadOnly(true);
        this.getTotalTitular().setReadOnly(true);
        this.getTotalDependentes().setReadOnly(true);
        this.getParcIsentaAtivRural().setReadOnly(true);
        this.getLucroRecebido().setReadOnly(true);
        this.getBensPequenoValorTransportado().setHabilitado(false);
        this.getUnicoImovelTransportado().setHabilitado(false);
        this.getOutrosBensImoveisTransportado().setHabilitado(false);
        this.getMoedaEstrangeiraEspecieTransportado().setHabilitado(false);
        this.getTotalInformado().setHabilitado(false);
        this.getTotalTransportado().setHabilitado(false);
        this.getParcIsentaAposentadoria().addValidador(new ValidadorImpeditivoDefault(this.tab.msg("rendisentos_aposentadoria_limite", new String[]{LIMITE_ISENCAO_APOSENTADORIA})){

            public RetornoValidacao validarImplementado() {
                Valor valor = new Valor((String)this.getProximoConteudo());
                if (valor.comparacao(">", RendIsentos.LIMITE_ISENCAO_APOSENTADORIA)) {
                    this.setTipoExibicao(0);
                    this.setSeveridade((byte)5);
                    return new RetornoValidacao(tab.msg("rendisentos_aposentadoria_limite", new String[]{RendIsentos.LIMITE_ISENCAO_APOSENTADORIA}));
                }
                return null;
            }

            public void acaoOk() {
            }

            public void acaoCancelar() {
            }

            public String getTituloPopup() {
                return RendIsentos.this.getParcIsentaAposentadoria().getNomeCampo();
            }
        });
        this.getLucroRecebido().addValidador(new ValidadorDefault(2){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos : RendIsentos.this.lucroRecebidoQuadroAuxiliar.recuperarLista()) {
                    if (!itemQuadroOutrosRendimentos.getNomeFonte().isVazio()) continue;
                    return new RetornoValidacao(tab.msg("nome_fonte_pagadora_ausente"), 2);
                }
                return null;
            }
        });
        this.setFicha("Rendimentos Isentos e N\u00e3o-Tribut\u00e1veis");
    }

    public void addObservador(CalculosRendIsentos calculosRendIsentos) {
        this.bolsaEstudosQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.residenciaPronatecQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.capitalApolices.addObservador(calculosRendIsentos);
        this.indenizacoesQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.bensPequenoValorInformado.addObservador(calculosRendIsentos);
        this.bensPequenoValorTransportado.addObservador(calculosRendIsentos);
        this.unicoImovelInformado.addObservador(calculosRendIsentos);
        this.unicoImovelTransportado.addObservador(calculosRendIsentos);
        this.outrosBensImoveisInformado.addObservador(calculosRendIsentos);
        this.outrosBensImoveisTransportado.addObservador(calculosRendIsentos);
        this.moedaEstrangeiraEspecieInformado.addObservador(calculosRendIsentos);
        this.moedaEstrangeiraEspecieTransportado.addObservador(calculosRendIsentos);
        this.totalLucroAlienacao.addObservador(calculosRendIsentos);
        this.lucroRecebidoQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.parcIsentaAtivRural.addObservador(calculosRendIsentos);
        this.parcIsentaAposentadoriaQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.pensaoQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.poupancaQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.rendSocioQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.transferenciasQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.parcIsentaAtivRural.addObservador(calculosRendIsentos);
        this.IRPFAntCompJudQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.rendAssalMoedaEstrangQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.incorpReservasCapitalQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.meacaoDissolucaoQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.ganhosLiqAcoesQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.ganhosCapOuroQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.recuperacaoPrejuizosBolsaValores.addObservador(calculosRendIsentos);
        this.transporteCargas.addObservador(calculosRendIsentos);
        this.transportePassageiros.addObservador(calculosRendIsentos);
        this.restitIRPFAnt.addObservador(calculosRendIsentos);
        this.outrosQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
        this.pensaoAlimenticiaQuadroAuxiliar.getTotais().addObservador(calculosRendIsentos);
    }

    public ColecaoItemQuadroOutrosRendimentos getBolsaEstudosQuadroAuxiliar() {
        return this.bolsaEstudosQuadroAuxiliar;
    }

    public Valor getBolsaEstudos() {
        return this.getBolsaEstudosQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getResidenciaPronatecQuadroAuxiliar() {
        return this.residenciaPronatecQuadroAuxiliar;
    }

    public Valor getResidenciaPronatec() {
        return this.getResidenciaPronatecQuadroAuxiliar().getTotais();
    }

    public Valor getCapitalApolices() {
        return this.capitalApolices;
    }

    public ColecaoItemQuadroOutrosRendimentos getIndenizacoesQuadroAuxiliar() {
        return this.indenizacoesQuadroAuxiliar;
    }

    public Valor getIndenizacoes() {
        return this.getIndenizacoesQuadroAuxiliar().getTotais();
    }

    public Valor getBensPequenoValorInformado() {
        return this.bensPequenoValorInformado;
    }

    public Valor getBensPequenoValorTransportado() {
        return this.bensPequenoValorTransportado;
    }

    public Valor getUnicoImovelInformado() {
        return this.unicoImovelInformado;
    }

    public Valor getUnicoImovelTransportado() {
        return this.unicoImovelTransportado;
    }

    public Valor getOutrosBensImoveisInformado() {
        return this.outrosBensImoveisInformado;
    }

    public Valor getOutrosBensImoveisTransportado() {
        return this.outrosBensImoveisTransportado;
    }

    public Valor getMoedaEstrangeiraEspecieInformado() {
        return this.moedaEstrangeiraEspecieInformado;
    }

    public Valor getMoedaEstrangeiraEspecieTransportado() {
        return this.moedaEstrangeiraEspecieTransportado;
    }

    public Valor getTotalInformado() {
        return this.totalLucroAlienacaoInformado;
    }

    public Valor getTotalTransportado() {
        return this.totalLucroAlienacaoTransportado;
    }

    public Valor getLucroAlienacao() {
        return this.totalLucroAlienacao;
    }

    public ColecaoItemQuadroOutrosRendimentos getLucroRecebidoQuadroAuxiliar() {
        return this.lucroRecebidoQuadroAuxiliar;
    }

    public Valor getLucroRecebido() {
        return this.getLucroRecebidoQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getParcIsentaAposentadoriaQuadroAuxiliar() {
        return this.parcIsentaAposentadoriaQuadroAuxiliar;
    }

    public Valor getParcIsentaAposentadoria() {
        return this.getParcIsentaAposentadoriaQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getPensaoQuadroAuxiliar() {
        return this.pensaoQuadroAuxiliar;
    }

    public Valor getPensao() {
        return this.getPensaoQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getPoupancaQuadroAuxiliar() {
        return this.poupancaQuadroAuxiliar;
    }

    public Valor getPoupanca() {
        return this.getPoupancaQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getRendSocioQuadroAuxiliar() {
        return this.rendSocioQuadroAuxiliar;
    }

    public Valor getRendSocio() {
        return this.getRendSocioQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getTransferenciasQuadroAuxiliar() {
        return this.transferenciasQuadroAuxiliar;
    }

    public Valor getTransferencias() {
        return this.getTransferenciasQuadroAuxiliar().getTotais();
    }

    public Valor getParcIsentaAtivRural() {
        return this.parcIsentaAtivRural;
    }

    public ColecaoItemQuadroOutrosRendimentos getIRPFAntCompJudQuadroAuxiliar() {
        return this.IRPFAntCompJudQuadroAuxiliar;
    }

    public Valor getIRPFAntCompJud() {
        return this.getIRPFAntCompJudQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getRendAssalMoedaEstrangQuadroAuxiliar() {
        return this.rendAssalMoedaEstrangQuadroAuxiliar;
    }

    public Valor getRendAssalMoedaEstrang() {
        return this.getRendAssalMoedaEstrangQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getIncorpReservasCapitalQuadroAuxiliar() {
        return this.incorpReservasCapitalQuadroAuxiliar;
    }

    public Valor getIncorpReservasCapital() {
        return this.getIncorpReservasCapitalQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getMeacaoDissolucaoQuadroAuxiliar() {
        return this.meacaoDissolucaoQuadroAuxiliar;
    }

    public Valor getMeacaoDissolucao() {
        return this.getMeacaoDissolucaoQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getGanhosLiqAcoesQuadroAuxiliar() {
        return this.ganhosLiqAcoesQuadroAuxiliar;
    }

    public Valor getGanhosLiqAcoes() {
        return this.getGanhosLiqAcoesQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getGanhosCapOuroQuadroAuxiliar() {
        return this.ganhosCapOuroQuadroAuxiliar;
    }

    public Valor getGanhosCapOuro() {
        return this.getGanhosCapOuroQuadroAuxiliar().getTotais();
    }

    public Valor getRecuperacaoPrejuizosBolsaValores() {
        return this.recuperacaoPrejuizosBolsaValores;
    }

    public Valor getTransporteCargas() {
        return this.transporteCargas;
    }

    public Valor getTransportePassageiros() {
        return this.transportePassageiros;
    }

    public Valor getRestitIRPFAnt() {
        return this.restitIRPFAnt;
    }

    public ColecaoItemQuadroOutrosRendimentos getOutrosQuadroAuxiliar() {
        return this.outrosQuadroAuxiliar;
    }

    public Valor getOutros() {
        return this.getOutrosQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getPensaoAlimenticiaQuadroAuxiliar() {
        return this.pensaoAlimenticiaQuadroAuxiliar;
    }

    public Valor getPensaoAlimenticia() {
        return this.getPensaoAlimenticiaQuadroAuxiliar().getTotais();
    }

    public Valor getTotal() {
        return this.total;
    }

    public Valor getTotalTitular() {
        return this.totalTitular;
    }

    public Valor getTotalDependentes() {
        return this.totalDependentes;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getLucroRecebido());
        return list;
    }

    public Valor recuperarTotalTitularExcetoAtividadeRuraleGC() {
        return this.getTotalTitular().operacao('-', this.recuperarSubTotalRendIsentoTransportado()).operacao('-', this.getTotalInformado());
    }

    public Valor recuperarSubTotalRendIsentoTransportado() {
        Valor valor = new Valor();
        valor.append('+', this.getParcIsentaAtivRural());
        valor.append('+', this.getTotalTransportado());
        return valor;
    }

    public Valor recuperarTotalLucrosDividendosTit() {
        return this.getLucroRecebidoQuadroAuxiliar().getTotaisTitular();
    }

    public Valor recuperarTotalLucrosDividendosDep() {
        return this.getLucroRecebidoQuadroAuxiliar().getTotaisDependentes();
    }
}

