/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class XYPlot
extends Plot
implements ValueAxisPlot,
Zoomable,
RendererChangeListener,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 7044148245716569264L;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private ObjectList domainAxes;
    private ObjectList domainAxisLocations;
    private ObjectList rangeAxes;
    private ObjectList rangeAxisLocations;
    private ObjectList datasets;
    private ObjectList renderers;
    private Map datasetToDomainAxisMap;
    private Map datasetToRangeAxisMap;
    private transient Point2D quadrantOrigin = new Point2D.Double(0.0, 0.0);
    private transient Paint[] quadrantPaint = new Paint[4];
    private boolean domainGridlinesVisible;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean domainZeroBaselineVisible;
    private transient Stroke domainZeroBaselineStroke;
    private transient Paint domainZeroBaselinePaint;
    private boolean rangeZeroBaselineVisible;
    private transient Stroke rangeZeroBaselineStroke;
    private transient Paint rangeZeroBaselinePaint;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List annotations;
    private transient Paint domainTickBandPaint;
    private transient Paint rangeTickBandPaint;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private DatasetRenderingOrder datasetRenderingOrder = DatasetRenderingOrder.REVERSE;
    private SeriesRenderingOrder seriesRenderingOrder = SeriesRenderingOrder.REVERSE;
    private int weight = 1;
    private LegendItemCollection fixedLegendItems;

    public XYPlot() {
        this(null, null, null, null);
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.domainAxes = new ObjectList();
        this.domainAxisLocations = new ObjectList();
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.rangeAxes = new ObjectList();
        this.rangeAxisLocations = new ObjectList();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        this.datasets = new ObjectList();
        this.renderers = new ObjectList();
        this.datasetToDomainAxisMap = new TreeMap();
        this.datasetToRangeAxisMap = new TreeMap();
        this.datasets.set(0, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        this.renderers.set(0, xYItemRenderer);
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            xYItemRenderer.addChangeListener(this);
        }
        this.domainAxes.set(0, valueAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.domainAxisLocations.set(0, AxisLocation.BOTTOM_OR_LEFT);
        this.rangeAxes.set(0, valueAxis2);
        this.mapDatasetToRangeAxis(0, 0);
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.rangeAxisLocations.set(0, AxisLocation.BOTTOM_OR_LEFT);
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = true;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.domainZeroBaselineVisible = false;
        this.domainZeroBaselinePaint = Color.black;
        this.domainZeroBaselineStroke = new BasicStroke(0.5f);
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeZeroBaselineVisible = false;
        this.rangeZeroBaselinePaint = Color.black;
        this.rangeZeroBaselineStroke = new BasicStroke(0.5f);
        this.domainCrosshairVisible = false;
        this.domainCrosshairValue = 0.0;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.annotations = new ArrayList();
    }

    public String getPlotType() {
        return localizationResources.getString("XY_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (plotOrientation != this.orientation) {
            this.orientation = plotOrientation;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = rectangleInsets;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public ValueAxis getDomainAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.domainAxes.size()) {
            valueAxis = (ValueAxis)this.domainAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getDomainAxis(n);
        }
        return valueAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) {
        this.setDomainAxis(0, valueAxis);
    }

    public void setDomainAxis(int n, ValueAxis valueAxis) {
        this.setDomainAxis(n, valueAxis, true);
    }

    public void setDomainAxis(int n, ValueAxis valueAxis, boolean bl) {
        ValueAxis valueAxis2 = this.getDomainAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.domainAxes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setDomainAxes(ValueAxis[] valueAxisArray) {
        int n = 0;
        while (n < valueAxisArray.length) {
            this.setDomainAxis(n, valueAxisArray[n], false);
            ++n;
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getDomainAxisLocation() {
        return (AxisLocation)this.domainAxisLocations.get(0);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(0, axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl) {
        this.setDomainAxisLocation(0, axisLocation, bl);
    }

    public RectangleEdge getDomainAxisEdge() {
        return Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        int n = 0;
        while (n < this.domainAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(n);
            if (valueAxis != null) {
                valueAxis.removeChangeListener(this);
            }
            ++n;
        }
        this.domainAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureDomainAxes() {
        int n = 0;
        while (n < this.domainAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(n);
            if (valueAxis != null) {
                valueAxis.configure();
            }
            ++n;
        }
    }

    public AxisLocation getDomainAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.domainAxisLocations.size()) {
            axisLocation = (AxisLocation)this.domainAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getDomainAxisLocation());
        }
        return axisLocation;
    }

    public void setDomainAxisLocation(int n, AxisLocation axisLocation) {
        this.setDomainAxisLocation(n, axisLocation, true);
    }

    public void setDomainAxisLocation(int n, AxisLocation axisLocation, boolean bl) {
        if (n == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.domainAxisLocations.set(n, axisLocation);
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public RectangleEdge getDomainAxisEdge(int n) {
        AxisLocation axisLocation = this.getDomainAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getDomainAxisEdge());
        }
        return rectangleEdge;
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        ValueAxis valueAxis2;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        if ((valueAxis2 = this.getRangeAxis()) != null) {
            valueAxis2.removeChangeListener(this);
        }
        this.rangeAxes.set(0, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getRangeAxisLocation() {
        return (AxisLocation)this.rangeAxisLocations.get(0);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(0, axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl) {
        this.setRangeAxisLocation(0, axisLocation, bl);
    }

    public RectangleEdge getRangeAxisEdge() {
        return Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
    }

    public ValueAxis getRangeAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.rangeAxes.size()) {
            valueAxis = (ValueAxis)this.rangeAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getRangeAxis(n);
        }
        return valueAxis;
    }

    public void setRangeAxis(int n, ValueAxis valueAxis) {
        this.setRangeAxis(n, valueAxis, true);
    }

    public void setRangeAxis(int n, ValueAxis valueAxis, boolean bl) {
        ValueAxis valueAxis2 = this.getRangeAxis(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.rangeAxes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setRangeAxes(ValueAxis[] valueAxisArray) {
        int n = 0;
        while (n < valueAxisArray.length) {
            this.setRangeAxis(n, valueAxisArray[n], false);
            ++n;
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        int n = 0;
        while (n < this.rangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
            if (valueAxis != null) {
                valueAxis.removeChangeListener(this);
            }
            ++n;
        }
        this.rangeAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureRangeAxes() {
        int n = 0;
        while (n < this.rangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
            if (valueAxis != null) {
                valueAxis.configure();
            }
            ++n;
        }
    }

    public AxisLocation getRangeAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.rangeAxisLocations.size()) {
            axisLocation = (AxisLocation)this.rangeAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getRangeAxisLocation());
        }
        return axisLocation;
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation) {
        this.setRangeAxisLocation(n, axisLocation, true);
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation, boolean bl) {
        if (n == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.rangeAxisLocations.set(n, axisLocation);
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public RectangleEdge getRangeAxisEdge(int n) {
        AxisLocation axisLocation = this.getRangeAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getRangeAxisEdge());
        }
        return rectangleEdge;
    }

    public XYDataset getDataset() {
        return this.getDataset(0);
    }

    public XYDataset getDataset(int n) {
        XYDataset xYDataset = null;
        if (this.datasets.size() > n) {
            xYDataset = (XYDataset)this.datasets.get(n);
        }
        return xYDataset;
    }

    public void setDataset(XYDataset xYDataset) {
        this.setDataset(0, xYDataset);
    }

    public void setDataset(int n, XYDataset xYDataset) {
        XYDataset xYDataset2 = this.getDataset(n);
        if (xYDataset2 != null) {
            xYDataset2.removeChangeListener(this);
        }
        this.datasets.set(n, xYDataset);
        if (xYDataset != null) {
            xYDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, xYDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(XYDataset xYDataset) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.datasets.size()) {
            if (xYDataset == this.datasets.get(n2)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public void mapDatasetToDomainAxis(int n, int n2) {
        this.datasetToDomainAxisMap.put(new Integer(n), new Integer(n2));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    public void mapDatasetToRangeAxis(int n, int n2) {
        this.datasetToRangeAxisMap.put(new Integer(n), new Integer(n2));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    public XYItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public XYItemRenderer getRenderer(int n) {
        XYItemRenderer xYItemRenderer = null;
        if (this.renderers.size() > n) {
            xYItemRenderer = (XYItemRenderer)this.renderers.get(n);
        }
        return xYItemRenderer;
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        this.setRenderer(0, xYItemRenderer);
    }

    public void setRenderer(int n, XYItemRenderer xYItemRenderer) {
        this.setRenderer(n, xYItemRenderer, true);
    }

    public void setRenderer(int n, XYItemRenderer xYItemRenderer, boolean bl) {
        XYItemRenderer xYItemRenderer2 = this.getRenderer(n);
        if (xYItemRenderer2 != null) {
            xYItemRenderer2.removeChangeListener(this);
        }
        this.renderers.set(n, xYItemRenderer);
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            xYItemRenderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setRenderers(XYItemRenderer[] xYItemRendererArray) {
        int n = 0;
        while (n < xYItemRendererArray.length) {
            this.setRenderer(n, xYItemRendererArray[n], false);
            ++n;
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.datasetRenderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        if (datasetRenderingOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.datasetRenderingOrder = datasetRenderingOrder;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public SeriesRenderingOrder getSeriesRenderingOrder() {
        return this.seriesRenderingOrder;
    }

    public void setSeriesRenderingOrder(SeriesRenderingOrder seriesRenderingOrder) {
        if (seriesRenderingOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.seriesRenderingOrder = seriesRenderingOrder;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getIndexOf(XYItemRenderer xYItemRenderer) {
        return this.renderers.indexOf(xYItemRenderer);
    }

    public XYItemRenderer getRendererForDataset(XYDataset xYDataset) {
        XYItemRenderer xYItemRenderer = null;
        int n = 0;
        while (n < this.datasets.size()) {
            if (this.datasets.get(n) == xYDataset) {
                xYItemRenderer = (XYItemRenderer)this.renderers.get(n);
                if (xYItemRenderer != null) break;
                xYItemRenderer = this.getRenderer();
                break;
            }
            ++n;
        }
        return xYItemRenderer;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainZeroBaselineVisible() {
        return this.domainZeroBaselineVisible;
    }

    public void setDomainZeroBaselineVisible(boolean bl) {
        this.domainZeroBaselineVisible = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getDomainZeroBaselineStroke() {
        return this.domainZeroBaselineStroke;
    }

    public void setDomainZeroBaselineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainZeroBaselineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainZeroBaselinePaint() {
        return this.domainZeroBaselinePaint;
    }

    public void setDomainZeroBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainZeroBaselinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeZeroBaselineVisible() {
        return this.rangeZeroBaselineVisible;
    }

    public void setRangeZeroBaselineVisible(boolean bl) {
        this.rangeZeroBaselineVisible = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getRangeZeroBaselineStroke() {
        return this.rangeZeroBaselineStroke;
    }

    public void setRangeZeroBaselineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeZeroBaselineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeZeroBaselinePaint() {
        return this.rangeZeroBaselinePaint;
    }

    public void setRangeZeroBaselinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeZeroBaselinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainTickBandPaint() {
        return this.domainTickBandPaint;
    }

    public void setDomainTickBandPaint(Paint paint) {
        this.domainTickBandPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeTickBandPaint() {
        return this.rangeTickBandPaint;
    }

    public void setRangeTickBandPaint(Paint paint) {
        this.rangeTickBandPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Point2D getQuadrantOrigin() {
        return this.quadrantOrigin;
    }

    public void setQuadrantOrigin(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException("Null 'origin' argument.");
        }
        this.quadrantOrigin = point2D;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getQuadrantPaint(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("The index should be in the range 0 to 3.");
        }
        return this.quadrantPaint[n];
    }

    public void setQuadrantPaint(int n, Paint paint) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("The index should be in the range 0 to 3.");
        }
        this.quadrantPaint[n] = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addDomainMarker(Marker marker) {
        this.addDomainMarker(marker, Layer.FOREGROUND);
    }

    public void addDomainMarker(Marker marker, Layer layer) {
        this.addDomainMarker(0, marker, layer);
    }

    public void clearDomainMarkers() {
        Set set;
        if (this.backgroundDomainMarkers != null) {
            set = this.backgroundDomainMarkers.keySet();
            for (Integer n : set) {
                this.clearDomainMarkers(n);
            }
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            set = this.foregroundDomainMarkers.keySet();
            for (Integer n : set) {
                this.clearDomainMarkers(n);
            }
            this.foregroundDomainMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearDomainMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundDomainMarkers != null && (collection = (Collection)this.backgroundDomainMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundDomainMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addDomainMarker(int n, Marker marker, Layer layer) {
        if (marker == null) {
            throw new IllegalArgumentException("Null 'marker' not permitted.");
        }
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' not permitted.");
        }
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundDomainMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundDomainMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundDomainMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundDomainMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        marker.addChangeListener(this);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void clearRangeMarkers() {
        Set set;
        if (this.backgroundRangeMarkers != null) {
            set = this.backgroundRangeMarkers.keySet();
            for (Integer n : set) {
                this.clearRangeMarkers(n);
            }
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            set = this.foregroundRangeMarkers.keySet();
            for (Integer n : set) {
                this.clearRangeMarkers(n);
            }
            this.foregroundRangeMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addRangeMarker(int n, Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        marker.addChangeListener(this);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundRangeMarkers != null && (collection = (Collection)this.backgroundRangeMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundRangeMarkers.get(n2)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addAnnotation(XYAnnotation xYAnnotation) {
        if (xYAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        this.annotations.add(xYAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean removeAnnotation(XYAnnotation xYAnnotation) {
        if (xYAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        boolean bl = this.annotations.remove(xYAnnotation);
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
        return bl;
    }

    public List getAnnotations() {
        return new ArrayList(this.annotations);
    }

    public void clearAnnotations() {
        this.annotations.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D, axisSpace);
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        return axisSpace;
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block5: {
            block3: {
                block4: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block5;
            }
            int n = 0;
            while (n < this.domainAxes.size()) {
                Axis axis = (Axis)this.domainAxes.get(n);
                if (axis != null) {
                    RectangleEdge rectangleEdge = this.getDomainAxisEdge(n);
                    axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
                }
                ++n;
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block5: {
            block3: {
                block4: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block5;
            }
            int n = 0;
            while (n < this.rangeAxes.size()) {
                Axis axis = (Axis)this.rangeAxes.get(n);
                if (axis != null) {
                    RectangleEdge rectangleEdge = this.getRangeAxisEdge(n);
                    axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
                }
                ++n;
            }
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Object object;
        ValueAxis valueAxis;
        ValueAxis valueAxis2;
        Object object2;
        int n;
        int n2;
        AxisState axisState;
        Object object3;
        Object object4;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        Map map = this.drawAxes(graphics2D, rectangle2D, rectangle2D2, plotRenderingInfo);
        PlotOrientation plotOrientation = this.getOrientation();
        if (point2D != null && !rectangle2D2.contains(point2D)) {
            point2D = null;
        }
        CrosshairState crosshairState = new CrosshairState();
        crosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairState.setAnchor(point2D);
        crosshairState.setAnchorX(Double.NaN);
        crosshairState.setAnchorY(Double.NaN);
        if (point2D != null) {
            object4 = this.getDomainAxis();
            if (object4 != null) {
                double d = plotOrientation == PlotOrientation.VERTICAL ? ((ValueAxis)object4).java2DToValue(point2D.getX(), rectangle2D2, this.getDomainAxisEdge()) : ((ValueAxis)object4).java2DToValue(point2D.getY(), rectangle2D2, this.getDomainAxisEdge());
                crosshairState.setAnchorX(d);
            }
            if ((object3 = this.getRangeAxis()) != null) {
                double d = plotOrientation == PlotOrientation.VERTICAL ? ((ValueAxis)object3).java2DToValue(point2D.getY(), rectangle2D2, this.getRangeAxisEdge()) : ((ValueAxis)object3).java2DToValue(point2D.getX(), rectangle2D2, this.getRangeAxisEdge());
                crosshairState.setAnchorY(d);
            }
        }
        crosshairState.setCrosshairX(this.getDomainCrosshairValue());
        crosshairState.setCrosshairY(this.getRangeCrosshairValue());
        object4 = graphics2D.getClip();
        object3 = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        AxisState axisState2 = (AxisState)map.get(this.getDomainAxis());
        if (axisState2 == null && plotState != null) {
            axisState2 = (AxisState)plotState.getSharedAxisStates().get(this.getDomainAxis());
        }
        if ((axisState = (AxisState)map.get(this.getRangeAxis())) == null && plotState != null) {
            axisState = (AxisState)plotState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (axisState2 != null) {
            this.drawDomainTickBands(graphics2D, rectangle2D2, axisState2.getTicks());
        }
        if (axisState != null) {
            this.drawRangeTickBands(graphics2D, rectangle2D2, axisState.getTicks());
        }
        if (axisState2 != null) {
            this.drawDomainGridlines(graphics2D, rectangle2D2, axisState2.getTicks());
            this.drawZeroDomainBaseline(graphics2D, rectangle2D2);
        }
        if (axisState != null) {
            this.drawRangeGridlines(graphics2D, rectangle2D2, axisState.getTicks());
            this.drawZeroRangeBaseline(graphics2D, rectangle2D2);
        }
        int n3 = 0;
        while (n3 < this.renderers.size()) {
            this.drawDomainMarkers(graphics2D, rectangle2D2, n3, Layer.BACKGROUND);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.renderers.size()) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n3, Layer.BACKGROUND);
            ++n3;
        }
        n3 = 0;
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        if (datasetRenderingOrder == DatasetRenderingOrder.FORWARD) {
            n2 = this.renderers.size();
            n = 0;
            while (n < n2) {
                object2 = this.getRenderer(n);
                if (object2 != null) {
                    valueAxis2 = this.getDomainAxisForDataset(n);
                    valueAxis = this.getRangeAxisForDataset(n);
                    object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis2, valueAxis, Layer.BACKGROUND, plotRenderingInfo);
                }
                ++n;
            }
            n = 0;
            while (n < this.getDatasetCount()) {
                n3 = !this.render(graphics2D, rectangle2D2, n, plotRenderingInfo, crosshairState) && n3 == 0 ? 0 : 1;
                ++n;
            }
            n = 0;
            while (n < n2) {
                object2 = this.getRenderer(n);
                if (object2 != null) {
                    valueAxis2 = this.getDomainAxisForDataset(n);
                    valueAxis = this.getRangeAxisForDataset(n);
                    object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis2, valueAxis, Layer.FOREGROUND, plotRenderingInfo);
                }
                ++n;
            }
        } else if (datasetRenderingOrder == DatasetRenderingOrder.REVERSE) {
            n2 = this.renderers.size();
            n = n2 - 1;
            while (n >= 0) {
                object2 = this.getRenderer(n);
                if (n < this.getDatasetCount() && object2 != null) {
                    valueAxis2 = this.getDomainAxisForDataset(n);
                    valueAxis = this.getRangeAxisForDataset(n);
                    object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis2, valueAxis, Layer.BACKGROUND, plotRenderingInfo);
                }
                --n;
            }
            n = this.getDatasetCount() - 1;
            while (n >= 0) {
                n3 = !this.render(graphics2D, rectangle2D2, n, plotRenderingInfo, crosshairState) && n3 == 0 ? 0 : 1;
                --n;
            }
            n = n2 - 1;
            while (n >= 0) {
                object2 = this.getRenderer(n);
                if (n < this.getDatasetCount() && object2 != null) {
                    valueAxis2 = this.getDomainAxisForDataset(n);
                    valueAxis = this.getRangeAxisForDataset(n);
                    object2.drawAnnotations(graphics2D, rectangle2D2, valueAxis2, valueAxis, Layer.FOREGROUND, plotRenderingInfo);
                }
                --n;
            }
        }
        n2 = crosshairState.getDomainAxisIndex();
        ValueAxis valueAxis3 = this.getDomainAxis(n2);
        object2 = this.getDomainAxisEdge(n2);
        if (!this.domainCrosshairLockedOnData && point2D != null) {
            double d = plotOrientation == PlotOrientation.VERTICAL ? valueAxis3.java2DToValue(point2D.getX(), rectangle2D2, (RectangleEdge)object2) : valueAxis3.java2DToValue(point2D.getY(), rectangle2D2, (RectangleEdge)object2);
            crosshairState.setCrosshairX(d);
        }
        this.setDomainCrosshairValue(crosshairState.getCrosshairX(), false);
        if (this.isDomainCrosshairVisible()) {
            double d = this.getDomainCrosshairValue();
            object = this.getDomainCrosshairPaint();
            Stroke stroke = this.getDomainCrosshairStroke();
            this.drawDomainCrosshair(graphics2D, rectangle2D2, plotOrientation, d, valueAxis3, stroke, (Paint)object);
        }
        int n4 = crosshairState.getRangeAxisIndex();
        valueAxis = this.getRangeAxis(n4);
        object = this.getRangeAxisEdge(n4);
        if (!this.rangeCrosshairLockedOnData && point2D != null) {
            double d = plotOrientation == PlotOrientation.VERTICAL ? valueAxis.java2DToValue(point2D.getY(), rectangle2D2, (RectangleEdge)object) : valueAxis.java2DToValue(point2D.getX(), rectangle2D2, (RectangleEdge)object);
            crosshairState.setCrosshairY(d);
        }
        this.setRangeCrosshairValue(crosshairState.getCrosshairY(), false);
        if (this.isRangeCrosshairVisible()) {
            double d = this.getRangeCrosshairValue();
            Paint paint = this.getRangeCrosshairPaint();
            Stroke stroke = this.getRangeCrosshairStroke();
            this.drawRangeCrosshair(graphics2D, rectangle2D2, plotOrientation, d, valueAxis, stroke, paint);
        }
        if (n3 == 0) {
            this.drawNoDataMessage(graphics2D, rectangle2D2);
        }
        int n5 = 0;
        while (n5 < this.renderers.size()) {
            this.drawDomainMarkers(graphics2D, rectangle2D2, n5, Layer.FOREGROUND);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.renderers.size()) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n5, Layer.FOREGROUND);
            ++n5;
        }
        this.drawAnnotations(graphics2D, rectangle2D2, plotRenderingInfo);
        graphics2D.setClip((Shape)object4);
        graphics2D.setComposite((Composite)object3);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.fillBackground(graphics2D, rectangle2D);
        this.drawQuadrants(graphics2D, rectangle2D);
        this.drawBackgroundImage(graphics2D, rectangle2D);
    }

    protected void drawQuadrants(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        boolean bl = false;
        ValueAxis valueAxis = this.getDomainAxis();
        double d = this.quadrantOrigin.getX();
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, this.getDomainAxisEdge());
        ValueAxis valueAxis2 = this.getRangeAxis();
        double d3 = this.quadrantOrigin.getY();
        double d4 = valueAxis2.valueToJava2D(d3, rectangle2D, this.getRangeAxisEdge());
        double d5 = valueAxis.getLowerBound();
        double d6 = valueAxis.valueToJava2D(d5, rectangle2D, this.getDomainAxisEdge());
        double d7 = valueAxis.getUpperBound();
        double d8 = valueAxis.valueToJava2D(d7, rectangle2D, this.getDomainAxisEdge());
        double d9 = valueAxis2.getLowerBound();
        double d10 = valueAxis2.valueToJava2D(d9, rectangle2D, this.getRangeAxisEdge());
        double d11 = valueAxis2.getUpperBound();
        double d12 = valueAxis2.valueToJava2D(d11, rectangle2D, this.getRangeAxisEdge());
        Rectangle2D[] rectangle2DArray = new Rectangle2D[4];
        if (this.quadrantPaint[0] != null && d > d5 && d3 < d11) {
            rectangle2DArray[0] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d12, d4), Math.min(d6, d2), Math.abs(d4 - d12), Math.abs(d2 - d6)) : new Rectangle2D.Double(Math.min(d6, d2), Math.min(d12, d4), Math.abs(d2 - d6), Math.abs(d4 - d12));
            bl = true;
        }
        if (this.quadrantPaint[1] != null && d < d7 && d3 < d11) {
            rectangle2DArray[1] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d12, d4), Math.min(d8, d2), Math.abs(d4 - d12), Math.abs(d2 - d8)) : new Rectangle2D.Double(Math.min(d2, d8), Math.min(d12, d4), Math.abs(d2 - d8), Math.abs(d4 - d12));
            bl = true;
        }
        if (this.quadrantPaint[2] != null && d > d5 && d3 > d9) {
            rectangle2DArray[2] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d10, d4), Math.min(d6, d2), Math.abs(d4 - d10), Math.abs(d2 - d6)) : new Rectangle2D.Double(Math.min(d6, d2), Math.min(d10, d4), Math.abs(d2 - d6), Math.abs(d4 - d10));
            bl = true;
        }
        if (this.quadrantPaint[3] != null && d < d7 && d3 > d9) {
            rectangle2DArray[3] = this.orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(Math.min(d10, d4), Math.min(d8, d2), Math.abs(d4 - d10), Math.abs(d2 - d8)) : new Rectangle2D.Double(Math.min(d2, d8), Math.min(d10, d4), Math.abs(d2 - d8), Math.abs(d4 - d10));
            bl = true;
        }
        if (bl) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getBackgroundAlpha()));
            int n = 0;
            while (n < 4) {
                if (this.quadrantPaint[n] != null && rectangle2DArray[n] != null) {
                    graphics2D.setPaint(this.quadrantPaint[n]);
                    graphics2D.fill(rectangle2DArray[n]);
                }
                ++n;
            }
            graphics2D.setComposite(composite);
        }
    }

    public void drawDomainTickBands(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        Paint paint = this.getDomainTickBandPaint();
        if (paint != null) {
            boolean bl = false;
            ValueAxis valueAxis = this.getDomainAxis();
            double d = valueAxis.getLowerBound();
            for (ValueTick valueTick : list) {
                double d2 = valueTick.getValue();
                if (bl) {
                    this.getRenderer().fillDomainGridBand(graphics2D, this, valueAxis, rectangle2D, d, d2);
                }
                d = d2;
                boolean bl2 = bl = !bl;
            }
            double d3 = valueAxis.getUpperBound();
            if (bl) {
                this.getRenderer().fillDomainGridBand(graphics2D, this, valueAxis, rectangle2D, d, d3);
            }
        }
    }

    public void drawRangeTickBands(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        Paint paint = this.getRangeTickBandPaint();
        if (paint != null) {
            boolean bl = false;
            ValueAxis valueAxis = this.getRangeAxis();
            double d = valueAxis.getLowerBound();
            for (ValueTick valueTick : list) {
                double d2 = valueTick.getValue();
                if (bl) {
                    this.getRenderer().fillRangeGridBand(graphics2D, this, valueAxis, rectangle2D, d, d2);
                }
                d = d2;
                boolean bl2 = bl = !bl;
            }
            double d3 = valueAxis.getUpperBound();
            if (bl) {
                this.getRenderer().fillRangeGridBand(graphics2D, this, valueAxis, rectangle2D, d, d3);
            }
        }
    }

    protected Map drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState;
        ValueAxis valueAxis;
        AxisCollection axisCollection = new AxisCollection();
        int n = 0;
        while (n < this.domainAxes.size()) {
            valueAxis = (ValueAxis)this.domainAxes.get(n);
            if (valueAxis != null) {
                axisCollection.add(valueAxis, this.getDomainAxisEdge(n));
            }
            ++n;
        }
        n = 0;
        while (n < this.rangeAxes.size()) {
            valueAxis = (ValueAxis)this.rangeAxes.get(n);
            if (valueAxis != null) {
                axisCollection.add(valueAxis, this.getRangeAxisEdge(n));
            }
            ++n;
        }
        HashMap<ValueAxis, AxisState> hashMap = new HashMap<ValueAxis, AxisState>();
        double d = rectangle2D2.getMinY() - this.axisOffset.calculateTopOutset(rectangle2D2.getHeight());
        for (ValueAxis valueAxis2 : axisCollection.getAxesAtTop()) {
            axisState = valueAxis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.TOP, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(valueAxis2, axisState);
        }
        d = rectangle2D2.getMaxY() + this.axisOffset.calculateBottomOutset(rectangle2D2.getHeight());
        for (ValueAxis valueAxis2 : axisCollection.getAxesAtBottom()) {
            axisState = valueAxis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(valueAxis2, axisState);
        }
        d = rectangle2D2.getMinX() - this.axisOffset.calculateLeftOutset(rectangle2D2.getWidth());
        for (ValueAxis valueAxis2 : axisCollection.getAxesAtLeft()) {
            axisState = valueAxis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(valueAxis2, axisState);
        }
        d = rectangle2D2.getMaxX() + this.axisOffset.calculateRightOutset(rectangle2D2.getWidth());
        for (ValueAxis valueAxis2 : axisCollection.getAxesAtRight()) {
            axisState = valueAxis2.draw(graphics2D, d, rectangle2D, rectangle2D2, RectangleEdge.RIGHT, plotRenderingInfo);
            d = axisState.getCursor();
            hashMap.put(valueAxis2, axisState);
        }
        return hashMap;
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, PlotRenderingInfo plotRenderingInfo, CrosshairState crosshairState) {
        boolean bl;
        block9: {
            bl = false;
            XYDataset xYDataset = this.getDataset(n);
            if (DatasetUtilities.isEmptyOrNull(xYDataset)) break block9;
            bl = true;
            ValueAxis valueAxis = this.getDomainAxisForDataset(n);
            ValueAxis valueAxis2 = this.getRangeAxisForDataset(n);
            XYItemRenderer xYItemRenderer = this.getRenderer(n);
            if (xYItemRenderer == null && (xYItemRenderer = this.getRenderer()) == null) {
                return bl;
            }
            XYItemRendererState xYItemRendererState = xYItemRenderer.initialise(graphics2D, rectangle2D, this, xYDataset, plotRenderingInfo);
            int n2 = xYItemRenderer.getPassCount();
            SeriesRenderingOrder seriesRenderingOrder = this.getSeriesRenderingOrder();
            if (seriesRenderingOrder == SeriesRenderingOrder.REVERSE) {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = xYDataset.getSeriesCount();
                    int n5 = n4 - 1;
                    while (n5 >= 0) {
                        int n6 = xYDataset.getItemCount(n5);
                        int n7 = 0;
                        while (n7 < n6) {
                            xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, this, valueAxis, valueAxis2, xYDataset, n5, n7, crosshairState, n3);
                            ++n7;
                        }
                        --n5;
                    }
                    ++n3;
                }
            } else {
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = xYDataset.getSeriesCount();
                    int n10 = 0;
                    while (n10 < n9) {
                        int n11 = xYDataset.getItemCount(n10);
                        int n12 = 0;
                        while (n12 < n11) {
                            xYItemRenderer.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, this, valueAxis, valueAxis2, xYDataset, n10, n12, crosshairState, n8);
                            ++n12;
                        }
                        ++n10;
                    }
                    ++n8;
                }
            }
        }
        return bl;
    }

    public ValueAxis getDomainAxisForDataset(int n) {
        if (n < 0 || n >= this.getDatasetCount()) {
            throw new IllegalArgumentException("Index 'index' out of bounds.");
        }
        ValueAxis valueAxis = null;
        Integer n2 = (Integer)this.datasetToDomainAxisMap.get(new Integer(n));
        valueAxis = n2 != null ? this.getDomainAxis(n2) : this.getDomainAxis(0);
        return valueAxis;
    }

    public ValueAxis getRangeAxisForDataset(int n) {
        if (n < 0 || n >= this.getDatasetCount()) {
            throw new IllegalArgumentException("Index 'index' out of bounds.");
        }
        ValueAxis valueAxis = null;
        Integer n2 = (Integer)this.datasetToRangeAxisMap.get(new Integer(n));
        valueAxis = n2 != null ? this.getRangeAxis(n2) : this.getRangeAxis(0);
        return valueAxis;
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isDomainGridlinesVisible()) {
            Stroke stroke = this.getDomainGridlineStroke();
            Paint paint = this.getDomainGridlinePaint();
            if (stroke != null && paint != null) {
                for (ValueTick valueTick : list) {
                    this.getRenderer().drawDomainGridLine(graphics2D, this, this.getDomainAxis(), rectangle2D, valueTick.getValue());
                }
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.getRenderer() == null) {
            return;
        }
        if (this.isRangeGridlinesVisible()) {
            Stroke stroke = this.getRangeGridlineStroke();
            Paint paint = this.getRangeGridlinePaint();
            ValueAxis valueAxis = this.getRangeAxis();
            if (valueAxis != null) {
                for (ValueTick valueTick : list) {
                    if (valueTick.getValue() == 0.0 && this.isRangeZeroBaselineVisible()) continue;
                    this.getRenderer().drawRangeLine(graphics2D, this, this.getRangeAxis(), rectangle2D, valueTick.getValue(), paint, stroke);
                }
            }
        }
    }

    protected void drawZeroDomainBaseline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        XYItemRenderer xYItemRenderer;
        if (this.isDomainZeroBaselineVisible() && (xYItemRenderer = this.getRenderer()) instanceof AbstractXYItemRenderer) {
            AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)xYItemRenderer;
            abstractXYItemRenderer.drawDomainLine(graphics2D, this, this.getDomainAxis(), rectangle2D, 0.0, this.domainZeroBaselinePaint, this.domainZeroBaselineStroke);
        }
    }

    protected void drawZeroRangeBaseline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.isRangeZeroBaselineVisible()) {
            this.getRenderer().drawRangeLine(graphics2D, this, this.getRangeAxis(), rectangle2D, 0.0, this.rangeZeroBaselinePaint, this.rangeZeroBaselineStroke);
        }
    }

    public void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        for (XYAnnotation xYAnnotation : this.annotations) {
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            xYAnnotation.draw(graphics2D, this, rectangle2D, valueAxis, valueAxis2, 0, plotRenderingInfo);
        }
    }

    protected void drawDomainMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        XYItemRenderer xYItemRenderer = this.getRenderer(n);
        if (xYItemRenderer == null) {
            return;
        }
        if (n >= this.getDatasetCount()) {
            return;
        }
        Collection collection = this.getDomainMarkers(n, layer);
        ValueAxis valueAxis = this.getDomainAxisForDataset(n);
        if (collection != null && valueAxis != null) {
            for (Marker marker : collection) {
                xYItemRenderer.drawDomainMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        XYItemRenderer xYItemRenderer = this.getRenderer(n);
        if (xYItemRenderer == null) {
            return;
        }
        if (n >= this.getDatasetCount()) {
            return;
        }
        Collection collection = this.getRangeMarkers(n, layer);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n);
        if (collection != null && valueAxis != null) {
            for (Marker marker : collection) {
                xYItemRenderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getDomainMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundDomainMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundDomainMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public Collection getRangeMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundRangeMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundRangeMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        ValueAxis valueAxis = this.getRangeAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            valueAxis = this.getDomainAxis();
        }
        if (valueAxis.getRange().contains(d)) {
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.LEFT);
            Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawDomainCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, double d, ValueAxis valueAxis, Stroke stroke, Paint paint) {
        if (valueAxis.getRange().contains(d)) {
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.BOTTOM);
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else {
                double d3 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.LEFT);
                double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        ValueAxis valueAxis = this.getDomainAxis();
        if (this.getOrientation() == PlotOrientation.HORIZONTAL) {
            valueAxis = this.getRangeAxis();
        }
        if (valueAxis.getRange().contains(d)) {
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.BOTTOM);
            Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    protected void drawRangeCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, double d, ValueAxis valueAxis, Stroke stroke, Paint paint) {
        if (valueAxis.getRange().contains(d)) {
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d2 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.BOTTOM);
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else {
                double d3 = valueAxis.valueToJava2D(d, rectangle2D, RectangleEdge.LEFT);
                double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            ValueAxis valueAxis;
            ValueAxis valueAxis2 = this.getDomainAxis();
            if (valueAxis2 != null) {
                double d = valueAxis2.java2DToValue(n, plotRenderingInfo.getDataArea(), this.getDomainAxisEdge());
                this.setDomainCrosshairValue(d);
            }
            if ((valueAxis = this.getRangeAxis()) != null) {
                double d = valueAxis.java2DToValue(n2, plotRenderingInfo.getDataArea(), this.getRangeAxisEdge());
                this.setRangeCrosshairValue(d);
            }
        }
    }

    private List getDatasetsMappedToDomainAxis(Integer n) {
        if (n == null) {
            throw new IllegalArgumentException("Null 'axisIndex' argument.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < this.datasets.size()) {
            Integer n3 = (Integer)this.datasetToDomainAxisMap.get(new Integer(n2));
            if (n3 == null) {
                if (n.equals(ZERO)) {
                    arrayList.add(this.datasets.get(n2));
                }
            } else if (n3.equals(n)) {
                arrayList.add(this.datasets.get(n2));
            }
            ++n2;
        }
        return arrayList;
    }

    private List getDatasetsMappedToRangeAxis(Integer n) {
        if (n == null) {
            throw new IllegalArgumentException("Null 'axisIndex' argument.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < this.datasets.size()) {
            Integer n3 = (Integer)this.datasetToRangeAxisMap.get(new Integer(n2));
            if (n3 == null) {
                if (n.equals(ZERO)) {
                    arrayList.add(this.datasets.get(n2));
                }
            } else if (n3.equals(n)) {
                arrayList.add(this.datasets.get(n2));
            }
            ++n2;
        }
        return arrayList;
    }

    public int getDomainAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        int n = this.domainAxes.indexOf(valueAxis);
        if (n < 0 && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            n = xYPlot.getDomainAxisIndex(valueAxis);
        }
        return n;
    }

    public int getRangeAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        int n = this.rangeAxes.indexOf(valueAxis);
        if (n < 0 && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            n = xYPlot.getRangeAxisIndex(valueAxis);
        }
        return n;
    }

    public Range getDataRange(ValueAxis valueAxis) {
        int n;
        Range range = null;
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        int n2 = this.getDomainAxisIndex(valueAxis);
        if (n2 >= 0) {
            bl = true;
            arrayList.addAll(this.getDatasetsMappedToDomainAxis(new Integer(n2)));
        }
        if ((n = this.getRangeAxisIndex(valueAxis)) >= 0) {
            bl = false;
            arrayList.addAll(this.getDatasetsMappedToRangeAxis(new Integer(n)));
        }
        for (XYDataset xYDataset : arrayList) {
            if (xYDataset == null) continue;
            XYItemRenderer xYItemRenderer = this.getRendererForDataset(xYDataset);
            if (bl) {
                if (xYItemRenderer != null) {
                    range = Range.combine(range, xYItemRenderer.findDomainBounds(xYDataset));
                    continue;
                }
                range = Range.combine(range, DatasetUtilities.findDomainBounds(xYDataset));
                continue;
            }
            range = xYItemRenderer != null ? Range.combine(range, xYItemRenderer.findRangeBounds(xYDataset)) : Range.combine(range, DatasetUtilities.findRangeBounds(xYDataset));
        }
        return range;
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            plotChangeEvent.setType(ChartChangeEventType.DATASET_UPDATED);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl) {
        if (this.domainCrosshairVisible != bl) {
            this.domainCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean bl) {
        if (this.domainCrosshairLockedOnData != bl) {
            this.domainCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double d) {
        this.setDomainCrosshairValue(d, true);
    }

    public void setDomainCrosshairValue(double d, boolean bl) {
        this.domainCrosshairValue = d;
        if (this.isDomainCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.domainCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.fixedDomainAxisSpace = axisSpace;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.fixedRangeAxisSpace = axisSpace;
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        int n = 0;
        while (n < this.domainAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(n);
            if (valueAxis != null) {
                valueAxis.resizeRange(d);
            }
            ++n;
        }
    }

    public void zoomDomainAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        int n = 0;
        while (n < this.domainAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.domainAxes.get(n);
            if (valueAxis != null) {
                valueAxis.zoomRange(d, d2);
            }
            ++n;
        }
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        int n = 0;
        while (n < this.rangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
            if (valueAxis != null) {
                valueAxis.resizeRange(d);
            }
            ++n;
        }
    }

    public void zoomRangeAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        int n = 0;
        while (n < this.rangeAxes.size()) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(n);
            if (valueAxis != null) {
                valueAxis.zoomRange(d, d2);
            }
            ++n;
        }
    }

    public boolean isDomainZoomable() {
        return true;
    }

    public boolean isRangeZoomable() {
        return true;
    }

    public int getSeriesCount() {
        int n = 0;
        XYDataset xYDataset = this.getDataset();
        if (xYDataset != null) {
            n = xYDataset.getSeriesCount();
        }
        return n;
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n = this.datasets.size();
        int n2 = 0;
        while (n2 < n) {
            XYDataset xYDataset = this.getDataset(n2);
            if (xYDataset != null) {
                XYItemRenderer xYItemRenderer = this.getRenderer(n2);
                if (xYItemRenderer == null) {
                    xYItemRenderer = this.getRenderer(0);
                }
                if (xYItemRenderer != null) {
                    int n3 = xYDataset.getSeriesCount();
                    int n4 = 0;
                    while (n4 < n3) {
                        LegendItem legendItem;
                        if (xYItemRenderer.isSeriesVisible(n4) && xYItemRenderer.isSeriesVisibleInLegend(n4) && (legendItem = xYItemRenderer.getLegendItem(n2, n4)) != null) {
                            legendItemCollection.add(legendItem);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return legendItemCollection;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYPlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYPlot xYPlot = (XYPlot)object;
        if (this.weight != xYPlot.weight) {
            return false;
        }
        if (this.orientation != xYPlot.orientation) {
            return false;
        }
        if (!this.domainAxes.equals(xYPlot.domainAxes)) {
            return false;
        }
        if (!this.domainAxisLocations.equals(xYPlot.domainAxisLocations)) {
            return false;
        }
        if (this.rangeCrosshairLockedOnData != xYPlot.rangeCrosshairLockedOnData) {
            return false;
        }
        if (this.domainGridlinesVisible != xYPlot.domainGridlinesVisible) {
            return false;
        }
        if (this.rangeGridlinesVisible != xYPlot.rangeGridlinesVisible) {
            return false;
        }
        if (this.domainZeroBaselineVisible != xYPlot.domainZeroBaselineVisible) {
            return false;
        }
        if (this.rangeZeroBaselineVisible != xYPlot.rangeZeroBaselineVisible) {
            return false;
        }
        if (this.domainCrosshairVisible != xYPlot.domainCrosshairVisible) {
            return false;
        }
        if (this.domainCrosshairValue != xYPlot.domainCrosshairValue) {
            return false;
        }
        if (this.domainCrosshairLockedOnData != xYPlot.domainCrosshairLockedOnData) {
            return false;
        }
        if (this.rangeCrosshairVisible != xYPlot.rangeCrosshairVisible) {
            return false;
        }
        if (this.rangeCrosshairValue != xYPlot.rangeCrosshairValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.axisOffset, xYPlot.axisOffset)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.renderers, xYPlot.renderers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeAxes, xYPlot.rangeAxes)) {
            return false;
        }
        if (!this.rangeAxisLocations.equals(xYPlot.rangeAxisLocations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToDomainAxisMap, xYPlot.datasetToDomainAxisMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToRangeAxisMap, xYPlot.datasetToRangeAxisMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainGridlineStroke, xYPlot.domainGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, xYPlot.domainGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeGridlineStroke, xYPlot.rangeGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, xYPlot.rangeGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainZeroBaselinePaint, xYPlot.domainZeroBaselinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainZeroBaselineStroke, xYPlot.domainZeroBaselineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeZeroBaselinePaint, xYPlot.rangeZeroBaselinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeZeroBaselineStroke, xYPlot.rangeZeroBaselineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairStroke, xYPlot.domainCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainCrosshairPaint, xYPlot.domainCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeCrosshairStroke, xYPlot.rangeCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeCrosshairPaint, xYPlot.rangeCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundDomainMarkers, xYPlot.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundDomainMarkers, xYPlot.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, xYPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, xYPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundDomainMarkers, xYPlot.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundDomainMarkers, xYPlot.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, xYPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, xYPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.annotations, xYPlot.annotations)) {
            return false;
        }
        if (!this.quadrantOrigin.equals(xYPlot.quadrantOrigin)) {
            return false;
        }
        int n = 0;
        while (n < 4) {
            if (!PaintUtilities.equal(this.quadrantPaint[n], xYPlot.quadrantPaint[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        PublicCloneable publicCloneable;
        Object object;
        XYPlot xYPlot = (XYPlot)super.clone();
        xYPlot.domainAxes = (ObjectList)ObjectUtilities.clone(this.domainAxes);
        int n = 0;
        while (n < this.domainAxes.size()) {
            object = (ValueAxis)this.domainAxes.get(n);
            if (object != null) {
                publicCloneable = (ValueAxis)((ValueAxis)object).clone();
                xYPlot.domainAxes.set(n, publicCloneable);
                ((Axis)((Object)publicCloneable)).setPlot(xYPlot);
                ((Axis)((Object)publicCloneable)).addChangeListener(xYPlot);
            }
            ++n;
        }
        xYPlot.domainAxisLocations = (ObjectList)this.domainAxisLocations.clone();
        xYPlot.rangeAxes = (ObjectList)ObjectUtilities.clone(this.rangeAxes);
        n = 0;
        while (n < this.rangeAxes.size()) {
            object = (ValueAxis)this.rangeAxes.get(n);
            if (object != null) {
                publicCloneable = (ValueAxis)((ValueAxis)object).clone();
                xYPlot.rangeAxes.set(n, publicCloneable);
                ((Axis)((Object)publicCloneable)).setPlot(xYPlot);
                ((Axis)((Object)publicCloneable)).addChangeListener(xYPlot);
            }
            ++n;
        }
        xYPlot.rangeAxisLocations = (ObjectList)ObjectUtilities.clone(this.rangeAxisLocations);
        xYPlot.datasets = (ObjectList)ObjectUtilities.clone(this.datasets);
        n = 0;
        while (n < xYPlot.datasets.size()) {
            object = this.getDataset(n);
            if (object != null) {
                object.addChangeListener(xYPlot);
            }
            ++n;
        }
        xYPlot.datasetToDomainAxisMap = new TreeMap();
        xYPlot.datasetToDomainAxisMap.putAll(this.datasetToDomainAxisMap);
        xYPlot.datasetToRangeAxisMap = new TreeMap();
        xYPlot.datasetToRangeAxisMap.putAll(this.datasetToRangeAxisMap);
        xYPlot.renderers = (ObjectList)ObjectUtilities.clone(this.renderers);
        n = 0;
        while (n < this.renderers.size()) {
            object = (XYItemRenderer)this.renderers.get(n);
            if (object instanceof PublicCloneable) {
                publicCloneable = (PublicCloneable)object;
                xYPlot.renderers.set(n, publicCloneable.clone());
            }
            ++n;
        }
        xYPlot.foregroundDomainMarkers = (Map)ObjectUtilities.clone(this.foregroundDomainMarkers);
        xYPlot.backgroundDomainMarkers = (Map)ObjectUtilities.clone(this.backgroundDomainMarkers);
        xYPlot.foregroundRangeMarkers = (Map)ObjectUtilities.clone(this.foregroundRangeMarkers);
        xYPlot.backgroundRangeMarkers = (Map)ObjectUtilities.clone(this.backgroundRangeMarkers);
        xYPlot.annotations = (List)ObjectUtilities.deepClone(this.annotations);
        if (this.fixedDomainAxisSpace != null) {
            xYPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedDomainAxisSpace);
        }
        if (this.fixedRangeAxisSpace != null) {
            xYPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedRangeAxisSpace);
        }
        xYPlot.quadrantOrigin = (Point2D)ObjectUtilities.clone(this.quadrantOrigin);
        xYPlot.quadrantPaint = (Paint[])this.quadrantPaint.clone();
        return xYPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.domainGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeZeroBaselineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeZeroBaselinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.domainCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainCrosshairPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeCrosshairPaint, objectOutputStream);
        SerialUtilities.writePaint(this.domainTickBandPaint, objectOutputStream);
        SerialUtilities.writePaint(this.rangeTickBandPaint, objectOutputStream);
        SerialUtilities.writePoint2D(this.quadrantOrigin, objectOutputStream);
        int n = 0;
        while (n < 4) {
            SerialUtilities.writePaint(this.quadrantPaint[n], objectOutputStream);
            ++n;
        }
        SerialUtilities.writeStroke(this.domainZeroBaselineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainZeroBaselinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeZeroBaselineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeZeroBaselinePaint = SerialUtilities.readPaint(objectInputStream);
        this.domainCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.domainTickBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeTickBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.quadrantOrigin = SerialUtilities.readPoint2D(objectInputStream);
        this.quadrantPaint = new Paint[4];
        int n = 0;
        while (n < 4) {
            this.quadrantPaint[n] = SerialUtilities.readPaint(objectInputStream);
            ++n;
        }
        this.domainZeroBaselineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainZeroBaselinePaint = SerialUtilities.readPaint(objectInputStream);
        n = this.domainAxes.size();
        int n2 = 0;
        while (n2 < n) {
            Axis axis = (Axis)this.domainAxes.get(n2);
            if (axis != null) {
                axis.setPlot(this);
                axis.addChangeListener(this);
            }
            ++n2;
        }
        n2 = this.rangeAxes.size();
        int n3 = 0;
        while (n3 < n2) {
            Axis axis = (Axis)this.rangeAxes.get(n3);
            if (axis != null) {
                axis.setPlot(this);
                axis.addChangeListener(this);
            }
            ++n3;
        }
        n3 = this.datasets.size();
        int n4 = 0;
        while (n4 < n3) {
            Dataset dataset = (Dataset)this.datasets.get(n4);
            if (dataset != null) {
                dataset.addChangeListener(this);
            }
            ++n4;
        }
        n4 = this.renderers.size();
        int n5 = 0;
        while (n5 < n4) {
            XYItemRenderer xYItemRenderer = (XYItemRenderer)this.renderers.get(n5);
            if (xYItemRenderer != null) {
                xYItemRenderer.addChangeListener(this);
            }
            ++n5;
        }
    }
}

