/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class Jpeg
extends Image {
    public static final int NOT_A_MARKER = -1;
    public static final int VALID_MARKER = 0;
    public static final int[] VALID_MARKERS = new int[]{192, 193, 194};
    public static final int UNSUPPORTED_MARKER = 1;
    public static final int[] UNSUPPORTED_MARKERS = new int[]{195, 197, 198, 199, 200, 201, 202, 203, 205, 206, 207};
    public static final int NOPARAM_MARKER = 2;
    public static final int[] NOPARAM_MARKERS = new int[]{208, 209, 210, 211, 212, 213, 214, 215, 216, 1};
    public static final int M_APP0 = 224;
    public static final int M_APPE = 238;
    public static final byte[] JFIF_ID;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 74;
        byArray[1] = 70;
        byArray[2] = 73;
        byArray[3] = 70;
        JFIF_ID = byArray;
    }

    Jpeg(Image image) {
        super(image);
    }

    public Jpeg(URL uRL) throws BadElementException, IOException {
        super(uRL);
        this.processParameters();
    }

    public Jpeg(URL uRL, float f, float f2) throws BadElementException, IOException {
        this(uRL);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    public Jpeg(String string) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string));
    }

    public Jpeg(String string, float f, float f2) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(string), f, f2);
    }

    public Jpeg(byte[] byArray) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = byArray;
        this.originalData = byArray;
        this.processParameters();
    }

    public Jpeg(byte[] byArray, float f, float f2) throws BadElementException, IOException {
        this(byArray);
        this.scaledWidth = f;
        this.scaledHeight = f2;
    }

    private static final int getShort(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    private static final int marker(int n) {
        int n2 = 0;
        while (n2 < VALID_MARKERS.length) {
            if (n == VALID_MARKERS[n2]) {
                return 0;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < NOPARAM_MARKERS.length) {
            if (n == NOPARAM_MARKERS[n2]) {
                return 2;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < UNSUPPORTED_MARKERS.length) {
            if (n == UNSUPPORTED_MARKERS[n2]) {
                return 1;
            }
            ++n2;
        }
        return -1;
    }

    private void processParameters() throws BadElementException, IOException {
        this.type = 32;
        this.originalType = 1;
        InputStream inputStream = null;
        try {
            String string;
            if (this.rawData == null) {
                inputStream = this.url.openStream();
                string = this.url.toString();
            } else {
                inputStream = new ByteArrayInputStream(this.rawData);
                string = "Byte array";
            }
            if (inputStream.read() != 255 || inputStream.read() != 216) {
                throw new BadElementException(String.valueOf(string) + " is not a valid JPEG-file.");
            }
            boolean bl = true;
            while (true) {
                int n;
                int n2;
                if ((n2 = inputStream.read()) < 0) {
                    throw new IOException("Premature EOF while reading JPG.");
                }
                if (n2 != 255) continue;
                int n3 = inputStream.read();
                if (bl && n3 == 224) {
                    bl = false;
                    n = Jpeg.getShort(inputStream);
                    if (n < 16) {
                        Jpeg.skip(inputStream, n - 2);
                        continue;
                    }
                    byte[] byArray = new byte[JFIF_ID.length];
                    int n4 = inputStream.read(byArray);
                    if (n4 != byArray.length) {
                        throw new BadElementException(String.valueOf(string) + " corrupted JFIF marker.");
                    }
                    boolean bl2 = true;
                    int n5 = 0;
                    while (n5 < byArray.length) {
                        if (byArray[n5] != JFIF_ID[n5]) {
                            bl2 = false;
                            break;
                        }
                        ++n5;
                    }
                    if (!bl2) {
                        Jpeg.skip(inputStream, n - 2 - byArray.length);
                        continue;
                    }
                    Jpeg.skip(inputStream, 2);
                    n5 = inputStream.read();
                    int n6 = Jpeg.getShort(inputStream);
                    int n7 = Jpeg.getShort(inputStream);
                    if (n5 == 1) {
                        this.dpiX = n6;
                        this.dpiY = n7;
                    } else if (n5 == 2) {
                        this.dpiX = (int)((float)n6 * 2.54f + 0.5f);
                        this.dpiY = (int)((float)n7 * 2.54f + 0.5f);
                    }
                    Jpeg.skip(inputStream, n - 2 - byArray.length - 7);
                    continue;
                }
                if (n3 == 238) {
                    String string2;
                    n = Jpeg.getShort(inputStream) - 2;
                    byte[] byArray = new byte[n];
                    int n8 = 0;
                    while (n8 < n) {
                        byArray[n8] = (byte)inputStream.read();
                        ++n8;
                    }
                    if (byArray.length < 12 || !(string2 = new String(byArray, 0, 5, "ISO-8859-1")).equals("Adobe")) continue;
                    this.invert = true;
                    continue;
                }
                bl = false;
                int n9 = Jpeg.marker(n3);
                if (n9 == 0) {
                    Jpeg.skip(inputStream, 2);
                    if (inputStream.read() != 8) {
                        throw new BadElementException(String.valueOf(string) + " must have 8 bits per component.");
                    }
                    this.scaledHeight = Jpeg.getShort(inputStream);
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = Jpeg.getShort(inputStream);
                    this.setRight(this.scaledWidth);
                    this.colorspace = inputStream.read();
                    this.bpc = 8;
                    break;
                }
                if (n9 == 1) {
                    throw new BadElementException(String.valueOf(string) + ": unsupported JPEG marker: " + n3);
                }
                if (n9 == 2) continue;
                Jpeg.skip(inputStream, Jpeg.getShort(inputStream) - 2);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
        }
    }
}

