/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ModeloCompleta;
import serpro.ppgd.irpf.ModeloDeclaracao;
import serpro.ppgd.irpf.ModeloSimplificada;
import serpro.ppgd.irpf.ObservadorTipoDeclaracao;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.calculos.CalculosApuracaoResultadoARBrasil;
import serpro.ppgd.irpf.calculos.CalculosApuracaoResultadoARExterior;
import serpro.ppgd.irpf.calculos.CalculosBens;
import serpro.ppgd.irpf.calculos.CalculosDeducoesIncentivos;
import serpro.ppgd.irpf.calculos.CalculosDividas;
import serpro.ppgd.irpf.calculos.CalculosFundosInvestimentos;
import serpro.ppgd.irpf.calculos.CalculosGanhosRendaVar;
import serpro.ppgd.irpf.calculos.CalculosPagamentos;
import serpro.ppgd.irpf.calculos.CalculosReceitaDespesaARExterior;
import serpro.ppgd.irpf.calculos.CalculosReceitasDespesasARBrasil;
import serpro.ppgd.irpf.calculos.CalculosRendIsentos;
import serpro.ppgd.irpf.calculos.CalculosRendPF;
import serpro.ppgd.irpf.calculos.CalculosRendPJComExigibilidadeDependentes;
import serpro.ppgd.irpf.calculos.CalculosRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.calculos.CalculosRendPJDependentes;
import serpro.ppgd.irpf.calculos.CalculosRendPJTitular;
import serpro.ppgd.irpf.calculos.CalculosRendTributacaoExclusiva;
import serpro.ppgd.irpf.calculos.CalculosResumo;
import serpro.ppgd.irpf.calculos.CalculosTotaisFundosInvestimentos;
import serpro.ppgd.irpf.calculos.CalculosTotaisLivroCaixa;
import serpro.ppgd.irpf.calculos.CalculosTotaisRendaVariavel;
import serpro.ppgd.irpf.calculos.CalculosTotalRendRecebidosMaisExterior;
import serpro.ppgd.irpf.comparativo.Comparativo;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.eleicoes.Doacoes;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.ganhosdecapital.GanhosDeCapital;
import serpro.ppgd.irpf.impostopago.ImpostoPago;
import serpro.ppgd.irpf.moedaestrangeira.MoedaEstrangeira;
import serpro.ppgd.irpf.pagamentos.CalculosDoacoes;
import serpro.ppgd.irpf.pagamentos.ObservadorCPFDependente;
import serpro.ppgd.irpf.pagamentos.ObservadorCodigoPagamento;
import serpro.ppgd.irpf.pagamentos.ObservadorNomeAlimentando;
import serpro.ppgd.irpf.pagamentos.ObservadorNomeDependente;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.pagamentos.ValidadorDeducoesDoacoes;
import serpro.ppgd.irpf.pagamentos.ValidadorDeducoesPrevPrivadaComFapi;
import serpro.ppgd.irpf.rendIsentos.ObservadorResultadoNaoTributavel;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpf.RendPFDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJ;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidade;
import serpro.ppgd.irpf.resumo.Resumo;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.persistenciagenerica.RepositorioXMLDefault;

public class DeclaracaoIRPF
extends ObjetoNegocio {
    protected transient IdentificadorDeclaracao identificadorDeclaracao;
    private Contribuinte contribuinte;
    private RendPJ rendPJ;
    private RendPJComExigibilidade rendPJComExigibilidade;
    private RendPF rendPFTitular;
    private RendPFDependente rendPFDependente;
    private RendIsentos rendIsentos;
    private RendTributacaoExclusiva rendTributacaoExclusiva;
    private ImpostoPago impostoPago;
    private Dependentes dependentes;
    private Alimentandos alimentandos;
    private Pagamentos pagamentos;
    private Bens bens;
    private Dividas dividas;
    private Espolio espolio;
    private Resumo resumo;
    private Comparativo comparativo;
    private Doacoes doacoes;
    private RendaVariavel rendaVariavel;
    private AtividadeRural atividadeRural;
    private GanhosDeCapital ganhosDeCapital;
    private MoedaEstrangeira moedaEstrangeira;
    private IdentificadorDeclaracao copiaIdentificador;
    private transient ModeloCompleta modeloCompleta;
    private transient ModeloSimplificada modeloSimplificada;
    private transient ModeloDeclaracao modelo;

    public DeclaracaoIRPF(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.copiaIdentificador = identificadorDeclaracao;
        this.instanciaAtributos();
        this.identificadorDeclaracao.setPersistente(false);
        this.modelo.setPersistente(false);
        this.adicionaObservadoresCalculos();
        this.adicionaObservadoresNegocio();
        this.adicionaValidadoresEspeciais();
    }

    private void instanciaAtributos() {
        this.contribuinte = new Contribuinte(this.identificadorDeclaracao);
        this.pagamentos = new Pagamentos(this);
        this.rendPJ = new RendPJ(this.identificadorDeclaracao);
        this.rendPJComExigibilidade = new RendPJComExigibilidade(this.identificadorDeclaracao);
        this.espolio = new Espolio(this.identificadorDeclaracao);
        this.impostoPago = new ImpostoPago();
        this.dependentes = new Dependentes(this.getContribuinte());
        this.rendaVariavel = new RendaVariavel();
        this.alimentandos = new Alimentandos();
        this.bens = new Bens(this);
        this.dividas = new Dividas();
        this.atividadeRural = new AtividadeRural();
        this.ganhosDeCapital = new GanhosDeCapital();
        this.moedaEstrangeira = new MoedaEstrangeira();
        this.rendPFTitular = new RendPF();
        this.rendPFDependente = new RendPFDependente();
        this.rendIsentos = new RendIsentos(this);
        this.rendTributacaoExclusiva = new RendTributacaoExclusiva(this);
        this.comparativo = new Comparativo();
        this.resumo = new Resumo(this.identificadorDeclaracao, this.contribuinte);
        this.doacoes = new Doacoes();
        this.modeloSimplificada = new ModeloSimplificada(this);
        this.modeloCompleta = new ModeloCompleta(this);
        this.modelo = this.modeloCompleta;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public void adicionaValidadoresEspeciais() {
        this.getPagamentos().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                if (string.equals("ObjetoInserido")) {
                    ((Pagamento)object3).getValorPago().addValidador(new ValidadorDeducoesDoacoes(2, DeclaracaoIRPF.this, (Pagamento)object3));
                    ((Pagamento)object3).getValorPago().addValidador(new ValidadorDeducoesPrevPrivadaComFapi(2, DeclaracaoIRPF.this, (Pagamento)object3));
                }
            }
        });
        this.getImpostoPago().getImpostoRetidoFonte().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF.this.setFicha("Imposto Pago");
                boolean bl = DeclaracaoIRPF.this.getRendaVariavel().temResultadoLiquido();
                if (!DeclaracaoIRPF.this.getImpostoPago().isVazio() && !bl) {
                    return new RetornoValidacao(tab.msg("imposto_retido_rendvar_vazio"), 3);
                }
                return null;
            }
        });
    }

    public List verificarPendencias(int n) {
        List list = super.verificarPendencias(n);
        this.verificaLivroCaixa(n, list);
        return list;
    }

    protected void verificaLivroCaixa(int n, List list) {
        Valor valor = null;
        valor = !this.getColecaoRendPJTitular().recuperarLista().isEmpty() ? ((RendPJTitular)this.getColecaoRendPJTitular().recuperarLista().get(0)).getRendRecebidoPJ() : (!this.getColecaoRendPJDependente().recuperarLista().isEmpty() ? ((RendPJTitular)this.getColecaoRendPJDependente().recuperarLista().get(0)).getRendRecebidoPJ() : this.getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        if (!this.identificadorDeclaracao.getTipoDeclaracao().asString().equals("1") && this.getModelo().getTotalRendRecebidosMaisExterior().comparacao("<", this.getModelo().getTotalLivroCaixa())) {
            Pendencia pendencia = new Pendencia(3, valor, "Livro Caixa", this.tab.msg("rend_maior_livro_caixa"), -1);
            list.add(pendencia);
        }
    }

    public void adicionaObservadoresCalculos() {
        CalculosRendPF calculosRendPF = new CalculosRendPF(this.getRendPFTitular());
        CalculosRendPF calculosRendPF2 = new CalculosRendPF(this.getRendPFDependente());
        this.getRendPFTitular().addObservador(calculosRendPF);
        this.getRendPFDependente().addObservador(calculosRendPF2);
        CalculosRendPJTitular calculosRendPJTitular = new CalculosRendPJTitular(this.getColecaoRendPJTitular(), this);
        CalculosRendPJDependentes calculosRendPJDependentes = new CalculosRendPJDependentes(this.getColecaoRendPJDependente(), this);
        this.getColecaoRendPJTitular().addObservador(calculosRendPJTitular);
        this.getColecaoRendPJDependente().addObservador(calculosRendPJDependentes);
        CalculosRendPJComExigibilidadeTitular calculosRendPJComExigibilidadeTitular = new CalculosRendPJComExigibilidadeTitular(this.getColecaoRendPJComExigibilidadeTitular(), this);
        CalculosRendPJComExigibilidadeDependentes calculosRendPJComExigibilidadeDependentes = new CalculosRendPJComExigibilidadeDependentes(this.getColecaoRendPJComExigibilidadeDependente(), this);
        this.getColecaoRendPJComExigibilidadeTitular().addObservador(calculosRendPJComExigibilidadeTitular);
        this.getColecaoRendPJComExigibilidadeDependente().addObservador(calculosRendPJComExigibilidadeDependentes);
        CalculosTotalRendRecebidosMaisExterior calculosTotalRendRecebidosMaisExterior = new CalculosTotalRendRecebidosMaisExterior(this);
        this.getColecaoRendPJTitular().getTotaisRendRecebidoPJ().addObservador(calculosTotalRendRecebidosMaisExterior);
        this.getColecaoRendPJDependente().getTotaisRendRecebidoPJ().addObservador(calculosTotalRendRecebidosMaisExterior);
        this.getRendPFTitular().getTotalPessoaFisica().addObservador(calculosTotalRendRecebidosMaisExterior);
        this.getRendPFTitular().getTotalExterior().addObservador(calculosTotalRendRecebidosMaisExterior);
        this.getRendPFDependente().getTotalPessoaFisica().addObservador(calculosTotalRendRecebidosMaisExterior);
        this.getRendPFDependente().getTotalExterior().addObservador(calculosTotalRendRecebidosMaisExterior);
        CalculosTotaisLivroCaixa calculosTotaisLivroCaixa = new CalculosTotaisLivroCaixa(this);
        this.getRendPFTitular().getTotalLivroCaixa().addObservador(calculosTotaisLivroCaixa);
        this.getRendPFDependente().getTotalLivroCaixa().addObservador(calculosTotaisLivroCaixa);
        CalculosRendIsentos calculosRendIsentos = new CalculosRendIsentos(this.getRendIsentos());
        this.getRendIsentos().addObservador(calculosRendIsentos);
        CalculosRendTributacaoExclusiva calculosRendTributacaoExclusiva = new CalculosRendTributacaoExclusiva(this);
        this.getRendTributacaoExclusiva().addObservador(calculosRendTributacaoExclusiva);
        this.getColecaoRendPJTitular().getTotaisDecimoTerceiro().addObservador(calculosRendTributacaoExclusiva);
        this.getColecaoRendPJDependente().getTotaisDecimoTerceiro().addObservador(calculosRendTributacaoExclusiva);
        this.getBens().addObservador(new CalculosBens(this.getBens()));
        this.getDividas().addObservador(new CalculosDividas(this.getDividas()));
        this.getPagamentos().addObservador(new CalculosPagamentos(this));
        CalculosDeducoesIncentivos calculosDeducoesIncentivos = new CalculosDeducoesIncentivos(this);
        this.getModeloCompleta().getImposto().addObservador(calculosDeducoesIncentivos);
        this.getDoacoes().addObservador(new CalculosDoacoes(this));
        this.getAtividadeRural().getBrasil().getReceitasDespesas().addObservadorCalculosTotais(new CalculosReceitasDespesasARBrasil(this));
        CalculosApuracaoResultadoARBrasil calculosApuracaoResultadoARBrasil = new CalculosApuracaoResultadoARBrasil(this);
        this.getAtividadeRural().getBrasil().getReceitasDespesas().getTotalReceita().addObservador(calculosApuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getReceitasDespesas().getTotalDespesas().addObservador(calculosApuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getPrejuizoExercicioAnterior().addObservador(calculosApuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getReceitaRecebidaContaVenda().addObservador(calculosApuracaoResultadoARBrasil);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getValorAdiantamento().addObservador(calculosApuracaoResultadoARBrasil);
        this.getAtividadeRural().getExterior().getReceitasDespesas().addObservador(new CalculosReceitaDespesaARExterior(this));
        CalculosApuracaoResultadoARExterior calculosApuracaoResultadoARExterior = new CalculosApuracaoResultadoARExterior(this);
        this.getAtividadeRural().getExterior().getReceitasDespesas().getTotais().addObservador(calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getPrejuizoExercicioAnterior().addObservador(calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getOpcaoArbitramento().addObservador(calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getReceitaRecebidaContaVenda().addObservador(calculosApuracaoResultadoARExterior);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getValorAdiantamento().addObservador(calculosApuracaoResultadoARExterior);
        this.getRendaVariavel().adicionarObservadorCalculosTotaisRendaVariavel(new CalculosTotaisRendaVariavel(this));
        CalculosFundosInvestimentos calculosFundosInvestimentos = null;
        int n = 0;
        while (n < 12) {
            calculosFundosInvestimentos = new CalculosFundosInvestimentos(this.getRendaVariavel().getFundInvest().getMeses()[n], this.getRendaVariavel());
            this.getRendaVariavel().getFundInvest().getMeses()[n].getResultLiquidoMes().addObservador(calculosFundosInvestimentos);
            this.getRendaVariavel().getFundInvest().getMeses()[n].getResultNegativoAnterior().addObservador(calculosFundosInvestimentos);
            this.getRendaVariavel().getFundInvest().getMeses()[n].getBaseCalcImposto().addObservador(calculosFundosInvestimentos);
            this.getRendaVariavel().getFundInvest().getMeses()[n].getImpostoPago().addObservador(calculosFundosInvestimentos);
            if (n > 0) {
                this.getRendaVariavel().getFundInvest().getMeses()[n - 1].getPrejuizoCompensar().addObservador(calculosFundosInvestimentos);
            }
            ++n;
        }
        this.getRendaVariavel().getFundInvest().adicionarCalculosTotaisFundInvest(new CalculosTotaisFundosInvestimentos(this.getRendaVariavel().getFundInvest()));
        CalculosGanhosRendaVar calculosGanhosRendaVar = new CalculosGanhosRendaVar(this.getRendaVariavel(), this.getRendTributacaoExclusiva());
        this.getRendaVariavel().getFundInvest().adicionarObservGanhosFundInvest(calculosGanhosRendaVar);
        this.getRendaVariavel().adicionarObservGanhosRendaVar(calculosGanhosRendaVar);
    }

    public void adicionaObservadoresCalculosLate() {
        CalculosResumo calculosResumo = new CalculosResumo(this);
        this.identificadorDeclaracao.getTipoDeclaracao().addObservador(calculosResumo);
        this.getRendPFTitular().getTotalPessoaFisica().addObservador(calculosResumo);
        this.getRendPFDependente().getTotalPessoaFisica().addObservador(calculosResumo);
        this.getRendPFTitular().getTotalPensao().addObservador(calculosResumo);
        this.getRendPFDependente().getTotalPensao().addObservador(calculosResumo);
        this.getRendPFTitular().getTotalExterior().addObservador(calculosResumo);
        this.getRendPFDependente().getTotalExterior().addObservador(calculosResumo);
        this.getRendPFTitular().getTotalPrevidencia().addObservador(calculosResumo);
        this.getRendPFDependente().getTotalPrevidencia().addObservador(calculosResumo);
        this.getRendPFTitular().getTotalLivroCaixa().addObservador(calculosResumo);
        this.getRendPFDependente().getTotalLivroCaixa().addObservador(calculosResumo);
        this.getRendPFTitular().getTotalDarfPago().addObservador(calculosResumo);
        this.getRendPFDependente().getTotalDarfPago().addObservador(calculosResumo);
        this.getRendPFTitular().getTotalDependentes().addObservador(calculosResumo);
        this.getRendPFDependente().getTotalDependentes().addObservador(calculosResumo);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel().addObservador(calculosResumo);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().getTotaisRendRecebidoPJ().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().getTotaisRendRecebidoPJ().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().getTotaisContribuicaoPrevOficial().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().getTotaisContribuicaoPrevOficial().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().getTotaisImpostoRetidoFonte().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().getTotaisImpostoRetidoFonte().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJTitular().getTotaisImpostoRetidoFonte().addObservador(calculosResumo);
        this.getRendPJ().getColecaoRendPJDependente().getTotaisImpostoRetidoFonte().addObservador(calculosResumo);
        this.getImpostoPago().getImpostoComplementar().addObservador(calculosResumo);
        this.getImpostoPago().getImpostoRetidoFonte().addObservador(calculosResumo);
        this.getImpostoPago().getImpostoPagoExterior().addObservador(calculosResumo);
        this.getRendIsentos().getTotal().addObservador(calculosResumo);
        this.getRendTributacaoExclusiva().getTotal().addObservador(calculosResumo);
        this.getBens().addObservador(calculosResumo);
        this.getBens().getTotalExercicioAnterior().addObservador(calculosResumo);
        this.getBens().getTotalExercicioAtual().addObservador(calculosResumo);
        this.getDividas().addObservador(calculosResumo);
        this.getDividas().getTotalExercicioAnterior().addObservador(calculosResumo);
        this.getDividas().getTotalExercicioAtual().addObservador(calculosResumo);
        this.getPagamentos().addObservador(calculosResumo);
        this.getPagamentos().getTotalDeducoesInstrucao().addObservador(calculosResumo);
        this.getPagamentos().getTotalContribuicaoFAPI().addObservador(calculosResumo);
        this.getPagamentos().getTotalDespesasMedicas().addObservador(calculosResumo);
        this.getPagamentos().getTotalPensao().addObservador(calculosResumo);
        this.getPagamentos().getTotalDeducaoIncentivo().addObservador(calculosResumo);
        this.getRendaVariavel().getTotalImpostoRetidoFonteLei11033().addObservador(calculosResumo);
        this.getRendaVariavel().getTotalImpostoPago().addObservador(calculosResumo);
        this.getRendaVariavel().getTotalImpostoPagoComFundInvest().addObservador(calculosResumo);
        this.getDependentes().getTotalDeducaoDependentes().addObservador(calculosResumo);
        this.getDoacoes().getTotalDoacoes().addObservador(calculosResumo);
        this.getImpostoPago().getImpostoComplementar().disparaObservadores();
    }

    public void adicionaObservadoresNegocio() {
        this.identificadorDeclaracao.getTipoDeclaracao().addObservador(new ObservadorTipoDeclaracao(this));
        this.getPagamentos().addObservador(new ObservadorCodigoPagamento(this));
        this.getDependentes().addObservador(new ObservadorNomeDependente(this));
        this.getDependentes().addObservador(new ObservadorCPFDependente(this));
        this.getAlimentandos().addObservador(new ObservadorNomeAlimentando(this));
        ObservadorResultadoNaoTributavel observadorResultadoNaoTributavel = new ObservadorResultadoNaoTributavel(this);
        this.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoNaoTributavel().addObservador(observadorResultadoNaoTributavel);
        this.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoNaoTributavel().addObservador(observadorResultadoNaoTributavel);
    }

    public ModeloCompleta getModeloCompleta() {
        return this.modeloCompleta;
    }

    public ModeloSimplificada getModeloSimplificada() {
        return this.modeloSimplificada;
    }

    public ModeloDeclaracao getModelo() {
        this.modelo = this.identificadorDeclaracao.getTipoDeclaracao().asString().equals("0") ? this.getModeloCompleta() : this.getModeloSimplificada();
        return this.modelo;
    }

    public void setModeloCompleta() {
        this.modelo = this.getModeloCompleta();
    }

    public void setModeloSimplificada() {
        this.modelo = this.getModeloSimplificada();
    }

    public Alimentandos getAlimentandos() {
        return this.alimentandos;
    }

    public Doacoes getDoacoes() {
        return this.doacoes;
    }

    public AtividadeRural getAtividadeRural() {
        return this.atividadeRural;
    }

    public Bens getBens() {
        return this.bens;
    }

    public RendPJ getRendPJ() {
        return this.rendPJ;
    }

    public ColecaoRendPJDependente getColecaoRendPJDependente() {
        return this.rendPJ.getColecaoRendPJDependente();
    }

    public ColecaoRendPJTitular getColecaoRendPJTitular() {
        return this.rendPJ.getColecaoRendPJTitular();
    }

    public RendPJComExigibilidade getRendPJComExigibilidade() {
        return this.rendPJComExigibilidade;
    }

    public ColecaoRendPJComExigibilidadeDependente getColecaoRendPJComExigibilidadeDependente() {
        return this.rendPJComExigibilidade.getColecaoRendPJComExigibilidadeDependente();
    }

    public ColecaoRendPJComExigibilidadeTitular getColecaoRendPJComExigibilidadeTitular() {
        return this.rendPJComExigibilidade.getColecaoRendPJComExigibilidadeTitular();
    }

    public Comparativo getComparativo() {
        return this.comparativo;
    }

    public Contribuinte getContribuinte() {
        return this.contribuinte;
    }

    public Dependentes getDependentes() {
        return this.dependentes;
    }

    public Dividas getDividas() {
        return this.dividas;
    }

    public Espolio getEspolio() {
        return this.espolio;
    }

    public GanhosDeCapital getGanhosDeCapital() {
        return this.ganhosDeCapital;
    }

    public ImpostoPago getImpostoPago() {
        return this.impostoPago;
    }

    public MoedaEstrangeira getMoedaEstrangeira() {
        return this.moedaEstrangeira;
    }

    public Pagamentos getPagamentos() {
        return this.pagamentos;
    }

    public RendaVariavel getRendaVariavel() {
        return this.rendaVariavel;
    }

    public RendPFDependente getRendPFDependente() {
        return this.rendPFDependente;
    }

    public RendPF getRendPFTitular() {
        return this.rendPFTitular;
    }

    public RendTributacaoExclusiva getRendTributacaoExclusiva() {
        return this.rendTributacaoExclusiva;
    }

    public Resumo getResumo() {
        return this.resumo;
    }

    public NI recuperarPrincipalFontePagadora() {
        class FontePagadora
        extends ObjetoNegocio {
            public RendPJTitular rendimento;
            public Valor valorTotal = new Valor(this, "");
            public IdentificadorDeclaracao id = null;

            public FontePagadora(IdentificadorDeclaracao identificadorDeclaracao, RendPJTitular rendPJTitular) {
                this.id = identificadorDeclaracao;
                this.rendimento = rendPJTitular;
            }
        }
        FontePagadora fontePagadora;
        ObjetoNegocio objetoNegocio2;
        ColecaoRendPJTitular colecaoRendPJTitular = this.getColecaoRendPJTitular();
        ColecaoRendPJDependente colecaoRendPJDependente = this.getColecaoRendPJDependente();
        Hashtable<String, FontePagadora> hashtable = new Hashtable<String, FontePagadora>();
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio2 : colecaoRendPJTitular.recuperarLista()) {
            if (!hashtable.containsKey(((RendPJTitular)objetoNegocio2).getNIFontePagadora().asString())) {
                fontePagadora = new FontePagadora(this.getIdentificadorDeclaracao(), (RendPJTitular)objetoNegocio2);
                hashtable.put(fontePagadora.rendimento.getNIFontePagadora().asString(), fontePagadora);
            }
            fontePagadora = (FontePagadora)hashtable.get(((RendPJTitular)objetoNegocio2).getNIFontePagadora().asString());
            fontePagadora.valorTotal.append('+', ((RendPJTitular)objetoNegocio2).getRendRecebidoPJ());
        }
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio2 : colecaoRendPJDependente.recuperarLista()) {
            if (!hashtable.containsKey(((RendPJTitular)objetoNegocio2).getNIFontePagadora().asString())) {
                fontePagadora = new FontePagadora(this.getIdentificadorDeclaracao(), (RendPJTitular)objetoNegocio2);
                hashtable.put(fontePagadora.rendimento.getNIFontePagadora().asString(), fontePagadora);
            }
            fontePagadora = (FontePagadora)hashtable.get(((RendPJTitular)objetoNegocio2).getNIFontePagadora().asString());
            fontePagadora.valorTotal.append('+', ((RendPJTitular)objetoNegocio2).getRendRecebidoPJ());
        }
        Iterator<Object> iterator = hashtable.values().iterator();
        objetoNegocio2 = null;
        while (iterator.hasNext()) {
            fontePagadora = (FontePagadora)iterator.next();
            if (objetoNegocio2 != null && !fontePagadora.valorTotal.comparacao(">", ((FontePagadora)objetoNegocio2).valorTotal)) continue;
            objetoNegocio2 = fontePagadora;
        }
        if (objetoNegocio2 == null) {
            return new NI(this, "");
        }
        return ((FontePagadora)objetoNegocio2).rendimento.getNIFontePagadora();
    }

    public NI recuperarSegundaMaiorFontePagadora() {
        ObjetoNegocio objetoNegocio;
        ObjetoNegocio objetoNegocio22;
        ColecaoRendPJTitular colecaoRendPJTitular = this.getColecaoRendPJTitular();
        ColecaoRendPJDependente colecaoRendPJDependente = this.getColecaoRendPJDependente();
        class FontePagadora
        extends ObjetoNegocio {
            public RendPJTitular rendimento;
            public Valor valorTotal = new Valor(this, "");
            public IdentificadorDeclaracao id = null;

            public FontePagadora(IdentificadorDeclaracao identificadorDeclaracao, RendPJTitular rendPJTitular) {
                this.id = identificadorDeclaracao;
                this.rendimento = rendPJTitular;
            }
        }
        Hashtable<String, FontePagadora> hashtable = new Hashtable<String, FontePagadora>();
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio22 : colecaoRendPJTitular.recuperarLista()) {
            if (!hashtable.containsKey(objetoNegocio22.getNIFontePagadora().asString())) {
                objetoNegocio = new FontePagadora(this.getIdentificadorDeclaracao(), (RendPJTitular)objetoNegocio22);
                hashtable.put(objetoNegocio.rendimento.getNIFontePagadora().asString(), (FontePagadora)objetoNegocio);
            }
            objetoNegocio = (FontePagadora)hashtable.get(objetoNegocio22.getNIFontePagadora().asString());
            objetoNegocio.valorTotal.append('+', objetoNegocio22.getRendRecebidoPJ());
        }
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio22 : colecaoRendPJDependente.recuperarLista()) {
            if (!hashtable.containsKey(objetoNegocio22.getNIFontePagadora().asString())) {
                objetoNegocio = new FontePagadora(this.getIdentificadorDeclaracao(), (RendPJTitular)objetoNegocio22);
                hashtable.put(objetoNegocio.rendimento.getNIFontePagadora().asString(), (FontePagadora)objetoNegocio);
            }
            objetoNegocio = (FontePagadora)hashtable.get(objetoNegocio22.getNIFontePagadora().asString());
            objetoNegocio.valorTotal.append('+', objetoNegocio22.getRendRecebidoPJ());
        }
        Iterator<Object> iterator = hashtable.values().iterator();
        objetoNegocio22 = null;
        objetoNegocio = null;
        while (iterator.hasNext()) {
            FontePagadora fontePagadora = (FontePagadora)iterator.next();
            if (objetoNegocio22 == null || fontePagadora.valorTotal.comparacao(">", ((FontePagadora)objetoNegocio22).valorTotal)) {
                objetoNegocio = objetoNegocio22;
                objetoNegocio22 = fontePagadora;
                continue;
            }
            if (objetoNegocio != null && !fontePagadora.valorTotal.comparacao(">", objetoNegocio.valorTotal)) continue;
            objetoNegocio = fontePagadora;
        }
        if (objetoNegocio == null) {
            return new NI(this, "");
        }
        return objetoNegocio.rendimento.getNIFontePagadora();
    }

    public NI recuperarTerceiraMaiorFontePagadora() {
        ObjetoNegocio objetoNegocio;
        ObjetoNegocio objetoNegocio22;
        ColecaoRendPJTitular colecaoRendPJTitular = this.getColecaoRendPJTitular();
        ColecaoRendPJDependente colecaoRendPJDependente = this.getColecaoRendPJDependente();
        class FontePagadora
        extends ObjetoNegocio {
            public RendPJTitular rendimento;
            public Valor valorTotal = new Valor(this, "");
            public IdentificadorDeclaracao id = null;

            public FontePagadora(IdentificadorDeclaracao identificadorDeclaracao, RendPJTitular rendPJTitular) {
                this.id = identificadorDeclaracao;
                this.rendimento = rendPJTitular;
            }
        }
        Hashtable<String, FontePagadora> hashtable = new Hashtable<String, FontePagadora>();
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio22 : colecaoRendPJTitular.recuperarLista()) {
            if (!hashtable.containsKey(objetoNegocio22.getNIFontePagadora().asString())) {
                objetoNegocio = new FontePagadora(this.getIdentificadorDeclaracao(), (RendPJTitular)objetoNegocio22);
                hashtable.put(objetoNegocio.rendimento.getNIFontePagadora().asString(), (FontePagadora)objetoNegocio);
            }
            objetoNegocio = (FontePagadora)hashtable.get(objetoNegocio22.getNIFontePagadora().asString());
            objetoNegocio.valorTotal.append('+', objetoNegocio22.getRendRecebidoPJ());
        }
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio22 : colecaoRendPJDependente.recuperarLista()) {
            if (!hashtable.containsKey(objetoNegocio22.getNIFontePagadora().asString())) {
                objetoNegocio = new FontePagadora(this.getIdentificadorDeclaracao(), (RendPJTitular)objetoNegocio22);
                hashtable.put(objetoNegocio.rendimento.getNIFontePagadora().asString(), (FontePagadora)objetoNegocio);
            }
            objetoNegocio = (FontePagadora)hashtable.get(objetoNegocio22.getNIFontePagadora().asString());
            objetoNegocio.valorTotal.append('+', objetoNegocio22.getRendRecebidoPJ());
        }
        Iterator<Object> iterator = hashtable.values().iterator();
        objetoNegocio22 = null;
        objetoNegocio = null;
        FontePagadora fontePagadora = null;
        while (iterator.hasNext()) {
            FontePagadora fontePagadora2 = (FontePagadora)iterator.next();
            if (objetoNegocio22 == null || fontePagadora2.valorTotal.comparacao(">", ((FontePagadora)objetoNegocio22).valorTotal)) {
                fontePagadora = objetoNegocio;
                objetoNegocio = objetoNegocio22;
                objetoNegocio22 = fontePagadora2;
                continue;
            }
            if (objetoNegocio == null || fontePagadora2.valorTotal.comparacao(">", objetoNegocio.valorTotal)) {
                fontePagadora = objetoNegocio;
                objetoNegocio = fontePagadora2;
                continue;
            }
            if (fontePagadora != null && !fontePagadora2.valorTotal.comparacao(">", fontePagadora.valorTotal)) continue;
            fontePagadora = fontePagadora2;
        }
        if (fontePagadora == null) {
            return new NI(this, "");
        }
        return fontePagadora.rendimento.getNIFontePagadora();
    }

    public NI recuperarQuartaMaiorFontePagadora() {
        ObjetoNegocio objetoNegocio;
        ObjetoNegocio objetoNegocio22;
        ColecaoRendPJTitular colecaoRendPJTitular = this.getColecaoRendPJTitular();
        ColecaoRendPJDependente colecaoRendPJDependente = this.getColecaoRendPJDependente();
        class FontePagadora
        extends ObjetoNegocio {
            public RendPJTitular rendimento;
            public Valor valorTotal = new Valor(this, "");
            public IdentificadorDeclaracao id = null;

            public FontePagadora(IdentificadorDeclaracao identificadorDeclaracao, RendPJTitular rendPJTitular) {
                this.id = identificadorDeclaracao;
                this.rendimento = rendPJTitular;
            }
        }
        Hashtable<String, FontePagadora> hashtable = new Hashtable<String, FontePagadora>();
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio22 : colecaoRendPJTitular.recuperarLista()) {
            if (!hashtable.containsKey(objetoNegocio22.getNIFontePagadora().asString())) {
                objetoNegocio = new FontePagadora(this.getIdentificadorDeclaracao(), (RendPJTitular)objetoNegocio22);
                hashtable.put(objetoNegocio.rendimento.getNIFontePagadora().asString(), (FontePagadora)objetoNegocio);
            }
            objetoNegocio = (FontePagadora)hashtable.get(objetoNegocio22.getNIFontePagadora().asString());
            objetoNegocio.valorTotal.append('+', objetoNegocio22.getRendRecebidoPJ());
        }
        colecaoRendPJTitular.excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio22 : colecaoRendPJDependente.recuperarLista()) {
            if (!hashtable.containsKey(objetoNegocio22.getNIFontePagadora().asString())) {
                objetoNegocio = new FontePagadora(this.getIdentificadorDeclaracao(), (RendPJTitular)objetoNegocio22);
                hashtable.put(objetoNegocio.rendimento.getNIFontePagadora().asString(), (FontePagadora)objetoNegocio);
            }
            objetoNegocio = (FontePagadora)hashtable.get(objetoNegocio22.getNIFontePagadora().asString());
            objetoNegocio.valorTotal.append('+', objetoNegocio22.getRendRecebidoPJ());
        }
        Iterator<Object> iterator = hashtable.values().iterator();
        objetoNegocio22 = null;
        objetoNegocio = null;
        FontePagadora fontePagadora = null;
        FontePagadora fontePagadora2 = null;
        while (iterator.hasNext()) {
            FontePagadora fontePagadora3 = (FontePagadora)iterator.next();
            if (objetoNegocio22 == null || fontePagadora3.valorTotal.comparacao(">", ((FontePagadora)objetoNegocio22).valorTotal)) {
                fontePagadora2 = fontePagadora;
                fontePagadora = objetoNegocio;
                objetoNegocio = objetoNegocio22;
                objetoNegocio22 = fontePagadora3;
                continue;
            }
            if (objetoNegocio == null || fontePagadora3.valorTotal.comparacao(">", objetoNegocio.valorTotal)) {
                fontePagadora2 = fontePagadora;
                fontePagadora = objetoNegocio;
                objetoNegocio = fontePagadora3;
                continue;
            }
            if (fontePagadora == null || fontePagadora3.valorTotal.comparacao(">", fontePagadora.valorTotal)) {
                fontePagadora2 = fontePagadora;
                fontePagadora = fontePagadora3;
                continue;
            }
            if (fontePagadora2 != null && !fontePagadora3.valorTotal.comparacao(">", fontePagadora2.valorTotal)) continue;
            fontePagadora2 = fontePagadora3;
        }
        if (fontePagadora2 == null) {
            return new NI(this, "");
        }
        return fontePagadora2.rendimento.getNIFontePagadora();
    }

    private CPF recuperarDependentesPorOrdemValor(int n) {
        class CPFDependente
        extends ObjetoNegocio {
            public CPF cpf;
            public Valor valorTotal = new Valor(this, "");

            public CPFDependente(CPF cPF) {
                this.cpf = cPF;
            }

            public boolean equals(Object object) {
                return object instanceof CPFDependente && this.cpf.asString().equals(((CPFDependente)object).cpf.asString());
            }
        }
        ObjetoNegocio objetoNegocio2;
        ColecaoRendPJDependente colecaoRendPJDependente = this.getColecaoRendPJDependente();
        ArrayList<ObjetoNegocio> arrayList = new ArrayList<ObjetoNegocio>();
        for (ObjetoNegocio objetoNegocio2 : colecaoRendPJDependente.recuperarLista()) {
            ObjetoNegocio objetoNegocio3 = new CPFDependente(((RendPJDependente)objetoNegocio2).getCpfDependente());
            int n2 = arrayList.indexOf(objetoNegocio3);
            if (n2 < 0) {
                arrayList.add(objetoNegocio3);
            } else {
                objetoNegocio3 = (CPFDependente)arrayList.get(n2);
            }
            ((CPFDependente)objetoNegocio3).valorTotal.append('+', ((RendPJTitular)objetoNegocio2).getRendRecebidoPJ());
        }
        if (this.getIdentificadorDeclaracao().isCompleta()) {
            objetoNegocio2 = this.getDependentes();
            for (ObjetoNegocio objetoNegocio3 : ((Colecao)objetoNegocio2).recuperarLista()) {
                CPFDependente cPFDependente = new CPFDependente(((Dependente)objetoNegocio3).getCpfDependente());
                if (arrayList.contains(cPFDependente)) continue;
                arrayList.add(cPFDependente);
            }
        }
        objetoNegocio2 = null;
        int n3 = 0;
        while (n3 < n) {
            Iterator iterator = arrayList.iterator();
            objetoNegocio2 = null;
            while (iterator.hasNext()) {
                CPFDependente cPFDependente = (CPFDependente)iterator.next();
                if (objetoNegocio2 != null && !cPFDependente.valorTotal.comparacao(">", ((CPFDependente)objetoNegocio2).valorTotal)) continue;
                objetoNegocio2 = cPFDependente;
            }
            arrayList.remove(objetoNegocio2);
            ++n3;
        }
        if (objetoNegocio2 == null) {
            return new CPF();
        }
        return ((CPFDependente)objetoNegocio2).cpf;
    }

    public CPF recuperarMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(1);
    }

    public CPF recuperarSegundoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(2);
    }

    public CPF recuperarTerceiroMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(3);
    }

    public CPF recuperarQuartoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(4);
    }

    public CPF recuperarQuintoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(5);
    }

    public CPF recuperarSextoMaiorDependente() {
        return this.recuperarDependentesPorOrdemValor(6);
    }

    public String verificaObrigatoriedadeEntrega() {
        if (!this.criteriosObrigatoriedadeEntrega().equals("0")) {
            return "1";
        }
        return "0";
    }

    public String criteriosObrigatoriedadeEntrega() {
        Object object;
        Valor valor;
        int n = 0;
        Valor valor2 = valor = this.getModelo() instanceof ModeloCompleta ? new Valor(this.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().getConteudoFormatado()) : new Valor(this.getResumo().getCalculoImposto().getTotalResultadosTributaveis().getConteudoFormatado());
        if (valor.comparacao(">", "30.639,90")) {
            ++n;
        }
        Valor valor3 = new Valor();
        valor3.setConteudo(this.getRendIsentos().getTotal());
        Valor valor4 = new Valor();
        valor4.setConteudo(this.getRendTributacaoExclusiva().getTotal());
        if (valor3.operacao('+', valor4).comparacao(">", ConstantesGlobaisIRPF.LIMITE_REND_ISEN_TRIB_EXCL)) {
            n += 2;
        }
        if (this.getRendIsentos().getGanhosLiqAcoes().comparacao(">", "0,00")) {
            n += 4;
        } else {
            int n2 = 0;
            while (n2 <= 11) {
                object = this.getRendaVariavel().getGanhosPorIndice(n2);
                if (!((GanhosLiquidosOuPerdas)object).getOperacoesComuns().getResultadoLiquidoMes().isVazio()) {
                    n += 4;
                    break;
                }
                if (!((GanhosLiquidosOuPerdas)object).getOperacoesDayTrade().getResultadoLiquidoMes().isVazio()) {
                    n += 4;
                    break;
                }
                ++n2;
            }
        }
        if (this.getBens().getTotalExercicioAtual().comparacao(">", ConstantesGlobaisIRPF.LIMITE_BENS_DIREITOS)) {
            n += 32;
        }
        Valor valor5 = new Valor();
        valor5.setConteudo(this.getAtividadeRural().getBrasil().getApuracaoResultado().getReceitaBrutaTotal());
        object = new Valor();
        ((Valor)object).setConteudo(this.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoI_EmReais());
        if (valor5.operacao('+', (Valor)object).comparacao(">", "153.199,50")) {
            n += 64;
        }
        if (this.getIdentificadorDeclaracao().isCompleta()) {
            if (!this.getAtividadeRural().getBrasil().getApuracaoResultado().getPrejuizoCompensar().isVazio()) {
                n += 128;
            } else if (!this.getAtividadeRural().getExterior().getApuracaoResultado().getPrejuizoCompensar().isVazio()) {
                n += 128;
            }
        }
        return "" + n;
    }

    public RendIsentos getRendIsentos() {
        return this.rendIsentos;
    }

    public int getChaveDependenteOuAlimentando(Pagamento pagamento) {
        block5: {
            int n;
            block4: {
                n = 1;
                if (!pagamento.getTipo().asString().equals(Pagamento.TIPO_DEPENDENTE)) break block4;
                for (Dependente dependente : this.getDependentes().recuperarLista()) {
                    if (dependente.getNome().asString().toUpperCase().equals(pagamento.getDependenteOuAlimentando().asString().toUpperCase())) {
                        return n;
                    }
                    ++n;
                }
                break block5;
            }
            if (!pagamento.getTipo().asString().equals(Pagamento.TIPO_ALIMENTANDO)) break block5;
            for (Alimentando alimentando : this.getAlimentandos().recuperarLista()) {
                if (alimentando.getNome().asString().toUpperCase().equals(pagamento.getDependenteOuAlimentando().asString().toUpperCase())) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    public String getNomeDependenteOuAlimentandoPorChave(Pagamento pagamento, String string) {
        block3: {
            block2: {
                if (!pagamento.getTipo().asString().equals(Pagamento.TIPO_DEPENDENTE)) break block2;
                for (Dependente dependente : this.getDependentes().recuperarLista()) {
                    if (!dependente.getChave().equals(string)) continue;
                    return dependente.getNome().getConteudoFormatado();
                }
                break block3;
            }
            if (!pagamento.getTipo().asString().equals(Pagamento.TIPO_ALIMENTANDO)) break block3;
            for (Alimentando alimentando : this.getAlimentandos().recuperarLista()) {
                if (!alimentando.getChave().equals(string)) continue;
                return alimentando.getNome().getConteudoFormatado();
            }
        }
        return "";
    }

    public Valor recuperarSubTotalExclusivoTransporteRendTribExclusiva() {
        this.getRendTributacaoExclusiva();
        Valor valor = new Valor();
        valor.append('+', this.recuperarRendaVariavelTribtExclusiva());
        return valor;
    }

    public Valor recuperarRendaVariavelTribtExclusiva() {
        return this.rendTributacaoExclusiva.getGanhosRendaVariavel();
    }

    public boolean simplesEhMelhor() {
        Valor valor = new Valor(this.getModeloSimplificada().getImpostoRestituir().getConteudoFormatado());
        Valor valor2 = new Valor(this.getModeloCompleta().getImpostoRestituir().getConteudoFormatado());
        Valor valor3 = new Valor(this.getModeloSimplificada().getSaldoImpostoPagar().getConteudoFormatado());
        Valor valor4 = new Valor(this.getModeloCompleta().getSaldoImpostoPagar().getConteudoFormatado());
        return valor.comparacao(">", valor2) || valor3.comparacao("<", valor4);
    }

    public static void main(String[] stringArray) {
        IdentificadorDeclaracao identificadorDeclaracao = new IdentificadorDeclaracao();
        identificadorDeclaracao.getCpf().setConteudo("00338419500");
        DeclaracaoIRPF declaracaoIRPF = new DeclaracaoIRPF(identificadorDeclaracao);
        RepositorioXMLDefault repositorioXMLDefault = new RepositorioXMLDefault();
        try {
            repositorioXMLDefault.salvar(declaracaoIRPF, "C:\\Dec2.xml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

