/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;

public class PiePlot3D
extends PiePlot
implements Serializable {
    private static final long serialVersionUID = 3408984188945161432L;
    private double depthFactor = 0.2;

    public PiePlot3D() {
        this(null);
    }

    public PiePlot3D(PieDataset pieDataset) {
        super(pieDataset);
        this.setCircular(false, false);
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void setDepthFactor(double d) {
        this.depthFactor = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Object object;
        Object object2;
        Stroke stroke;
        Paint paint;
        Paint paint2;
        Serializable serializable;
        Object object422;
        List list;
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        double d = this.getInteriorGap();
        double d2 = 0.0;
        if (this.getLabelGenerator() != null) {
            d2 = this.getLabelGap() + this.getMaximumLabelWidth() + this.getLabelLinkMargin();
        }
        double d3 = rectangle2D.getWidth() * (d + d2);
        double d4 = rectangle2D.getHeight() * d;
        double d5 = rectangle2D.getX() + d3 / 2.0;
        double d6 = rectangle2D.getY() + d4 / 2.0;
        double d7 = rectangle2D.getWidth() - d3;
        double d8 = rectangle2D.getHeight() - d4;
        if (this.isCircular()) {
            double d9 = Math.min(d7, d8) / 2.0;
            d5 = (d5 + d5 + d7) / 2.0 - d9;
            d6 = (d6 + d6 + d8) / 2.0 - d9;
            d7 = 2.0 * d9;
            d8 = 2.0 * d9;
        }
        PiePlotState piePlotState = this.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
        double d10 = d7 * this.getLabelLinkMargin();
        double d11 = d8 * this.getLabelLinkMargin();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5 + d10 / 2.0, d6 + d11 / 2.0, d7 - d10, d8 - d11);
        piePlotState.setExplodedPieArea(double_);
        double d12 = this.getMaximumExplodePercent();
        double d13 = d12 / (1.0 + d12);
        double d14 = ((RectangularShape)double_).getWidth() * d13;
        double d15 = ((RectangularShape)double_).getHeight() * d13;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(((RectangularShape)double_).getX() + d14 / 2.0, ((RectangularShape)double_).getY() + d15 / 2.0, ((RectangularShape)double_).getWidth() - d14, ((RectangularShape)double_).getHeight() - d15);
        int n = (int)(((RectangularShape)double_2).getHeight() * this.depthFactor);
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d5, d6, d7, d8 - (double)n);
        piePlotState.setLinkArea(double_3);
        piePlotState.setPieArea(double_2);
        piePlotState.setPieCenterX(double_2.getCenterX());
        piePlotState.setPieCenterY(double_2.getCenterY() - (double)n / 2.0);
        piePlotState.setPieWRadius(((RectangularShape)double_2).getWidth() / 2.0);
        piePlotState.setPieHRadius((((RectangularShape)double_2).getHeight() - (double)n) / 2.0);
        this.drawBackground(graphics2D, rectangle2D);
        PieDataset pieDataset = this.getDataset();
        if (DatasetUtilities.isEmptyOrNull(this.getDataset())) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
            graphics2D.setClip(shape);
            this.drawOutline(graphics2D, rectangle2D);
            return;
        }
        if ((double)pieDataset.getKeys().size() > rectangle2D.getWidth()) {
            String string = "Too many elements";
            Font font = new Font("dialog", 1, 10);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n2 = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, (int)(rectangle2D.getX() + (rectangle2D.getWidth() - (double)n2) / 2.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0));
            return;
        }
        if (this.isCircular()) {
            double d16 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
            rectangle2D = new Rectangle2D.Double(rectangle2D.getCenterX() - d16, rectangle2D.getCenterY() - d16, 2.0 * d16, 2.0 * d16);
        }
        if ((list = pieDataset.getKeys()).size() == 0) {
            return;
        }
        double d17 = ((RectangularShape)double_2).getX();
        double d18 = ((RectangularShape)double_2).getY();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        double d19 = DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        double d20 = 0.0;
        if (n < 0) {
            return;
        }
        ArrayList<Arc2D.Double> arrayList = new ArrayList<Arc2D.Double>();
        for (Object object422 : list) {
            double d21;
            double d22;
            serializable = pieDataset.getValue((Comparable)object422);
            if (serializable == null) {
                arrayList.add(null);
                continue;
            }
            double d23 = ((Number)serializable).doubleValue();
            if (d23 <= 0.0) {
                arrayList.add(null);
                continue;
            }
            double d24 = this.getStartAngle();
            double d25 = d24 + (d22 = this.getDirection().getFactor()) * (d20 + d23) * 360.0 / d19;
            if (Math.abs(d25 - (d21 = d24 + d22 * (d20 * 360.0) / d19)) > this.getMinimumArcAngleToDraw()) {
                arrayList.add(new Arc2D.Double(d17, d18 + (double)n, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, d21, d25 - d21, 2));
            } else {
                arrayList.add(null);
            }
            d20 += d23;
        }
        object422 = graphics2D.getClip();
        serializable = new Ellipse2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY(), ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY() + (double)n, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n);
        Rectangle2D.Double double_5 = new Rectangle2D.Double(((RectangularShape)((Object)serializable)).getX(), ((RectangularShape)((Object)serializable)).getCenterY(), ((RectangularShape)double_2).getWidth(), double_4.getMaxY() - ((RectangularShape)((Object)serializable)).getCenterY());
        Rectangle2D.Double double_6 = new Rectangle2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)((Object)serializable)).getY(), ((RectangularShape)double_2).getWidth(), double_4.getCenterY() - ((RectangularShape)((Object)serializable)).getY());
        Area area = new Area((Shape)((Object)serializable));
        area.add(new Area(double_5));
        Area area2 = new Area(double_4);
        area2.add(new Area(double_6));
        Area area3 = new Area(area);
        area3.intersect(area2);
        Area area4 = new Area(area3);
        area4.subtract(new Area((Shape)((Object)serializable)));
        Area area5 = new Area(area3);
        area5.subtract(new Area(double_4));
        Arc2D.Double double_7 = new Arc2D.Double(d17, d18 + (double)n, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, 0.0, 360.0, 2);
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            double_7 = (Arc2D.Double)arrayList.get(n4);
            if (double_7 != null) {
                Comparable object32 = this.getSectionKey(n4);
                paint2 = this.lookupSectionPaint(object32, true);
                paint = this.lookupSectionOutlinePaint(object32);
                stroke = this.lookupSectionOutlineStroke(object32);
                graphics2D.setPaint(paint2);
                graphics2D.fill(double_7);
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                graphics2D.draw(double_7);
                graphics2D.setPaint(paint2);
                object2 = double_7.getStartPoint();
                int[] nArray = new int[]{(int)double_7.getCenterX(), (int)double_7.getCenterX(), (int)((Point2D)object2).getX(), (int)((Point2D)object2).getX()};
                int[] nArray2 = new int[]{(int)double_7.getCenterY(), (int)double_7.getCenterY() - n, (int)((Point2D)object2).getY() - n, (int)((Point2D)object2).getY()};
                object = new Polygon(nArray, nArray2, 4);
                graphics2D.setPaint(Color.lightGray);
                graphics2D.fill((Shape)object);
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                graphics2D.draw((Shape)object);
                graphics2D.setPaint(paint2);
            }
            ++n4;
        }
        graphics2D.setPaint(Color.gray);
        graphics2D.fill(area5);
        graphics2D.fill(area4);
        n4 = 0;
        for (Arc2D arc2D : arrayList) {
            if (arc2D != null) {
                object2 = this.getSectionKey(n4);
                paint2 = this.lookupSectionPaint((Comparable)object2, true);
                paint = this.lookupSectionOutlinePaint((Comparable)object2);
                stroke = this.lookupSectionOutlineStroke((Comparable)object2);
                this.drawSide(graphics2D, double_2, arc2D, area4, area5, paint2, paint, stroke, false, true);
            }
            ++n4;
        }
        n4 = 0;
        for (Arc2D arc2D : arrayList) {
            if (arc2D != null) {
                object2 = this.getSectionKey(n4);
                paint2 = this.lookupSectionPaint((Comparable)object2);
                paint = this.lookupSectionOutlinePaint((Comparable)object2);
                stroke = this.lookupSectionOutlineStroke((Comparable)object2);
                this.drawSide(graphics2D, double_2, arc2D, area4, area5, paint2, paint, stroke, true, false);
            }
            ++n4;
        }
        graphics2D.setClip((Shape)object422);
        int n2 = 0;
        while (n2 < n3) {
            double_7 = (Arc2D.Double)arrayList.get(n2);
            if (double_7 != null) {
                Object object3;
                Object object4;
                Arc2D.Double double_8 = new Arc2D.Double(d17, d18, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, double_7.getAngleStart(), double_7.getAngleExtent(), 2);
                object = (Comparable)list.get(n2);
                paint2 = this.lookupSectionPaint((Comparable)object, true);
                paint = this.lookupSectionOutlinePaint((Comparable)object);
                stroke = this.lookupSectionOutlineStroke((Comparable)object);
                graphics2D.setPaint(paint2);
                graphics2D.fill(double_8);
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint);
                graphics2D.draw(double_8);
                if (plotRenderingInfo != null && (object4 = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                    object3 = null;
                    PieToolTipGenerator pieToolTipGenerator = this.getToolTipGenerator();
                    if (pieToolTipGenerator != null) {
                        object3 = pieToolTipGenerator.generateToolTip(pieDataset, (Comparable)object);
                    }
                    String string = null;
                    if (this.getURLGenerator() != null) {
                        string = this.getURLGenerator().generateURL(pieDataset, (Comparable)object, this.getPieIndex());
                    }
                    PieSectionEntity pieSectionEntity = new PieSectionEntity(double_8, pieDataset, this.getPieIndex(), n2, (Comparable)object, (String)object3, string);
                    object4.add(pieSectionEntity);
                }
                object4 = pieDataset.getKeys();
                object3 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() - (double)n);
                this.drawLabels(graphics2D, (List)object4, d19, (Rectangle2D)object3, double_3, piePlotState);
            }
            ++n2;
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    protected void drawSide(Graphics2D graphics2D, Rectangle2D rectangle2D, Arc2D arc2D, Area area, Area area2, Paint paint, Paint paint2, Stroke stroke, boolean bl, boolean bl2) {
        double d = arc2D.getAngleStart();
        double d2 = arc2D.getAngleExtent();
        double d3 = d + d2;
        graphics2D.setStroke(stroke);
        if (d2 < 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 > -180.0) {
                        if (bl) {
                            Area area3 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                            area3.intersect(area);
                            graphics2D.setPaint(paint);
                            graphics2D.fill(area3);
                            graphics2D.setPaint(paint2);
                            graphics2D.draw(area3);
                        }
                    } else {
                        Area area4 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area4.intersect(area);
                        Area area5 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area5.intersect(area);
                        graphics2D.setPaint(paint);
                        if (bl) {
                            graphics2D.fill(area4);
                            graphics2D.fill(area5);
                        }
                        if (bl2) {
                            graphics2D.fill(area2);
                        }
                        graphics2D.setPaint(paint2);
                        if (bl) {
                            graphics2D.draw(area4);
                            graphics2D.draw(area5);
                        }
                        if (bl2) {
                            graphics2D.draw(area2);
                        }
                    }
                } else {
                    Area area6;
                    if (bl2) {
                        area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area6.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area6);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area6);
                    }
                    if (bl) {
                        area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area6.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area6);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area6);
                    }
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 > -180.0) {
                    if (bl2) {
                        Area area7 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area7.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area7);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area7);
                    }
                } else {
                    Area area8 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area8.intersect(area2);
                    Area area9 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area9.intersect(area2);
                    graphics2D.setPaint(paint);
                    if (bl2) {
                        graphics2D.fill(area8);
                        graphics2D.fill(area9);
                    }
                    if (bl) {
                        graphics2D.fill(area);
                    }
                    graphics2D.setPaint(paint2);
                    if (bl2) {
                        graphics2D.draw(area8);
                        graphics2D.draw(area9);
                    }
                    if (bl) {
                        graphics2D.draw(area);
                    }
                }
            } else {
                Area area10;
                if (bl2) {
                    area10 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area10.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area10);
                }
                if (bl) {
                    area10 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area10.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area10);
                }
            }
        } else if (d2 > 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 < 180.0) {
                        if (bl) {
                            Area area11 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                            area11.intersect(area);
                            graphics2D.setPaint(paint);
                            graphics2D.fill(area11);
                            graphics2D.setPaint(paint2);
                            graphics2D.draw(area11);
                        }
                    } else {
                        Area area12 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area12.intersect(area);
                        Area area13 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area13.intersect(area);
                        graphics2D.setPaint(paint);
                        if (bl) {
                            graphics2D.fill(area12);
                            graphics2D.fill(area13);
                        }
                        if (bl2) {
                            graphics2D.fill(area2);
                        }
                        graphics2D.setPaint(paint2);
                        if (bl) {
                            graphics2D.draw(area12);
                            graphics2D.draw(area13);
                        }
                        if (bl2) {
                            graphics2D.draw(area2);
                        }
                    }
                } else {
                    Area area14;
                    if (bl2) {
                        area14 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area14);
                    }
                    if (bl) {
                        area14 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area14);
                    }
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 < 180.0) {
                    if (bl2) {
                        Area area15 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area15.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area15);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area15);
                    }
                } else {
                    Area area16 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area16.intersect(area2);
                    Area area17 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area17.intersect(area2);
                    graphics2D.setPaint(paint);
                    if (bl2) {
                        graphics2D.fill(area16);
                        graphics2D.fill(area17);
                    }
                    if (bl) {
                        graphics2D.fill(area);
                    }
                    graphics2D.setPaint(paint2);
                    if (bl2) {
                        graphics2D.draw(area16);
                        graphics2D.draw(area17);
                    }
                    if (bl) {
                        graphics2D.draw(area);
                    }
                }
            } else {
                Area area18;
                if (bl2) {
                    area18 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area18.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area18);
                }
                if (bl) {
                    area18 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area18.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area18);
                }
            }
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Pie_3D_Plot");
    }

    private boolean isAngleAtFront(double d) {
        return Math.sin(Math.toRadians(d)) < 0.0;
    }

    private boolean isAngleAtBack(double d) {
        return Math.sin(Math.toRadians(d)) > 0.0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PiePlot3D)) {
            return false;
        }
        PiePlot3D piePlot3D = (PiePlot3D)object;
        if (this.depthFactor != piePlot3D.depthFactor) {
            return false;
        }
        return super.equals(object);
    }
}

