/*
 * Decompiled with CFR 0.152.
 */
package org.fsfla.irpf;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import serpro.ppgd.formatosexternos.barcode.BarcodeEncoder;
import serpro.ppgd.formatosexternos.barcode.util.DarfAdaptor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConstantesRepositorio;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.Validador;

public class Main {
    public static void ajuda() {
        System.out.println(String.valueOf(ConstantesGlobais.NOME_PROGRAMA) + "\n" + "Copyright 2007-2024 FSFLA\n" + "Licenciado sob GNU LGPLv2.1+ e outras licen\u00e7as livres, SEM QUALQUER GARANTIA.\n" + "Veja o leiame para maiores detalhes.\n" + "\n" + "leiame: mostra instru\u00e7\u00f5es mais longas de uso\n" + "nova CPF: cria nova declara\u00e7\u00e3o\n" + "remove CPF: remove declara\u00e7\u00e3o\n" + "importa CPF: importa declara\u00e7\u00e3o do ano anterior\n" + "grava CPF: faz c\u00f3pia de seguran\u00e7a da declara\u00e7\u00e3o\n" + "restaura CPF: restaura c\u00f3pia de seguran\u00e7a\n" + "recalcula CPF: refaz c\u00e1lculos na declara\u00e7\u00e3o\n" + "verifica CPF: verifica pend\u00eancias\n" + "calculaDV CPF: calcula d\u00edgitos verificadores de recibos\n" + "prepara CPF: prepara declara\u00e7\u00e3o para envio\n" + "resumo CPF: apresenta resumo da declara\u00e7\u00e3o\n" + "darf CPF: gera c\u00f3digo de barras para pagamento\n" + "completa CPF: imprime declara\u00e7\u00e3o completa\n" + "recibo CPF: imprime recibo da declara\u00e7\u00e3o\n");
    }

    public static void leiame() throws Exception {
        int n;
        InputStream inputStream = Main.class.getClassLoader().getResource("LEIAME").openStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            System.out.write(byArray, 0, n);
        }
    }

    protected static DeclaracaoIRPF leDeclXML(String string) throws Exception {
        if (!IRPFFacade.existeDeclaracao(string)) {
            throw new Exception("Declara\u00e7\u00e3o n\u00e3o encontrada");
        }
        DeclaracaoIRPF declaracaoIRPF = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(string);
        IdentificadorDeclaracao identificadorDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(string);
        IRPFFacade.abreDeclaracao(identificadorDeclaracao);
        IRPFFacade.getInstancia();
        declaracaoIRPF = IRPFFacade.getDeclaracao();
        Main.recalcula(declaracaoIRPF);
        return declaracaoIRPF;
    }

    public static void nova(String string) throws Exception {
        if (IRPFFacade.existeDeclaracao(string)) {
            System.err.println("declara\u00e7\u00e3o j\u00e1 existe, remova para confirmar");
            return;
        }
        IdentificadorDeclaracao identificadorDeclaracao = new IdentificadorDeclaracao();
        identificadorDeclaracao.getCpf().setConteudo(string);
        IRPFFacade.criarDeclaracao(identificadorDeclaracao);
    }

    public static void remove(String string) throws Exception {
        if (IRPFFacade.existeDeclaracao(string)) {
            IRPFFacade.excluirDeclaracao(string);
        } else {
            System.err.println("declara\u00e7\u00e3o n\u00e3o registrada");
        }
    }

    public static void importa(String string) throws Exception {
        File file = null;
        String string2 = null;
        boolean bl = false;
        Object object = new String[]{"-IRPF-A-" + ConstantesGlobais.EXERCICIO_ANTERIOR + "-" + ConstantesGlobais.ANO_BASE_ANTERIOR + "-RETIF", "-IRPF-A-" + ConstantesGlobais.EXERCICIO_ANTERIOR + "-" + ConstantesGlobais.ANO_BASE_ANTERIOR + "-ORIGI"};
        Object object2 = new String[]{".DEC", ".DBK"};
        int n = 0;
        block0: while (n < ((String[])object).length) {
            int n2 = 0;
            while (n2 < ((String[])object2).length) {
                string2 = String.valueOf(string) + object[n] + object2[n2];
                file = new File(string2);
                if (file.exists()) {
                    bl = n2 == 0;
                    break block0;
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            bl = new File(String.valueOf(string2.substring(0, string2.length() - 4)) + ".REC").exists();
        }
        System.out.println("importando de " + string2 + (bl ? " com recibo" : " sem recibo"));
        object = new ImportadorTxt();
        if (IRPFFacade.existeDeclaracao(string)) {
            System.err.println("declara\u00e7\u00e3o j\u00e1 existe, remova para confirmar");
            return;
        }
        object2 = ((ImportadorTxt)object).restaurarIdDeclaracaoNaoPersistidoAnoAnterior(file);
        IRPFFacade.criarDeclaracao((IdentificadorDeclaracao)object2);
        object2 = ((ImportadorTxt)object).importarDeclaracaoAnoAnterior(file, bl);
        if (bl) {
            String string3 = ((ImportadorTxt)object).getRepositorioTxt().recuperarNroRecibo();
            string3 = String.valueOf(string3) + Validador.calcularModulo11(string3, null, 2);
            string3 = String.valueOf(string3) + Validador.calcularModulo11(string3, null, 2);
            ((IdentificadorDeclaracao)object2).getNumeroReciboDecAnterior().setConteudo(string3);
            IRPFFacade.getInstancia().salvarDeclaracao(string);
        }
    }

    public static void grava(String string) throws Exception {
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        String string2 = GravadorTXT.montaNomeArquivoTXT(ConstantesRepositorio.GRAV_COPIA, declaracaoIRPF.getIdentificadorDeclaracao());
        System.out.println("gravando em " + string2);
        RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(string2));
        repositorioDeclaracaoCentralTxt.atualizarDeclaracao(declaracaoIRPF, RepositorioDeclaracaoCentralTxt.FINALIDADE_BACKUP);
        String string3 = repositorioDeclaracaoCentralTxt.getArquivo().calcularHash();
        Vector vector = repositorioDeclaracaoCentralTxt.getConversor2Registros().montarRegistroHeader(declaracaoIRPF);
        repositorioDeclaracaoCentralTxt.getArquivo().atualizaHeader(vector, string3);
        repositorioDeclaracaoCentralTxt.getArquivo().salvar();
    }

    public static void restaura(String string) throws Exception {
        File file = null;
        String string2 = null;
        Object object = new String[]{"-IRPF-A-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.ANO_BASE + "-RETIF", "-IRPF-A-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.ANO_BASE + "-ORIGI"};
        String[] stringArray = new String[]{".DEC", ".DBK"};
        int n = 0;
        block0: while (n < ((String[])object).length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                string2 = String.valueOf(string) + (String)object[n] + stringArray[n2];
                file = new File(string2);
                if (file.exists()) break block0;
                ++n2;
            }
            ++n;
        }
        System.out.println("restaurando de " + string2);
        object = new ImportadorTxt();
        ((ImportadorTxt)object).restaurarDeclaracao(file);
    }

    public static void recalcula(DeclaracaoIRPF declaracaoIRPF) {
    }

    public static void recalcula(String string) throws Exception {
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        declaracaoIRPF.getBens().excluirRegistrosEmBranco();
        Bens bens = declaracaoIRPF.getBens();
        boolean bl = false;
        int n = 0;
        while (n < bens.recuperarLista().size()) {
            Bem bem = (Bem)bens.recuperarLista().get(n);
            int n2 = bem.getChave().asInteger();
            if (n2 != n + 1) {
                bl = true;
                System.out.println("O bem agora com chave " + (n + 1) + " antes tinha chave " + n2 + ".");
                bem.getChave().setConteudo(n + 1);
            }
            ++n;
        }
        if (bl) {
            System.out.println("ATEN\u00c7\u00c3O: ocorr\u00eancias dessas chaves em quadros auxiliares, se houver, N\u00c3O foram atualizadas.");
        }
        IRPFFacade.salvaDeclaracaoAberta();
    }

    public static boolean verifica(String string) throws Exception {
        Pendencia pendencia;
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        List list = FabricaUtilitarios.verificarPendencias(declaracaoIRPF);
        if (list.isEmpty()) {
            System.out.println("N\u00e3o h\u00e1 pend\u00eancias.");
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                pendencia = (Pendencia)iterator.next();
                if (!pendencia.isErro()) {
                    bl2 = true;
                    continue;
                }
                if (!bl) {
                    System.out.println("Pend\u00eancias graves:\n");
                    bl = true;
                }
                System.out.println(pendencia.getMsg());
                System.out.println("no item " + pendencia.getNumItem());
                if (pendencia.getCampo() != null) {
                    System.out.println("do campo " + pendencia.getCampo());
                }
                if (pendencia.getEntidade() != null) {
                    System.out.println("da entidade " + pendencia.getEntidade());
                }
                System.out.println("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            return bl;
        }
        System.out.println("Avisos:\n");
        iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                pendencia = (Pendencia)iterator.next();
                if (pendencia.isErro()) continue;
                System.out.println(pendencia.getMsg());
                System.out.println("no item " + pendencia.getNumItem());
                if (pendencia.getCampo() != null) {
                    System.out.println("do campo " + pendencia.getCampo());
                }
                if (pendencia.getEntidade() != null) {
                    System.out.println("da entidade " + pendencia.getEntidade());
                }
                System.out.println("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static void calculaDV(String string) throws Exception {
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        IdentificadorDeclaracao identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        Alfa alfa = identificadorDeclaracao.getNumeroReciboDecAnterior();
        String string2 = alfa.getConteudoFormatado();
        if (string2.length() == 10) {
            string2 = String.valueOf(string2) + Validador.calcularModulo11(string2, null, 2);
            string2 = String.valueOf(string2) + Validador.calcularModulo11(string2, null, 2);
            alfa.setConteudo(string2);
            IRPFFacade.getInstancia().salvarDeclaracao(string);
        }
        if (identificadorDeclaracao.isRetificadora() && (string2 = (alfa = identificadorDeclaracao.getNumReciboDecRetif()).getConteudoFormatado()).length() == 10) {
            string2 = String.valueOf(string2) + Validador.calcularModulo11(string2, null, 2);
            string2 = String.valueOf(string2) + Validador.calcularModulo11(string2, null, 2);
            alfa.setConteudo(string2);
            IRPFFacade.getInstancia().salvarDeclaracao(string);
        }
    }

    public static void prepara(String string) throws Exception {
        if (Main.verifica(string)) {
            System.out.println("Ignorando pendencias");
        }
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        String string2 = GravadorTXT.montaNomeArquivoTXT(ConstantesRepositorio.GRAV_GERACAO, declaracaoIRPF.getIdentificadorDeclaracao());
        RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(string2));
        repositorioDeclaracaoCentralTxt.atualizarDeclaracao(declaracaoIRPF, RepositorioDeclaracaoCentralTxt.FINALIDADE_ENTREGA);
        String string3 = repositorioDeclaracaoCentralTxt.getArquivo().calcularHash();
        Vector vector = repositorioDeclaracaoCentralTxt.getConversor2Registros().montarRegistroHeader(declaracaoIRPF);
        repositorioDeclaracaoCentralTxt.getArquivo().atualizaHeader(vector, string3);
        vector = repositorioDeclaracaoCentralTxt.getConversor2Registros().montarRecibo(declaracaoIRPF);
        repositorioDeclaracaoCentralTxt.getArquivo().incluirRecibo(vector, string3);
        repositorioDeclaracaoCentralTxt.getArquivo().salvar();
        String string4 = string3;
        string4 = String.valueOf(string4) + Validador.calcularModulo11(string4, null, 2);
        string4 = String.valueOf(string4) + Validador.calcularModulo11(string4, null, 2);
        System.out.println("gravada em " + string2 + " com recibo " + string4);
    }

    public static void resumo(String string) throws Exception {
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        String string2 = declaracaoIRPF.getResumo().getCalculoImposto().getBaseCalculo().toString();
        System.out.println("Base de C\u00e1lculo: " + string2);
        string2 = declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoMaisImpostoComplementar().toString();
        System.out.println("Carn\u00ea Le\u00e3o e Imposto Complementar: " + string2);
        string2 = declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosNaoTributaveis().toString();
        System.out.println("Rendimentos Isentos: " + string2);
        string2 = declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosTributacaoExclusiva().toString();
        System.out.println("Rendimentos sujeitos a Tributa\u00e7\u00e3o Exclusiva na Fonte: " + string2);
        System.out.println("Imposto a pagar: " + declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar().toString());
        System.out.println("Al\u00edquota efetiva: " + declaracaoIRPF.getModelo().getAliquotaEfetiva().toString());
        System.out.println("Imposto a restituir: " + declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRestituir().toString());
        System.out.println("Modelo de declara\u00e7\u00e3o: " + (declaracaoIRPF.getIdentificadorDeclaracao().isCompleta() ? "completa" : "simplificada") + (declaracaoIRPF.getIdentificadorDeclaracao().isCompleta() == declaracaoIRPF.simplesEhMelhor() ? ", mas ATEN\u00c7\u00c3O: esse modelo \u00e9 menos vantajoso!" : ", o modelo mais vantajoso"));
    }

    public static void darf(String string) throws Exception {
        Object object;
        Object object2;
        DeclaracaoIRPF declaracaoIRPF = Main.leDeclXML(string);
        if (declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota().comparacao("<=", "0,00")) {
            System.out.println("N\u00e3o h\u00e1 saldo de imposto a pagar");
            return;
        }
        DarfAdaptor darfAdaptor = new DarfAdaptor();
        try {
            darfAdaptor.setCodigoEmpresa("0064");
            darfAdaptor.setIndicadorManualCalculado("1");
            darfAdaptor.setCpfCnpj(declaracaoIRPF.getIdentificadorDeclaracao().getCpf());
            darfAdaptor.setNome(declaracaoIRPF.getIdentificadorDeclaracao().getNome().toString());
            darfAdaptor.setTelefone("(" + declaracaoIRPF.getContribuinte().getDdd().asString() + ") " + declaracaoIRPF.getContribuinte().getTelefone().asString());
            object2 = new Data();
            ((Data)object2).setConteudo("31/12/" + ConstantesGlobais.ANO_BASE);
            darfAdaptor.setPeriodoApuracao((Data)object2);
            darfAdaptor.setCodigoReceita("0211");
            darfAdaptor.setNumeroReferencia("856");
            object = new Data();
            ((Data)object).setConteudo("30/04/" + ConstantesGlobais.EXERCICIO);
            darfAdaptor.setDataVencimento((Data)object);
            darfAdaptor.setValorPrincipal(declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota().asString());
            darfAdaptor.setValorMulta("0,00");
            darfAdaptor.setValorJuros("0,00");
            darfAdaptor.setValorTotal(declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota().asString());
            darfAdaptor.setDataValidade((Data)object);
            darfAdaptor.setMensagem("IRPF " + ConstantesGlobais.EXERCICIO + " quota " + (declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asInteger() == 1 ? "\u00fanica" : "1 de " + declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asString()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = BarcodeEncoder.gerarCodigo(darfAdaptor);
        object = ((BarcodeEncoder)object2).getGrupos();
        System.out.println("01 Nome/Telefone: " + darfAdaptor.getNome() + " / " + darfAdaptor.getTelefone());
        System.out.println("02 Per\u00edodo de Apura\u00e7\u00e3o: " + darfAdaptor.getPeriodoApuracao().getConteudoFormatado());
        System.out.println("03 CPF: " + darfAdaptor.getCpfCnpj().getConteudoFormatado());
        System.out.println("04 C\u00f3digo da Receita: " + darfAdaptor.getCodigoReceita());
        System.out.println("05 N\u00famero de Refer\u00eancia: " + darfAdaptor.getNumeroReferencia());
        System.out.println("06 Data de Vencimento: " + darfAdaptor.getDataVencimento().getConteudoFormatado());
        System.out.println("07 Valor do Principal: " + darfAdaptor.getValorPrincipal());
        System.out.println("08 Valor da Multa: " + darfAdaptor.getValorMulta());
        System.out.println("09 Valor dos Juros: " + darfAdaptor.getValorJuros());
        System.out.println("10 Valor Total: " + darfAdaptor.getValorTotal());
        if (declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota().comparacao("<", "10,00")) {
            System.out.println("N\u00e3o \u00e9 permitido o recolhimento de DARF com valor inferior a R$ 10,00");
            return;
        }
        System.out.println();
        System.out.println(darfAdaptor.getMensagem());
        System.out.println("DARF v\u00e1lido para pagamento at\u00e9 " + darfAdaptor.getDataValidade().getConteudoFormatado());
        System.out.print("C\u00f3digo de barras:");
        int n = 0;
        while (n < ((Object)object).length) {
            System.out.print(" " + (String)object[n]);
            ++n;
        }
        System.out.println("");
    }

    public static void completa(String string) throws Exception {
        Main.leDeclXML(string);
        System.out.println("ainda n\u00e3o funciona :-(");
    }

    public static void recibo(String string) throws Exception {
        System.out.println("ainda n\u00e3o funciona :-(");
    }

    public static void main(String[] stringArray) {
        try {
            PlataformaPPGD.setEmDesign(false);
            int n = 0;
            if (stringArray.length >= 1 && "leiame".equals(stringArray[0])) {
                Main.leiame();
            } else if (stringArray.length != 2) {
                Main.ajuda();
            } else if ("nova".equals(stringArray[0])) {
                Main.nova(stringArray[1]);
            } else if ("remove".equals(stringArray[0])) {
                Main.remove(stringArray[1]);
            } else if ("importa".equals(stringArray[0])) {
                Main.importa(stringArray[1]);
            } else if ("grava".equals(stringArray[0])) {
                Main.grava(stringArray[1]);
            } else if ("restaura".equals(stringArray[0])) {
                Main.restaura(stringArray[1]);
            } else if ("recalcula".equals(stringArray[0])) {
                Main.recalcula(stringArray[1]);
            } else if ("verifica".equals(stringArray[0])) {
                n = Main.verifica(stringArray[1]) ? 1 : 0;
            } else if ("calculaDV".equals(stringArray[0])) {
                Main.calculaDV(stringArray[1]);
            } else if ("prepara".equals(stringArray[0])) {
                Main.prepara(stringArray[1]);
            } else if ("resumo".equals(stringArray[0])) {
                Main.resumo(stringArray[1]);
            } else if ("darf".equals(stringArray[0])) {
                Main.darf(stringArray[1]);
            } else if ("completa".equals(stringArray[0])) {
                Main.completa(stringArray[1]);
            } else if ("recibo".equals(stringArray[0])) {
                Main.recibo(stringArray[1]);
            } else {
                Main.ajuda();
            }
            System.exit(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

