<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!--
    
    ver_TipoArquivo_e_Nomes_do_mapeamentoTxt.xslt: Transformador XSL para listar os tipos de quadros e nomes dos registros e dos campos de um arquivo mapeamentoTxt.xml.
    
    Copyright 2023 FSFLA
    
    Este arquivo é parte do IRPF-Livre.
    
    IRPF-Livre é Software Livre; você pode redistribuir e/ou modificar a
    maior parte dele, inclusive este arquivo, de acordo com os termos da
    GNU Lesser General Public License publicada pela Free Software
    Foundation; tanto a versão 2.1 dessa licença, quanto (à sua escolha)
    qualquer versão posterior.
    
    Alguns componentes podem ser distribuídos e/ou modificados deacordo
    com outras licenças, incluídas no executável e consolidadas no arquivo
    list/licenses nos fontes.
    
    IRPF-Livre é distribuído na esperança de que ele seja útil, mas SEM
    QUALQUER GARANTIA; até mesmo sem qualquer garantia implícita de
    COMERCIABILIDADE OU ADEQUAÇÃO A UMA FINALIDADE ESPECÍFICA. Consulte a
    GNU Lesser General Public License para mais detalhes.
    
    Você deve ter recebido uma cópia da GNU Lesser General Public License
    junto com IRPF-Livre; se não, escreva para a Free Software Foundation,
    Inc., no endereço 59 Temple Street, Suite 330, Boston, MA 02111-1307
    USA.
    
    Veja uma tradução não oficial da licença em
    http://creativecommons.org/licenses/LGPL/2.1/legalcode.pt
    
    
    This file is part of IRPF-Livre.
    
    IRPF-Livre is free software; you can redistribute and/or modify most
    of it, this file included, under the terms of the GNU Lesser General
    Public License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.
    
    Some components can be distributed and/or modified under different
     licenses, included in the executable and consolidated in the file
     list/licenses in the source tree.
    
    IRPF-Livre is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.
    
    You should have received a copy of the GNU Lesser General Public
    License along with IRPF-Livre; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA.
    
  -->

  <!--

    # Contribuintes

    * Adonay Felipe Nogueira <https://libreplanet.org/wiki/User:Adfeno>

    # Como usar

    Para usar, instale um processador de XSLT 1.0, como o 
    `xsltproc` do pacote libxslt ou similar e faça algo como:

    xsltproc "Este script" "XML do mapeamentoTxt"

    Salvando duas saídas deste script sobre mapeamentoTxt.xml 
    de anos diferentes, pode-se então proceder com a 
    comparação, pelo menos, dos nomes dos campos que talvez 
    foram alterados de um ano para o outro. Todavia, este 
    script não compara o tamanho ou tipo do conteúdo esperado 
    no arquivo de declaração (.DEC). Para estes últimos dois 
    casos veja a descrição do script 
    `tirar_ano_anterior_do_mapeamentoTxt.xslt`.

  -->

  <!-- Gera arquivos de texto não XML, codificados em UTF-8. -->
  <xsl:output method="text" encoding="UTF-8" />
  <!-- Tentamos fazer igual como em `tirar_ano_anterior_do_mapeamentoTxt.xslt`, mas parece que no XSLT, o aceite de generalizações é mais fácil de lidar, uma vez que já se sabe as exceções que devem ser ignoradas. Todavia, quando se quer manipular nós específicos e ter resultado em um texto não XML, então torna-se necessário eliminar as linhas em branco ou espaços extras que seriam deixados. -->
  <!-- ATENÇÃO: Também retira espaços extras do próprio conteúdo do XML, não importa onde estejam, podendo assim causar diferenças na hora de fazer algumas comparações. -->
  <!-- FIXME: Ver se esta função é necessária. -->
  <!-- FIXME: Impacta na quebra das linhas. Procure por `&#10;`. -->
  <xsl:strip-space elements='*' />

  <!-- Inicia no nó raiz. -->
  <xsl:template match='/'>
    <!-- Não precisamos do prefixo "/Mapeamento/DeclaracaoTXT[@TipoArquivo]/Registro[@Nome]/" para fazer a seleção funcionar, mas verificamos se (`xsl:if`) este existe para identificar falha no mapeamentoTxt.xml informado. -->
    <xsl:if test='not(/Mapeamento/DeclaracaoTXT[@TipoArquivo]/Registro[@Nome]/Campo[@Nome])'>
      <!-- Termina o processador com erro e imprime no descritor de erro padrão (stderr). -->
      <xsl:message terminate="yes">
        <!-- Ignora os espaços e tabulaçãoes/tabs em volta, usando apenas o texto dentro de `xsl:text`. -->
        <xsl:text>XML sem quadro com tipo, contendo registros e campos com nomes.</xsl:text>
      </xsl:message>
    </xsl:if>
    <!-- Tudo normal, continua (aplica os outros modelos para todos os nós descendentes) -->
    <xsl:apply-templates/>
  </xsl:template>

  <!-- Para todos os nós e atributos… -->
  <xsl:template match='node() | @*'>
    <!-- Copia eles. -->
    <xsl:copy>
      <!-- Segue procurando por outro modelos a aplicar ou reexibe. -->
      <xsl:apply-templates select='node() | @*'/>
    </xsl:copy>
  </xsl:template>

  <!-- Não precisamos do prefixo "/Mapeamento/DeclaracaoTXT[@TipoArquivo]/Registro[@Nome]/" para fazer a seleção funcionar, mas mantemos o prefixo para coincidir com o a verificação inicial. -->
  <xsl:template match='/Mapeamento/DeclaracaoTXT[@TipoArquivo]/Registro[@Nome]/Campo[@Nome]'>
    <!-- A sequência de `xsl:text` e `xsl:value-of` monta e imprime uma representação do caminho XPath que pode ser reprocessada mais tarde. -->
    <xsl:text>/Mapeamento/DeclaracaoTXT[@TipoArquivo = "</xsl:text>
    <!-- Pega o valor do nó ou atributo selecionado. -->
    <xsl:value-of select='../../@TipoArquivo' />
    <xsl:text>"]/Registro[@Nome = "</xsl:text>
    <xsl:value-of select='../@Nome' />
    <xsl:text>"]/Campo[@Nome = "</xsl:text>
    <xsl:value-of select='@Nome' />
    <!-- FIXME: Como `xsl:strip-space elements='*'` impacta na quebra de linhas, forçamos uma agora com um line feed (LF, `\n`), independente do que foi usado no arquivo original ou das preferências do sistema ou do usuário. -->
    <xsl:text>"]&#10;</xsl:text>
  </xsl:template>
</xsl:stylesheet>
