/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural;

import java.util.List;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ImovelAR
extends ObjetoNegocio {
    protected Codigo codigo = new Codigo(this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoAtividadesRural());
    protected Alfa nome = new Alfa(this, "Nome do Im\u00f3vel", 60);
    protected Alfa localizacao = new Alfa(this, "Localiza\u00e7\u00e3o do Im\u00f3vel", 55);
    protected Valor area = new Valor(this, "\u00c1rea(ha)");
    protected Valor participacao = new Valor(this, "Participa\u00e7\u00e3o(%)");
    protected Codigo condicaoExploracao = new Codigo(this, "Condi\u00e7\u00e3o de Explora\u00e7\u00e3o", CadastroTabelasIRPF.recuperarCondicoesExploracao());

    public ImovelAR() {
        this.getParticipacao().setMaximoDigitosParteInteira(3);
        this.getArea().setMaximoDigitosParteInteira(9);
        this.getArea().converteQtdCasasDecimais(1);
        this.getCodigo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("ficha_imovel_ar_codigo")){

            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getNome().addValidador(new ValidadorNaoNulo(3, this.tab.msg("ficha_imovel_ar_nome")){

            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.getCodigo().isVazio()) {
                    return null;
                }
                String string = ImovelAR.this.getCodigo().getConteudoAtual(0);
                if (string.trim().equals("13") || string.trim().equals("14") || string.trim().equals("15") || string.trim().equals("99")) {
                    this.setSeveridade((byte)2);
                } else if (string.trim().equals("10") || string.trim().equals("11") || string.trim().equals("12")) {
                    this.setSeveridade((byte)3);
                } else {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getLocalizacao().addValidador(new ValidadorNaoNulo(3, this.tab.msg("ficha_imovel_ar_localizacao")){

            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.getCodigo().isVazio()) {
                    return null;
                }
                String string = ImovelAR.this.getCodigo().getConteudoAtual(0);
                if (string.trim().equals("10") || string.trim().equals("11") || string.trim().equals("12")) {
                    this.setSeveridade((byte)3);
                } else if (string.trim().equals("13") || string.trim().equals("14") || string.trim().equals("99")) {
                    this.setSeveridade((byte)2);
                } else {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getArea().addValidador(new ValidadorNaoNulo(3, this.tab.msg("ficha_imovel_ar_area")){

            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.getCodigo().isVazio()) {
                    return null;
                }
                String string = ImovelAR.this.getCodigo().getConteudoAtual(0);
                if (string.trim().equals("10") || string.trim().equals("11") || string.trim().equals("12")) {
                    this.setSeveridade((byte)3);
                } else if (string.trim().equals("13") || string.trim().equals("14") || string.trim().equals("99")) {
                    this.setSeveridade((byte)2);
                } else {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getParticipacao().addValidador(new ValidadorNaoNulo(3, this.tab.msg("ficha_imovel_ar_participacao_exploracao_1")){

            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.getParticipacao().comparacao(">", "100,00")) {
                    return new RetornoValidacao(tab.msg("ficha_imovel_ar_participacao_exploracao_3"), 3);
                }
                if (ImovelAR.this.getCondicaoExploracao().isVazio()) {
                    return null;
                }
                String string = ImovelAR.this.getCondicaoExploracao().getConteudoAtual(0);
                if (string.equals("1")) {
                    if (ImovelAR.this.getParticipacao().comparacao("=", "100,00")) {
                        return null;
                    }
                    return new RetornoValidacao(tab.msg("ficha_imovel_ar_participacao_exploracao_1"), 3);
                }
                if (string.equals("2") || string.equals("3")) {
                    if (!ImovelAR.this.getParticipacao().comparacao("=", "100,00")) {
                        return null;
                    }
                    return new RetornoValidacao(tab.msg("ficha_imovel_ar_participacao_exploracao_2"), 3);
                }
                return null;
            }
        });
        this.getCondicaoExploracao().addValidador(new ValidadorNaoNulo(3, this.tab.msg("ficha_imovel_ar_cond_exploracao")){

            public RetornoValidacao validarImplementado() {
                if (ImovelAR.this.isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
    }

    public Valor getArea() {
        return this.area;
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Codigo getCondicaoExploracao() {
        return this.condicaoExploracao;
    }

    public Alfa getLocalizacao() {
        return this.localizacao;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public Valor getParticipacao() {
        return this.participacao;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    protected List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }
}

