/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import java.util.List;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorData;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNome;

public class Alimentando
extends ObjetoNegocio
implements JEditObjetoNegocioItemIf {
    public static final String PROP_CAMPO_NOME = "Nome";
    private String chave = "";
    private Alfa exterior = new Alfa(this, "Residente no Exterior?", 1);
    private Alfa nome = new Alfa(this, "Nome", 60);
    private CPF cpfAlimentando = new CPF(this, "CPF");
    private Data dataNascimento = new Data(this, "Data de Nascimento");
    private CPF cpfVinculado = new CPF(this, "CPF Vinculado");

    public Alimentando() {
        this.getNome().addValidador(new ValidadorNome(3));
        this.getNome().addValidador(new ValidadorNaoNulo(3, this.tab.msg("dependente_nome")){

            public RetornoValidacao validarImplementado() {
                if (!Alimentando.this.getDataNascimento().isVazio() && Alimentando.this.getNome().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCpf().addValidador(new ValidadorCPF(3));
        this.getCpf().addValidador(new ValidadorNaoNulo(3, this.tab.msg("dependente_cpf_brancoinvalido")));
        this.getDataNascimento().addValidador(new ValidadorData(3));
        this.getExterior().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Alimentando.this.getExterior().asString().equals("0") || Alimentando.this.getExterior().asString().equals("1")) {
                    return new RetornoValidacao(tab.msg("alimentando_residente_exterior"), 3);
                }
                return null;
            }
        });
        this.getCpfVinculado().addValidador(new ValidadorCPF(3));
    }

    public Alfa getNome() {
        return this.nome;
    }

    public CPF getCpf() {
        return this.cpfAlimentando;
    }

    public Data getDataNascimento() {
        return this.dataNascimento;
    }

    public Alfa getExterior() {
        return this.exterior;
    }

    public CPF getCpfVinculado() {
        return this.cpfVinculado;
    }

    public String toString() {
        return this.nome.asString();
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getExterior());
        list.add(this.getCpf());
        list.add(this.getDataNascimento());
        list.add(this.getNome());
        list.add(this.getCpfVinculado());
        return list;
    }

    public String getConteudo(int n) {
        return this.getNome().getConteudoFormatado();
    }

    public int getTotalAtributos() {
        return 1;
    }

    public int getColunaFiltro() {
        return 0;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        this.chave = string;
    }
}

