/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.treeview;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.acoes.AcaoMudaPainel;
import serpro.ppgd.infraestrutura.treeview.NoGenerico;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class ArvoreGenerica
extends JTree {
    protected DefaultMutableTreeNode raizTree;
    protected Map vctNos;
    protected Map vctNosEscondidos;
    protected Map vctListaOrdenadaDeRotulos = new Hashtable();
    protected int TAM_MIN = 25;
    protected String nodoInicial = "";
    private boolean minimizado = false;
    private String labelRaiz;
    private int tamanhoMaximo = 0;
    private int tamanhoMinimo = 0;

    public ArvoreGenerica() {
        super(new NoGenerico("", null));
        this.vctNos = new Hashtable();
        this.vctNosEscondidos = new Hashtable();
        this.raizTree = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.setToggleClickCount(1);
        this.getSelectionModel().setSelectionMode(1);
        this.setFocusable(false);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setFonteDados(String string) {
        Document document = FabricaUtilitarios.carregarDOM(string);
        Element element = document.getDocumentElement();
        if (element.getNodeName().trim().equalsIgnoreCase("arvore")) {
            try {
                Object[] objectArray;
                Class[] classArray;
                String string2 = element.getAttribute("labelRaiz");
                String string3 = element.getAttribute("tamanhoMaximo");
                String string4 = element.getAttribute("tamanhoMinimo");
                String string5 = element.getAttribute("cellRenderer");
                String string6 = element.getAttribute("treeSelectionListener");
                String string7 = element.getAttribute("iconeExpandido");
                String string8 = element.getAttribute("iconeContraido");
                String string9 = element.getAttribute("cellEditor");
                String string10 = element.getAttribute("editable");
                if (string2 != null && string2.trim().length() > 0) {
                    ((NoGenerico)this.raizTree).setActionHabilitado(false);
                    ((NoGenerico)this.raizTree).setLabel(string2);
                    if (string7.length() != 0) {
                        ((NoGenerico)this.raizTree).setIconeExpandido(string7);
                    }
                    if (string8.length() != 0) {
                        ((NoGenerico)this.raizTree).setIconeContraido(string8);
                    }
                    this.raizTree.setUserObject(string2);
                } else {
                    super.setRootVisible(false);
                    this.putClientProperty("JTree.lineStyle", "None");
                    ((NoGenerico)this.raizTree).setActionHabilitado(false);
                    classArray = "imagens/ico_vazio.gif";
                    ((NoGenerico)this.raizTree).setIconeExpandido((String)classArray);
                    ((NoGenerico)this.raizTree).setIconeContraido((String)classArray);
                    this.raizTree.setUserObject(string2);
                }
                if (string3 != null && string3.trim().length() > 0) {
                    this.setTamanhoMaximo(Integer.parseInt(string3));
                }
                if (string4 != null && string3.trim().length() > 0) {
                    this.setTamanhoMinimo(Integer.parseInt(string4));
                }
                if (string9 != null && string9.trim().length() > 0) {
                    try {
                        classArray = Class.forName(string9);
                        objectArray = (Object[])classArray.newInstance();
                        this.setCellEditor((TreeCellEditor)objectArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (string10 != null && string10.trim().length() > 0) {
                    if (string10.toLowerCase().equals("true")) {
                        this.setEditable(true);
                    } else {
                        this.setEditable(false);
                    }
                }
                try {
                    Object obj;
                    Constructor<?> constructor;
                    Class<?> clazz;
                    classArray = new Class[]{JTree.class};
                    objectArray = new Object[]{this};
                    if (string5.trim().length() != 0) {
                        clazz = Class.forName(string5);
                        constructor = clazz.getConstructor(classArray);
                        obj = constructor.newInstance(objectArray);
                        this.setCellRenderer((TreeCellRenderer)obj);
                    }
                    if (string6.trim().length() != 0) {
                        clazz = Class.forName(string6);
                        constructor = clazz.getConstructor(classArray);
                        obj = constructor.newInstance(objectArray);
                        this.addTreeSelectionListener((TreeSelectionListener)obj);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new IllegalArgumentException("Erro na instancia\u00e7\u00e3o do CellRenderer ou do TreeSelectionListener " + exception.getMessage());
                }
                this.obtemNodos(element, null);
            }
            catch (Exception exception) {
                LogPPGD.erro("Erro no carregamento da \u00e1rvore a partir do XML:" + exception.getMessage());
                exception.printStackTrace();
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
        throw new IllegalArgumentException("Tag <arvore> n\u00e3o encontrada");
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    private void obtemNodos(Element element, NoGenerico noGenerico) throws Exception {
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element2;
                if (nodeList.item(n).getNodeType() == 1 && (element2 = (Element)nodeList.item(n)).getNodeName().trim().equalsIgnoreCase("nodo")) {
                    NoGenerico noGenerico2;
                    String string = element2.getAttribute("label");
                    String string2 = element2.getAttribute("action");
                    String string3 = element2.getAttribute("actionCommand");
                    String string4 = element2.getAttribute("painel");
                    String string5 = element2.getAttribute("iconeExpandido");
                    String string6 = element2.getAttribute("iconeContraido");
                    String string7 = element2.getAttribute("selecionado");
                    String string8 = element2.getAttribute("tooltip");
                    String string9 = element2.getAttribute("enable");
                    String string10 = element2.getAttribute("nodoInicial");
                    if (string.length() == 0) {
                        string = "Node";
                    }
                    Action action = null;
                    if (string2.length() == 0) {
                        noGenerico2 = new NoGenerico();
                        noGenerico2.setLabel(string);
                    } else {
                        action = string2.equals("AcaoMudaPainel") ? new AcaoMudaPainel(string4) : (Action)Class.forName(string2).newInstance();
                        noGenerico2 = new NoGenerico(string, action);
                    }
                    if (string3.length() > 0) {
                        noGenerico2.setActionCommand(string3);
                    }
                    if (string5.length() != 0) {
                        noGenerico2.setIconeExpandido(string5);
                    }
                    if (string6.length() != 0) {
                        noGenerico2.setIconeContraido(string6);
                    }
                    if (string10.length() != 0 || this.nodoInicial.trim().length() == 0) {
                        this.nodoInicial = string;
                    }
                    if (string8.trim().length() != 0) {
                        noGenerico2.setTooltip(string8);
                    }
                    if (string9.trim().length() != 0) {
                        noGenerico2.setActionHabilitado(string9.trim().equalsIgnoreCase("true"));
                    }
                    this.add(noGenerico, noGenerico2);
                    if (string7.trim().equalsIgnoreCase("sim")) {
                        this.selecionarNodo(noGenerico2.toString());
                    }
                    this.obtemNodos(element2, noGenerico2);
                }
                ++n;
            }
        }
    }

    public String getRotuloNodo(String string) {
        if (this.vctListaOrdenadaDeRotulos.containsKey(string)) {
            return (String)this.vctListaOrdenadaDeRotulos.get(string);
        }
        return "";
    }

    public void add(NoGenerico noGenerico, NoGenerico noGenerico2) {
        this.vctListaOrdenadaDeRotulos.put(noGenerico2.getActionCommand(), noGenerico2.getNome());
        if (noGenerico == null) {
            this.raizTree.add(noGenerico2);
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.vctNos.get(noGenerico.toString());
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)this.vctNosEscondidos.get(noGenerico.toString());
            }
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = this.raizTree;
            }
            defaultMutableTreeNode.add(noGenerico2);
        }
        this.vctNos.put(noGenerico2.toString(), noGenerico2);
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
    }

    public void add(NoGenerico noGenerico) {
        this.raizTree.add(noGenerico);
        this.vctNos.put(noGenerico.toString(), noGenerico);
    }

    public void selecionaNodoInicial() {
        this.selecionarNodo(this.nodoInicial);
    }

    public void setSelectionPath(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode.getLevel() == 1) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        } else if (defaultMutableTreeNode.getLevel() == 2) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(defaultMutableTreeNode.getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        } else if (defaultMutableTreeNode.getLevel() == 3) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(defaultMutableTreeNode.getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(defaultMutableTreeNode.getParent().getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        } else if (defaultMutableTreeNode.getLevel() == 4) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(defaultMutableTreeNode.getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(defaultMutableTreeNode.getParent().getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(defaultMutableTreeNode.getParent().getParent().getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        }
        super.setSelectionPath(treePath);
    }

    public void preparaNavegador(JTree jTree, DefaultMutableTreeNode defaultMutableTreeNode) {
    }

    public DefaultMutableTreeNode getRaiz() {
        return this.raizTree;
    }

    public Map getVctNos() {
        return this.vctNos;
    }

    public void setRaiz(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.raizTree = defaultMutableTreeNode;
    }

    public void minimiza() {
        this.minimizado = true;
        this.setExpandsSelectedPaths(false);
        UtilitariosGUI.setParametrosGUI((JComponent)this, this.getSize().width, this.getTamanhoMinimo());
        this.collapseRow(0);
    }

    public void maximiza() {
        this.minimizado = false;
        this.setExpandsSelectedPaths(true);
        UtilitariosGUI.setParametrosGUI((JComponent)this, this.getSize().width, this.getTamanhoMaximo());
        this.expandRow(0);
    }

    public void esconde() {
        UtilitariosGUI.setParametrosGUI((JComponent)this, 0, 0);
    }

    public boolean isMinimizado() {
        return this.minimizado;
    }

    public void setMinimizado(boolean bl) {
        this.minimizado = bl;
    }

    public void selecionarNodo(String string) {
        if (this.vctNos.containsKey(string)) {
            NoGenerico noGenerico = (NoGenerico)this.vctNos.get(string);
            this.setSelectionPath(this.encontrarObjetoNaTree(noGenerico));
        }
    }

    public void removerNodo(String string) {
        if (this.vctNos.containsKey(string)) {
            NoGenerico noGenerico = (NoGenerico)this.vctNos.get(string);
            this.vctNos.remove(noGenerico.toString());
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(noGenerico);
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        }
    }

    public void setNodoEnabled(String string, boolean bl) {
        if (this.vctNos.containsKey(string)) {
            NoGenerico noGenerico = (NoGenerico)this.vctNos.get(string);
            noGenerico.setActionHabilitado(bl);
            this.repaint();
        }
    }

    private void escondeNodo(String string) {
        if (this.vctNos.containsKey(string)) {
            NoGenerico noGenerico = (NoGenerico)this.vctNos.remove(string);
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(noGenerico);
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
            this.vctNosEscondidos.put(noGenerico.toString(), noGenerico);
        }
    }

    private void mostraNodo(String string) {
        if (this.vctNosEscondidos.containsKey(string)) {
            NoGenerico noGenerico = (NoGenerico)this.vctNosEscondidos.remove(string);
            NoGenerico noGenerico2 = (NoGenerico)noGenerico.getParent();
            if (noGenerico2 == null) {
                noGenerico2 = (NoGenerico)noGenerico.getOldParent();
            }
            this.add(noGenerico2, noGenerico);
        }
    }

    public void setNodoVisivel(String string, boolean bl) {
        if (bl) {
            this.mostraNodo(string);
        } else {
            this.escondeNodo(string);
        }
    }

    public void escondeTodosNodos() {
        for (NoGenerico noGenerico : new ArrayList(this.vctNos.values())) {
            this.escondeNodo(noGenerico.toString());
        }
    }

    public TreePath encontrarObjetoNaTree(Object object) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() != object) continue;
            return new TreePath(defaultMutableTreeNode.getPath());
        }
        return null;
    }

    public int getTamanhoMaximo() {
        return this.tamanhoMaximo;
    }

    public void setTamanhoMaximo(int n) {
        this.tamanhoMaximo = n;
    }

    public int getTamanhoMinimo() {
        return this.tamanhoMinimo;
    }

    public void setTamanhoMinimo(int n) {
        this.tamanhoMinimo = n;
    }

    public String getLabelRaiz() {
        return this.labelRaiz;
    }

    public void setLabelRaiz(String string) {
        this.labelRaiz = string;
        this.raizTree.setUserObject(string);
    }

    public DefaultMutableTreeNode getRaizTree() {
        return this.raizTree;
    }

    public void setRaizTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.raizTree = defaultMutableTreeNode;
    }

    public void setCellRenderer(Constructor constructor) {
        Object[] objectArray = new Object[]{this};
        try {
            this.setCellRenderer((TreeCellRenderer)constructor.newInstance(objectArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTreeSelectionListener(Constructor constructor) {
        Object[] objectArray = new Object[]{this};
        try {
            this.addTreeSelectionListener((TreeSelectionListener)constructor.newInstance(objectArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getNodoInicial() {
        return this.nodoInicial;
    }

    public void setNodoInicial(String string) {
        this.nodoInicial = string;
    }
}

