/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.ObjectCache;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ExceptionHandlingFlowContext
extends FlowContext {
    public static final int BitCacheSize = 32;
    public ReferenceBinding[] handledExceptions;
    int[] isReached;
    int[] isNeeded;
    UnconditionalFlowInfo[] initsOnExceptions;
    ObjectCache indexes = new ObjectCache();
    boolean isMethodContext;
    public UnconditionalFlowInfo initsOnReturn;
    public ArrayList extendedExceptions;

    public ExceptionHandlingFlowContext(FlowContext flowContext, ASTNode aSTNode, ReferenceBinding[] referenceBindingArray, BlockScope blockScope, UnconditionalFlowInfo unconditionalFlowInfo) {
        super(flowContext, aSTNode);
        this.isMethodContext = blockScope == blockScope.methodScope();
        this.handledExceptions = referenceBindingArray;
        int n = referenceBindingArray.length;
        int n2 = n / 32 + 1;
        this.isReached = new int[n2];
        this.isNeeded = new int[n2];
        this.initsOnExceptions = new UnconditionalFlowInfo[n];
        int n3 = 0;
        while (n3 < n) {
            this.indexes.put(referenceBindingArray[n3], n3);
            int n4 = n3 / 32;
            int n5 = 1 << n3 % 32;
            if (referenceBindingArray[n3].isUncheckedException(true)) {
                int n6 = n4;
                this.isReached[n6] = this.isReached[n6] | n5;
                this.initsOnExceptions[n3] = unconditionalFlowInfo.unconditionalCopy();
            } else {
                this.initsOnExceptions[n3] = FlowInfo.DEAD_END;
            }
            ++n3;
        }
        System.arraycopy(this.isReached, 0, this.isNeeded, 0, n2);
        this.initsOnReturn = FlowInfo.DEAD_END;
    }

    public void complainIfUnusedExceptionHandlers(AbstractMethodDeclaration abstractMethodDeclaration) {
        MethodScope methodScope = abstractMethodDeclaration.scope;
        if ((abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0 && !methodScope.compilerOptions().reportUnusedDeclaredThrownExceptionWhenOverriding) {
            return;
        }
        int n = 0;
        int n2 = this.handledExceptions.length;
        while (n < n2) {
            int n3;
            int n4 = this.indexes.get(this.handledExceptions[n]);
            int n5 = n4 / 32;
            if ((this.isReached[n5] & (n3 = 1 << n4 % 32)) == 0) {
                methodScope.problemReporter().unusedDeclaredThrownException(this.handledExceptions[n4], abstractMethodDeclaration, abstractMethodDeclaration.thrownExceptions[n4]);
            }
            ++n;
        }
    }

    public void complainIfUnusedExceptionHandlers(BlockScope blockScope, TryStatement tryStatement) {
        int n = 0;
        int n2 = this.handledExceptions.length;
        while (n < n2) {
            int n3;
            int n4 = this.indexes.get(this.handledExceptions[n]);
            int n5 = n4 / 32;
            if ((this.isReached[n5] & (n3 = 1 << n4 % 32)) == 0) {
                blockScope.problemReporter().unreachableCatchBlock(this.handledExceptions[n4], tryStatement.catchArguments[n4].type);
            } else if ((this.isNeeded[n5] & n3) == 0) {
                blockScope.problemReporter().hiddenCatchBlock(this.handledExceptions[n4], tryStatement.catchArguments[n4].type);
            }
            ++n;
        }
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Exception flow context");
        int n = this.handledExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 / 32;
            int n4 = 1 << n2 % 32;
            stringBuffer.append('[').append(this.handledExceptions[n2].readableName());
            if ((this.isReached[n3] & n4) != 0) {
                if ((this.isNeeded[n3] & n4) == 0) {
                    stringBuffer.append("-masked");
                } else {
                    stringBuffer.append("-reached");
                }
            } else {
                stringBuffer.append("-not reached");
            }
            stringBuffer.append('-').append(this.initsOnExceptions[n2].toString()).append(']');
            ++n2;
        }
        stringBuffer.append("[initsOnReturn -").append(this.initsOnReturn.toString()).append(']');
        return stringBuffer.toString();
    }

    public UnconditionalFlowInfo initsOnException(ReferenceBinding referenceBinding) {
        int n = this.indexes.get(referenceBinding);
        if (n < 0) {
            return FlowInfo.DEAD_END;
        }
        return this.initsOnExceptions[n];
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return this.initsOnReturn;
    }

    public void mergeUnhandledException(TypeBinding typeBinding) {
        int n;
        if (this.extendedExceptions == null) {
            this.extendedExceptions = new ArrayList(5);
            n = 0;
            while (n < this.handledExceptions.length) {
                this.extendedExceptions.add(this.handledExceptions[n]);
                ++n;
            }
        }
        n = 0;
        int n2 = this.extendedExceptions.size() - 1;
        while (n2 >= 0) {
            switch (Scope.compareTypes(typeBinding, (TypeBinding)this.extendedExceptions.get(n2))) {
                case 1: {
                    this.extendedExceptions.remove(n2);
                    break;
                }
                case -1: {
                    n = 1;
                    break;
                }
            }
            --n2;
        }
        if (n == 0) {
            this.extendedExceptions.add(typeBinding);
        }
    }

    public void recordHandlingException(ReferenceBinding referenceBinding, UnconditionalFlowInfo unconditionalFlowInfo, TypeBinding typeBinding, ASTNode aSTNode, boolean bl) {
        int n = this.indexes.get(referenceBinding);
        int n2 = n / 32;
        int n3 = 1 << n % 32;
        if (!bl) {
            int n4 = n2;
            this.isNeeded[n4] = this.isNeeded[n4] | n3;
        }
        int n5 = n2;
        this.isReached[n5] = this.isReached[n5] | n3;
        this.initsOnExceptions[n] = (this.initsOnExceptions[n].tagBits & 1) == 0 ? this.initsOnExceptions[n].mergedWith(unconditionalFlowInfo) : unconditionalFlowInfo.unconditionalCopy();
    }

    public void recordReturnFrom(UnconditionalFlowInfo unconditionalFlowInfo) {
        if ((unconditionalFlowInfo.tagBits & 1) == 0) {
            this.initsOnReturn = (this.initsOnReturn.tagBits & 1) == 0 ? this.initsOnReturn.mergedWith(unconditionalFlowInfo) : (UnconditionalFlowInfo)unconditionalFlowInfo.copy();
        }
    }

    public SubRoutineStatement subroutine() {
        if (this.associatedNode instanceof SubRoutineStatement) {
            if (this.parent.subroutine() == this.associatedNode) {
                return null;
            }
            return (SubRoutineStatement)this.associatedNode;
        }
        return null;
    }
}

