/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignSubreportReturnValue;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreportReturnValue;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRSubreportRunnerFactory;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillSubreport
extends JRFillElement
implements JRSubreport {
    private static final Log log = LogFactory.getLog(JRFillSubreport.class);
    private static final JRSingletonCache runnerFactoryCache = new JRSingletonCache(JRSubreportRunnerFactory.class);
    private Map parameterValues = null;
    private JRSubreportParameter[] parameters = null;
    private Connection connection = null;
    private JRDataSource dataSource = null;
    private JasperReport jasperReport = null;
    private Map loadedEvaluators = null;
    private JRFillSubreportReturnValue[] returnValues = null;
    protected JRBaseFiller subreportFiller = null;
    private JRPrintPage printPage = null;
    private JRSubreportRunner runner;
    private Set checkedReports;

    protected JRFillSubreport(JRBaseFiller jRBaseFiller, JRSubreport jRSubreport, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRSubreport, jRFillObjectFactory);
        this.parameters = jRSubreport.getParameters();
        JRSubreportReturnValue[] jRSubreportReturnValueArray = jRSubreport.getReturnValues();
        if (jRSubreportReturnValueArray != null) {
            ArrayList arrayList = new ArrayList(jRSubreportReturnValueArray.length * 2);
            this.returnValues = new JRFillSubreportReturnValue[jRSubreportReturnValueArray.length];
            int n = 0;
            while (n < jRSubreportReturnValueArray.length) {
                this.addReturnValue(jRSubreportReturnValueArray[n], arrayList, jRFillObjectFactory);
                ++n;
            }
            this.returnValues = new JRFillSubreportReturnValue[arrayList.size()];
            arrayList.toArray(this.returnValues);
        }
        this.loadedEvaluators = new HashMap();
        this.checkedReports = new HashSet();
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public boolean isUsingCache() {
        return ((JRSubreport)this.parent).isUsingCache();
    }

    public void setUsingCache(boolean bl) {
    }

    public JRExpression getParametersMapExpression() {
        return ((JRSubreport)this.parent).getParametersMapExpression();
    }

    public JRSubreportParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getConnectionExpression() {
        return ((JRSubreport)this.parent).getConnectionExpression();
    }

    public JRExpression getDataSourceExpression() {
        return ((JRSubreport)this.parent).getDataSourceExpression();
    }

    public JRExpression getExpression() {
        return ((JRSubreport)this.parent).getExpression();
    }

    protected JRTemplateRectangle getJRTemplateRectangle() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateRectangle jRTemplateRectangle = (JRTemplateRectangle)this.getTemplate(jRStyle);
        if (jRTemplateRectangle == null) {
            jRTemplateRectangle = new JRTemplateRectangle(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.registerTemplate(jRStyle, jRTemplateRectangle);
        }
        return jRTemplateRectangle;
    }

    protected Collection getPrintElements() {
        List list = null;
        if (this.printPage != null) {
            list = this.printPage.getElements();
        }
        return list;
    }

    protected void evaluate(byte by) throws JRException {
        JRExpression jRExpression;
        Object object;
        this.reset();
        this.evaluatePrintWhenExpression(by);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && (object = this.evaluateExpression(jRExpression = this.getExpression(), by)) != null) {
            JREvaluator jREvaluator = null;
            if (this.isUsingCache() && this.filler.loadedSubreports.containsKey(object)) {
                this.jasperReport = (JasperReport)this.filler.loadedSubreports.get(object);
                jREvaluator = (JREvaluator)this.loadedEvaluators.get(this.jasperReport);
                if (jREvaluator == null) {
                    jREvaluator = JRDefaultCompiler.getInstance().loadEvaluator(this.jasperReport);
                    this.loadedEvaluators.put(this.jasperReport, jREvaluator);
                }
            } else {
                Class clazz = jRExpression.getValueClass();
                if (clazz.equals(JasperReport.class)) {
                    this.jasperReport = (JasperReport)object;
                } else if (clazz.equals(InputStream.class)) {
                    this.jasperReport = (JasperReport)JRLoader.loadObject((InputStream)object);
                } else if (clazz.equals(URL.class)) {
                    this.jasperReport = (JasperReport)JRLoader.loadObject((URL)object);
                } else if (clazz.equals(File.class)) {
                    this.jasperReport = (JasperReport)JRLoader.loadObject((File)object);
                } else if (clazz.equals(String.class)) {
                    this.jasperReport = (JasperReport)JRLoader.loadObjectFromLocation((String)object, this.filler.reportClassLoader, this.filler.urlHandlerFactory);
                }
                if (this.jasperReport != null) {
                    jREvaluator = JRDefaultCompiler.getInstance().loadEvaluator(this.jasperReport);
                }
                if (this.isUsingCache()) {
                    this.filler.loadedSubreports.put(object, this.jasperReport);
                    this.loadedEvaluators.put(this.jasperReport, jREvaluator);
                }
            }
            if (this.jasperReport != null) {
                jRExpression = this.getConnectionExpression();
                this.connection = (Connection)this.evaluateExpression(jRExpression, by);
                jRExpression = this.getDataSourceExpression();
                this.dataSource = (JRDataSource)this.evaluateExpression(jRExpression, by);
                this.parameterValues = JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), by, false, this.jasperReport.getResourceBundle() != null, this.jasperReport.getFormatFactoryClass() != null);
                if (this.subreportFiller != null) {
                    this.filler.unregisterSubfiller(this.subreportFiller);
                }
                this.initSubreportFiller(jREvaluator);
                this.checkReturnValues();
            }
        }
    }

    protected void initSubreportFiller(JREvaluator jREvaluator) throws JRException {
        switch (this.jasperReport.getPrintOrder()) {
            case 2: {
                this.subreportFiller = new JRHorizontalFiller(this.jasperReport, jREvaluator, this.filler);
                break;
            }
            case 1: {
                this.subreportFiller = new JRVerticalFiller(this.jasperReport, jREvaluator, this.filler);
                break;
            }
            default: {
                throw new JRRuntimeException("Unkown print order " + this.jasperReport.getPrintOrder() + ".");
            }
        }
        this.runner = JRFillSubreport.getRunnerFactory().createSubreportRunner(this, this.subreportFiller);
        this.subreportFiller.setSubreportRunner(this.runner);
    }

    public static Map getParameterValues(JRBaseFiller jRBaseFiller, JRExpression jRExpression, JRDatasetParameter[] jRDatasetParameterArray, byte by, boolean bl, boolean bl2, boolean bl3) throws JRException {
        HashMap<String, Object> hashMap = null;
        if (jRExpression != null) {
            hashMap = (HashMap<String, Object>)jRBaseFiller.evaluateExpression(jRExpression, by);
        }
        if (hashMap != null) {
            if (bl2) {
                hashMap.remove("REPORT_RESOURCE_BUNDLE");
            }
            if (bl3) {
                hashMap.remove("REPORT_DATE_FORMAT_FACTORY");
            }
            hashMap.remove("REPORT_CONNECTION");
            hashMap.remove("REPORT_MAX_COUNT");
            hashMap.remove("REPORT_DATA_SOURCE");
            hashMap.remove("REPORT_SCRIPTLET");
            hashMap.remove("REPORT_VIRTUALIZER");
            hashMap.remove("IS_IGNORE_PAGINATION");
            hashMap.remove("REPORT_PARAMETERS_MAP");
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
        }
        if (jRDatasetParameterArray != null && jRDatasetParameterArray.length > 0) {
            Object object = null;
            int n = 0;
            while (n < jRDatasetParameterArray.length) {
                JRExpression jRExpression2 = jRDatasetParameterArray[n].getExpression();
                if (jRExpression2 != null || !bl) {
                    object = jRBaseFiller.evaluateExpression(jRExpression2, by);
                    if (object == null) {
                        hashMap.remove(jRDatasetParameterArray[n].getName());
                    } else {
                        hashMap.put(jRDatasetParameterArray[n].getName(), object);
                    }
                }
                ++n;
            }
        }
        if (!hashMap.containsKey("REPORT_LOCALE")) {
            hashMap.put("REPORT_LOCALE", jRBaseFiller.getLocale());
        }
        if (!hashMap.containsKey("REPORT_TIME_ZONE")) {
            hashMap.put("REPORT_TIME_ZONE", jRBaseFiller.getTimeZone());
        }
        if (!hashMap.containsKey("REPORT_DATE_FORMAT_FACTORY") && !bl3) {
            hashMap.put("REPORT_DATE_FORMAT_FACTORY", jRBaseFiller.getFormatFactory());
        }
        if (!hashMap.containsKey("REPORT_CLASS_LOADER") && jRBaseFiller.reportClassLoader != null) {
            hashMap.put("REPORT_CLASS_LOADER", jRBaseFiller.reportClassLoader);
        }
        if (!hashMap.containsKey("REPORT_URL_HANDLER_FACTORY") && jRBaseFiller.urlHandlerFactory != null) {
            hashMap.put("REPORT_URL_HANDLER_FACTORY", jRBaseFiller.urlHandlerFactory);
        }
        return hashMap;
    }

    protected void fillSubreport() throws JRException {
        if (this.getConnectionExpression() != null) {
            this.subreportFiller.fill(this.parameterValues, this.connection);
        } else if (this.getDataSourceExpression() != null) {
            this.subreportFiller.fill(this.parameterValues, this.dataSource);
        } else {
            this.subreportFiller.fill(this.parameterValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepare(int n, boolean bl) throws JRException {
        boolean bl2;
        boolean bl3 = false;
        super.prepare(n, bl);
        if (this.subreportFiller == null) {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return bl3;
        }
        if (n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            this.setToPrint(false);
            return true;
        }
        boolean bl4 = this.runner.isFilling();
        boolean bl5 = !bl || this.isPrintWhenDetailOverflows() || !this.isAlreadyPrinted();
        boolean bl6 = bl2 = bl && this.isPrintWhenDetailOverflows();
        if (!bl4 && bl5 && bl2) {
            this.rewind();
        }
        int n2 = this.getHeight() + n - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.subreportFiller.setPageHeight(n2);
        Object object = this.subreportFiller;
        synchronized (object) {
            JRSubreportRunResult jRSubreportRunResult;
            if (bl4) {
                jRSubreportRunResult = this.runner.resume();
            } else if (bl5) {
                this.setReprinted(bl2);
                jRSubreportRunResult = this.runner.start();
            } else {
                this.printPage = null;
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return bl3;
            }
            if (jRSubreportRunResult.getException() != null) {
                Throwable throwable = jRSubreportRunResult.getException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new JRRuntimeException(throwable);
            }
            if (jRSubreportRunResult.hasFinished()) {
                this.copyValues();
            }
            this.printPage = this.subreportFiller.getCurrentPage();
            this.setStretchHeight(jRSubreportRunResult.hasFinished() ? this.subreportFiller.getCurrentPageStretchHeight() : n2);
            boolean bl7 = bl3 = !jRSubreportRunResult.hasFinished();
            if (!bl3) {
                this.runner.reset();
            }
        }
        object = this.getPrintElements();
        if ((object == null || object.size() == 0) && this.isRemoveLineWhenBlank()) {
            this.setToPrint(false);
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() throws JRException {
        if (this.subreportFiller == null) {
            return;
        }
        this.subreportFiller.setInterrupted(true);
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.runner.cancel();
            this.runner.reset();
        }
        this.filler.unregisterSubfiller(this.subreportFiller);
        this.initSubreportFiller(null);
        if (this.getConnectionExpression() == null && this.dataSource != null) {
            if (this.dataSource instanceof JRRewindableDataSource) {
                ((JRRewindableDataSource)this.dataSource).moveFirst();
            } else if (log.isDebugEnabled()) {
                log.debug("The subreport is placed on a non-splitting band, but it does not have a rewindable data source.");
            }
        }
    }

    protected JRPrintElement fill() {
        JRTemplatePrintRectangle jRTemplatePrintRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle());
        jRTemplatePrintRectangle.setX(this.getX());
        jRTemplatePrintRectangle.setY(this.getRelativeY());
        jRTemplatePrintRectangle.setWidth(this.getWidth());
        jRTemplatePrintRectangle.setHeight(this.getStretchHeight());
        return jRTemplatePrintRectangle;
    }

    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getSubreport(this);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeSubreport(this);
    }

    private JRFillSubreportReturnValue addReturnValue(JRSubreportReturnValue jRSubreportReturnValue, List list, JRFillObjectFactory jRFillObjectFactory) {
        JRFillSubreportReturnValue jRFillSubreportReturnValue = jRFillObjectFactory.getSubreportReturnValue(jRSubreportReturnValue);
        byte by = jRFillSubreportReturnValue.getCalculation();
        switch (by) {
            case 3: 
            case 7: {
                JRSubreportReturnValue jRSubreportReturnValue2 = this.createHelperReturnValue(jRSubreportReturnValue, "_COUNT", (byte)1);
                this.addReturnValue(jRSubreportReturnValue2, list, jRFillObjectFactory);
                JRSubreportReturnValue jRSubreportReturnValue3 = this.createHelperReturnValue(jRSubreportReturnValue, "_SUM", (byte)2);
                this.addReturnValue(jRSubreportReturnValue3, list, jRFillObjectFactory);
                this.filler.addVariableCalculationReq(jRFillSubreportReturnValue.getToVariable(), by);
                break;
            }
            case 6: {
                JRSubreportReturnValue jRSubreportReturnValue4 = this.createHelperReturnValue(jRSubreportReturnValue, "_VARIANCE", (byte)7);
                this.addReturnValue(jRSubreportReturnValue4, list, jRFillObjectFactory);
                this.filler.addVariableCalculationReq(jRFillSubreportReturnValue.getToVariable(), by);
                break;
            }
            case 10: {
                JRSubreportReturnValue jRSubreportReturnValue5 = this.createDistinctCountHelperReturnValue(jRSubreportReturnValue);
                this.addReturnValue(jRSubreportReturnValue5, list, jRFillObjectFactory);
                this.filler.addVariableCalculationReq(jRFillSubreportReturnValue.getToVariable(), by);
            }
        }
        list.add(jRFillSubreportReturnValue);
        return jRFillSubreportReturnValue;
    }

    protected JRSubreportReturnValue createHelperReturnValue(JRSubreportReturnValue jRSubreportReturnValue, String string, byte by) {
        JRDesignSubreportReturnValue jRDesignSubreportReturnValue = new JRDesignSubreportReturnValue();
        jRDesignSubreportReturnValue.setToVariable(String.valueOf(jRSubreportReturnValue.getToVariable()) + string);
        jRDesignSubreportReturnValue.setSubreportVariable(jRSubreportReturnValue.getSubreportVariable());
        jRDesignSubreportReturnValue.setCalculation(by);
        jRDesignSubreportReturnValue.setIncrementerFactoryClassName(jRDesignSubreportReturnValue.getIncrementerFactoryClassName());
        return jRDesignSubreportReturnValue;
    }

    protected JRSubreportReturnValue createDistinctCountHelperReturnValue(JRSubreportReturnValue jRSubreportReturnValue) {
        JRDesignSubreportReturnValue jRDesignSubreportReturnValue = new JRDesignSubreportReturnValue();
        jRDesignSubreportReturnValue.setToVariable(String.valueOf(jRSubreportReturnValue.getToVariable()) + "_DISTINCT_COUNT");
        jRDesignSubreportReturnValue.setSubreportVariable(jRSubreportReturnValue.getSubreportVariable());
        jRDesignSubreportReturnValue.setCalculation((byte)0);
        jRDesignSubreportReturnValue.setIncrementerFactoryClassName(jRDesignSubreportReturnValue.getIncrementerFactoryClassName());
        return jRDesignSubreportReturnValue;
    }

    public JRSubreportReturnValue[] getReturnValues() {
        return this.returnValues;
    }

    private void copyValues() {
        if (this.returnValues != null && this.returnValues.length > 0) {
            int n = 0;
            while (n < this.returnValues.length) {
                try {
                    JRFillVariable jRFillVariable = this.filler.getVariable(this.returnValues[n].getToVariable());
                    Object object = this.subreportFiller.getVariableValue(this.returnValues[n].getSubreportVariable());
                    Object object2 = this.returnValues[n].getIncrementer().increment(jRFillVariable, object, AbstractValueProvider.getCurrentValueProvider());
                    jRFillVariable.setOldValue(object2);
                    jRFillVariable.setValue(object2);
                }
                catch (JRException jRException) {
                    throw new JRRuntimeException(jRException);
                }
                ++n;
            }
        }
    }

    private void checkReturnValues() throws JRException {
        if (this.returnValues != null && this.returnValues.length > 0 && !this.checkedReports.contains(this.jasperReport)) {
            int n = 0;
            while (n < this.returnValues.length) {
                JRFillSubreportReturnValue jRFillSubreportReturnValue = this.returnValues[n];
                String string = jRFillSubreportReturnValue.getSubreportVariable();
                JRFillVariable jRFillVariable = this.subreportFiller.getVariable(string);
                if (jRFillVariable == null) {
                    throw new JRException("Subreport variable " + string + " not found.");
                }
                JRFillVariable jRFillVariable2 = this.filler.getVariable(jRFillSubreportReturnValue.getToVariable());
                if (jRFillSubreportReturnValue.getCalculation() == 1 || jRFillSubreportReturnValue.getCalculation() == 10) {
                    if (!Number.class.isAssignableFrom(jRFillVariable2.getValueClass())) {
                        throw new JRException("Variable " + jRFillSubreportReturnValue.getToVariable() + " must have a numeric type.");
                    }
                } else if (!(jRFillVariable2.getValueClass().isAssignableFrom(jRFillVariable.getValueClass()) || Number.class.isAssignableFrom(jRFillVariable2.getValueClass()) && Number.class.isAssignableFrom(jRFillVariable.getValueClass()))) {
                    throw new JRException("Variable " + jRFillSubreportReturnValue.getToVariable() + " is not assignable from subreport variable " + string);
                }
                ++n;
            }
            if (this.isUsingCache()) {
                this.checkedReports.add(this.jasperReport);
            }
        }
    }

    protected void resolveElement(JRPrintElement jRPrintElement, byte by) {
    }

    public Boolean isOwnUsingCache() {
        return ((JRSubreport)this.parent).isOwnUsingCache();
    }

    public void setUsingCache(Boolean bl) {
    }

    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return null;
    }

    protected static JRSubreportRunnerFactory getRunnerFactory() throws JRException {
        String string = JRProperties.getProperty("net.sf.jasperreports.subreport.runner.factory");
        if (string == null) {
            throw new JRException("Property \"net.sf.jasperreports.subreport.runner.factory\" must be set");
        }
        return (JRSubreportRunnerFactory)runnerFactoryCache.getCachedInstance(string);
    }
}

