/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendTributacaoExclusiva;

import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class RendTributacaoExclusiva
extends ObjetoNegocio {
    private Valor decimoTerceiro = new Valor();
    private Valor ganhosCapital = new Valor();
    private Valor ganhosCapitalEstrangeira = new Valor();
    private Valor ganhosCapitalEmEspecie = new Valor();
    private Valor ganhosRendaVariavel = new Valor();
    private ColecaoItemQuadroOutrosRendimentos rendAplicacoesQuadroAuxiliar;
    private Valor RRA = new Valor();
    private Valor decimoTerceiroDependentes = new Valor();
    private Valor RRADep = new Valor();
    private ColecaoItemQuadroOutrosRendimentos jurosCapitalProprioQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos rendPLRQuadroAuxiliar;
    private ColecaoItemQuadroOutrosRendimentos outrosQuadroAuxiliar;
    private Valor total = new Valor();

    public RendTributacaoExclusiva(DeclaracaoIRPF declaracaoIRPF) {
        this.rendAplicacoesQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Rendimentos de Aplica\u00e7\u00f5es Financeiras");
        this.jurosCapitalProprioQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Juros sobre capital pr\u00f3prio");
        this.rendPLRQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Participa\u00e7\u00e3o nos lucros e resultados");
        this.outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(declaracaoIRPF, "Outros rendimentos de tributa\u00e7\u00e3o exclusiva na fonte");
        this.getDecimoTerceiro().setReadOnly(true);
        this.getGanhosCapital().setReadOnly(true);
        this.getGanhosCapitalEstrangeira().setReadOnly(true);
        this.getGanhosCapitalEmEspecie().setReadOnly(true);
        this.getGanhosRendaVariavel().setReadOnly(true);
        this.getDecimoTerceiroDependentes().setReadOnly(true);
        this.getRRA().setReadOnly(true);
        this.getRRADep().setReadOnly(true);
        this.getTotal().setReadOnly(true);
    }

    public void addObservador(Observador observador) {
        this.decimoTerceiro.addObservador(observador);
        this.ganhosCapital.addObservador(observador);
        this.ganhosCapitalEstrangeira.addObservador(observador);
        this.ganhosCapitalEmEspecie.addObservador(observador);
        this.ganhosRendaVariavel.addObservador(observador);
        this.rendAplicacoesQuadroAuxiliar.getTotais().addObservador(observador);
        this.RRA.addObservador(observador);
        this.decimoTerceiroDependentes.addObservador(observador);
        this.RRADep.addObservador(observador);
        this.jurosCapitalProprioQuadroAuxiliar.getTotais().addObservador(observador);
        this.rendPLRQuadroAuxiliar.getTotais().addObservador(observador);
        this.outrosQuadroAuxiliar.getTotais().addObservador(observador);
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public Valor getGanhosCapital() {
        return this.ganhosCapital;
    }

    public Valor getGanhosCapitalEmEspecie() {
        return this.ganhosCapitalEmEspecie;
    }

    public Valor getGanhosCapitalEstrangeira() {
        return this.ganhosCapitalEstrangeira;
    }

    public Valor getGanhosRendaVariavel() {
        return this.ganhosRendaVariavel;
    }

    public ColecaoItemQuadroOutrosRendimentos getRendAplicacoesQuadroAuxiliar() {
        return this.rendAplicacoesQuadroAuxiliar;
    }

    public Valor getRendAplicacoes() {
        return this.getRendAplicacoesQuadroAuxiliar().getTotais();
    }

    public Valor getRRA() {
        return this.RRA;
    }

    public Valor getDecimoTerceiroDependentes() {
        return this.decimoTerceiroDependentes;
    }

    public Valor getRRADep() {
        return this.RRADep;
    }

    public ColecaoItemQuadroOutrosRendimentos getJurosCapitalProprioQuadroAuxiliar() {
        return this.jurosCapitalProprioQuadroAuxiliar;
    }

    public Valor getJurosCapitalProprio() {
        return this.getJurosCapitalProprioQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getRendPLRQuadroAuxiliar() {
        return this.rendPLRQuadroAuxiliar;
    }

    public Valor getRendPLR() {
        return this.getRendPLRQuadroAuxiliar().getTotais();
    }

    public ColecaoItemQuadroOutrosRendimentos getOutrosQuadroAuxiliar() {
        return this.outrosQuadroAuxiliar;
    }

    public Valor getOutros() {
        return this.getOutrosQuadroAuxiliar().getTotais();
    }

    public Valor getTotal() {
        return this.total;
    }

    public Valor recuperarExclusivosTitular() {
        Valor valor = new Valor();
        valor.append('+', this.decimoTerceiro);
        valor.append('+', this.ganhosCapital);
        valor.append('+', this.ganhosCapitalEstrangeira);
        valor.append('+', this.ganhosCapitalEmEspecie);
        valor.append('+', this.ganhosRendaVariavel);
        valor.append('+', this.getRendAplicacoesQuadroAuxiliar().getTotaisTitular());
        valor.append('+', this.RRA);
        valor.append('+', this.getJurosCapitalProprioQuadroAuxiliar().getTotaisTitular());
        valor.append('+', this.getRendPLRQuadroAuxiliar().getTotaisTitular());
        valor.append('+', this.getOutrosQuadroAuxiliar().getTotaisTitular());
        return valor;
    }

    public Valor recuperarExclusivosDependentes() {
        Valor valor = new Valor();
        valor.append('+', this.getRendAplicacoesQuadroAuxiliar().getTotaisDependentes());
        valor.append('+', this.decimoTerceiroDependentes);
        valor.append('+', this.RRADep);
        valor.append('+', this.getJurosCapitalProprioQuadroAuxiliar().getTotaisDependentes());
        valor.append('+', this.getRendPLRQuadroAuxiliar().getTotaisDependentes());
        valor.append('+', this.getOutrosQuadroAuxiliar().getTotaisDependentes());
        return valor;
    }

    public Valor recuperarTotalTitularExceto13_RV_e_GC() {
        Valor valor = new Valor();
        valor.append('+', this.getRendAplicacoesQuadroAuxiliar().getTotaisTitular());
        valor.append('+', this.RRA);
        valor.append('+', this.getJurosCapitalProprioQuadroAuxiliar().getTotaisTitular());
        valor.append('+', this.getRendPLRQuadroAuxiliar().getTotaisTitular());
        valor.append('+', this.getOutrosQuadroAuxiliar().getTotaisTitular());
        return valor;
    }
}

