/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LoopingFlowContext
extends SwitchFlowContext {
    public BranchLabel continueLabel;
    public UnconditionalFlowInfo initsOnContinue = FlowInfo.DEAD_END;
    private UnconditionalFlowInfo upstreamNullFlowInfo;
    private LoopingFlowContext[] innerFlowContexts = null;
    private UnconditionalFlowInfo[] innerFlowInfos = null;
    private int innerFlowContextsNb = 0;
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount = 0;
    LocalVariableBinding[] nullLocals;
    Expression[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;
    Scope associatedScope;

    public LoopingFlowContext(FlowContext flowContext, FlowInfo flowInfo, ASTNode aSTNode, BranchLabel branchLabel, BranchLabel branchLabel2, Scope scope) {
        super(flowContext, aSTNode, branchLabel);
        this.preemptNullDiagnostic = true;
        this.continueLabel = branchLabel2;
        this.associatedScope = scope;
        this.upstreamNullFlowInfo = flowInfo.unconditionalCopy();
    }

    public void complainOnDeferredFinalChecks(BlockScope blockScope, FlowInfo flowInfo) {
        int n = 0;
        while (n < this.assignCount) {
            VariableBinding variableBinding = this.finalVariables[n];
            if (variableBinding != null) {
                boolean bl = false;
                if (variableBinding instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned((FieldBinding)variableBinding)) {
                        bl = true;
                        blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variableBinding, this.finalAssignments[n]);
                    }
                } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variableBinding)) {
                    bl = true;
                    blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variableBinding, this.finalAssignments[n]);
                }
                if (bl) {
                    FlowContext flowContext = this.parent;
                    while (flowContext != null) {
                        flowContext.removeFinalAssignmentIfAny(this.finalAssignments[n]);
                        flowContext = flowContext.parent;
                    }
                }
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void complainOnDeferredNullChecks(BlockScope var1_1, FlowInfo var2_2) {
        block22: {
            block21: {
                var3_3 = 0;
                while (var3_3 < this.innerFlowContextsNb) {
                    this.upstreamNullFlowInfo.addPotentialNullInfoFrom(this.innerFlowContexts[var3_3].upstreamNullFlowInfo).addPotentialNullInfoFrom(this.innerFlowInfos[var3_3]);
                    ++var3_3;
                }
                this.innerFlowContextsNb = 0;
                var2_2 = this.upstreamNullFlowInfo.addPotentialNullInfoFrom(var2_2.unconditionalInitsWithoutSideEffect());
                if (!this.deferNullDiagnostic) break block21;
                var3_3 = 0;
                while (var3_3 < this.nullCount) {
                    var4_4 = this.nullLocals[var3_3];
                    var5_6 = this.nullReferences[var3_3];
                    switch (this.nullCheckTypes[var3_3]) {
                        case 23: {
                            if (var2_2.isDefinitelyNonNull(var4_4)) {
                                this.nullReferences[var3_3] = null;
                                var1_1.problemReporter().localVariableCannotBeNull(var4_4, var5_6);
                                break;
                            }
                            ** GOTO lbl42
                        }
                        case 20: {
                            if (var2_2.isDefinitelyNonNull(var4_4)) {
                                this.nullReferences[var3_3] = null;
                                var1_1.problemReporter().localVariableCannotBeNull(var4_4, var5_6);
                                break;
                            }
                            if (var2_2.isDefinitelyNull(var4_4)) {
                                this.nullReferences[var3_3] = null;
                                var1_1.problemReporter().localVariableCanOnlyBeNull(var4_4, var5_6);
                                break;
                            }
                            ** GOTO lbl42
                        }
                        case 21: {
                            if (var2_2.isDefinitelyNull(var4_4)) {
                                this.nullReferences[var3_3] = null;
                                var1_1.problemReporter().localVariableCanOnlyBeNull(var4_4, var5_6);
                                break;
                            }
                            ** GOTO lbl42
                        }
                        case 22: {
                            if (var2_2.isDefinitelyNull(var4_4)) {
                                this.nullReferences[var3_3] = null;
                                var1_1.problemReporter().localVariableCanOnlyBeNull(var4_4, var5_6);
                                break;
                            }
                        }
lbl42:
                        // 6 sources

                        default: {
                            this.parent.recordUsingNullReference(var1_1, var4_4, var5_6, this.nullCheckTypes[var3_3], var2_2);
                        }
                    }
                    ++var3_3;
                }
                break block22;
            }
            var3_3 = 0;
            while (var3_3 < this.nullCount) {
                var4_5 = this.nullReferences[var3_3];
                var5_7 = this.nullLocals[var3_3];
                switch (this.nullCheckTypes[var3_3]) {
                    case 20: {
                        if (var2_2.isDefinitelyNonNull(var5_7)) {
                            this.nullReferences[var3_3] = null;
                            var1_1.problemReporter().localVariableCannotBeNull(var5_7, var4_5);
                            break;
                        }
                    }
                    case 21: {
                        if (!var2_2.isDefinitelyNull(var5_7)) break;
                        this.nullReferences[var3_3] = null;
                        var1_1.problemReporter().localVariableCanOnlyBeNull(var5_7, var4_5);
                        break;
                    }
                    case 22: {
                        if (var2_2.isDefinitelyNull(var5_7)) {
                            this.nullReferences[var3_3] = null;
                            var1_1.problemReporter().localVariableCanOnlyBeNull(var5_7, var4_5);
                            break;
                        }
                        if (!var2_2.isPotentiallyNull(var5_7)) break;
                        this.nullReferences[var3_3] = null;
                        var1_1.problemReporter().localVariableMayBeNull(var5_7, var4_5);
                    }
                }
                ++var3_3;
            }
        }
    }

    public BranchLabel continueLabel() {
        return this.continueLabel;
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Looping flow context");
        stringBuffer.append("[initsOnBreak - ").append(this.initsOnBreak.toString()).append(']');
        stringBuffer.append("[initsOnContinue - ").append(this.initsOnContinue.toString()).append(']');
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    public boolean isContinuable() {
        return true;
    }

    public boolean isContinuedTo() {
        return this.initsOnContinue != FlowInfo.DEAD_END;
    }

    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.initsOnContinue = (this.initsOnContinue.tagBits & 1) == 0 ? this.initsOnContinue.mergedWith(flowInfo.unconditionalInitsWithoutSideEffect()) : flowInfo.unconditionalCopy();
            FlowContext flowContext2 = flowContext;
            while (flowContext2 != this && !(flowContext2 instanceof LoopingFlowContext)) {
                flowContext2 = flowContext2.parent;
            }
            if (flowContext2 == this) {
                this.upstreamNullFlowInfo.addPotentialNullInfoFrom(flowInfo.unconditionalInitsWithoutSideEffect());
            } else {
                int n = 0;
                if (this.innerFlowContexts == null) {
                    this.innerFlowContexts = new LoopingFlowContext[5];
                    this.innerFlowInfos = new UnconditionalFlowInfo[5];
                } else {
                    n = this.innerFlowContexts.length;
                    if (this.innerFlowContextsNb == n - 1) {
                        this.innerFlowContexts = new LoopingFlowContext[n + 5];
                        System.arraycopy(this.innerFlowContexts, 0, this.innerFlowContexts, 0, n);
                        this.innerFlowInfos = new UnconditionalFlowInfo[n + 5];
                        System.arraycopy(this.innerFlowInfos, 0, this.innerFlowInfos, 0, n);
                    }
                }
                this.innerFlowContexts[this.innerFlowContextsNb] = (LoopingFlowContext)flowContext2;
                this.innerFlowInfos[this.innerFlowContextsNb++] = flowInfo.unconditionalInitsWithoutSideEffect();
            }
        }
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (variableBinding instanceof LocalVariableBinding) {
            Scope scope = ((LocalVariableBinding)variableBinding).declaringScope;
            while ((scope = scope.parent) != null) {
                if (scope != this.associatedScope) continue;
                return false;
            }
        }
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new Expression[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            this.nullLocals = new LocalVariableBinding[this.nullCount * 2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new Expression[this.nullCount * 2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[this.nullCount * 2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = expression;
        this.nullCheckTypes[this.nullCount++] = n;
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        switch (n) {
            case 20: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCannotBeNull(localVariableBinding, expression);
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    return;
                }
                if (flowInfo.isPotentiallyUnknown(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isPotentiallyNonNull(localVariableBinding)) {
                    this.recordNullReference(localVariableBinding, expression, 23);
                } else {
                    this.recordNullReference(localVariableBinding, expression, n);
                }
                return;
            }
            case 21: {
                if (flowInfo.isPotentiallyNonNull(localVariableBinding) || flowInfo.isPotentiallyUnknown(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    return;
                }
                this.recordNullReference(localVariableBinding, expression, n);
                return;
            }
            case 22: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                    return;
                }
                if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableMayBeNull(localVariableBinding, expression);
                    return;
                }
                this.recordNullReference(localVariableBinding, expression, n);
                return;
            }
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int n = 0;
        while (n < this.assignCount) {
            if (this.finalAssignments[n] == reference) {
                this.finalAssignments[n] = null;
                this.finalVariables[n] = null;
                return;
            }
            ++n;
        }
    }
}

