<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!--
    
    tirar_ano_anterior_do_mapeamentoTxt.xslt: Transformador XSL para remover quadro referente à declaração do ano anterior de um arquivo mapeamentoTxt.xml, para facilitar a comparação dos demais quadros.
    
    Copyright 2023 FSFLA
    
    Este arquivo é parte do IRPF-Livre.
    
    IRPF-Livre é Software Livre; você pode redistribuir e/ou modificar a
    maior parte dele, inclusive este arquivo, de acordo com os termos da
    GNU Lesser General Public License publicada pela Free Software
    Foundation; tanto a versão 2.1 dessa licença, quanto (à sua escolha)
    qualquer versão posterior.
    
    Alguns componentes podem ser distribuídos e/ou modificados deacordo
    com outras licenças, incluídas no executável e consolidadas no arquivo
    list/licenses nos fontes.
    
    IRPF-Livre é distribuído na esperança de que ele seja útil, mas SEM
    QUALQUER GARANTIA; até mesmo sem qualquer garantia implícita de
    COMERCIABILIDADE OU ADEQUAÇÃO A UMA FINALIDADE ESPECÍFICA. Consulte a
    GNU Lesser General Public License para mais detalhes.
    
    Você deve ter recebido uma cópia da GNU Lesser General Public License
    junto com IRPF-Livre; se não, escreva para a Free Software Foundation,
    Inc., no endereço 59 Temple Street, Suite 330, Boston, MA 02111-1307
    USA.
    
    Veja uma tradução não oficial da licença em
    http://creativecommons.org/licenses/LGPL/2.1/legalcode.pt
    
    
    This file is part of IRPF-Livre.
    
    IRPF-Livre is free software; you can redistribute and/or modify most
    of it, this file included, under the terms of the GNU Lesser General
    Public License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.
    
    Some components can be distributed and/or modified under different
     licenses, included in the executable and consolidated in the file
     list/licenses in the source tree.
    
    IRPF-Livre is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.
    
    You should have received a copy of the GNU Lesser General Public
    License along with IRPF-Livre; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA.
    
  -->

  <!--

    # Contribuintes

    * Adonay Felipe Nogueira <https://libreplanet.org/wiki/User:Adfeno>

    # Como usar

    Para usar, instale um processador de XSLT 1.0, como o 
    `xsltproc` do pacote libxslt ou similar e faça algo como:

    xsltproc "Este script" "XML do mapeamentoTxt"

    Salvando duas saídas deste script sobre mapeamentoTxt.xml 
    de anos diferentes, pode-se então proceder com a 
    comparação linha por linha usando ferramentas POSIX como 
    `diff`, palavra por palavra com GNU `wdiff`, ou ainda com 
    as especializadas em comparar XML, tal como o pacote 
    `xmldiff` (veja <https://github.com/Shoobx/xmldiff>), por 
    exemplo:

    xmldiff -f xml -p mapa1.xml mapa2.xml | less -IN +'/diff:'

  -->

  <!-- Gera arquivos XML, codificados em UTF-8. -->
  <xsl:output encoding="UTF-8" />
  <!-- Inicia no nó raiz. -->
  <xsl:template match='/'>
    <!-- Não precisamos do prefixo "/Mapeamento/" para fazer a seleção funcionar, mas verificamos se (`xsl:if`) este existe para identificar falha no mapeamentoTxt.xml informado. -->
    <xsl:if test='not(/Mapeamento/DeclaracaoTXT[@TipoArquivo = "ARQ_IRPFANOANTERIOR"])'>
      <!-- Termina o processador com erro e imprime no descritor de erro padrão (stderr). -->
      <xsl:message terminate="yes">
        <!-- Ignora os espaços e tabulaçãoes/tabs em volta, usando apenas o texto dentro de `xsl:text`. -->
        <xsl:text>XML sem quadro do IRPF do ano anterior.</xsl:text>
      </xsl:message>
    </xsl:if>
    <!-- Tudo normal, continua (aplica os outros modelos para todos os nós descendentes) -->
    <xsl:apply-templates/>
  </xsl:template>

  <!-- Para todos os nós e atributos… -->
  <xsl:template match='node() | @*'>
    <!-- Copia eles. -->
    <xsl:copy>
      <!-- Segue procurando por outro modelos a aplicar ou reexibe. -->
      <xsl:apply-templates select='node() | @*'/>
    </xsl:copy>
  </xsl:template>

  <!-- Se é um quadro do ano anterior, não reexibe e não faz nada (nó `xsl:template` fechado na invocação, com /). -->
  <!-- Não precisamos do prefixo "/Mapeamento/" para fazer a seleção funcionar, mas mantemos o prefixo para coincidir com o a verificação inicial. -->
  <xsl:template match='/Mapeamento/DeclaracaoTXT[@TipoArquivo = "ARQ_IRPFANOANTERIOR"]'/>
</xsl:stylesheet>
