/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ItemQuadroOutrosRendimentos
extends ObjetoNegocio {
    private CPF cpfBenefic = new CPF(this, "CPF");
    private Alfa especificacao = new Alfa(this, "Descri\u00e7\u00e3o do rendimento", 60);
    private Valor valor = new Valor(this, "Valor do recebimento");
    private Alfa nomeFonte = new Alfa(this, "Nome da fonte pagadora", 60);
    private NI cnpjoucpfdaFonte = new NI(this, "CNPJ da Empresa ou CPF da Fonte");
    private Inteiro indiceDoBem = new Inteiro(this, "Chave/\u00edndice do bem; o primeiro \u00e9 1");
    private transient DeclaracaoIRPF objDecl;

    public ItemQuadroOutrosRendimentos(final DeclaracaoIRPF declaracaoIRPF) {
        this.objDecl = declaracaoIRPF;
        this.getCpfBenefic().setConteudo(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        this.getCnpjEmpresa().addValidador(new ValidadorNI(3));
        this.getValor().addValidador(new ValidadorNaoNulo(3));
        this.getCpfBenefic().addValidador(new ValidadorCPF(3));
        this.getCpfBenefic().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (ItemQuadroOutrosRendimentos.this.isMissingBenefic()) {
                    return new RetornoValidacao(tab.msg("cpf_branco"));
                }
                if (!ItemQuadroOutrosRendimentos.this.isTitular()) {
                    return new RetornoValidacao(tab.msg("rend_outros_cpf"));
                }
                return null;
            }
        });
        this.getIndiceDoBem().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                int n = ItemQuadroOutrosRendimentos.this.getIndiceDoBem().asInteger();
                if (n == 0) {
                    return null;
                }
                String string = ItemQuadroOutrosRendimentos.this.getNomeFonte().asString();
                if (string.length() == 0) {
                    return null;
                }
                if (n < 0 || n > declaracaoIRPF.getBens().recuperarLista().size()) {
                    return new RetornoValidacao(tab.msg("rend_bem_inexiste"));
                }
                Bem bem = (Bem)declaracaoIRPF.getBens().recuperarLista().get(n - 1);
                if (bem.getDiscriminacao().asString().indexOf(string) < 0) {
                    return new RetornoValidacao(tab.msg("rend_bem_indice_suspeito"));
                }
                return null;
            }
        });
    }

    public CPF getCpfBenefic() {
        return this.cpfBenefic;
    }

    public Alfa getEspecificacao() {
        return this.especificacao;
    }

    public Valor getValor() {
        return this.valor;
    }

    public Alfa getNomeFonte() {
        return this.nomeFonte;
    }

    public NI getCnpjEmpresa() {
        return this.cnpjoucpfdaFonte;
    }

    public Inteiro getIndiceDoBem() {
        return this.indiceDoBem;
    }

    public boolean isMissingBenefic(String string) {
        return string.equals("") || string.equals("   .   .   -  ");
    }

    public boolean isMissingBenefic() {
        String string = this.getCpfBenefic().asString();
        return this.isMissingBenefic(string);
    }

    public boolean isTitular() {
        String string = this.getCpfBenefic().asString();
        return this.isMissingBenefic(string) || string.equals(this.objDecl.getIdentificadorDeclaracao().getCpf().asString());
    }

    public boolean isDependente() {
        return !this.isTitular() && this.objDecl.getDependentes().getDependenteByCPF(this.getCpfBenefic()) != null;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getCnpjEmpresa());
        list.add(this.getEspecificacao());
        list.add(this.getValor());
        list.add(this.getCpfBenefic());
        list.add(this.getIndiceDoBem());
        return list;
    }
}

