/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.treeview.ArvoreGenerica;
import serpro.ppgd.infraestrutura.util.PPGDFormPanel;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelCacher
extends Thread {
    private List listaNomeProximos = new LinkedList();
    private List listaNomeTodos = new LinkedList();
    private Hashtable cache = new Hashtable();
    private Integer lockLista = new Integer(0);
    private static PainelCacher instance = new PainelCacher();
    public static final int INICIADO = 0;
    public static final int PAUSADO = 1;
    public static final int FINALIZADO = 2;
    private long cacherSleep;
    private transient int estado = 2;
    private ArvoreGenerica arvorePlataforma = (ArvoreGenerica)PlataformaPPGD.getPlataforma().getSwingEngine().find("ppgdarvore");

    public static PainelCacher getInstance() {
        if (!instance.isAlive()) {
            instance.start();
            instance.setPriority(1);
        }
        return instance;
    }

    public static PainelCacher getInstancia() {
        if (!instance.isAlive()) {
            instance.start();
            instance.setPriority(1);
        }
        return instance;
    }

    private PainelCacher() {
        this.cacherSleep = Long.parseLong(FabricaUtilitarios.getProperties().getProperty("aplicacao.infraestrutura.painelcacher.intervalo", "3000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.estado == 0) {
                        Integer n = this.lockLista;
                        synchronized (n) {
                            if (this.listaNomeProximos.size() > 0) {
                                ItemCache itemCache = (ItemCache)this.listaNomeProximos.remove(0);
                                String string = itemCache.getNomeClasse();
                                JPanel jPanel = (JPanel)this.cache.get(string);
                                if (jPanel == null) {
                                    jPanel = PlataformaPPGD.getPlataforma().instanciaPainel(string);
                                }
                                if (jPanel != null) {
                                    this.aplicaIdentificacao(string, jPanel);
                                    this.cache.put(string, jPanel);
                                }
                            }
                        }
                    }
                    PainelCacher.sleep(this.cacherSleep);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void inicia() {
        LogPPGD.debug("############ Iniciando PainelCacher ##############");
        this.estado = 0;
    }

    public void pausa() {
        this.estado = 1;
    }

    public void encerra() {
        LogPPGD.debug("############ Encerrando PainelCacher ##############");
        this.estado = 2;
        this.reiniciaCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void esvaziaCache() {
        LogPPGD.debug("############ Esvaziando PainelCacher ##############");
        this.estado = 2;
        Integer n = this.lockLista;
        synchronized (n) {
            this.cache.clear();
            this.listaNomeProximos.clear();
            this.listaNomeTodos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reiniciaCache() {
        Integer n = this.lockLista;
        synchronized (n) {
            this.cache.clear();
            this.listaNomeProximos.clear();
            this.listaNomeProximos.addAll(this.listaNomeTodos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fazCacheDe(String string) {
        Integer n = this.lockLista;
        synchronized (n) {
            ItemCache itemCache = new ItemCache(string);
            this.listaNomeProximos.add(itemCache);
            this.listaNomeTodos.add(itemCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fazCacheDe(String string, Object object) {
        Integer n = this.lockLista;
        synchronized (n) {
            ItemCache itemCache = new ItemCache(string, object);
            this.listaNomeProximos.add(itemCache);
            this.listaNomeTodos.add(itemCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPanel obtemUrgentemente(String string) {
        JPanel jPanel = (JPanel)this.cache.get(string);
        int n = this.estado;
        if (jPanel == null) {
            Integer n2 = this.lockLista;
            synchronized (n2) {
                JPanel jPanel2 = null;
                try {
                    jPanel2 = PlataformaPPGD.getPlataforma().instanciaPainel(string);
                    this.aplicaIdentificacao(string, jPanel2);
                    this.cache.put(string, jPanel2);
                    this.listaNomeProximos.remove(string);
                }
                catch (Exception exception) {
                    LogPPGD.erro("O PainelCacher n\u00e3o conseguiu instanciar a classe " + string + "!!");
                    exception.printStackTrace();
                }
                jPanel = jPanel2;
            }
        }
        this.estado = n;
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPanel obtemUrgentemente(String string, String string2) {
        JPanel jPanel = (JPanel)this.cache.get(string);
        int n = this.estado;
        if (jPanel == null) {
            Integer n2 = this.lockLista;
            synchronized (n2) {
                JPanel jPanel2 = null;
                try {
                    jPanel2 = PlataformaPPGD.getPlataforma().instanciaPainel(string2);
                    this.aplicaIdentificacao(string, jPanel2);
                    this.cache.put(string, jPanel2);
                    this.listaNomeProximos.remove(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                jPanel = jPanel2;
            }
        }
        this.estado = n;
        return jPanel;
    }

    public boolean isEmCache(String string) {
        return this.cache.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instanciaTodosUrgenteMente() {
        try {
            int n = this.estado;
            this.pausa();
            Integer n2 = this.lockLista;
            synchronized (n2) {
                for (ItemCache itemCache : this.listaNomeProximos) {
                    String string = itemCache.getNomeClasse();
                    this.obtemUrgentemente(string);
                }
                this.listaNomeProximos.clear();
            }
            this.estado = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void aplicaIdentificacao(String string, JPanel jPanel) {
        if (jPanel instanceof PPGDFormPanel) {
            ((PPGDFormPanel)jPanel).setIdentificaoPainel(this.arvorePlataforma.getRotuloNodo(string));
        }
    }

    private class ItemCache {
        private String nomeClasse;
        private Object param;

        public ItemCache(String string) {
            this.setNomeClasse(string);
        }

        public ItemCache(String string, Object object) {
            this.setNomeClasse(string);
            this.setParam(object);
        }

        public void setNomeClasse(String string) {
            this.nomeClasse = string;
        }

        public String getNomeClasse() {
            return this.nomeClasse;
        }

        public void setParam(Object object) {
            this.param = object;
        }

        public Object getParam() {
            return this.param;
        }

        public boolean equals(Object object) {
            if (object instanceof ItemCache) {
                ItemCache itemCache = (ItemCache)object;
                return this.getNomeClasse().equals(itemCache.getNomeClasse());
            }
            return false;
        }
    }
}

