/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogPPGD {
    private static Logger logger;

    static {
        LogPPGD.instanciaEAplicaLevel();
    }

    private static void instanciaEAplicaLevel() {
        InputStream inputStream = LogPPGD.class.getResourceAsStream("/aplicacao.properties");
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                String string = properties.getProperty("logger.level", "ERRO");
                if (string.compareTo("ERRO") == 0) {
                    string = "SEVERE";
                } else if (string.compareTo("AVISO") == 0) {
                    string = "WARNING";
                } else if (string.compareTo("DEBUG") == 0) {
                    string = "INFO";
                }
                logger = Logger.getLogger(LogPPGD.class.getName());
                logger.setLevel(Level.parse(string));
            } else {
                System.err.println("Nao foi poss\u00edvel localizar o arquivo: /aplicacao.properties");
                System.err.println("O log n\u00e3o vai funcionar assim!");
            }
        }
        catch (IOException iOException) {
            System.err.println("N\u00e3o foi poss\u00edvel carregar arquivo: /aplicacao.properties");
            System.err.println("O log n\u00e3o vai funcionar assim!");
            iOException.printStackTrace();
        }
    }

    public static void debug(String string) {
        if (logger == null) {
            System.err.println("H\u00e1 algum problema com o logger, n\u00e3o foi instanciado.");
        } else {
            logger.info(string);
        }
    }

    public static void aviso(String string) {
        if (logger == null) {
            System.err.println("H\u00e1 algum problema com o logger, n\u00e3o foi instanciado.");
        } else {
            logger.warning(string);
        }
    }

    public static void erro(String string) {
        if (logger == null) {
            System.err.println("H\u00e1 algum problema com o logger, n\u00e3o foi instanciado.");
        } else {
            logger.severe(string);
        }
    }

    public static void main(String[] stringArray) {
        LogPPGD.debug("Este \u00e9 um debug!");
        LogPPGD.aviso("Este \u00e9 um aviso!");
        LogPPGD.erro("Este \u00e9 um erro!");
    }
}

