/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.fill.JRFillCategorySeries;
import net.sf.jasperreports.charts.util.CategoryLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class JRFillCategoryDataset
extends JRFillChartDataset
implements JRCategoryDataset {
    protected JRFillCategorySeries[] categorySeries = null;
    private DefaultCategoryDataset dataset = null;
    private Map labelsMap = null;
    private Map itemHyperlinks;

    public JRFillCategoryDataset(JRCategoryDataset jRCategoryDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRCategoryDataset, jRFillObjectFactory);
        JRCategorySeries[] jRCategorySeriesArray = jRCategoryDataset.getSeries();
        if (jRCategorySeriesArray != null && jRCategorySeriesArray.length > 0) {
            this.categorySeries = new JRFillCategorySeries[jRCategorySeriesArray.length];
            int n = 0;
            while (n < this.categorySeries.length) {
                this.categorySeries[n] = (JRFillCategorySeries)jRFillObjectFactory.getCategorySeries(jRCategorySeriesArray[n]);
                ++n;
            }
        }
    }

    public JRCategorySeries[] getSeries() {
        return this.categorySeries;
    }

    protected void customInitialize() {
        this.dataset = null;
        this.labelsMap = null;
        this.itemHyperlinks = null;
    }

    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            int n = 0;
            while (n < this.categorySeries.length) {
                this.categorySeries[n].evaluate(jRCalculator);
                ++n;
            }
        }
    }

    protected void customIncrement() {
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            if (this.dataset == null) {
                this.dataset = new DefaultCategoryDataset();
                this.labelsMap = new HashMap();
                this.itemHyperlinks = new HashMap();
            }
            int n = 0;
            while (n < this.categorySeries.length) {
                Map<Comparable<Object>, String> map;
                JRFillCategorySeries jRFillCategorySeries = this.categorySeries[n];
                Comparable comparable = jRFillCategorySeries.getSeries();
                comparable.toString();
                this.dataset.addValue(jRFillCategorySeries.getValue(), jRFillCategorySeries.getSeries(), jRFillCategorySeries.getCategory());
                if (jRFillCategorySeries.getLabelExpression() != null) {
                    map = (HashMap<Comparable, String>)this.labelsMap.get(comparable);
                    if (map == null) {
                        map = new HashMap<Comparable, String>();
                        this.labelsMap.put(comparable, map);
                    }
                    map.put(jRFillCategorySeries.getCategory(), jRFillCategorySeries.getLabel());
                }
                if (jRFillCategorySeries.hasItemHyperlinks()) {
                    map = (Map)this.itemHyperlinks.get(comparable);
                    if (map == null) {
                        map = new HashMap();
                        this.itemHyperlinks.put(comparable, map);
                    }
                    map.put(jRFillCategorySeries.getCategory(), (String)((Object)jRFillCategorySeries.getPrintItemHyperlink()));
                }
                ++n;
            }
        }
    }

    public Dataset getCustomDataset() {
        return this.dataset;
    }

    public byte getDatasetType() {
        return 2;
    }

    public CategoryLabelGenerator getLabelGenerator() {
        return new CategoryLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    public boolean hasItemHyperlinks() {
        boolean bl = false;
        if (this.categorySeries != null && this.categorySeries.length > 0) {
            int n = 0;
            while (n < this.categorySeries.length && !bl) {
                JRFillCategorySeries jRFillCategorySeries = this.categorySeries[n];
                bl = jRFillCategorySeries.hasItemHyperlinks();
                ++n;
            }
        }
        return bl;
    }

    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }
}

