/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.TabelaMensagens;

public abstract class ObjetoNegocio
extends Observador {
    protected transient IdDeclaracao idDeclaracao;
    private boolean observadorAtivo = true;
    protected TabelaMensagens tab = TabelaMensagens.getTabelaMensagens();
    protected String ficha = "";
    protected boolean persistente = true;

    public ObjetoNegocio(IdDeclaracao idDeclaracao) {
        this.idDeclaracao = idDeclaracao;
    }

    public ObjetoNegocio() {
        this.idDeclaracao = null;
    }

    public IdDeclaracao getIdDeclaracao() {
        return this.idDeclaracao;
    }

    protected boolean testaVazio(Informacao informacao) {
        return true;
    }

    public boolean isVazio() {
        try {
            for (Field field : FabricaUtilitarios.getAllFields(this.getClass())) {
                Object object;
                boolean bl = field.isAccessible();
                field.setAccessible(true);
                if (Informacao.class.isAssignableFrom(field.getType())) {
                    object = (Informacao)field.get(this);
                    if (this.testaVazio((Informacao)object) && !((Informacao)object).isVazio()) {
                        return false;
                    }
                    break;
                }
                if (ObjetoNegocio.class.isAssignableFrom(field.getType()) && (object = (ObjetoNegocio)field.get(this)) != null && !(object instanceof IdDeclaracao) && !((ObjetoNegocio)object).isVazio()) {
                    return false;
                }
                field.setAccessible(bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(exception);
        }
        return true;
    }

    public List recuperarCamposInformacao() {
        Vector<Informacao> vector = new Vector<Informacao>();
        try {
            for (Field field : FabricaUtilitarios.getAllFields(this.getClass())) {
                boolean bl = field.isAccessible();
                field.setAccessible(true);
                if (Informacao.class.isAssignableFrom(field.getType())) {
                    Informacao informacao = (Informacao)field.get(this);
                    vector.add(informacao);
                }
                field.setAccessible(bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(exception);
        }
        return vector;
    }

    public void clear() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            informacao.clear();
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isObservadorAtivo()) {
            LogPPGD.debug("Disparando observador " + this + ".");
            this.implementacaoPropertyChange(propertyChangeEvent);
        }
        super.propertyChange(propertyChangeEvent);
    }

    protected void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void notifica(Object object, String string, Object object2, Object object3) {
    }

    public boolean isObservadorAtivo() {
        return this.observadorAtivo;
    }

    public void setObservadorAtivo(boolean bl) {
        this.observadorAtivo = bl;
    }

    public void setValidadoresAtivos(boolean bl) {
        try {
            for (Field field : FabricaUtilitarios.getAllFields(this.getClass())) {
                Object object;
                boolean bl2 = field.isAccessible();
                field.setAccessible(true);
                if (Informacao.class.isAssignableFrom(field.getType())) {
                    object = (Informacao)field.get(this);
                    if (object != null) {
                        ((Informacao)object).setValidadoresAtivos(bl);
                    }
                } else if (!IdDeclaracao.class.isAssignableFrom(field.getType()) && ObjetoNegocio.class.isAssignableFrom(field.getType()) && (object = (ObjetoNegocio)field.get(this)) != null) {
                    ((ObjetoNegocio)object).setValidadoresAtivos(bl);
                }
                field.setAccessible(bl2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(exception);
        }
    }

    public List verificarPendencias(int n) {
        Vector<Object> vector = new Vector<Object>();
        for (Object e : this.recuperarListaCamposPendencia()) {
            if (!(e instanceof Informacao)) {
                throw new IllegalArgumentException("Par\u00e2metro " + e.getClass() + " n\u00e3o \u00e9 Informacao.");
            }
            Informacao informacao = (Informacao)e;
            Enumeration enumeration = informacao.validar().elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object e2 = enumeration.nextElement();
                if (!(e2 instanceof RetornoValidacao)) {
                    object = "Elemento " + e2.getClass() + " da lista de RetornosValidacoes da classe " + this.getClass() + " n\u00e3o \u00e9 um RetornoValidacao";
                    LogPPGD.erro((String)object);
                    throw new IllegalArgumentException((String)object);
                }
                RetornoValidacao retornoValidacao = (RetornoValidacao)e2;
                if (retornoValidacao.getSeveridade() <= 0) continue;
                object = new Pendencia(retornoValidacao.getSeveridade(), informacao, informacao.getNomeCampo(), retornoValidacao.getMensagemValidacao(), n);
                vector.add(object);
            }
        }
        return vector;
    }

    protected List recuperarListaCamposPendencia() {
        Vector vector = new Vector();
        return vector;
    }

    public void setFicha(String string) {
        this.ficha = string;
        for (Object e : this.recuperarListaCamposPendencia()) {
            if (!(e instanceof Informacao)) {
                throw new IllegalArgumentException("Par\u00e2metro " + e.getClass() + " n\u00e3o \u00e9 Informacao.");
            }
            Informacao informacao = (Informacao)e;
            informacao.setFicha(this.ficha);
        }
    }

    public String getFicha() {
        return this.ficha;
    }

    public void removeObservadoresAnonimosDesnecessarios(Class clazz) {
        try {
            for (Field field : FabricaUtilitarios.getAllFields(this.getClass())) {
                Object object;
                boolean bl;
                if (Modifier.isTransient(field.getModifiers())) continue;
                if (Informacao.class.isAssignableFrom(field.getType())) {
                    bl = field.isAccessible();
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if ((object = (Informacao)field.get(this)) != null) {
                        ((Informacao)object).removeObservadoresAnonimosDesnecessarios(clazz);
                    }
                    field.setAccessible(bl);
                    continue;
                }
                if (IdDeclaracao.class.isAssignableFrom(field.getType()) || !ObjetoNegocio.class.isAssignableFrom(field.getType())) continue;
                bl = field.isAccessible();
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((object = (ObjetoNegocio)field.get(this)) != null) {
                    ((ObjetoNegocio)object).removeObservadoresAnonimosDesnecessarios(clazz);
                }
                field.setAccessible(bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeObservadores(Class[] classArray) {
        try {
            for (Field field : FabricaUtilitarios.getAllFields(this.getClass())) {
                Object object;
                boolean bl;
                if (Modifier.isTransient(field.getModifiers())) continue;
                if (Informacao.class.isAssignableFrom(field.getType())) {
                    bl = field.isAccessible();
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if ((object = (Informacao)field.get(this)) != null) {
                        ((Informacao)object).removeObservadores(classArray);
                    }
                    field.setAccessible(bl);
                    continue;
                }
                if (IdDeclaracao.class.isAssignableFrom(field.getType()) || !ObjetoNegocio.class.isAssignableFrom(field.getType())) continue;
                bl = field.isAccessible();
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((object = (ObjetoNegocio)field.get(this)) != null) {
                    ((ObjetoNegocio)object).removeObservadores(classArray);
                }
                field.setAccessible(bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isPersistente() {
        return this.persistente;
    }

    public void setPersistente(boolean bl) {
        this.persistente = bl;
    }
}

