/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.OpcaoLogico;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.ValidadorImpeditivoLogico;
import serpro.ppgd.negocio.util.LogPPGD;

public class Logico
extends Informacao {
    private String conteudo = "";
    public static String SIM = "1";
    public static String NAO = "0";
    public static String LABEL_SIM = "Sim";
    public static String LABEL_NAO = "N\u00e3o";
    public boolean selecaoMultipla = false;
    private Map opcoes = new Hashtable();
    private LinkedList listaOrdenada = new LinkedList();
    private Vector listaValidadoresimpeditivosTemporaria = new Vector();

    public Logico() {
        super("");
    }

    @Override
    public void addValidador(ValidadorIf validadorIf) {
        if (validadorIf instanceof ValidadorImpeditivoDefault && !(validadorIf instanceof ValidadorImpeditivoLogico)) {
            throw new IllegalArgumentException("O Validador adicionado n\u00e3o \u00e9 do tipo ValidadorImpeditivoLogico.\n Fa\u00e7a com que esse herde de ValidadorImpeditivoLogico.");
        }
        super.addValidador(validadorIf);
    }

    public void atualizaListaValidadoresImpeditivos(String string) {
        Vector<ValidadorImpeditivoLogico> vector = new Vector<ValidadorImpeditivoLogico>();
        for (ValidadorImpeditivoLogico validadorImpeditivoLogico : super.getListaValidadoresImpeditivos()) {
            if (validadorImpeditivoLogico.getValorOpcaoDoLogico().trim().equals("") || !this.getOpcoes().containsKey(validadorImpeditivoLogico.getValorOpcaoDoLogico().trim()) || !string.equals(validadorImpeditivoLogico.getValorOpcaoDoLogico())) continue;
            vector.add(validadorImpeditivoLogico);
        }
        this.listaValidadoresimpeditivosTemporaria.clear();
        this.listaValidadoresimpeditivosTemporaria.addAll(vector);
    }

    @Override
    public void ordenaListaValidadoreImpeditivos() {
        LinkedList<ValidadorImpeditivoDefault> linkedList = new LinkedList<ValidadorImpeditivoDefault>();
        for (ValidadorImpeditivoDefault validadorImpeditivoDefault : this.getListaValidadoresImpeditivos()) {
            if (validadorImpeditivoDefault.getSeveridade() == 5) {
                linkedList.addFirst(validadorImpeditivoDefault);
                continue;
            }
            if (validadorImpeditivoDefault.getSeveridade() != 4) continue;
            linkedList.addLast(validadorImpeditivoDefault);
        }
        this.listaValidadoresimpeditivosTemporaria.clear();
        this.listaValidadoresimpeditivosTemporaria.addAll(linkedList);
    }

    @Override
    public Vector getListaValidadoresImpeditivos() {
        return this.listaValidadoresimpeditivosTemporaria;
    }

    public void adicionaOpcao(String string, String string2) {
        if (this.opcoes.containsKey(string2)) {
            this.listaOrdenada.remove(this.opcoes.get(string2));
        }
        OpcaoLogico opcaoLogico = new OpcaoLogico(string, string2);
        this.opcoes.put(string2, opcaoLogico);
        this.listaOrdenada.addLast(opcaoLogico);
    }

    public void addOpcao(String string, String string2) {
        if (this.opcoes.containsKey(string)) {
            this.listaOrdenada.remove(this.opcoes.get(string));
        }
        OpcaoLogico opcaoLogico = new OpcaoLogico(string2, string);
        this.opcoes.put(string, opcaoLogico);
        this.listaOrdenada.addLast(opcaoLogico);
    }

    public String getLabelOpcao(String string) {
        if (this.opcoes.containsKey(string)) {
            return ((OpcaoLogico)this.opcoes.get((Object)string)).labelOpcao;
        }
        return "";
    }

    public String getValorOpcao(String string) {
        String string2 = "";
        for (OpcaoLogico opcaoLogico : this.opcoes.values()) {
            if (!opcaoLogico.labelOpcao.trim().equals(string.trim())) continue;
            return opcaoLogico.valorOpcao;
        }
        return string2;
    }

    public Logico(ObjetoNegocio objetoNegocio, String string) {
        super(objetoNegocio, string);
    }

    public void converteEmTipoSimNao(String string) {
        this.adicionaOpcao(LABEL_SIM, SIM);
        this.adicionaOpcao(LABEL_NAO, NAO);
        this.setConteudo(string);
    }

    @Override
    public void clear() {
        this.setConteudo("");
    }

    @Override
    public String asString() {
        for (OpcaoLogico opcaoLogico : this.opcoes.values()) {
            if (!opcaoLogico.selecionado) continue;
            return opcaoLogico.valorOpcao;
        }
        return this.conteudo;
    }

    @Override
    public String getConteudoFormatado() {
        return this.asString();
    }

    @Override
    public void setConteudo(String string) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + this.conteudo);
        String string2 = this.conteudo;
        this.clearRetornosValidacoes();
        if (!this.opcoes.containsKey(string)) {
            string = "";
        }
        this.conteudo = string;
        for (OpcaoLogico opcaoLogico : this.opcoes.values()) {
            if (opcaoLogico.valorOpcao.trim().equals(string.trim())) {
                opcaoLogico.selecionado = true;
                continue;
            }
            opcaoLogico.selecionado = false;
        }
        this.disparaObservadores(string2);
    }

    @Override
    public boolean isVazio() {
        return this.asString() == null || this.asString().trim().length() == 0;
    }

    public Map getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(Map map) {
        this.opcoes = map;
    }

    public LinkedList getListaOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isSelecaoMultipla() {
        return this.selecaoMultipla;
    }

    public void setSelecaoMultipla(boolean bl) {
        this.selecaoMultipla = bl;
    }
}

