/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.RetornosValidacoes;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;

public abstract class Informacao
implements Comparable {
    public static final String VALIDO_PROPERTY = "Val-Property";
    public static final String READ_ONLY_PROPERTY = "ReadOnly";
    public static final String HABILITADO_PROPERTY = "habilitado";
    public static final String ROTULO_CHANGE_PROPERTY = "Label_Modificado";
    private String nomeCampo = "";
    private String nomeCampoCurto = "";
    private ObjetoNegocio owner;
    private String conteudo = "";
    private String ficha = "";
    private boolean readOnly = false;
    private boolean habilitado = true;
    private boolean transportado = false;
    protected String conteudoAntigo = "";
    protected boolean inicializouUltimoConteudoValido = false;
    private String ultimoConteudoValido = "";
    private Vector listaValidadores;
    private Vector listaValidadoresImpeditivos = new Vector();
    private RetornosValidacoes retornoTodasValidacoes = new RetornosValidacoes();
    private PropertyChangeSupport observadores = new PropertyChangeSupport(this);
    private boolean observadoresAtivos = true;
    private boolean validadoresAtivos = true;
    private boolean atributoPersistente = true;

    public Informacao() {
    }

    public Informacao(ObjetoNegocio objetoNegocio, String string) {
        this();
        this.setOwner(objetoNegocio);
        this.setNomeCampo(string);
        this.setNomeCampoAlternativo(string);
        LogPPGD.debug("Campo [" + string + "] criado como objeto " + this.getClass().getName() + ".");
    }

    public Informacao(String string) {
        this();
        this.setNomeCampo(string);
        this.setNomeCampoAlternativo(string);
        LogPPGD.debug("Campo [" + string + "] criado como objeto " + this.getClass().getName() + ".");
    }

    public void setConteudo(String string) {
        if (!this.inicializouUltimoConteudoValido) {
            this.inicializouUltimoConteudoValido = true;
            this.ultimoConteudoValido = string;
        }
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + string);
        String string2 = this.asString();
        this.clearRetornosValidacoes();
        this.conteudo = string;
        if (this.isVazio()) {
            this.ultimoConteudoValido = "";
        }
        this.disparaObservadores(string2);
    }

    public abstract String getConteudoFormatado();

    public String toString() {
        return this.getConteudoFormatado();
    }

    public String asString() {
        return this.conteudo;
    }

    public boolean isVazio() {
        return this.asString() == null || UtilitariosString.retiraMascara(this.asString().trim()).length() == 0;
    }

    public int compareTo(Object object) {
        return this.asString().compareTo(object.toString());
    }

    public void clear() {
        this.setConteudo("");
    }

    public String getNomeCampo() {
        return this.nomeCampo;
    }

    public void setNomeCampo(String string) {
        String string2 = this.getNomeCampo();
        this.nomeCampo = string;
        this.getObservadores().firePropertyChange(ROTULO_CHANGE_PROPERTY, string2, this.getNomeCampo());
    }

    public void addValidador(ValidadorIf validadorIf) {
        if (this.listaValidadores == null) {
            this.listaValidadores = new Vector();
        }
        if (validadorIf instanceof ValidadorImpeditivoDefault) {
            this.listaValidadoresImpeditivos.add(validadorIf);
        } else {
            this.listaValidadores.add(validadorIf);
        }
        validadorIf.setInformacao(this);
        validadorIf.setRetornosValidacoes(this.retornoTodasValidacoes);
    }

    public boolean isValido() {
        return this.retornoTodasValidacoes.isTodosValidos();
    }

    public RetornoValidacao getPrimeiroRetornoValidacaoMaisSevero() {
        return this.retornoTodasValidacoes.getPrimeiroRetornoValidacaoMaisSevero();
    }

    public void clearRetornosValidacoes() {
        this.retornoTodasValidacoes.clear();
    }

    public RetornosValidacoes validar() {
        LogPPGD.debug("Valida\u00e7\u00e3o de " + this.getNomeCampo() + " [=" + this.toString() + "]");
        this.retornoTodasValidacoes.clear();
        if (this.listaValidadores != null && this.isValidadoresAtivos()) {
            Iterator iterator = this.listaValidadores.iterator();
            while (iterator.hasNext()) {
                ((ValidadorIf)iterator.next()).validar();
            }
        }
        if (this.isValido() && this.getRetornoTodasValidacoes().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() != 4) {
            this.setUltimoConteudoValido(this.asString());
        }
        return this.retornoTodasValidacoes;
    }

    public ObjetoNegocio getOwner() {
        return this.owner;
    }

    public void setOwner(ObjetoNegocio objetoNegocio) {
        this.owner = objetoNegocio;
    }

    public PropertyChangeSupport getObservadores() {
        return this.observadores;
    }

    public void addObservador(Observador observador) {
        this.observadores.addPropertyChangeListener(observador);
    }

    public void addObservador(String string, Observador observador) {
        this.observadores.addPropertyChangeListener(string, observador);
    }

    public void removeObservador(Observador observador) {
        this.observadores.removePropertyChangeListener(observador);
    }

    public void removeObservador(String string, Observador observador) {
        this.observadores.removePropertyChangeListener(string, observador);
    }

    public void disparaObservadores() {
        if (this.isVazio()) {
            this.disparaObservadores("");
        } else {
            this.disparaObservadores("_");
        }
    }

    protected void disparaObservadores(Object object) {
        if (object != null && !object.equals("-")) {
            this.setConteudoAntigo((String)object);
        }
        LogPPGD.debug("Chamando observadores de " + this.getNomeCampo() + " [=" + this.toString() + "]");
        if (this.isObservadoresAtivos()) {
            this.getObservadores().firePropertyChange(this.getNomeCampo(), object, this.asString());
        }
    }

    public boolean isObservadoresAtivos() {
        return this.observadoresAtivos;
    }

    public void setObservadoresAtivos(boolean bl) {
        this.observadoresAtivos = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        LogPPGD.debug(this.getNomeCampo() + ".readOnly = " + String.valueOf(bl));
        boolean bl2 = this.readOnly;
        this.readOnly = bl;
        if (this.isObservadoresAtivos() && bl2 != this.readOnly) {
            this.getObservadores().firePropertyChange(READ_ONLY_PROPERTY, !bl, bl);
        }
    }

    public String getFicha() {
        return this.ficha;
    }

    public void setFicha(String string) {
        this.ficha = string;
    }

    public RetornosValidacoes getRetornoTodasValidacoes() {
        return this.retornoTodasValidacoes;
    }

    public void setRetornoTodasValidacoes(RetornosValidacoes retornosValidacoes) {
        this.retornoTodasValidacoes = retornosValidacoes;
    }

    public Vector getListaValidadores() {
        return this.listaValidadores;
    }

    public void setNomeCampoAlternativo(String string) {
        this.nomeCampoCurto = string;
    }

    public String getNomeCampoCurto() {
        return this.nomeCampoCurto;
    }

    public void setHabilitado(boolean bl) {
        LogPPGD.debug(this.getNomeCampo() + ".isHabilitado = " + String.valueOf(bl));
        this.habilitado = bl;
        if (this.isObservadoresAtivos()) {
            this.getObservadores().firePropertyChange(HABILITADO_PROPERTY, !bl, bl);
        }
        this.habilitado = bl;
    }

    public void sinalizaValidoEdit() {
        this.getObservadores().firePropertyChange(VALIDO_PROPERTY, "Invalido", "Valido");
    }

    public boolean isHabilitado() {
        return this.habilitado;
    }

    public boolean isTransportado() {
        return this.transportado;
    }

    public void setTransportado(boolean bl) {
        this.transportado = bl;
    }

    public String getConteudoAntigo() {
        return this.conteudoAntigo;
    }

    public void setConteudoAntigo(String string) {
        if (!string.equals(this.asString())) {
            this.conteudoAntigo = string;
        }
    }

    public void removeObservadores(Class[] classArray) throws ClassNotFoundException {
        PropertyChangeListener[] propertyChangeListenerArray = this.getObservadores().getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            String string = propertyChangeListenerArray[i].getClass().getName();
            Class<?> clazz = null;
            clazz = string.indexOf("$") != -1 ? Class.forName(string.substring(0, string.indexOf("$"))) : propertyChangeListenerArray[i].getClass();
            if (!this.comparaClass(classArray, clazz)) continue;
            this.getObservadores().removePropertyChangeListener(propertyChangeListenerArray[i]);
        }
    }

    private boolean comparaClass(Class[] classArray, Class clazz) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public void removeObservadoresAnonimosDesnecessarios(Class clazz) throws ClassNotFoundException {
        PropertyChangeListener[] propertyChangeListenerArray = this.getObservadores().getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            Class<?> clazz2;
            String string = propertyChangeListenerArray[i].getClass().getName();
            if (string.indexOf("$") == -1 || !clazz.isAssignableFrom(clazz2 = Class.forName(string.substring(0, string.indexOf("$"))))) continue;
            this.getObservadores().removePropertyChangeListener(propertyChangeListenerArray[i]);
        }
    }

    public boolean isValidadoresAtivos() {
        return this.validadoresAtivos;
    }

    public void setValidadoresAtivos(boolean bl) {
        this.validadoresAtivos = bl;
    }

    public void setUltimoConteudoValido(String string) {
        this.ultimoConteudoValido = string;
    }

    public String getUltimoConteudoValido() {
        return this.ultimoConteudoValido;
    }

    public Vector getListaValidadoresImpeditivos() {
        return this.listaValidadoresImpeditivos;
    }

    public void ordenaListaValidadoreImpeditivos() {
        LinkedList<ValidadorImpeditivoDefault> linkedList = new LinkedList<ValidadorImpeditivoDefault>();
        LinkedList<ValidadorImpeditivoDefault> linkedList2 = new LinkedList<ValidadorImpeditivoDefault>();
        for (ValidadorImpeditivoDefault validadorImpeditivoDefault : this.getListaValidadoresImpeditivos()) {
            if (validadorImpeditivoDefault.getSeveridade() == 5) {
                linkedList.add(validadorImpeditivoDefault);
                continue;
            }
            if (validadorImpeditivoDefault.getSeveridade() != 4) continue;
            linkedList2.add(validadorImpeditivoDefault);
        }
        linkedList.addAll(linkedList2);
        this.listaValidadoresImpeditivos.clear();
        this.listaValidadoresImpeditivos.addAll(linkedList);
    }

    public boolean isAtributoPersistente() {
        return this.atributoPersistente;
    }

    public void setAtributoPersistente(boolean bl) {
        this.atributoPersistente = bl;
    }
}

