/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosDividas
extends Observador {
    private Dividas dividas = null;

    public CalculosDividas(Dividas dividas) {
        this.dividas = dividas;
    }

    @Override
    public void notifica(Object object, String string, Object object2, Object object3) {
        if (string != null) {
            if (string.equals("ObjetoInserido")) {
                ((Divida)object3).getValorExercicioAtual().addObservador(this);
                ((Divida)object3).getValorExercicioAnterior().addObservador(this);
            } else if (string.equals("ObjetoRemovido")) {
                ((Divida)object3).getValorExercicioAtual().removeObservador(this);
                ((Divida)object3).getValorExercicioAnterior().removeObservador(this);
            }
        }
        this.calculaTotalExercicioAtual();
        this.calculaTotalExercicioAnterior();
    }

    private void calculaTotalExercicioAtual() {
        Valor valor = new Valor();
        for (Divida divida : this.dividas.recuperarLista()) {
            valor.append('+', divida.getValorExercicioAtual());
        }
        this.dividas.getTotalExercicioAtual().setConteudo(valor);
    }

    private void calculaTotalExercicioAnterior() {
        Valor valor = new Valor();
        for (Divida divida : this.dividas.recuperarLista()) {
            valor.append('+', divida.getValorExercicioAnterior());
        }
        this.dividas.getTotalExercicioAnterior().setConteudo(valor);
    }
}

