/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDTextArea;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;

public class EditMemo
extends EditCampo {
    private static Alfa vazio = new Alfa("EditMemo");
    private JTextArea componente;
    private JScrollPane sp;
    private int nrMaxCaracteres;

    public EditMemo() {
        super(vazio);
    }

    public EditMemo(Informacao informacao, Dimension dimension, int n) {
        super(informacao, dimension);
        this.nrMaxCaracteres = n;
    }

    @Override
    public void setInformacao(Informacao informacao) {
        if (this.componente == null) {
            this.componente = new PPGDTextArea(this.d[0].height, this.d[0].width);
            this.sp = new JScrollPane(this.componente);
            this.componente.setLineWrap(true);
            this.componente.setWrapStyleWord(true);
            this.componente.setTabSize(1);
            this.componente.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getOppositeComponent() != null) {
                        EditMemo.this.setIdentificacaoFoco(false);
                        if (EditMemo.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() || EditMemo.this.verificaValidacoesImpeditivas(EditMemo.this.componente.getText())) {
                            EditMemo.this.setObservadorAtivo(false);
                            String string = EditMemo.this.componente.getText();
                            if (string.length() > EditMemo.this.nrMaxCaracteres) {
                                string = string.substring(0, EditMemo.this.nrMaxCaracteres);
                            }
                            EditMemo.this.getInformacao().setConteudo(string);
                            EditMemo.this.chamaValidacao();
                            EditMemo.this.setObservadorAtivo(true);
                        }
                    }
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    boolean bl = c != '\uffff' && c != '\b' && c != '\u007f' && c != '%' && c != '\'' || c == '\u0011';
                    int n = EditMemo.this.componente.getText().length();
                    if (n >= EditMemo.this.nrMaxCaracteres && bl && EditMemo.this.componente.getSelectedText() == null) {
                        keyEvent.setKeyChar('\uffff');
                        keyEvent.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(EditMemo.this.componente);
                    }
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    char c = keyEvent.getKeyChar();
                    boolean bl = c != '\t' && c != '\n' && c != '\b' && c != '\u007f' && c != '%' && c != '\'';
                    int n = EditMemo.this.componente.getText().length();
                    if (n >= EditMemo.this.nrMaxCaracteres && bl && EditMemo.this.componente.getSelectedText() == null) {
                        keyEvent.setKeyChar('\uffff');
                        keyEvent.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(EditMemo.this.componente);
                    }
                }
            });
        }
        ((PPGDTextArea)this.componente).setInformacao(this.getInformacao());
        this.setMaxCaracteres(((Alfa)informacao).getMaximoCaracteres());
        this.implementacaoPropertyChange(null);
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.sp;
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
    }

    @Override
    protected void readOnlyPropertyChange(boolean bl) {
        if (bl) {
            this.componente.setEditable(false);
        } else {
            this.componente.setEditable(true);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean bl) {
        this.componente.setEnabled(bl);
        this.labelCampo.setEnabled(bl);
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public void setMaxCaracteres(int n) {
        this.nrMaxCaracteres = n;
    }

    @Override
    public void setPerdeFocoComEnter(boolean bl) {
    }
}

