/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.util.UtilitariosString;

public abstract class DocumentoTXT {
    private Vector vectorDeclaracao = new Vector();
    private String fTipoArquivo;
    private boolean fAlterado = true;
    private boolean fBKP = true;
    private String fPath;

    public DocumentoTXT(String string, String string2) {
        this.fPath = string2;
        this.fTipoArquivo = string;
    }

    protected Vector lerLinhas(String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.vectorDeclaracao.size(); ++i) {
            String string2 = (String)this.arquivo().elementAt(i);
            if (!string.equals("Default") && string.trim().length() != 0 && !string.equals(string2.substring(0, string.length()))) continue;
            vector.add(string2);
        }
        return vector;
    }

    protected void incluirLinhas(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.arquivo().add(UtilitariosString.retiraCaracteresEspeciais((String)vector.elementAt(i)));
        }
        this.fAlterado = true;
    }

    protected abstract Vector transformarObjDaDeclaracaoEmRegistroTXT(Vector var1) throws GeracaoTxtException;

    protected abstract Vector transformarRegistroTXTEmObjDaDeclaracao(Vector var1, String var2, String var3) throws GeracaoTxtException;

    public Vector arquivo() {
        return this.vectorDeclaracao;
    }

    public void setTipoArquivo(String string) {
        this.fTipoArquivo = string;
    }

    public String getTipoArquivo() {
        return this.fTipoArquivo;
    }

    public Vector getRegistrosTxt(String string) throws GeracaoTxtException {
        Vector vector = this.lerLinhas(string);
        Vector vector2 = this.transformarRegistroTXTEmObjDaDeclaracao(vector, this.getTipoArquivo(), string);
        return vector2;
    }

    public void atualizarRegistros(int n, RegistroTxt registroTxt) throws GeracaoTxtException {
        this.arquivo().set(n, registroTxt.getLinha());
    }

    protected void antesDeAtualizarRegistros(String string, RegistroTxt registroTxt) {
    }

    public void setObjetosDaDeclaracao(Vector vector) throws GeracaoTxtException {
        Vector vector2 = this.transformarObjDaDeclaracaoEmRegistroTXT(vector);
    }

    public String getPath() {
        return this.fPath;
    }

    public void setAlterado() {
        this.fAlterado = true;
    }

    public void setUpper() {
        this.setAlterado();
        for (int i = 0; i < this.vectorDeclaracao.size(); ++i) {
            this.vectorDeclaracao.set(i, UtilitariosString.retiraCaracteresEspeciais((String)this.vectorDeclaracao.elementAt(i)));
        }
    }

    public void setBKPno() {
        this.fBKP = false;
    }

    public void salvar() throws IOException {
        char[] cArray = new char[]{'\r', '\n'};
        String string = new String(cArray);
        if (this.fAlterado) {
            try {
                Object object;
                File file = new File(this.fPath);
                if (file.exists()) {
                    object = new File(this.fPath.substring(0, this.fPath.lastIndexOf(".")) + ".BAK");
                    if (((File)object).exists()) {
                        ((File)object).delete();
                    }
                    if (!this.fBKP) {
                        file.delete();
                    } else if (!file.renameTo((File)object)) {
                        throw new IOException("Erro na c\u00f3pia do arquivo de gravacao.");
                    }
                }
                object = new BufferedWriter(new FileWriter(file));
                for (int i = 0; i < this.vectorDeclaracao.size(); ++i) {
                    ((Writer)object).write((String)this.vectorDeclaracao.elementAt(i) + string);
                }
                try {
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new IOException("Erro ao gravar arquivo - " + this.fPath);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new IOException("Erro ao gravar arquivo - " + this.fPath);
            }
        }
    }

    public void ler() throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fPath));
            boolean bl = false;
            while (!bl) {
                String string = bufferedReader.readLine();
                if (string != null) {
                    this.vectorDeclaracao.add(string);
                    continue;
                }
                bl = true;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IOException("Erro ao ler arquivo - " + this.fPath);
        }
    }

    public void clear() {
        this.vectorDeclaracao.clear();
    }

    public void setFicha(Vector vector) throws GeracaoTxtException {
        String string = "";
        boolean bl = false;
        Vector vector2 = this.transformarObjDaDeclaracaoEmRegistroTXT(vector);
        if (vector2.size() > 0) {
            this.incluirLinhas(vector2);
        }
    }
}

