/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private static String SEPARATOR = ",";
    private Locale locale = Locale.getDefault();
    private String bundleName;
    private ResourceBundle bundle;
    private ClassLoader cl = Localizer.class.getClassLoader();

    public static void setSeparator(String string) {
        SEPARATOR = string;
    }

    public String getString(String string) {
        if (!this.isUsable()) {
            return string;
        }
        String string2 = "";
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            String[] stringArray = string.split(SEPARATOR);
            if (2 <= stringArray.length) {
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + (i == 0 ? this.getString(stringArray[i]) : "," + this.getString(stringArray[i]));
                }
            } else {
                string2 = string;
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.locale = null;
            this.bundle = null;
            this.bundleName = null;
        } else if (this.locale != locale) {
            this.locale = locale;
            this.setResourceBundle(this.bundleName);
        }
    }

    public void setResourceBundle(String string) throws MissingResourceException {
        this.bundleName = string;
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.bundle = string != null ? ResourceBundle.getBundle(string, this.locale, this.cl) : null;
    }

    public boolean isUsable() {
        return this.locale != null && this.bundle != null;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    void setClassLoader(ClassLoader classLoader) {
        this.cl = classLoader;
    }
}

