/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.util.Arrays;
import java.util.Date;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.OHLCDataset;

public class DefaultHighLowDataset
extends AbstractXYDataset
implements OHLCDataset {
    private Comparable seriesKey;
    private Date[] date;
    private Number[] high;
    private Number[] low;
    private Number[] open;
    private Number[] close;
    private Number[] volume;

    public DefaultHighLowDataset(Comparable comparable, Date[] dateArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (dateArray == null) {
            throw new IllegalArgumentException("Null 'date' argument.");
        }
        this.seriesKey = comparable;
        this.date = dateArray;
        this.high = DefaultHighLowDataset.createNumberArray(dArray);
        this.low = DefaultHighLowDataset.createNumberArray(dArray2);
        this.open = DefaultHighLowDataset.createNumberArray(dArray3);
        this.close = DefaultHighLowDataset.createNumberArray(dArray4);
        this.volume = DefaultHighLowDataset.createNumberArray(dArray5);
    }

    @Override
    public Comparable getSeriesKey(int n) {
        return this.seriesKey;
    }

    @Override
    public Number getX(int n, int n2) {
        return new Long(this.date[n2].getTime());
    }

    public Date getXDate(int n, int n2) {
        return this.date[n2];
    }

    @Override
    public Number getY(int n, int n2) {
        return this.getClose(n, n2);
    }

    @Override
    public Number getHigh(int n, int n2) {
        return this.high[n2];
    }

    @Override
    public double getHighValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getHigh(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    @Override
    public Number getLow(int n, int n2) {
        return this.low[n2];
    }

    @Override
    public double getLowValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getLow(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    @Override
    public Number getOpen(int n, int n2) {
        return this.open[n2];
    }

    @Override
    public double getOpenValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getOpen(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    @Override
    public Number getClose(int n, int n2) {
        return this.close[n2];
    }

    @Override
    public double getCloseValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getClose(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    @Override
    public Number getVolume(int n, int n2) {
        return this.volume[n2];
    }

    @Override
    public double getVolumeValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getVolume(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public int getItemCount(int n) {
        return this.date.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultHighLowDataset)) {
            return false;
        }
        DefaultHighLowDataset defaultHighLowDataset = (DefaultHighLowDataset)object;
        if (!this.seriesKey.equals(defaultHighLowDataset.seriesKey)) {
            return false;
        }
        if (!Arrays.equals(this.date, defaultHighLowDataset.date)) {
            return false;
        }
        if (!Arrays.equals(this.open, defaultHighLowDataset.open)) {
            return false;
        }
        if (!Arrays.equals(this.high, defaultHighLowDataset.high)) {
            return false;
        }
        if (!Arrays.equals(this.low, defaultHighLowDataset.low)) {
            return false;
        }
        if (!Arrays.equals(this.close, defaultHighLowDataset.close)) {
            return false;
        }
        return Arrays.equals(this.volume, defaultHighLowDataset.volume);
    }

    public static Number[] createNumberArray(double[] dArray) {
        Number[] numberArray = new Number[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            numberArray[i] = new Double(dArray[i]);
        }
        return numberArray;
    }
}

