/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.HighLowItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 50390395841817121L;
    public static final int WIDTHMETHOD_AVERAGE = 0;
    public static final int WIDTHMETHOD_SMALLEST = 1;
    public static final int WIDTHMETHOD_INTERVALDATA = 2;
    private int autoWidthMethod = 0;
    private double autoWidthFactor = 0.6428571428571429;
    private double autoWidthGap = 0.0;
    private double candleWidth;
    private double maxCandleWidthInMilliseconds = 7.2E7;
    private double maxCandleWidth;
    private transient Paint upPaint;
    private transient Paint downPaint;
    private boolean drawVolume;
    private transient double maxVolume;
    private boolean useOutlinePaint;

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double d) {
        this(d, true, new HighLowItemLabelGenerator());
    }

    public CandlestickRenderer(double d, boolean bl, XYToolTipGenerator xYToolTipGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.candleWidth = d;
        this.drawVolume = bl;
        this.upPaint = Color.green;
        this.downPaint = Color.red;
        this.useOutlinePaint = false;
    }

    public double getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(double d) {
        if (d != this.candleWidth) {
            this.candleWidth = d;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public double getMaxCandleWidthInMilliseconds() {
        return this.maxCandleWidthInMilliseconds;
    }

    public void setMaxCandleWidthInMilliseconds(double d) {
        this.maxCandleWidthInMilliseconds = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public int getAutoWidthMethod() {
        return this.autoWidthMethod;
    }

    public void setAutoWidthMethod(int n) {
        if (this.autoWidthMethod != n) {
            this.autoWidthMethod = n;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public double getAutoWidthFactor() {
        return this.autoWidthFactor;
    }

    public void setAutoWidthFactor(double d) {
        if (this.autoWidthFactor != d) {
            this.autoWidthFactor = d;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public double getAutoWidthGap() {
        return this.autoWidthGap;
    }

    public void setAutoWidthGap(double d) {
        if (this.autoWidthGap != d) {
            this.autoWidthGap = d;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Paint getUpPaint() {
        return this.upPaint;
    }

    public void setUpPaint(Paint paint) {
        this.upPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getDownPaint() {
        return this.downPaint;
    }

    public void setDownPaint(Paint paint) {
        this.downPaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean drawVolume() {
        return this.drawVolume;
    }

    public boolean getDrawVolume() {
        return this.drawVolume;
    }

    public void setDrawVolume(boolean bl) {
        if (this.drawVolume != bl) {
            this.drawVolume = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl) {
        if (this.useOutlinePaint != bl) {
            this.useOutlinePaint = bl;
            this.fireChangeEvent();
        }
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        double d = valueAxis.getLowerBound();
        double d2 = d + this.maxCandleWidthInMilliseconds;
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        this.maxCandleWidth = Math.abs(d4 - d3);
        if (this.drawVolume) {
            OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
            this.maxVolume = 0.0;
            for (int i = 0; i < oHLCDataset.getSeriesCount(); ++i) {
                for (int j = 0; j < oHLCDataset.getItemCount(i); ++j) {
                    double d5 = oHLCDataset.getVolumeValue(i, j);
                    if (!(d5 > this.maxVolume)) continue;
                    this.maxVolume = d5;
                }
            }
        }
        return new XYItemRendererState(plotRenderingInfo);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            bl = true;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            bl = false;
        } else {
            return;
        }
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
        double d6 = oHLCDataset.getXValue(n, n2);
        double d7 = oHLCDataset.getHighValue(n, n2);
        double d8 = oHLCDataset.getLowValue(n, n2);
        double d9 = oHLCDataset.getOpenValue(n, n2);
        double d10 = oHLCDataset.getCloseValue(n, n2);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d11 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d12 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge2);
        double d13 = valueAxis2.valueToJava2D(d8, rectangle2D, rectangleEdge2);
        double d14 = valueAxis2.valueToJava2D(d9, rectangle2D, rectangleEdge2);
        double d15 = valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2);
        if (this.candleWidth > 0.0) {
            d5 = this.candleWidth;
            d4 = this.candleWidth;
        } else {
            double d16 = 0.0;
            switch (this.autoWidthMethod) {
                case 0: {
                    int n4 = oHLCDataset.getItemCount(n);
                    if (bl) {
                        d16 = rectangle2D.getHeight() / (double)n4;
                        break;
                    }
                    d16 = rectangle2D.getWidth() / (double)n4;
                    break;
                }
                case 1: {
                    int n4 = oHLCDataset.getItemCount(n);
                    d3 = -1.0;
                    d16 = rectangle2D.getWidth();
                    for (int i = 0; i < n4; ++i) {
                        d2 = valueAxis.valueToJava2D(oHLCDataset.getXValue(n, i), rectangle2D, rectangleEdge);
                        if (d3 != -1.0) {
                            d16 = Math.min(d16, Math.abs(d2 - d3));
                        }
                        d3 = d2;
                    }
                    break;
                }
                case 2: {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d2 = valueAxis.valueToJava2D(intervalXYDataset.getStartXValue(n, n2), rectangle2D, xYPlot.getDomainAxisEdge());
                    d = valueAxis.valueToJava2D(intervalXYDataset.getEndXValue(n, n2), rectangle2D, xYPlot.getDomainAxisEdge());
                    d16 = Math.abs(d - d2);
                }
            }
            d16 -= 2.0 * this.autoWidthGap;
            d16 *= this.autoWidthFactor;
            d16 = Math.min(d16, this.maxCandleWidth);
            d5 = Math.max(Math.min(1.0, this.maxCandleWidth), d16);
            d4 = Math.max(Math.min(3.0, this.maxCandleWidth), d16);
        }
        Paint paint = this.getItemPaint(n, n2);
        Paint paint2 = null;
        if (this.useOutlinePaint) {
            paint2 = this.getItemOutlinePaint(n, n2);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        if (this.drawVolume) {
            int n5 = (int)oHLCDataset.getVolumeValue(n, n2);
            double d17 = (double)n5 / this.maxVolume;
            if (bl) {
                d2 = rectangle2D.getMinX();
                d = rectangle2D.getMaxX();
            } else {
                d2 = rectangle2D.getMinY();
                d = rectangle2D.getMaxY();
            }
            double d18 = d17 * (d - d2);
            graphics2D.setPaint(Color.gray);
            object = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            if (bl) {
                graphics2D.fill(new Rectangle2D.Double(d2, d11 - d5 / 2.0, d18, d5));
            } else {
                graphics2D.fill(new Rectangle2D.Double(d11 - d5 / 2.0, d - d18, d5, d18));
            }
            graphics2D.setComposite((Composite)object);
        }
        if (this.useOutlinePaint) {
            graphics2D.setPaint(paint2);
        } else {
            graphics2D.setPaint(paint);
        }
        d3 = Math.max(d14, d15);
        double d19 = Math.min(d14, d15);
        double d20 = Math.max(d9, d10);
        double d21 = Math.min(d9, d10);
        if (d7 > d20) {
            if (bl) {
                graphics2D.draw(new Line2D.Double(d12, d11, d3, d11));
            } else {
                graphics2D.draw(new Line2D.Double(d11, d12, d11, d3));
            }
        }
        if (d8 < d21) {
            if (bl) {
                graphics2D.draw(new Line2D.Double(d13, d11, d19, d11));
            } else {
                graphics2D.draw(new Line2D.Double(d11, d13, d11, d19));
            }
        }
        Rectangle2D.Double double_ = null;
        double_ = bl ? new Rectangle2D.Double(d19, d11 - d4 / 2.0, d3 - d19, d4) : new Rectangle2D.Double(d11 - d4 / 2.0, d19, d4, d3 - d19);
        if (d10 > d9) {
            if (this.upPaint != null) {
                graphics2D.setPaint(this.upPaint);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
        } else {
            if (this.downPaint != null) {
                graphics2D.setPaint(this.downPaint);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
        }
        if (this.useOutlinePaint) {
            graphics2D.setPaint(paint2);
        } else {
            graphics2D.setPaint(paint);
        }
        graphics2D.draw(double_);
        if (entityCollection != null) {
            object = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                object = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            if (this.getURLGenerator() != null) {
                string = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, (String)object, string);
            entityCollection.add(xYItemEntity);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CandlestickRenderer)) {
            return false;
        }
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)object;
        if (this.candleWidth != candlestickRenderer.candleWidth) {
            return false;
        }
        if (!PaintUtilities.equal(this.upPaint, candlestickRenderer.upPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.downPaint, candlestickRenderer.downPaint)) {
            return false;
        }
        if (this.drawVolume != candlestickRenderer.drawVolume) {
            return false;
        }
        if (this.maxCandleWidthInMilliseconds != candlestickRenderer.maxCandleWidthInMilliseconds) {
            return false;
        }
        if (this.autoWidthMethod != candlestickRenderer.autoWidthMethod) {
            return false;
        }
        if (this.autoWidthFactor != candlestickRenderer.autoWidthFactor) {
            return false;
        }
        if (this.autoWidthGap != candlestickRenderer.autoWidthGap) {
            return false;
        }
        if (this.useOutlinePaint != candlestickRenderer.useOutlinePaint) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.upPaint, objectOutputStream);
        SerialUtilities.writePaint(this.downPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.upPaint = SerialUtilities.readPaint(objectInputStream);
        this.downPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

