/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.PublicCloneable;

public class StandardCategorySeriesLabelGenerator
implements CategorySeriesLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 4630760091523940820L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;

    public StandardCategorySeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public StandardCategorySeriesLabelGenerator(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.formatPattern = string;
    }

    @Override
    public String generateLabel(CategoryDataset categoryDataset, int n) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String string = MessageFormat.format(this.formatPattern, this.createItemArray(categoryDataset, n));
        return string;
    }

    protected Object[] createItemArray(CategoryDataset categoryDataset, int n) {
        Object[] objectArray = new Object[]{categoryDataset.getRowKey(n).toString()};
        return objectArray;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardCategorySeriesLabelGenerator)) {
            return false;
        }
        StandardCategorySeriesLabelGenerator standardCategorySeriesLabelGenerator = (StandardCategorySeriesLabelGenerator)object;
        return this.formatPattern.equals(standardCategorySeriesLabelGenerator.formatPattern);
    }
}

