/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.util.PublicCloneable;

public class BoxAndWhiskerToolTipGenerator
extends StandardCategoryToolTipGenerator
implements CategoryToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -6076837753823076334L;
    public static final String DEFAULT_TOOL_TIP_FORMAT = "X: {1} Mean: {2} Median: {3} Min: {4} Max: {5} Q1: {6} Q3: {7} ";

    public BoxAndWhiskerToolTipGenerator() {
        super(DEFAULT_TOOL_TIP_FORMAT, NumberFormat.getInstance());
    }

    public BoxAndWhiskerToolTipGenerator(String string, NumberFormat numberFormat) {
        super(string, numberFormat);
    }

    @Override
    protected Object[] createItemArray(CategoryDataset categoryDataset, int n, int n2) {
        Object[] objectArray = new Object[8];
        objectArray[0] = categoryDataset.getRowKey(n);
        Number number = categoryDataset.getValue(n, n2);
        NumberFormat numberFormat = this.getNumberFormat();
        objectArray[1] = numberFormat.format(number);
        if (categoryDataset instanceof BoxAndWhiskerCategoryDataset) {
            BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
            objectArray[2] = numberFormat.format(boxAndWhiskerCategoryDataset.getMeanValue(n, n2));
            objectArray[3] = numberFormat.format(boxAndWhiskerCategoryDataset.getMedianValue(n, n2));
            objectArray[4] = numberFormat.format(boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2));
            objectArray[5] = numberFormat.format(boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2));
            objectArray[6] = numberFormat.format(boxAndWhiskerCategoryDataset.getQ1Value(n, n2));
            objectArray[7] = numberFormat.format(boxAndWhiskerCategoryDataset.getQ3Value(n, n2));
        }
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BoxAndWhiskerToolTipGenerator) {
            return super.equals(object);
        }
        return false;
    }
}

