/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jfree.base.Library;
import org.jfree.util.ObjectUtilities;

public class BasicProjectInfo
extends Library {
    private String copyright;
    private List libraries = new ArrayList();
    private List optionalLibraries = new ArrayList();

    public BasicProjectInfo() {
    }

    public BasicProjectInfo(String string, String string2, String string3, String string4) {
        this();
        this.setName(string);
        this.setVersion(string2);
        this.setLicenceName(string3);
        this.setInfo(string4);
    }

    public BasicProjectInfo(String string, String string2, String string3, String string4, String string5) {
        this(string, string2, string5, string3);
        this.setCopyright(string4);
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String string) {
        this.copyright = string;
    }

    @Override
    public void setInfo(String string) {
        super.setInfo(string);
    }

    @Override
    public void setLicenceName(String string) {
        super.setLicenceName(string);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
    }

    @Override
    public void setVersion(String string) {
        super.setVersion(string);
    }

    public Library[] getLibraries() {
        return this.libraries.toArray(new Library[this.libraries.size()]);
    }

    public void addLibrary(Library library) {
        if (library == null) {
            throw new NullPointerException();
        }
        this.libraries.add(library);
    }

    public Library[] getOptionalLibraries() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (int i = 0; i < this.optionalLibraries.size(); ++i) {
            OptionalLibraryHolder optionalLibraryHolder = (OptionalLibraryHolder)this.optionalLibraries.get(i);
            Library library = optionalLibraryHolder.getLibrary();
            if (library == null) continue;
            arrayList.add(library);
        }
        return arrayList.toArray(new Library[arrayList.size()]);
    }

    public void addOptionalLibrary(String string) {
        if (string == null) {
            throw new NullPointerException("Library classname must be given.");
        }
        this.optionalLibraries.add(new OptionalLibraryHolder(string));
    }

    public void addOptionalLibrary(Library library) {
        if (library == null) {
            throw new NullPointerException("Library must be given.");
        }
        this.optionalLibraries.add(new OptionalLibraryHolder(library));
    }

    private static class OptionalLibraryHolder {
        private String libraryClass;
        private transient Library library;

        public OptionalLibraryHolder(String string) {
            if (string == null) {
                throw new NullPointerException("LibraryClass must not be null.");
            }
            this.libraryClass = string;
        }

        public OptionalLibraryHolder(Library library) {
            if (library == null) {
                throw new NullPointerException("Library must not be null.");
            }
            this.library = library;
            this.libraryClass = library.getClass().getName();
        }

        public String getLibraryClass() {
            return this.libraryClass;
        }

        public Library getLibrary() {
            if (this.library == null) {
                this.library = this.loadLibrary(this.libraryClass);
            }
            return this.library;
        }

        protected Library loadLibrary(String string) {
            if (string == null) {
                return null;
            }
            try {
                Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
                try {
                    Method method = clazz.getMethod("getInstance", null);
                    return (Library)method.invoke(null, (Object[])null);
                }
                catch (Exception exception) {
                    return (Library)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

