/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.jdesktop.layout.LayoutStyle;

class AquaLayoutStyle
extends LayoutStyle {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final int MINI = 0;
    private static final int SMALL = 1;
    private static final int REGULAR = 2;
    private static final Object[][] containerGapDefinitions = new Object[][]{{"TabbedPaneUI", new Insets(6, 10, 10, 10), new Insets(6, 10, 10, 12), new Insets(12, 20, 20, 20)}, {"RootPaneUI", new Insets(8, 10, 10, 10), new Insets(8, 10, 10, 12), new Insets(14, 20, 20, 20)}, {"default", new Insets(8, 10, 10, 10), new Insets(8, 10, 10, 12), new Insets(14, 20, 20, 20)}};
    private static final Object[][] relatedGapDefinitions = new Object[][]{{"ButtonUI", "ButtonUI.push", "ButtonUI.text", "ToggleButtonUI.push", "ToggleButtonUI.text", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"ButtonUI.metal", "ToggleButtonUI.metal", new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8), new Insets(12, 12, 12, 12)}, {"ButtonUI.bevel", "ButtonUI.toggle", "ButtonUI.square", "ToggleButtonUI", "ToggleButtonUI.bevel", "ToggleButtonUI.square", "ToggleButtonUI.toggle", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"ButtonUI.bevel.largeIcon", "ToggleButtonUI.bevel.largeIcon", new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8)}, {"ButtonUI.icon", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"ButtonUI.icon.largeIcon", new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8)}, {"ButtonUI.round", "ToggleButtonUI.round", new Insets(12, 12, 12, 12), new Insets(12, 12, 12, 12), new Insets(12, 12, 12, 12)}, {"ButtonUI.help", new Insets(12, 12, 12, 12), new Insets(12, 12, 12, 12), new Insets(12, 12, 12, 12)}, {"ButtonUI.toggleCenter", "ToggleButtonUI.toggleCenter", new Insets(8, 0, 8, 0), new Insets(10, 0, 10, 0), new Insets(12, 0, 12, 0)}, {"ButtonUI.toggleEast", "ToggleButtonUI.toggleEast", new Insets(8, 0, 8, 8), new Insets(10, 0, 10, 10), new Insets(12, 0, 12, 12)}, {"ButtonUI.toggleWest", "ToggleButtonUI.toggleWest", new Insets(8, 8, 8, 0), new Insets(10, 10, 10, 0), new Insets(12, 12, 12, 0)}, {"ButtonUI.toolBarTab", "ToggleButtonUI.toolBarTab", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"ButtonUI.colorWell", "ToggleButtonUI.colorWell", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"CheckBoxUI", new Insets(6, 5, 6, 5), new Insets(7, 6, 7, 6), new Insets(7, 6, 7, 6)}, {"ComboBoxUI", new Insets(8, 5, 8, 5), new Insets(10, 6, 10, 6), new Insets(12, 8, 12, 8)}, {"LabelUI", new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8), new Insets(8, 8, 8, 8)}, {"ListUI", new Insets(5, 5, 5, 5), new Insets(6, 6, 6, 6), new Insets(6, 6, 6, 6)}, {"PanelUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"ProgressBarUI", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"RadioButtonUI", new Insets(5, 5, 5, 5), new Insets(6, 6, 6, 6), new Insets(6, 6, 6, 6)}, {"ScrollPaneUI", new Insets(6, 8, 6, 8), new Insets(6, 8, 6, 8), new Insets(8, 10, 8, 10)}, {"SeparatorUI", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"SliderUI.horizontal", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"SliderUI.vertical", new Insets(8, 8, 8, 8), new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12)}, {"SpinnerUI", new Insets(6, 8, 6, 8), new Insets(6, 8, 6, 8), new Insets(8, 10, 8, 10)}, {"SplitPaneUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"TabbedPaneUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"TableUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"TextAreaUI", "EditorPaneUI", "TextPaneUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}, {"TextFieldUI", "FormattedTextFieldUI", "PasswordFieldUI", new Insets(6, 8, 6, 8), new Insets(6, 8, 6, 8), new Insets(8, 10, 8, 10)}, {"TreeUI", new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0), new Insets(0, 0, 0, 0)}};
    private static final Object[][] unrelatedGapDefinitions = new Object[][]{{"ButtonUI.help", new Insets(24, 24, 24, 24), new Insets(24, 24, 24, 24), new Insets(24, 24, 24, 24)}, {"default", new Insets(10, 10, 10, 10), new Insets(12, 12, 12, 12), new Insets(14, 14, 14, 14)}};
    private static final Object[][] indentGapDefinitions = new Object[][]{{"CheckBoxUI", "RadioButtonUI", new Insets(16, 24, 16, 24), new Insets(20, 24, 20, 24), new Insets(24, 24, 24, 24)}, {"default", new Insets(16, 16, 16, 16), new Insets(20, 20, 20, 20), new Insets(24, 24, 24, 24)}};
    private static final Object[][] visualMarginDefinitions = new Object[][]{{"ButtonUI", "ButtonUI.text", "ToggleButtonUI", "ToggleButtonUI.text", new Insets(5, 3, 3, 3)}, {"ButtonUI.icon", "ToggleButtonUI.icon", new Insets(5, 2, 3, 2)}, {"ButtonUI.toolbar", "ToggleButtonUI.toolbar", new Insets(0, 0, 0, 0)}, {"CheckBoxUI", new Insets(4, 4, 3, 3)}, {"ComboBoxUI", new Insets(2, 3, 4, 3)}, {"DesktopPaneUI", new Insets(0, 0, 0, 0)}, {"EditorPaneUI", "TextAreaUI", "TextPaneUI", new Insets(0, 0, 0, 0)}, {"FormattedTextFieldUI", "PasswordFieldUI", "TextFieldUI", new Insets(0, 0, 0, 0)}, {"LabelUI", new Insets(0, 0, 0, 0)}, {"ListUI", new Insets(0, 0, 0, 0)}, {"PanelUI", new Insets(0, 0, 0, 0)}, {"ProgressBarUI", "ProgressBarUI.horizontal", new Insets(0, 2, 4, 2)}, {"ProgressBarUI.vertical", new Insets(2, 0, 2, 4)}, {"RadioButtonUI", new Insets(4, 4, 3, 3)}, {"ScrollBarUI", new Insets(0, 0, 0, 0)}, {"ScrollPaneUI", new Insets(0, 0, 0, 0)}, {"SpinnerUI", new Insets(0, 0, 0, 0)}, {"SeparatorUI", new Insets(0, 0, 0, 0)}, {"SplitPaneUI", new Insets(0, 0, 0, 0)}, {"SliderUI", "SliderUI.horizontal", new Insets(3, 6, 3, 6)}, {"SliderUI.vertical", new Insets(6, 3, 6, 3)}, {"TabbedPaneUI", "TabbedPaneUI.top", new Insets(5, 7, 10, 7)}, {"TabbedPaneUI.bottom", new Insets(4, 7, 5, 7)}, {"TabbedPaneUI.left", new Insets(4, 6, 10, 7)}, {"TabbedPaneUI.right", new Insets(4, 7, 10, 6)}, {"TableUI", new Insets(0, 0, 0, 0)}, {"TreeUI", new Insets(0, 0, 0, 0)}, {"default", new Insets(0, 0, 0, 0)}};
    private static final Map RELATED_GAPS = AquaLayoutStyle.createInsetsMap(relatedGapDefinitions);
    private static final Map UNRELATED_GAPS = AquaLayoutStyle.createInsetsMap(unrelatedGapDefinitions);
    private static final Map CONTAINER_GAPS = AquaLayoutStyle.createInsetsMap(containerGapDefinitions);
    private static final Map INDENT_GAPS = AquaLayoutStyle.createInsetsMap(indentGapDefinitions);
    private static final Map VISUAL_MARGINS = AquaLayoutStyle.createInsetsMap(visualMarginDefinitions);

    private static Map createInsetsMap(Object[][] objectArray) {
        HashMap<String, ComponentInsets> hashMap = new HashMap<String, ComponentInsets>();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < objectArray[i].length && objectArray[i][n2] instanceof String; ++n2) {
            }
            Insets[] insetsArray = new Insets[objectArray[i].length - n2];
            for (n = n2; n < objectArray[i].length; ++n) {
                insetsArray[n - n2] = (Insets)objectArray[i][n];
            }
            for (n = 0; n < n2; ++n) {
                Object object;
                String string = (String)objectArray[i][n];
                int n3 = string.indexOf(46);
                if (n3 == -1) {
                    object = (ComponentInsets)hashMap.get(string);
                    if (object == null) {
                        object = new ComponentInsets(insetsArray);
                        hashMap.put(string, new ComponentInsets(insetsArray));
                        continue;
                    }
                    assert (((ComponentInsets)object).getInsets() == null);
                    ((ComponentInsets)object).setInsets(insetsArray);
                    continue;
                }
                object = string.substring(n3 + 1);
                String string2 = string.substring(0, n3);
                ComponentInsets componentInsets = (ComponentInsets)hashMap.get(string2);
                if (componentInsets == null) {
                    componentInsets = new ComponentInsets();
                    hashMap.put(string2, componentInsets);
                }
                componentInsets.addSubinsets((String)object, new ComponentInsets(insetsArray));
            }
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        JButton jButton = new JButton();
        jButton.putClientProperty("JButton.buttonType", "metal");
        JButton jButton2 = new JButton();
        AquaLayoutStyle aquaLayoutStyle = new AquaLayoutStyle();
        int n = ((LayoutStyle)aquaLayoutStyle).getPreferredGap(jButton, jButton2, 0, 3, null);
        System.err.println("gap= " + n);
        jButton.putClientProperty("JButton.buttonType", "square");
        jButton2.putClientProperty("JButton.buttonType", "square");
        n = ((LayoutStyle)aquaLayoutStyle).getPreferredGap(jButton, jButton2, 0, 3, null);
        System.err.println("gap= " + n);
    }

    @Override
    public int getPreferredGap(JComponent jComponent, JComponent jComponent2, int n, int n2, Container container) {
        int n3;
        super.getPreferredGap(jComponent, jComponent2, n, n2, container);
        if (n == 3) {
            int n4;
            if ((n2 == 3 || n2 == 7) && (n4 = this.getButtonChildIndent(jComponent, n2)) != 0) {
                return n4;
            }
            n4 = this.getSizeStyle(jComponent);
            Insets insets = this.getPreferredGap(jComponent, n, n4);
            switch (n2) {
                case 1: {
                    n3 = insets.bottom;
                    break;
                }
                case 5: {
                    n3 = insets.top;
                    break;
                }
                case 3: {
                    n3 = insets.left;
                    break;
                }
                default: {
                    n3 = insets.right;
                }
            }
            int n5 = n3;
            Insets insets2 = this.getVisualMargin(jComponent2);
            switch (n2) {
                case 1: {
                    n3 -= insets2.bottom;
                    break;
                }
                case 5: {
                    n3 -= insets2.top;
                    break;
                }
                case 3: {
                    n3 -= insets2.left;
                    break;
                }
                case 7: {
                    n3 -= insets2.right;
                }
            }
        } else {
            int n6 = Math.min(this.getSizeStyle(jComponent), this.getSizeStyle(jComponent2));
            Insets insets = this.getPreferredGap(jComponent, n, n6);
            Insets insets3 = this.getPreferredGap(jComponent2, n, n6);
            switch (n2) {
                case 1: {
                    n3 = Math.max(insets.top, insets3.bottom);
                    break;
                }
                case 5: {
                    n3 = Math.max(insets.bottom, insets3.top);
                    break;
                }
                case 3: {
                    n3 = Math.max(insets.right, insets3.left);
                    break;
                }
                default: {
                    n3 = Math.max(insets.left, insets3.right);
                }
            }
            Insets insets4 = this.getVisualMargin(jComponent);
            Insets insets5 = this.getVisualMargin(jComponent2);
            switch (n2) {
                case 1: {
                    n3 -= insets4.top + insets5.bottom;
                    break;
                }
                case 5: {
                    n3 -= insets4.bottom + insets5.top;
                    break;
                }
                case 3: {
                    n3 -= insets4.right + insets5.left;
                    break;
                }
                case 7: {
                    n3 -= insets4.left + insets5.right;
                }
            }
        }
        return Math.max(0, n3);
    }

    private Insets getPreferredGap(JComponent jComponent, int n, int n2) {
        Map map;
        switch (n) {
            case 3: {
                map = INDENT_GAPS;
                break;
            }
            case 0: {
                map = RELATED_GAPS;
                break;
            }
            default: {
                map = UNRELATED_GAPS;
            }
        }
        String string = jComponent.getUIClassID();
        String string2 = null;
        if (string == "ButtonUI" || string == "ToggleButtonUI") {
            string2 = (String)jComponent.getClientProperty("JButton.buttonType");
        } else if (string == "ProgressBarUI") {
            string2 = ((JProgressBar)jComponent).getOrientation() == 0 ? "horizontal" : "vertical";
        } else if (string == "SliderUI") {
            string2 = ((JSlider)jComponent).getOrientation() == 0 ? "horizontal" : "vertical";
        } else if (string == "TabbedPaneUI") {
            switch (((JTabbedPane)jComponent).getTabPlacement()) {
                case 1: {
                    string2 = "top";
                    break;
                }
                case 2: {
                    string2 = "left";
                    break;
                }
                case 3: {
                    string2 = "bottom";
                    break;
                }
                case 4: {
                    string2 = "right";
                }
            }
        }
        return this.getInsets(map, string, string2, n2);
    }

    @Override
    public int getContainerGap(JComponent jComponent, int n, Container container) {
        int n2;
        int n3 = Math.min(this.getSizeStyle(jComponent), this.getSizeStyle(container));
        Insets insets = this.getContainerGap(container, n3);
        switch (n) {
            case 1: {
                n2 = insets.top;
                break;
            }
            case 5: {
                n2 = insets.bottom;
                break;
            }
            case 3: {
                n2 = insets.right;
                break;
            }
            default: {
                n2 = insets.left;
            }
        }
        Insets insets2 = this.getVisualMargin(jComponent);
        switch (n) {
            case 1: {
                n2 -= insets2.top;
                break;
            }
            case 5: {
                n2 -= insets2.bottom;
                if (!(jComponent instanceof JRadioButton)) break;
                --n2;
                break;
            }
            case 3: {
                n2 -= insets2.left;
                break;
            }
            case 7: {
                n2 -= insets2.right;
            }
        }
        return Math.max(0, n2);
    }

    private Insets getContainerGap(Container container, int n) {
        String string = container instanceof JComponent ? ((JComponent)container).getUIClassID() : (container instanceof Dialog ? "Dialog" : (container instanceof Frame ? "Frame" : (container instanceof Applet ? "Applet" : (container instanceof Panel ? "Panel" : "default"))));
        return this.getInsets(CONTAINER_GAPS, string, null, n);
    }

    private Insets getInsets(Map map, String string, String string2, int n) {
        ComponentInsets componentInsets;
        ComponentInsets componentInsets2;
        if (string == null) {
            string = "default";
        }
        if ((componentInsets2 = (ComponentInsets)map.get(string)) == null) {
            componentInsets2 = (ComponentInsets)map.get("default");
            if (componentInsets2 == null) {
                return EMPTY_INSETS;
            }
        } else if (string2 != null && (componentInsets = componentInsets2.getSubinsets(string2)) != null) {
            componentInsets2 = componentInsets;
        }
        return componentInsets2.getInsets(n);
    }

    private Insets getVisualMargin(JComponent jComponent) {
        String string = jComponent.getUIClassID();
        String string2 = null;
        if (string == "ButtonUI" || string == "ToggleButtonUI") {
            string2 = (String)jComponent.getClientProperty("JButton.buttonType");
        } else if (string == "ProgressBarUI") {
            string2 = ((JProgressBar)jComponent).getOrientation() == 0 ? "horizontal" : "vertical";
        } else if (string == "SliderUI") {
            string2 = ((JSlider)jComponent).getOrientation() == 0 ? "horizontal" : "vertical";
        } else if (string == "TabbedPaneUI") {
            switch (((JTabbedPane)jComponent).getTabPlacement()) {
                case 1: {
                    string2 = "top";
                    break;
                }
                case 2: {
                    string2 = "left";
                    break;
                }
                case 3: {
                    string2 = "bottom";
                    break;
                }
                case 4: {
                    string2 = "right";
                }
            }
        }
        Insets insets = this.getInsets(VISUAL_MARGINS, string, string2, 0);
        if (string == "RadioButtonUI" || string == "CheckBoxUI") {
            switch (((AbstractButton)jComponent).getHorizontalTextPosition()) {
                case 4: {
                    insets = new Insets(insets.top, insets.right, insets.bottom, insets.left);
                    break;
                }
                case 0: {
                    insets = new Insets(insets.top, insets.right, insets.bottom, insets.right);
                }
            }
            if (jComponent.getBorder() instanceof EmptyBorder) {
                insets.left -= 2;
                insets.right -= 2;
                insets.top -= 2;
                insets.bottom -= 2;
            }
        }
        return insets;
    }

    private int getSizeStyle(Component component) {
        if (component == null) {
            return 2;
        }
        Font font = component.getFont();
        if (font == null) {
            return 2;
        }
        int n = font.getSize();
        return n >= 13 ? 2 : (n > 9 ? 1 : 0);
    }

    private static class ComponentInsets {
        private Map children;
        private Insets[] insets;

        public ComponentInsets() {
        }

        public ComponentInsets(Insets[] insetsArray) {
            this.insets = insetsArray;
        }

        public void setInsets(Insets[] insetsArray) {
            this.insets = insetsArray;
        }

        public Insets[] getInsets() {
            return this.insets;
        }

        public Insets getInsets(int n) {
            if (this.insets == null) {
                return EMPTY_INSETS;
            }
            return this.insets[n];
        }

        void addSubinsets(String string, ComponentInsets componentInsets) {
            if (this.children == null) {
                this.children = new HashMap(5);
            }
            this.children.put(string, componentInsets);
        }

        ComponentInsets getSubinsets(String string) {
            return this.children == null ? null : (ComponentInsets)this.children.get(string);
        }
    }
}

