/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class SimpleSet
implements Cloneable {
    public Object[] values;
    public int elementSize;
    public int threshold;

    public SimpleSet() {
        this(13);
    }

    public SimpleSet(int n) {
        if (n < 3) {
            n = 3;
        }
        this.elementSize = 0;
        this.threshold = n + 1;
        this.values = new Object[2 * n + 1];
    }

    public Object add(Object object) {
        Object object2;
        int n = this.values.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.values[n2]) != null) {
            if (object2.equals(object)) {
                this.values[n2] = object;
                return this.values[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.values[n2] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    public void asArray(Object[] objectArray) {
        if (this.elementSize != objectArray.length) {
            throw new IllegalArgumentException();
        }
        int n = this.elementSize;
        int n2 = this.values.length;
        for (int i = 0; i < n2 && n > 0; ++i) {
            if (this.values[i] == null) continue;
            objectArray[--n] = this.values[i];
        }
    }

    public void clear() {
        int n = this.values.length;
        while (--n >= 0) {
            this.values[n] = null;
        }
        this.elementSize = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleSet simpleSet = (SimpleSet)super.clone();
        simpleSet.elementSize = this.elementSize;
        simpleSet.threshold = this.threshold;
        int n = this.values.length;
        simpleSet.values = new Object[n];
        System.arraycopy(this.values, 0, simpleSet.values, 0, n);
        return simpleSet;
    }

    public boolean includes(Object object) {
        Object object2;
        int n = this.values.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.values[n2]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public Object remove(Object object) {
        Object object2;
        int n = this.values.length;
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % n;
        while ((object2 = this.values[n2]) != null) {
            if (object2.equals(object)) {
                --this.elementSize;
                Object object3 = this.values[n2];
                this.values[n2] = null;
                if (this.values[n2 + 1 == n ? 0 : n2 + 1] != null) {
                    this.rehash();
                }
                return object3;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void rehash() {
        SimpleSet simpleSet = new SimpleSet(this.elementSize * 2);
        int n = this.values.length;
        while (--n >= 0) {
            Object object = this.values[n];
            if (object == null) continue;
            simpleSet.add(object);
        }
        this.values = simpleSet.values;
        this.elementSize = simpleSet.elementSize;
        this.threshold = simpleSet.threshold;
    }

    public String toString() {
        String string = "";
        for (Object object : this.values) {
            if (object == null) continue;
            string = string + object.toString() + "\n";
        }
        return string;
    }
}

