/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredField;
import org.eclipse.jdt.internal.compiler.parser.RecoveredInitializer;
import org.eclipse.jdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredType
extends RecoveredStatement
implements TerminalTokens {
    public TypeDeclaration typeDeclaration;
    public RecoveredType[] memberTypes;
    public int memberTypeCount;
    public RecoveredField[] fields;
    public int fieldCount;
    public RecoveredMethod[] methods;
    public int methodCount;
    public boolean preserveContent = false;
    public int bodyEnd;
    public boolean insideEnumConstantPart = false;
    public TypeParameter[] pendingTypeParameters;
    public int pendingTypeParametersStart;

    public RecoveredType(TypeDeclaration typeDeclaration, RecoveredElement recoveredElement, int n) {
        super(typeDeclaration, recoveredElement, n);
        this.typeDeclaration = typeDeclaration;
        this.foundOpeningBrace = typeDeclaration.allocation != null && typeDeclaration.allocation.type == null ? true : !this.bodyStartsAtHeaderEnd();
        boolean bl = this.insideEnumConstantPart = TypeDeclaration.kind(typeDeclaration.modifiers) == 3;
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
        this.preserveContent = this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated;
    }

    @Override
    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n) {
        if (this.typeDeclaration.declarationSourceEnd != 0 && abstractMethodDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            this.pendingTypeParameters = null;
            return this.parent.add(abstractMethodDeclaration, n);
        }
        if (this.methods == null) {
            this.methods = new RecoveredMethod[5];
            this.methodCount = 0;
        } else if (this.methodCount == this.methods.length) {
            this.methods = new RecoveredMethod[2 * this.methodCount];
            System.arraycopy(this.methods, 0, this.methods, 0, this.methodCount);
        }
        RecoveredMethod recoveredMethod = new RecoveredMethod(abstractMethodDeclaration, this, n, this.recoveringParser);
        this.methods[this.methodCount++] = recoveredMethod;
        if (this.pendingTypeParameters != null) {
            recoveredMethod.attach(this.pendingTypeParameters, this.pendingTypeParametersStart);
            this.pendingTypeParameters = null;
        }
        this.insideEnumConstantPart = false;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (abstractMethodDeclaration.declarationSourceEnd == 0) {
            return recoveredMethod;
        }
        return this;
    }

    @Override
    public RecoveredElement add(Block block, int n) {
        this.pendingTypeParameters = null;
        int n2 = 0;
        if (this.parser().recoveredStaticInitializerStart != 0) {
            n2 = 8;
        }
        return this.add(new Initializer(block, n2), n);
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        RecoveredField recoveredField;
        this.pendingTypeParameters = null;
        if (this.typeDeclaration.declarationSourceEnd != 0 && fieldDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            return this.parent.add(fieldDeclaration, n);
        }
        if (this.fields == null) {
            this.fields = new RecoveredField[5];
            this.fieldCount = 0;
        } else if (this.fieldCount == this.fields.length) {
            this.fields = new RecoveredField[2 * this.fieldCount];
            System.arraycopy(this.fields, 0, this.fields, 0, this.fieldCount);
        }
        switch (fieldDeclaration.getKind()) {
            case 1: 
            case 3: {
                recoveredField = new RecoveredField(fieldDeclaration, this, n);
                break;
            }
            case 2: {
                recoveredField = new RecoveredInitializer(fieldDeclaration, this, n);
                break;
            }
            default: {
                return this;
            }
        }
        this.fields[this.fieldCount++] = recoveredField;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (fieldDeclaration.declarationSourceEnd == 0) {
            return recoveredField;
        }
        return this;
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        this.pendingTypeParameters = null;
        if (this.typeDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            return this.parent.add(typeDeclaration, n);
        }
        this.insideEnumConstantPart = false;
        if ((typeDeclaration.bits & 0x200) != 0) {
            if (this.methodCount > 0) {
                RecoveredMethod recoveredMethod = this.methods[this.methodCount - 1];
                recoveredMethod.methodDeclaration.bodyEnd = 0;
                recoveredMethod.methodDeclaration.declarationSourceEnd = 0;
                ++recoveredMethod.bracketBalance;
                return recoveredMethod.add(typeDeclaration, n);
            }
            return this;
        }
        if (this.memberTypes == null) {
            this.memberTypes = new RecoveredType[5];
            this.memberTypeCount = 0;
        } else if (this.memberTypeCount == this.memberTypes.length) {
            this.memberTypes = new RecoveredType[2 * this.memberTypeCount];
            System.arraycopy(this.memberTypes, 0, this.memberTypes, 0, this.memberTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.memberTypes[this.memberTypeCount++] = recoveredType;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (typeDeclaration.declarationSourceEnd == 0) {
            return recoveredType;
        }
        return this;
    }

    public void add(TypeParameter[] typeParameterArray, int n) {
        this.pendingTypeParameters = typeParameterArray;
        this.pendingTypeParametersStart = n;
    }

    public int bodyEnd() {
        if (this.bodyEnd == 0) {
            return this.typeDeclaration.declarationSourceEnd;
        }
        return this.bodyEnd;
    }

    public boolean bodyStartsAtHeaderEnd() {
        if (this.typeDeclaration.superInterfaces == null) {
            if (this.typeDeclaration.superclass == null) {
                if (this.typeDeclaration.typeParameters == null) {
                    return this.typeDeclaration.bodyStart == this.typeDeclaration.sourceEnd + 1;
                }
                return this.typeDeclaration.bodyStart == this.typeDeclaration.typeParameters[this.typeDeclaration.typeParameters.length - 1].sourceEnd + 1;
            }
            return this.typeDeclaration.bodyStart == this.typeDeclaration.superclass.sourceEnd + 1;
        }
        return this.typeDeclaration.bodyStart == this.typeDeclaration.superInterfaces[this.typeDeclaration.superInterfaces.length - 1].sourceEnd + 1;
    }

    @Override
    public RecoveredType enclosingType() {
        RecoveredElement recoveredElement = this.parent;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public char[] name() {
        return this.typeDeclaration.name;
    }

    @Override
    public ASTNode parseTree() {
        return this.typeDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.typeDeclaration.declarationSourceEnd;
    }

    @Override
    public String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered type:\n");
        if ((this.typeDeclaration.bits & 0x200) != 0) {
            stringBuffer.append(this.tabString(n));
            stringBuffer.append(" ");
        }
        this.typeDeclaration.print(n + 1, stringBuffer);
        if (this.memberTypes != null) {
            for (n2 = 0; n2 < this.memberTypeCount; ++n2) {
                stringBuffer.append("\n");
                stringBuffer.append(this.memberTypes[n2].toString(n + 1));
            }
        }
        if (this.fields != null) {
            for (n2 = 0; n2 < this.fieldCount; ++n2) {
                stringBuffer.append("\n");
                stringBuffer.append(this.fields[n2].toString(n + 1));
            }
        }
        if (this.methods != null) {
            for (n2 = 0; n2 < this.methodCount; ++n2) {
                stringBuffer.append("\n");
                stringBuffer.append(this.methods[n2].toString(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void updateBodyStart(int n) {
        this.foundOpeningBrace = true;
        this.typeDeclaration.bodyStart = n;
    }

    @Override
    public Statement updatedStatement() {
        if ((this.typeDeclaration.bits & 0x200) != 0 && !this.preserveContent) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.updatedTypeDeclaration();
        if ((typeDeclaration.bits & 0x200) != 0) {
            return typeDeclaration.allocation;
        }
        return typeDeclaration;
    }

    public TypeDeclaration updatedTypeDeclaration() {
        Object object;
        int n;
        AbstractMethodDeclaration[] abstractMethodDeclarationArray;
        int n2;
        Statement[] statementArray;
        int n3;
        int n4 = this.typeDeclaration.bodyStart;
        if (this.memberTypeCount > 0) {
            n3 = this.typeDeclaration.memberTypes == null ? 0 : this.typeDeclaration.memberTypes.length;
            statementArray = new TypeDeclaration[n3 + this.memberTypeCount];
            if (n3 > 0) {
                System.arraycopy(this.typeDeclaration.memberTypes, 0, statementArray, 0, n3);
            }
            if (this.memberTypes[this.memberTypeCount - 1].typeDeclaration.declarationSourceEnd == 0) {
                this.memberTypes[this.memberTypeCount - 1].typeDeclaration.declarationSourceEnd = n2 = this.bodyEnd();
                this.memberTypes[this.memberTypeCount - 1].typeDeclaration.bodyEnd = n2;
            }
            for (n2 = 0; n2 < this.memberTypeCount; ++n2) {
                statementArray[n3 + n2] = this.memberTypes[n2].updatedTypeDeclaration();
            }
            this.typeDeclaration.memberTypes = statementArray;
            if (((TypeDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd > n4) {
                n4 = ((TypeDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd;
            }
        }
        if (this.fieldCount > 0) {
            n3 = this.typeDeclaration.fields == null ? 0 : this.typeDeclaration.fields.length;
            statementArray = new FieldDeclaration[n3 + this.fieldCount];
            if (n3 > 0) {
                System.arraycopy(this.typeDeclaration.fields, 0, statementArray, 0, n3);
            }
            if (this.fields[this.fieldCount - 1].fieldDeclaration.declarationSourceEnd == 0) {
                this.fields[this.fieldCount - 1].fieldDeclaration.declarationSourceEnd = n2 = this.bodyEnd();
                this.fields[this.fieldCount - 1].fieldDeclaration.declarationEnd = n2;
            }
            for (n2 = 0; n2 < this.fieldCount; ++n2) {
                statementArray[n3 + n2] = this.fields[n2].updatedFieldDeclaration();
            }
            this.typeDeclaration.fields = statementArray;
            if (((FieldDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd > n4) {
                n4 = ((FieldDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd;
            }
        }
        n3 = this.typeDeclaration.methods == null ? 0 : this.typeDeclaration.methods.length;
        boolean bl = false;
        n2 = 0;
        boolean bl2 = false;
        int n5 = -1;
        if (this.methodCount > 0) {
            abstractMethodDeclarationArray = new AbstractMethodDeclaration[n3 + this.methodCount];
            for (n = 0; n < n3; ++n) {
                object = this.typeDeclaration.methods[n];
                if (((AbstractMethodDeclaration)object).isDefaultConstructor()) {
                    n5 = n;
                }
                if (((AbstractMethodDeclaration)object).isAbstract()) {
                    bl2 = true;
                }
                abstractMethodDeclarationArray[n] = object;
            }
            if (this.methods[this.methodCount - 1].methodDeclaration.declarationSourceEnd == 0) {
                this.methods[this.methodCount - 1].methodDeclaration.declarationSourceEnd = n = this.bodyEnd();
                this.methods[this.methodCount - 1].methodDeclaration.bodyEnd = n;
            }
            for (n = 0; n < this.methodCount; ++n) {
                object = this.methods[n].updatedMethodDeclaration();
                if (((AbstractMethodDeclaration)object).isConstructor()) {
                    n2 = 1;
                }
                if (((AbstractMethodDeclaration)object).isAbstract()) {
                    bl2 = true;
                }
                abstractMethodDeclarationArray[n3 + n] = object;
            }
            this.typeDeclaration.methods = abstractMethodDeclarationArray;
            if (abstractMethodDeclarationArray[abstractMethodDeclarationArray.length - 1].declarationSourceEnd > n4) {
                n4 = abstractMethodDeclarationArray[abstractMethodDeclarationArray.length - 1].declarationSourceEnd;
            }
            if (bl2) {
                this.typeDeclaration.bits |= 0x800;
            }
            bl = this.typeDeclaration.checkConstructors(this.parser());
        } else {
            for (int i = 0; i < n3; ++i) {
                if (!this.typeDeclaration.methods[i].isConstructor()) continue;
                bl = true;
            }
        }
        if (this.typeDeclaration.needClassInitMethod()) {
            boolean bl3 = false;
            for (n = 0; n < n3; ++n) {
                if (!this.typeDeclaration.methods[n].isClinit()) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.typeDeclaration.addClinit();
            }
        }
        if (n5 >= 0 && n2 != 0) {
            abstractMethodDeclarationArray = new AbstractMethodDeclaration[this.typeDeclaration.methods.length - 1];
            if (n5 != 0) {
                System.arraycopy(this.typeDeclaration.methods, 0, abstractMethodDeclarationArray, 0, n5);
            }
            if (n5 != this.typeDeclaration.methods.length - 1) {
                System.arraycopy(this.typeDeclaration.methods, n5 + 1, abstractMethodDeclarationArray, n5, this.typeDeclaration.methods.length - n5 - 1);
            }
            this.typeDeclaration.methods = abstractMethodDeclarationArray;
        } else {
            int n6 = TypeDeclaration.kind(this.typeDeclaration.modifiers);
            if (!bl && n6 != 2 && n6 != 4) {
                n = 0;
                object = this.parent;
                while (object != null) {
                    if (object instanceof RecoveredField) {
                        n = 1;
                        break;
                    }
                    object = ((RecoveredElement)object).parent;
                }
                this.typeDeclaration.createDefaultConstructor(!this.parser().diet || n != 0, true);
            }
        }
        if (this.parent instanceof RecoveredType) {
            this.typeDeclaration.bits |= 0x400;
        } else if (this.parent instanceof RecoveredMethod) {
            this.typeDeclaration.bits |= 0x100;
        }
        if (this.typeDeclaration.declarationSourceEnd == 0) {
            this.typeDeclaration.declarationSourceEnd = n4;
            this.typeDeclaration.bodyEnd = n4;
        }
        return this.typeDeclaration;
    }

    @Override
    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.typeDeclaration.allocation == null) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                boolean bl;
                int n = parser.astLengthStack[parser.astLengthPtr];
                int n2 = parser.astPtr - n;
                boolean bl2 = bl = n2 >= 0;
                if (bl) {
                    if (!(parser.astStack[n2] instanceof TypeDeclaration)) {
                        bl = false;
                    }
                    int n3 = n + 1;
                    for (int i = 1; i < n3; ++i) {
                        if (parser.astStack[n2 + i] instanceof TypeReference) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    parser.consumeClassHeaderImplements();
                }
            } else if (parser.listTypeParameterLength > 0) {
                boolean bl;
                int n = parser.genericsPtr;
                int n4 = parser.listTypeParameterLength;
                boolean bl3 = bl = n + 1 >= n4 && parser.astPtr > -1;
                if (bl) {
                    if (!(parser.astStack[parser.astPtr] instanceof TypeDeclaration)) {
                        bl = false;
                    }
                    while (n + 1 > n4 && !(parser.genericsStack[n] instanceof TypeParameter)) {
                        --n;
                    }
                    for (int i = 0; i < n4; ++i) {
                        if (parser.genericsStack[n - i] instanceof TypeParameter) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)parser.astStack[parser.astPtr];
                    typeDeclaration.typeParameters = new TypeParameter[n4];
                    System.arraycopy(parser.genericsStack, n - n4 + 1, typeDeclaration.typeParameters, 0, n4);
                    typeDeclaration.bodyStart = typeDeclaration.typeParameters[n4 - 1].declarationSourceEnd + 1;
                    parser.listTypeParameterLength = 0;
                    parser.lastCheckPoint = typeDeclaration.bodyStart;
                }
            }
        }
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n, n2);
            this.bodyEnd = n - 1;
            return this.parent;
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        TypeIds typeIds;
        if (this.bracketBalance == 0) {
            typeIds = this.parser();
            switch (typeIds.lastIgnoredToken) {
                case -1: 
                case 8: 
                case 11: 
                case 12: 
                case 99: 
                case 106: {
                    if (typeIds.recoveredStaticInitializerStart == 0) break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        if (this.bracketBalance == 1) {
            Initializer initializer;
            typeIds = new Block(0);
            Parser parser = this.parser();
            ((Block)typeIds).sourceStart = parser.scanner.startPosition;
            if (parser.recoveredStaticInitializerStart == 0) {
                initializer = new Initializer((Block)typeIds, 0);
            } else {
                initializer = new Initializer((Block)typeIds, 8);
                initializer.declarationSourceStart = parser.recoveredStaticInitializerStart;
            }
            initializer.bodyStart = parser.scanner.currentPosition;
            return this.add(initializer, 1);
        }
        return super.updateOnOpeningBrace(n, n2);
    }

    @Override
    public void updateParseTree() {
        this.updatedTypeDeclaration();
    }

    @Override
    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.typeDeclaration.declarationSourceEnd == 0) {
            this.bodyEnd = 0;
            this.typeDeclaration.declarationSourceEnd = n2;
            this.typeDeclaration.bodyEnd = n2;
        }
    }
}

