/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredInitializer;
import org.eclipse.jdt.internal.compiler.parser.RecoveredLocalVariable;
import org.eclipse.jdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredBlock
extends RecoveredStatement
implements TerminalTokens {
    public Block blockDeclaration;
    public RecoveredStatement[] statements;
    public int statementCount;
    public boolean preserveContent = false;
    public RecoveredLocalVariable pendingArgument;

    public RecoveredBlock(Block block, RecoveredElement recoveredElement, int n) {
        super(block, recoveredElement, n);
        this.blockDeclaration = block;
        this.foundOpeningBrace = true;
        this.preserveContent = this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated;
    }

    @Override
    public RecoveredElement add(Block block, int n) {
        if (this.blockDeclaration.sourceEnd != 0 && block.sourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(block, n);
        }
        RecoveredBlock recoveredBlock = new RecoveredBlock(block, (RecoveredElement)this, n);
        if (this.pendingArgument != null) {
            recoveredBlock.attach(this.pendingArgument);
            this.pendingArgument = null;
        }
        if (this.parser().statementRecoveryActivated) {
            this.addBlockStatement(recoveredBlock);
        }
        this.attach(recoveredBlock);
        if (block.sourceEnd == 0) {
            return recoveredBlock;
        }
        return this;
    }

    @Override
    public RecoveredElement add(LocalDeclaration localDeclaration, int n) {
        return this.add(localDeclaration, n, false);
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n, boolean bl) {
        if (this.blockDeclaration.sourceEnd != 0 && localDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            if (bl) {
                return this;
            }
            return this.parent.add(localDeclaration, n);
        }
        RecoveredLocalVariable recoveredLocalVariable = new RecoveredLocalVariable(localDeclaration, (RecoveredElement)this, n);
        if (localDeclaration instanceof Argument) {
            this.pendingArgument = recoveredLocalVariable;
            return this;
        }
        this.attach(recoveredLocalVariable);
        if (localDeclaration.declarationSourceEnd == 0) {
            return recoveredLocalVariable;
        }
        return this;
    }

    @Override
    public RecoveredElement add(Statement statement, int n) {
        return this.add(statement, n, false);
    }

    public RecoveredElement add(Statement statement, int n, boolean bl) {
        if (this.blockDeclaration.sourceEnd != 0 && statement.sourceStart > this.blockDeclaration.sourceEnd) {
            if (bl) {
                return this;
            }
            return this.parent.add(statement, n);
        }
        RecoveredStatement recoveredStatement = new RecoveredStatement(statement, this, n);
        this.attach(recoveredStatement);
        if (statement.sourceEnd == 0) {
            return recoveredStatement;
        }
        return this;
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        return this.add(typeDeclaration, n, false);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n, boolean bl) {
        if (this.blockDeclaration.sourceEnd != 0 && typeDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            if (bl) {
                return this;
            }
            return this.parent.add(typeDeclaration, n);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.attach(recoveredType);
        if (typeDeclaration.declarationSourceEnd == 0) {
            return recoveredType;
        }
        return this;
    }

    void attach(RecoveredStatement recoveredStatement) {
        if (this.statements == null) {
            this.statements = new RecoveredStatement[5];
            this.statementCount = 0;
        } else if (this.statementCount == this.statements.length) {
            this.statements = new RecoveredStatement[2 * this.statementCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.statementCount);
        }
        this.statements[this.statementCount++] = recoveredStatement;
    }

    @Override
    public ASTNode parseTree() {
        return this.blockDeclaration;
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered block:\n");
        this.blockDeclaration.print(n + 1, stringBuffer);
        if (this.statements != null) {
            for (int i = 0; i < this.statementCount; ++i) {
                stringBuffer.append("\n");
                stringBuffer.append(this.statements[i].toString(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public Block updatedBlock() {
        RecoveredStatement recoveredStatement;
        if (!this.preserveContent || this.statementCount == 0) {
            return null;
        }
        Statement[] statementArray = new Statement[this.statementCount];
        int n = 0;
        RecoveredStatement recoveredStatement2 = this.statements[this.statementCount - 1];
        RecoveredMethod recoveredMethod = this.enclosingMethod();
        RecoveredInitializer recoveredInitializer = this.enclosingInitializer();
        int n2 = 0;
        if (recoveredMethod != null) {
            n2 = recoveredMethod.methodDeclaration.bodyEnd;
            if (recoveredInitializer != null && recoveredMethod.methodDeclaration.sourceStart < recoveredInitializer.fieldDeclaration.sourceStart) {
                n2 = recoveredInitializer.fieldDeclaration.declarationSourceEnd;
            }
        } else {
            n2 = recoveredInitializer != null ? recoveredInitializer.fieldDeclaration.declarationSourceEnd : this.blockDeclaration.sourceEnd - 1;
        }
        if (recoveredStatement2 instanceof RecoveredLocalVariable) {
            recoveredStatement = (RecoveredLocalVariable)recoveredStatement2;
            if (recoveredStatement.localDeclaration.declarationSourceEnd == 0) {
                recoveredStatement.localDeclaration.declarationSourceEnd = n2;
                recoveredStatement.localDeclaration.declarationEnd = n2;
            }
        } else if (recoveredStatement2 instanceof RecoveredBlock) {
            recoveredStatement = (RecoveredBlock)recoveredStatement2;
            if (((RecoveredBlock)recoveredStatement).blockDeclaration.sourceEnd == 0) {
                ((RecoveredBlock)recoveredStatement).blockDeclaration.sourceEnd = n2;
            }
        } else if (!(recoveredStatement2 instanceof RecoveredType) && recoveredStatement2.statement.sourceEnd == 0) {
            recoveredStatement2.statement.sourceEnd = n2;
        }
        int n3 = this.blockDeclaration.sourceStart;
        for (int i = 0; i < this.statementCount; ++i) {
            Statement statement;
            Statement statement2 = this.statements[i].updatedStatement();
            if (statement2 == null) continue;
            statementArray[n++] = statement2;
            if (statement2 instanceof LocalDeclaration) {
                statement = (LocalDeclaration)statement2;
                if (statement.declarationSourceEnd <= n3) continue;
                n3 = statement.declarationSourceEnd;
                continue;
            }
            if (statement2 instanceof TypeDeclaration) {
                statement = (TypeDeclaration)statement2;
                if (((TypeDeclaration)statement).declarationSourceEnd <= n3) continue;
                n3 = ((TypeDeclaration)statement).declarationSourceEnd;
                continue;
            }
            if (statement2.sourceEnd <= n3) continue;
            n3 = statement2.sourceEnd;
        }
        if (n == 0) {
            return null;
        }
        if (n != this.statementCount) {
            this.blockDeclaration.statements = new Statement[n];
            System.arraycopy(statementArray, 0, this.blockDeclaration.statements, 0, n);
        } else {
            this.blockDeclaration.statements = statementArray;
        }
        if (this.blockDeclaration.sourceEnd == 0) {
            this.blockDeclaration.sourceEnd = n3 < n2 ? n2 : n3;
        }
        return this.blockDeclaration;
    }

    @Override
    public Statement updatedStatement() {
        return this.updatedBlock();
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n, n2);
            RecoveredMethod recoveredMethod = this.enclosingMethod();
            if (recoveredMethod != null && recoveredMethod.methodBody == this) {
                return this.parent.updateOnClosingBrace(n, n2);
            }
            RecoveredInitializer recoveredInitializer = this.enclosingInitializer();
            if (recoveredInitializer != null && recoveredInitializer.initializerBody == this) {
                return this.parent.updateOnClosingBrace(n, n2);
            }
            return this.parent;
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        Block block = new Block(0);
        block.sourceStart = this.parser().scanner.startPosition;
        return this.add(block, 1);
    }

    @Override
    public void updateParseTree() {
        this.updatedBlock();
    }

    public Statement updateStatement() {
        if (this.blockDeclaration.sourceEnd != 0 || this.statementCount == 0) {
            return null;
        }
        Statement[] statementArray = new Statement[this.statementCount];
        int n = 0;
        for (int i = 0; i < this.statementCount; ++i) {
            Statement statement = this.statements[i].updatedStatement();
            if (statement == null) continue;
            statementArray[n++] = statement;
        }
        if (n == 0) {
            return null;
        }
        if (n != this.statementCount) {
            this.blockDeclaration.statements = new Statement[n];
            System.arraycopy(statementArray, 0, this.blockDeclaration.statements, 0, n);
        } else {
            this.blockDeclaration.statements = statementArray;
        }
        return this.blockDeclaration;
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        char[][] cArray;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (cArray = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(cArray[0], TypeBinding.VOID.sourceName())) {
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, n);
        }
        if (this.blockDeclaration.sourceEnd != 0 && fieldDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(fieldDeclaration, n);
        }
        return this;
    }
}

