/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class TypeBinding
extends Binding {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;
    public static final BaseTypeBinding INT = new BaseTypeBinding(10, TypeConstants.INT, new char[]{'I'});
    public static final BaseTypeBinding BYTE = new BaseTypeBinding(3, TypeConstants.BYTE, new char[]{'B'});
    public static final BaseTypeBinding SHORT = new BaseTypeBinding(4, TypeConstants.SHORT, new char[]{'S'});
    public static final BaseTypeBinding CHAR = new BaseTypeBinding(2, TypeConstants.CHAR, new char[]{'C'});
    public static final BaseTypeBinding LONG = new BaseTypeBinding(7, TypeConstants.LONG, new char[]{'J'});
    public static final BaseTypeBinding FLOAT = new BaseTypeBinding(9, TypeConstants.FLOAT, new char[]{'F'});
    public static final BaseTypeBinding DOUBLE = new BaseTypeBinding(8, TypeConstants.DOUBLE, new char[]{'D'});
    public static final BaseTypeBinding BOOLEAN = new BaseTypeBinding(5, TypeConstants.BOOLEAN, new char[]{'Z'});
    public static final BaseTypeBinding NULL = new BaseTypeBinding(12, TypeConstants.NULL, new char[]{'N'});
    public static final BaseTypeBinding VOID = new BaseTypeBinding(6, TypeConstants.VOID, new char[]{'V'});

    public static final TypeBinding wellKnownType(Scope scope, int n) {
        switch (n) {
            case 5: {
                return BOOLEAN;
            }
            case 3: {
                return BYTE;
            }
            case 2: {
                return CHAR;
            }
            case 4: {
                return SHORT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return FLOAT;
            }
            case 10: {
                return INT;
            }
            case 7: {
                return LONG;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public TypeBinding capture(Scope scope, int n) {
        return this;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, Map map, int n) {
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public TypeBinding erasure() {
        return this;
    }

    public TypeBinding findSuperTypeWithSameErasure(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return this;
        }
        if (typeBinding == null) {
            return null;
        }
        switch (this.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)this;
                int n = typeBinding.dimensions();
                if (arrayBinding.dimensions != n) {
                    switch (typeBinding.id) {
                        case 1: 
                        case 36: 
                        case 37: {
                            return typeBinding;
                        }
                    }
                    if (n < arrayBinding.dimensions & typeBinding.leafComponentType().id == 1) {
                        return typeBinding;
                    }
                    return null;
                }
                if (!(arrayBinding.leafComponentType instanceof ReferenceBinding)) {
                    return null;
                }
                TypeBinding typeBinding2 = arrayBinding.leafComponentType.findSuperTypeWithSameErasure(typeBinding.leafComponentType());
                if (typeBinding2 == null) {
                    return null;
                }
                return arrayBinding.environment().createArrayType(typeBinding2, arrayBinding.dimensions);
            }
            case 4100: {
                ReferenceBinding[] referenceBindingArray;
                ReferenceBinding referenceBinding;
                if (this.isCapture()) {
                    TypeBinding typeBinding3;
                    referenceBinding = (CaptureBinding)this;
                    referenceBindingArray = ((CaptureBinding)referenceBinding).firstBound;
                    if (referenceBindingArray instanceof ArrayBinding && (typeBinding3 = referenceBindingArray.findSuperTypeWithSameErasure(typeBinding)) != null) {
                        return typeBinding3;
                    }
                }
            }
            case 4: 
            case 260: 
            case 516: 
            case 1028: 
            case 2052: {
                int n;
                if (!typeBinding.isTypeVariable() && !typeBinding.isIntersectionType()) {
                    typeBinding = typeBinding.erasure();
                }
                if (this == typeBinding || !this.isTypeVariable() && !this.isIntersectionType() && this.erasure() == typeBinding) {
                    return this;
                }
                ReferenceBinding referenceBinding = (ReferenceBinding)this;
                if (!typeBinding.isInterface()) {
                    while ((referenceBinding = referenceBinding.superclass()) != null) {
                        if (referenceBinding != typeBinding && (referenceBinding.isTypeVariable() || referenceBinding.isIntersectionType() || referenceBinding.erasure() != typeBinding)) continue;
                        return referenceBinding;
                    }
                    return null;
                }
                ReferenceBinding[] referenceBindingArray = null;
                int n2 = 0;
                do {
                    ReferenceBinding[] referenceBindingArray2;
                    if ((referenceBindingArray2 = referenceBinding.superInterfaces()) == Binding.NO_SUPERINTERFACES) continue;
                    if (referenceBindingArray == null) {
                        referenceBindingArray = referenceBindingArray2;
                        n2 = referenceBindingArray.length;
                        continue;
                    }
                    int n3 = referenceBindingArray2.length;
                    if (n2 + n3 >= referenceBindingArray.length) {
                        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                        System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
                    }
                    block10: for (n = 0; n < n3; ++n) {
                        ReferenceBinding referenceBinding2 = referenceBindingArray2[n];
                        for (int i = 0; i < n2; ++i) {
                            if (referenceBinding2 == referenceBindingArray[i]) continue block10;
                        }
                        referenceBindingArray[n2++] = referenceBinding2;
                    }
                } while ((referenceBinding = referenceBinding.superclass()) != null);
                for (int i = 0; i < n2; ++i) {
                    referenceBinding = referenceBindingArray[i];
                    if (referenceBinding == typeBinding || !referenceBinding.isTypeVariable() && !referenceBinding.isIntersectionType() && referenceBinding.erasure() == typeBinding) {
                        return referenceBinding;
                    }
                    ReferenceBinding[] referenceBindingArray4 = referenceBinding.superInterfaces();
                    if (referenceBindingArray4 == Binding.NO_SUPERINTERFACES) continue;
                    n = referenceBindingArray4.length;
                    if (n2 + n >= referenceBindingArray.length) {
                        ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                        System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
                    }
                    block13: for (int j = 0; j < n; ++j) {
                        ReferenceBinding referenceBinding3 = referenceBindingArray4[j];
                        for (int k = 0; k < n2; ++k) {
                            if (referenceBinding3 == referenceBindingArray[k]) continue block13;
                        }
                        referenceBindingArray[n2++] = referenceBinding3;
                    }
                }
                break;
            }
        }
        return null;
    }

    public TypeBinding genericCast(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return null;
        }
        TypeBinding typeBinding2 = typeBinding.erasure();
        if (typeBinding2 == this.erasure()) {
            return null;
        }
        return typeBinding2;
    }

    public char[] genericTypeSignature() {
        return this.signature();
    }

    public abstract PackageBinding getPackage();

    public boolean isAnnotationType() {
        return false;
    }

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEnum() {
        return false;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        if (typeBinding.isWildcard()) {
            return ((WildcardBinding)typeBinding).boundCheck(this);
        }
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x20000L) != 0L;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isIntersectingWith(TypeBinding typeBinding) {
        return this == typeBinding;
    }

    public boolean isIntersectionType() {
        return false;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isParameterizedWithOwnVariables() {
        if (this.kind() != 260) {
            return false;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
        if (parameterizedTypeBinding.arguments == null) {
            return false;
        }
        TypeVariableBinding[] typeVariableBindingArray = this.erasure().typeVariables();
        int n = typeVariableBindingArray.length;
        for (int i = 0; i < n; ++i) {
            if (typeVariableBindingArray[i] == parameterizedTypeBinding.arguments[i]) continue;
            return false;
        }
        ReferenceBinding referenceBinding = parameterizedTypeBinding.enclosingType();
        return referenceBinding == null || !referenceBinding.erasure().isGenericType() || referenceBinding.isParameterizedWithOwnVariables();
    }

    public boolean isProvablyDistinctFrom(TypeBinding typeBinding, int n) {
        if (this == typeBinding) {
            return false;
        }
        if (n > 1) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
        }
        switch (this.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
            case 260: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
                if (parameterizedTypeBinding.type.isProvablyDistinctFrom(typeBinding.erasure(), n)) {
                    return true;
                }
                switch (typeBinding.kind()) {
                    case 1028: 
                    case 2052: {
                        return false;
                    }
                    case 260: {
                        TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
                        if (typeBindingArray == null) {
                            return false;
                        }
                        ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding;
                        TypeBinding[] typeBindingArray2 = parameterizedTypeBinding2.arguments;
                        if (typeBindingArray2 == null) {
                            return false;
                        }
                        int n2 = typeBindingArray.length;
                        for (int i = 0; i < n2; ++i) {
                            if (!typeBindingArray[i].isProvablyDistinctFrom(typeBindingArray2[i], n + 1)) continue;
                            return true;
                        }
                        return false;
                    }
                }
                break;
            }
            case 1028: {
                if (n > 0) {
                    return true;
                }
                return this.erasure().isProvablyDistinctFrom(typeBinding.erasure(), 0);
            }
            case 2052: {
                if (n > 0) {
                    return true;
                }
                return this != typeBinding.erasure();
            }
        }
        return this != typeBinding;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isReifiable() {
        TypeBinding typeBinding = this.leafComponentType();
        if (!(typeBinding instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            switch (referenceBinding.kind()) {
                case 516: 
                case 2052: 
                case 4100: {
                    return false;
                }
                case 260: {
                    if (!referenceBinding.isBoundParameterizedType()) break;
                    return false;
                }
                case 1028: {
                    return true;
                }
            }
            if (referenceBinding.isStatic()) {
                return true;
            }
            if (!referenceBinding.isLocalType()) continue;
            NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)referenceBinding.erasure();
            if (!nestedTypeBinding.scope.methodScope().isStatic) continue;
            return true;
        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isTypeArgumentContainedBy(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: {
                TypeBinding typeBinding2;
                WildcardBinding wildcardBinding;
                TypeBinding typeBinding3 = this;
                TypeBinding typeBinding4 = this;
                switch (this.kind()) {
                    case 516: {
                        wildcardBinding = (WildcardBinding)this;
                        switch (wildcardBinding.boundKind) {
                            case 1: {
                                if (wildcardBinding.otherBounds != null) break;
                                typeBinding4 = wildcardBinding.bound;
                                typeBinding3 = null;
                                break;
                            }
                            case 2: {
                                typeBinding4 = wildcardBinding;
                                typeBinding3 = wildcardBinding.bound;
                                break;
                            }
                            case 0: {
                                typeBinding4 = wildcardBinding;
                                typeBinding3 = null;
                            }
                        }
                        break;
                    }
                    case 4100: {
                        if (!this.isCapture()) break;
                        typeBinding2 = (CaptureBinding)this;
                        if (((CaptureBinding)typeBinding2).lowerBound == null) break;
                        typeBinding3 = ((CaptureBinding)typeBinding2).lowerBound;
                        break;
                    }
                }
                wildcardBinding = (WildcardBinding)typeBinding;
                if (wildcardBinding.otherBounds != null) {
                    return false;
                }
                typeBinding2 = wildcardBinding.bound;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        if (typeBinding2 == this) {
                            return true;
                        }
                        if (typeBinding4 == null) {
                            return false;
                        }
                        TypeBinding typeBinding5 = typeBinding4.findSuperTypeWithSameErasure(typeBinding2);
                        if (typeBinding5 == null) return typeBinding4.isCompatibleWith(typeBinding2);
                        if (!(typeBinding5 = typeBinding5.leafComponentType()).isRawType()) return typeBinding4.isCompatibleWith(typeBinding2);
                        if (typeBinding5 != typeBinding2.leafComponentType()) return false;
                        return true;
                    }
                    case 2: {
                        if (typeBinding2 == this) {
                            return true;
                        }
                        if (typeBinding3 == null) {
                            return false;
                        }
                        TypeBinding typeBinding6 = typeBinding2.findSuperTypeWithSameErasure(typeBinding3);
                        if (typeBinding6 == null) return typeBinding2.isCompatibleWith(typeBinding3);
                        if (!(typeBinding6 = typeBinding6.leafComponentType()).isRawType()) return typeBinding2.isCompatibleWith(typeBinding3);
                        if (typeBinding6 != typeBinding3.leafComponentType()) return false;
                        return true;
                    }
                }
                return true;
            }
            case 260: {
                int n;
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                if (!this.isParameterizedType()) {
                    return false;
                }
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
                ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding;
                if (parameterizedTypeBinding.type != parameterizedTypeBinding2.type) {
                    return false;
                }
                if (!parameterizedTypeBinding.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding2.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding != typeBindingArray : !referenceBinding.isEquivalentTo(parameterizedTypeBinding2.enclosingType())) {
                        return false;
                    }
                }
                int n2 = parameterizedTypeBinding.arguments == null ? 0 : parameterizedTypeBinding.arguments.length;
                typeBindingArray = parameterizedTypeBinding2.arguments;
                int n3 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
                if (n != n2) {
                    return false;
                }
                int n4 = 0;
                while (n4 < n2) {
                    TypeBinding typeBinding7 = parameterizedTypeBinding.arguments[n4];
                    TypeBinding typeBinding8 = typeBindingArray[n4];
                    if (typeBinding7 != typeBinding8) {
                        int n5 = typeBinding7.kind();
                        if (typeBinding8.kind() != n5) {
                            return false;
                        }
                        block17 : switch (n5) {
                            case 260: {
                                if (!typeBinding7.isTypeArgumentContainedBy(typeBinding8)) return false;
                                break;
                            }
                            case 516: {
                                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding7;
                                WildcardBinding wildcardBinding2 = (WildcardBinding)typeBinding8;
                                switch (wildcardBinding.boundKind) {
                                    case 1: {
                                        if (wildcardBinding2.boundKind != 0) return false;
                                        if (wildcardBinding.bound != wildcardBinding.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 0: {
                                        if (wildcardBinding2.boundKind != 1) return false;
                                        if (wildcardBinding2.bound != wildcardBinding2.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                }
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    ++n4;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeArgumentIntersecting(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (this.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                switch (typeBinding.kind()) {
                    case 4100: {
                        return true;
                    }
                    case 516: {
                        TypeBinding typeBinding2 = null;
                        TypeBinding typeBinding3 = null;
                        WildcardBinding wildcardBinding = (WildcardBinding)this;
                        switch (wildcardBinding.boundKind) {
                            case 1: {
                                typeBinding3 = wildcardBinding.bound;
                                break;
                            }
                            case 2: {
                                typeBinding2 = wildcardBinding.bound;
                                break;
                            }
                        }
                        TypeBinding typeBinding4 = null;
                        TypeBinding typeBinding5 = null;
                        WildcardBinding wildcardBinding2 = (WildcardBinding)typeBinding;
                        switch (wildcardBinding2.boundKind) {
                            case 1: {
                                typeBinding5 = wildcardBinding2.bound;
                                break;
                            }
                            case 2: {
                                typeBinding4 = wildcardBinding2.bound;
                                break;
                            }
                        }
                        if (typeBinding2 != null) {
                            if (typeBinding4 != null) {
                                return true;
                            }
                            if (typeBinding5 != null) {
                                return typeBinding2.isCompatibleWith(typeBinding5);
                            }
                            return true;
                        }
                        if (typeBinding3 != null) {
                            if (typeBinding3.isTypeVariable()) {
                                return true;
                            }
                            if (typeBinding4 != null) {
                                return typeBinding4.isCompatibleWith(typeBinding3);
                            }
                            if (typeBinding5 != null) {
                                if (typeBinding3.isInterface()) {
                                    if (typeBinding5.isInterface()) {
                                        return true;
                                    }
                                    if (typeBinding5.isArrayType() || typeBinding5 instanceof ReferenceBinding && ((ReferenceBinding)typeBinding5).isFinal()) {
                                        return typeBinding5.isCompatibleWith(typeBinding3);
                                    }
                                    return true;
                                }
                                if (typeBinding5.isInterface()) {
                                    if (typeBinding3.isArrayType() || typeBinding3 instanceof ReferenceBinding && ((ReferenceBinding)typeBinding3).isFinal()) {
                                        return typeBinding3.isCompatibleWith(typeBinding5);
                                    }
                                } else {
                                    return typeBinding3.isCompatibleWith(typeBinding5);
                                }
                                return true;
                            }
                            return true;
                        }
                        return true;
                    }
                }
                WildcardBinding wildcardBinding = (WildcardBinding)this;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        return typeBinding.isCompatibleWith(wildcardBinding.bound);
                    }
                    case 2: {
                        return wildcardBinding.bound.isCompatibleWith(typeBinding);
                    }
                }
                return true;
            }
        }
        switch (typeBinding.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        return this.isCompatibleWith(wildcardBinding.bound);
                    }
                    case 2: {
                        return wildcardBinding.bound.isCompatibleWith(this);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUnboundWildcard() {
        return false;
    }

    public boolean isUncheckedException(boolean bl) {
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    @Override
    public int kind() {
        return 4;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public boolean needsUncheckedConversion(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return false;
        }
        if (!((typeBinding = typeBinding.leafComponentType()) instanceof ReferenceBinding)) {
            return false;
        }
        TypeBinding typeBinding2 = this.leafComponentType();
        TypeBinding typeBinding3 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
        if (!(typeBinding3 instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding3;
        while (referenceBinding.isRawType()) {
            if (typeBinding.isBoundParameterizedType()) {
                return true;
            }
            if (!referenceBinding.isStatic() && (referenceBinding = referenceBinding.enclosingType()) != null && (typeBinding = typeBinding.enclosingType()) != null) continue;
            break;
        }
        return false;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
    }

    public TypeVariableBinding[] typeVariables() {
        return Binding.NO_TYPE_VARIABLES;
    }
}

