/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class RawTypeBinding
extends ParameterizedTypeBinding {
    public RawTypeBinding(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
        super(referenceBinding, null, referenceBinding2, lookupEnvironment);
        if (referenceBinding2 == null || (referenceBinding2.modifiers & 0x40000000) == 0) {
            this.modifiers &= 0xBFFFFFFF;
        }
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
            char[] cArray = this.enclosingType().computeUniqueKey(false);
            for (int i = 0; i < cArray.length - 1; ++i) {
                stringBuffer.append(cArray[i]);
            }
            stringBuffer.append('.').append(this.sourceName()).append('<').append('>').append(';');
        } else {
            stringBuffer.append(this.type.computeUniqueKey(false));
            stringBuffer.insert(stringBuffer.length() - 1, "<>");
        }
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding methodBinding) {
        if (methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES || methodBinding.isStatic()) {
            return super.createParameterizedMethod(methodBinding);
        }
        return this.environment.createParameterizedGenericMethod(methodBinding, this);
    }

    @Override
    public int kind() {
        return 1028;
    }

    @Override
    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.type.sourceName()).append("#RAW");
        return stringBuffer.toString();
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
                int n;
                char[] cArray = this.enclosingType().genericTypeSignature();
                for (n = 0; n < cArray.length - 1; ++n) {
                    stringBuffer.append(cArray[n]);
                }
                stringBuffer.append('.').append(this.sourceName()).append(';');
                n = stringBuffer.length();
                this.genericTypeSignature = new char[n];
                stringBuffer.getChars(0, n, this.genericTypeSignature, 0);
            } else {
                this.genericTypeSignature = this.type.signature();
            }
        }
        return this.genericTypeSignature;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: 
            case 1028: 
            case 2052: {
                return this.erasure() == typeBinding.erasure();
            }
        }
        return false;
    }

    @Override
    public boolean isIntersectingWith(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 260: 
            case 1028: 
            case 2052: {
                return this.erasure() == typeBinding.erasure();
            }
        }
        return false;
    }

    @Override
    public boolean isParameterizedType() {
        return false;
    }

    @Override
    public boolean isRawType() {
        return true;
    }

    @Override
    protected void initializeArguments() {
        TypeVariableBinding[] typeVariableBindingArray = this.type.typeVariables();
        int n = typeVariableBindingArray.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            typeBindingArray[i] = this.environment.convertToRawType(typeVariableBindingArray[i].erasure());
        }
        this.arguments = typeBindingArray;
    }

    @Override
    public char[] readableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.type.compoundName, '.');
        return cArray;
    }

    @Override
    public char[] shortReadableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.type.sourceName;
        return cArray;
    }
}

