/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.CompoundNameVector;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleNameVector;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public HashtableOfObject typeOrPackageCache;
    public SourceTypeBinding[] topLevelTypes;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private ObjectVector referencedTypes;
    private ObjectVector referencedSuperTypes;
    HashtableOfType constantPoolNameUsage;

    public CompilationUnitScope(CompilationUnitDeclaration compilationUnitDeclaration, LookupEnvironment lookupEnvironment) {
        super(4, null);
        this.environment = lookupEnvironment;
        this.referenceContext = compilationUnitDeclaration;
        compilationUnitDeclaration.scope = this;
        char[][] cArray = this.currentPackageName = compilationUnitDeclaration.currentPackage == null ? CharOperation.NO_CHAR_CHAR : compilationUnitDeclaration.currentPackage.tokens;
        if (this.compilerOptions().produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.referencedTypes = new ObjectVector();
            this.referencedSuperTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.referencedTypes = null;
            this.referencedSuperTypes = null;
        }
    }

    void buildFieldsAndMethods() {
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            this.topLevelTypes[i].scope.buildFieldsAndMethods();
        }
    }

    void buildTypeBindings(AccessRestriction accessRestriction) {
        Object object;
        this.topLevelTypes = new SourceTypeBinding[0];
        boolean bl = false;
        if (this.referenceContext.compilationResult.compilationUnit != null && (object = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !CharOperation.equals(this.currentPackageName, object)) {
            if (this.referenceContext.currentPackage != null || this.referenceContext.types != null || this.referenceContext.imports != null) {
                this.problemReporter().packageIsNotExpectedPackage(this.referenceContext);
            }
            char[][] cArray = this.currentPackageName = ((char[][])object).length == 0 ? CharOperation.NO_CHAR_CHAR : object;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
            if (this.fPackage == null) {
                this.problemReporter().mustSpecifyPackage(this.referenceContext);
                return;
            }
        } else {
            this.fPackage = this.environment.createPackage(this.currentPackageName);
            if (this.fPackage == null) {
                this.problemReporter().packageCollidesWithType(this.referenceContext);
                return;
            }
            if (this.referenceContext.isPackageInfo() && this.referenceContext.currentPackage.annotations != null && (this.referenceContext.types == null || this.referenceContext.types.length == 0)) {
                this.referenceContext.types = new TypeDeclaration[1];
                object = new TypeDeclaration(this.referenceContext.compilationResult);
                this.referenceContext.types[0] = object;
                object.name = TypeConstants.PACKAGE_INFO_NAME;
                object.modifiers = 512;
                bl = true;
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        int n = (object = (Object)this.referenceContext.types) == null ? 0 : ((char[][])object).length;
        this.topLevelTypes = new SourceTypeBinding[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object2;
            char[] cArray = object[i];
            ReferenceBinding referenceBinding = this.fPackage.getType0(cArray.name);
            this.recordSimpleReference(cArray.name);
            if (referenceBinding != null && referenceBinding.isValidBinding() && !(referenceBinding instanceof UnresolvedReferenceBinding)) {
                this.problemReporter().duplicateTypes(this.referenceContext, (TypeDeclaration)cArray);
                continue;
            }
            if (this.fPackage != this.environment.defaultPackage && this.fPackage.getPackage(cArray.name) != null) {
                this.problemReporter().typeCollidesWithPackage(this.referenceContext, (TypeDeclaration)cArray);
                continue;
            }
            if ((cArray.modifiers & 1) != 0 && (object2 = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals((char[])object2, cArray.name)) {
                this.problemReporter().publicClassMustMatchFileName(this.referenceContext, (TypeDeclaration)cArray);
            }
            object2 = new ClassScope(this, (TypeDeclaration)cArray);
            SourceTypeBinding sourceTypeBinding = ((ClassScope)object2).buildType(null, this.fPackage, accessRestriction);
            if (bl && i == 0) {
                sourceTypeBinding.modifiers |= 0x1000;
            }
            if (sourceTypeBinding == null) continue;
            this.topLevelTypes[n2++] = sourceTypeBinding;
        }
        if (n2 != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[n2];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, n2);
        }
    }

    void checkAndSetImports() {
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int n = this.referenceContext.imports.length;
        int n2 = n + 1;
        for (int i = 0; i < n; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            if (!importReference.onDemand || !CharOperation.equals(JAVA_LANG, importReference.tokens) || importReference.isStatic()) continue;
            --n2;
            break;
        }
        ImportBinding[] importBindingArray = new ImportBinding[n2];
        importBindingArray[0] = this.getDefaultImports()[0];
        int n3 = 1;
        block1: for (int i = 0; i < n; ++i) {
            ImportReference importReference = this.referenceContext.imports[i];
            char[][] cArray = importReference.tokens;
            for (int j = 0; j < n3; ++j) {
                ImportBinding importBinding = importBindingArray[j];
                if (importBinding.onDemand == importReference.onDemand && importBinding.isStatic() == importReference.isStatic() && CharOperation.equals(cArray, importBindingArray[j].compoundName)) continue block1;
            }
            if (importReference.onDemand) {
                Binding binding;
                if (CharOperation.equals(cArray, this.currentPackageName) || !(binding = this.findImport(cArray, cArray.length)).isValidBinding() || importReference.isStatic() && binding instanceof PackageBinding) continue;
                importBindingArray[n3++] = new ImportBinding(cArray, true, binding, importReference);
                continue;
            }
            importBindingArray[n3++] = new ImportBinding(cArray, false, null, importReference);
        }
        if (importBindingArray.length > n3) {
            ImportBinding[] importBindingArray2 = importBindingArray;
            importBindingArray = new ImportBinding[n3];
            System.arraycopy(importBindingArray2, 0, importBindingArray, 0, n3);
        }
        this.imports = importBindingArray;
    }

    void checkParameterizedTypes() {
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            return;
        }
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            ClassScope classScope = this.topLevelTypes[i].scope;
            classScope.checkParameterizedTypeBounds();
            classScope.checkParameterizedSuperTypeCollisions();
        }
    }

    public char[] computeConstantPoolName(LocalTypeBinding localTypeBinding) {
        char[] cArray;
        boolean bl;
        if (localTypeBinding.constantPoolName() != null) {
            return localTypeBinding.constantPoolName();
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding sourceTypeBinding = localTypeBinding.scope.outerMostClassScope().enclosingSourceType();
        int n = 0;
        boolean bl2 = bl = this.compilerOptions().complianceLevel >= 0x310000L;
        while (true) {
            cArray = localTypeBinding.isMemberType() ? (n == 0 ? CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), localTypeBinding.sourceName, '$') : CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), '$', String.valueOf(n).toCharArray(), '$', localTypeBinding.sourceName)) : (localTypeBinding.isAnonymousType() ? (bl ? CharOperation.concat(localTypeBinding.enclosingType.constantPoolName(), String.valueOf(n + 1).toCharArray(), '$') : CharOperation.concat(sourceTypeBinding.constantPoolName(), String.valueOf(n + 1).toCharArray(), '$')) : (bl ? CharOperation.concat(CharOperation.concat(localTypeBinding.enclosingType().constantPoolName(), String.valueOf(n + 1).toCharArray(), '$'), localTypeBinding.sourceName) : CharOperation.concat(sourceTypeBinding.constantPoolName(), '$', String.valueOf(n + 1).toCharArray(), '$', localTypeBinding.sourceName)));
            if (this.constantPoolNameUsage.get(cArray) == null) break;
            ++n;
        }
        this.constantPoolNameUsage.put(cArray, localTypeBinding);
        return cArray;
    }

    void connectTypeHierarchy() {
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            this.topLevelTypes[i].scope.connectTypeHierarchy();
        }
    }

    void faultInImports() {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.referenceContext.imports == null) {
            this.typeOrPackageCache = new HashtableOfObject(1);
            return;
        }
        int n5 = this.referenceContext.imports.length;
        HashtableOfType hashtableOfType = null;
        for (n4 = 0; n4 < n5; ++n4) {
            if (this.referenceContext.imports[n4].onDemand) continue;
            hashtableOfType = new HashtableOfType(this.topLevelTypes.length + n5);
            n3 = this.topLevelTypes.length;
            for (n2 = 0; n2 < n3; ++n2) {
                hashtableOfType.put(this.topLevelTypes[n2].sourceName, this.topLevelTypes[n2]);
            }
            break;
        }
        n4 = n5 + 1;
        for (n2 = 0; n2 < n5; ++n2) {
            ImportReference importReference = this.referenceContext.imports[n2];
            if (!importReference.onDemand || !CharOperation.equals(JAVA_LANG, importReference.tokens) || importReference.isStatic()) continue;
            --n4;
            break;
        }
        ImportBinding[] importBindingArray = new ImportBinding[n4];
        importBindingArray[0] = this.getDefaultImports()[0];
        n3 = 1;
        block3: for (n = 0; n < n5; ++n) {
            Binding binding;
            Binding binding2;
            ImportReference importReference = this.referenceContext.imports[n];
            object = importReference.tokens;
            for (int i = 0; i < n3; ++i) {
                binding2 = importBindingArray[i];
                if (((ImportBinding)binding2).onDemand != importReference.onDemand || ((ImportBinding)binding2).isStatic() != importReference.isStatic() || !CharOperation.equals(object, ((ImportBinding)binding2).compoundName)) continue;
                this.problemReporter().unusedImport(importReference);
                continue block3;
            }
            if (importReference.onDemand) {
                if (CharOperation.equals(object, this.currentPackageName)) {
                    this.problemReporter().unusedImport(importReference);
                    continue;
                }
                Binding binding3 = this.findImport((char[][])object, ((char[][])object).length);
                if (!binding3.isValidBinding()) {
                    this.problemReporter().importProblem(importReference, binding3);
                    continue;
                }
                if (importReference.isStatic() && binding3 instanceof PackageBinding) {
                    this.problemReporter().cannotImportPackage(importReference);
                    continue;
                }
                importBindingArray[n3++] = new ImportBinding((char[][])object, true, binding3, importReference);
                continue;
            }
            Binding binding4 = this.findSingleImport((char[][])object, importReference.isStatic());
            if (!binding4.isValidBinding()) {
                this.problemReporter().importProblem(importReference, binding4);
                continue;
            }
            if (binding4 instanceof PackageBinding) {
                this.problemReporter().cannotImportPackage(importReference);
                continue;
            }
            binding2 = null;
            if (binding4 instanceof MethodBinding && !(binding2 = (ReferenceBinding)this.getType((char[][])object, ((char[][])object).length)).isValidBinding()) {
                binding2 = null;
            }
            if (binding4 instanceof ReferenceBinding || binding2 != null) {
                Binding binding5;
                Binding binding6 = binding5 = binding2 == null ? (ReferenceBinding)binding4 : binding2;
                if (importReference.isTypeUseDeprecated((TypeBinding)binding5, this)) {
                    this.problemReporter().deprecatedType((TypeBinding)binding5, importReference);
                }
                if ((binding = hashtableOfType.get(object[((char[][])object).length - 1])) != null) {
                    if (binding == binding5) continue;
                    int n6 = this.topLevelTypes.length;
                    for (int i = 0; i < n6; ++i) {
                        if (!CharOperation.equals(this.topLevelTypes[i].sourceName, ((ReferenceBinding)binding).sourceName)) continue;
                        this.problemReporter().conflictingImport(importReference);
                        continue block3;
                    }
                    this.problemReporter().duplicateImport(importReference);
                    continue;
                }
                hashtableOfType.put(object[((char[][])object).length - 1], (ReferenceBinding)binding5);
            } else if (binding4 instanceof FieldBinding) {
                for (int i = 0; i < n3; ++i) {
                    binding = importBindingArray[i];
                    if (!binding.isStatic() || !(binding.resolvedImport instanceof FieldBinding) || binding4 == binding.resolvedImport || !CharOperation.equals(object[((char[][])object).length - 1], binding.compoundName[binding.compoundName.length - 1])) continue;
                    this.problemReporter().duplicateImport(importReference);
                    continue block3;
                }
            }
            importBindingArray[n3++] = binding2 == null ? new ImportBinding((char[][])object, false, binding4, importReference) : new ImportConflictBinding((char[][])object, binding4, (ReferenceBinding)binding2, importReference);
        }
        if (importBindingArray.length > n3) {
            ImportBinding[] importBindingArray2 = importBindingArray;
            importBindingArray = new ImportBinding[n3];
            System.arraycopy(importBindingArray2, 0, importBindingArray, 0, n3);
        }
        this.imports = importBindingArray;
        n = this.imports.length;
        this.typeOrPackageCache = new HashtableOfObject(n);
        for (int i = 0; i < n; ++i) {
            object = this.imports[i];
            if ((object.onDemand || !(object.resolvedImport instanceof ReferenceBinding)) && !(object instanceof ImportConflictBinding)) continue;
            this.typeOrPackageCache.put(object.compoundName[object.compoundName.length - 1], object);
        }
    }

    public void faultInTypes() {
        this.faultInImports();
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            this.topLevelTypes[i].faultInTypesForFieldsAndMethods();
        }
    }

    private Binding findImport(char[][] cArray, int n) {
        Binding binding;
        int n2;
        Binding binding2;
        block12: {
            this.recordQualifiedReference(cArray);
            binding2 = this.environment.getTopLevelPackage(cArray[0]);
            n2 = 1;
            if (binding2 != null) {
                binding = binding2;
                while (n2 < n) {
                    if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null || !binding2.isValidBinding()) {
                        binding2 = null;
                    } else if (binding2 instanceof PackageBinding) {
                        binding = (PackageBinding)binding2;
                        continue;
                    }
                    break block12;
                }
                return binding;
            }
        }
        if (binding2 == null) {
            if (this.environment.defaultPackage == null || this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
            binding = this.findType(cArray[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (binding == null || !binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
            n2 = 1;
        } else {
            binding = (ReferenceBinding)binding2;
        }
        while (n2 < n) {
            char[] cArray2;
            if (!((ReferenceBinding)(binding = (ReferenceBinding)this.environment.convertToRawType((TypeBinding)binding))).canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 2);
            }
            if ((binding = ((ReferenceBinding)binding).getMemberType(cArray2 = cArray[n2++])) != null) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
        }
        if (!((ReferenceBinding)binding).canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding, 2);
        }
        return binding;
    }

    private Binding findSingleImport(char[][] cArray, boolean bl) {
        if (cArray.length == 1) {
            if (this.environment.defaultPackage == null || this.compilerOptions().complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(cArray, null, 1);
            }
            ReferenceBinding referenceBinding = this.findType(cArray[0], this.environment.defaultPackage, this.fPackage);
            if (referenceBinding == null) {
                return new ProblemReferenceBinding(cArray, null, 1);
            }
            return referenceBinding;
        }
        if (bl) {
            return this.findSingleStaticImport(cArray);
        }
        return this.findImport(cArray, cArray.length);
    }

    private Binding findSingleStaticImport(char[][] cArray) {
        Binding binding = this.findImport(cArray, cArray.length - 1);
        if (!binding.isValidBinding()) {
            return binding;
        }
        char[] cArray2 = cArray[cArray.length - 1];
        if (binding instanceof PackageBinding) {
            Binding binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray2);
            if (binding2 != null && binding2 instanceof ReferenceBinding) {
                return new ProblemReferenceBinding(cArray, (ReferenceBinding)binding2, 14);
            }
            return binding;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)binding;
        FieldBinding fieldBinding = this.findField(referenceBinding, cArray2, null, true);
        if (fieldBinding != null && fieldBinding.isValidBinding() && fieldBinding.isStatic() && fieldBinding.canBeSeenBy(referenceBinding, null, this)) {
            return fieldBinding;
        }
        MethodBinding methodBinding = this.findStaticMethod(referenceBinding, cArray2);
        if (methodBinding != null) {
            return methodBinding;
        }
        if ((referenceBinding = this.findMemberType(cArray2, referenceBinding)) == null || !referenceBinding.isStatic()) {
            if (fieldBinding != null && !fieldBinding.isValidBinding() && fieldBinding.problemId() != 1) {
                return fieldBinding;
            }
            return new ProblemReferenceBinding(cArray, referenceBinding, 1);
        }
        if (!referenceBinding.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(cArray, referenceBinding, 2);
        }
        return referenceBinding;
    }

    MethodBinding findStaticMethod(ReferenceBinding referenceBinding, char[] cArray) {
        if (!referenceBinding.canBeSeenBy(this)) {
            return null;
        }
        do {
            MethodBinding[] methodBindingArray;
            if ((methodBindingArray = referenceBinding.getMethods(cArray)) != Binding.NO_METHODS) {
                int n = methodBindingArray.length;
                while (--n >= 0) {
                    MethodBinding methodBinding = methodBindingArray[n];
                    if (!methodBinding.isStatic() || !methodBinding.canBeSeenBy(this.fPackage)) continue;
                    return methodBinding;
                }
            }
            if (referenceBinding.superInterfaces() != null) continue;
            ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchy();
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return null;
    }

    ImportBinding[] getDefaultImports() {
        if (this.environment.defaultImports != null) {
            return this.environment.defaultImports;
        }
        Binding binding = this.environment.getTopLevelPackage(JAVA);
        if (binding != null) {
            binding = binding.getTypeOrPackage(JAVA_LANG[1]);
        }
        if (binding == null || !binding.isValidBinding()) {
            BinaryTypeBinding binaryTypeBinding = this.environment.cacheMissingBinaryType(JAVA_LANG_OBJECT, this.referenceContext);
            binding = binaryTypeBinding.fPackage;
        }
        this.environment.defaultImports = new ImportBinding[]{new ImportBinding(JAVA_LANG, true, binding, null)};
        return this.environment.defaultImports;
    }

    public final Binding getImport(char[][] cArray, boolean bl, boolean bl2) {
        if (bl) {
            return this.findImport(cArray, cArray.length);
        }
        return this.findSingleImport(cArray, bl2);
    }

    @Override
    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] object) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int n = ((char[][])object).length;
        if (n > 1) {
            while (!this.qualifiedReferences.contains((char[][])object)) {
                this.qualifiedReferences.add((char[][])object);
                if (n == 2) {
                    this.recordSimpleReference(object[0]);
                    this.recordSimpleReference(object[1]);
                    return;
                }
                this.recordSimpleReference(object[--n]);
                char[][] cArray = object;
                char[][] cArrayArray = new char[n][];
                object = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, n);
            }
        } else if (n == 1) {
            this.recordSimpleReference(object[0]);
        }
    }

    void recordReference(char[][] cArray, char[] cArray2) {
        this.recordQualifiedReference(cArray);
        this.recordSimpleReference(cArray2);
    }

    void recordReference(ReferenceBinding referenceBinding, char[] cArray) {
        ReferenceBinding referenceBinding2 = this.typeToRecord(referenceBinding);
        if (referenceBinding2 != null) {
            this.recordReference(referenceBinding2.compoundName, cArray);
        }
    }

    void recordSimpleReference(char[] cArray) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(cArray)) {
            this.simpleNameReferences.add(cArray);
        }
    }

    void recordSuperTypeReference(TypeBinding typeBinding) {
        if (this.referencedSuperTypes == null) {
            return;
        }
        ReferenceBinding referenceBinding = this.typeToRecord(typeBinding);
        if (referenceBinding != null && !this.referencedSuperTypes.containsIdentical(referenceBinding)) {
            this.referencedSuperTypes.add(referenceBinding);
        }
    }

    public void recordTypeConversion(TypeBinding typeBinding, TypeBinding typeBinding2) {
        this.recordSuperTypeReference(typeBinding2);
    }

    void recordTypeReference(TypeBinding typeBinding) {
        if (this.referencedTypes == null) {
            return;
        }
        ReferenceBinding referenceBinding = this.typeToRecord(typeBinding);
        if (referenceBinding != null && !this.referencedTypes.containsIdentical(referenceBinding)) {
            this.referencedTypes.add(referenceBinding);
        }
    }

    void recordTypeReferences(TypeBinding[] typeBindingArray) {
        if (this.referencedTypes == null) {
            return;
        }
        if (typeBindingArray == null || typeBindingArray.length == 0) {
            return;
        }
        int n = typeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding = this.typeToRecord(typeBindingArray[i]);
            if (referenceBinding == null || this.referencedTypes.containsIdentical(referenceBinding)) continue;
            this.referencedTypes.add(referenceBinding);
        }
    }

    Binding resolveSingleImport(ImportBinding importBinding) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleImport(importBinding.compoundName, importBinding.isStatic());
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (this.imports != null) {
                    ImportBinding[] importBindingArray = new ImportBinding[this.imports.length - 1];
                    int n = 0;
                    int n2 = this.imports.length;
                    for (int i = 0; i < n2; ++i) {
                        if (this.imports[i] == importBinding) continue;
                        importBindingArray[n++] = this.imports[i];
                    }
                    this.imports = importBindingArray;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        ReferenceBinding referenceBinding;
        int n;
        for (n = 0; n < this.referencedSuperTypes.size; ++n) {
            ReferenceBinding[] referenceBindingArray;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.referencedSuperTypes.elementAt(n);
            if (!this.referencedTypes.containsIdentical(referenceBinding2)) {
                this.referencedTypes.add(referenceBinding2);
            }
            if (!referenceBinding2.isLocalType() && (referenceBinding = referenceBinding2.enclosingType()) != null) {
                this.recordSuperTypeReference(referenceBinding);
            }
            if ((referenceBinding = referenceBinding2.superclass()) != null) {
                this.recordSuperTypeReference(referenceBinding);
            }
            if ((referenceBindingArray = referenceBinding2.superInterfaces()) == null) continue;
            int n2 = referenceBindingArray.length;
            for (int i = 0; i < n2; ++i) {
                this.recordSuperTypeReference(referenceBindingArray[i]);
            }
        }
        int n3 = this.referencedTypes.size;
        for (n = 0; n < n3; ++n) {
            referenceBinding = (ReferenceBinding)this.referencedTypes.elementAt(n);
            if (referenceBinding.isLocalType()) continue;
            this.recordQualifiedReference(referenceBinding.isMemberType() ? CharOperation.splitOn('.', referenceBinding.readableName()) : referenceBinding.compoundName);
        }
        n = this.qualifiedReferences.size;
        char[][][] cArrayArray = new char[n][][];
        for (int i = 0; i < n; ++i) {
            cArrayArray[i] = this.qualifiedReferences.elementAt(i);
        }
        this.referenceContext.compilationResult.qualifiedReferences = cArrayArray;
        n = this.simpleNameReferences.size;
        char[][] cArrayArray2 = new char[n][];
        for (int i = 0; i < n; ++i) {
            cArrayArray2[i] = this.simpleNameReferences.elementAt(i);
        }
        this.referenceContext.compilationResult.simpleNameReferences = cArrayArray2;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    private ReferenceBinding typeToRecord(TypeBinding typeBinding) {
        if (typeBinding.isArrayType()) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        switch (typeBinding.kind()) {
            case 132: 
            case 516: 
            case 4100: {
                return null;
            }
            case 260: 
            case 1028: {
                typeBinding = typeBinding.erasure();
            }
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        if (referenceBinding.isLocalType()) {
            return null;
        }
        return referenceBinding;
    }

    public void verifyMethods(MethodVerifier methodVerifier) {
        int n = this.topLevelTypes.length;
        for (int i = 0; i < n; ++i) {
            this.topLevelTypes[i].verifyMethods(methodVerifier);
        }
    }
}

