/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends FlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;
    LocalVariableBinding[] nullLocals;
    Expression[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;

    public FinallyFlowContext(FlowContext flowContext, ASTNode aSTNode) {
        super(flowContext, aSTNode);
    }

    public void complainOnDeferredChecks(FlowInfo flowInfo, BlockScope blockScope) {
        Object object;
        int n;
        for (n = 0; n < this.assignCount; ++n) {
            object = this.finalVariables[n];
            if (object == null) continue;
            boolean bl = false;
            if (object instanceof FieldBinding) {
                if (flowInfo.isPotentiallyAssigned((FieldBinding)object)) {
                    bl = true;
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)object, this.finalAssignments[n]);
                }
            } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)object)) {
                bl = true;
                blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)object, this.finalAssignments[n]);
            }
            if (!bl) continue;
            FlowContext flowContext = this.parent;
            while (flowContext != null) {
                flowContext.removeFinalAssignmentIfAny(this.finalAssignments[n]);
                flowContext = flowContext.parent;
            }
        }
        if (this.deferNullDiagnostic) {
            for (n = 0; n < this.nullCount; ++n) {
                object = this.nullReferences[n];
                LocalVariableBinding localVariableBinding = this.nullLocals[n];
                switch (this.nullCheckTypes[n]) {
                    case 20: 
                    case 21: {
                        if (flowInfo.isProtectedNonNull(localVariableBinding)) {
                            if (this.nullCheckTypes[n] == 20) {
                                blockScope.problemReporter().localVariableCannotBeNull(localVariableBinding, (ASTNode)object);
                            }
                            return;
                        }
                        if (!flowInfo.isProtectedNull(localVariableBinding)) break;
                        blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, (ASTNode)object);
                        return;
                    }
                    case 22: {
                        if (flowInfo.isProtectedNonNull(localVariableBinding)) {
                            return;
                        }
                        if (!flowInfo.isProtectedNull(localVariableBinding)) break;
                        blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, (ASTNode)object);
                        return;
                    }
                }
                this.parent.recordUsingNullReference(blockScope, localVariableBinding, (Expression)object, this.nullCheckTypes[n], flowInfo);
            }
        } else {
            block12: for (n = 0; n < this.nullCount; ++n) {
                object = this.nullReferences[n];
                LocalVariableBinding localVariableBinding = this.nullLocals[n];
                switch (this.nullCheckTypes[n]) {
                    case 20: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            blockScope.problemReporter().localVariableCannotBeNull(localVariableBinding, (ASTNode)object);
                            return;
                        }
                    }
                    case 21: {
                        if (!flowInfo.isDefinitelyNull(localVariableBinding)) continue block12;
                        blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, (ASTNode)object);
                        return;
                    }
                    case 22: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            blockScope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, (ASTNode)object);
                            return;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) continue block12;
                        blockScope.problemReporter().localVariableMayBeNull(localVariableBinding, (ASTNode)object);
                        return;
                    }
                }
            }
        }
    }

    @Override
    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Finally flow context");
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    @Override
    public boolean isSubRoutine() {
        return true;
    }

    @Override
    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    @Override
    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n, FlowInfo flowInfo) {
        block17: {
            block19: {
                block18: {
                    if ((flowInfo.tagBits & 1) != 0) break block17;
                    if (!this.deferNullDiagnostic) break block18;
                    switch (n) {
                        case 20: 
                        case 21: {
                            if (flowInfo.isProtectedNonNull(localVariableBinding)) {
                                if (n == 20) {
                                    scope.problemReporter().localVariableCannotBeNull(localVariableBinding, expression);
                                }
                                return;
                            }
                            if (flowInfo.isProtectedNull(localVariableBinding)) {
                                scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                                return;
                            }
                            break block19;
                        }
                        case 22: {
                            if (flowInfo.isProtectedNonNull(localVariableBinding)) {
                                return;
                            }
                            if (flowInfo.isProtectedNull(localVariableBinding)) {
                                scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                                return;
                            }
                            break block19;
                        }
                    }
                    break block19;
                }
                switch (n) {
                    case 20: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            scope.problemReporter().localVariableCannotBeNull(localVariableBinding, expression);
                            return;
                        }
                    }
                    case 21: {
                        if (!flowInfo.isDefinitelyNull(localVariableBinding)) break;
                        scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                        return;
                    }
                    case 22: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            scope.problemReporter().localVariableCanOnlyBeNull(localVariableBinding, expression);
                            return;
                        }
                        if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                            scope.problemReporter().localVariableMayBeNull(localVariableBinding, expression);
                            return;
                        }
                        if (!flowInfo.isDefinitelyNonNull(localVariableBinding)) break;
                        return;
                    }
                }
            }
            this.recordNullReference(localVariableBinding, expression, n);
        }
    }

    @Override
    void removeFinalAssignmentIfAny(Reference reference) {
        for (int i = 0; i < this.assignCount; ++i) {
            if (this.finalAssignments[i] != reference) continue;
            this.finalAssignments[i] = null;
            this.finalVariables[i] = null;
            return;
        }
    }

    @Override
    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new Expression[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            int n2 = this.nullCount * 2;
            this.nullLocals = new LocalVariableBinding[n2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new Expression[n2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[n2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = expression;
        this.nullCheckTypes[this.nullCount++] = n;
    }
}

