/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRule;

public class AccessRuleSet {
    private AccessRule[] accessRules;
    public String[] messageTemplates;
    public static final int MESSAGE_TEMPLATES_LENGTH = 4;

    public AccessRuleSet(AccessRule[] accessRuleArray, String[] stringArray) {
        this.accessRules = accessRuleArray;
        this.messageTemplates = stringArray != null && stringArray.length == 4 ? stringArray : new String[]{"{0}", "{0}", "{0} {1}", "{0} {1}"};
    }

    public boolean equals(Object object) {
        int n;
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessRuleSet)) {
            return false;
        }
        AccessRuleSet accessRuleSet = (AccessRuleSet)object;
        if (this.messageTemplates.length != 4 || accessRuleSet.messageTemplates.length != 4) {
            return false;
        }
        for (n = 0; n < 4; ++n) {
            if (this.messageTemplates[n].equals(accessRuleSet.messageTemplates[n])) continue;
            return false;
        }
        n = this.accessRules.length;
        if (n != accessRuleSet.accessRules.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.accessRules[i].equals(accessRuleSet.accessRules[i])) continue;
            return false;
        }
        return true;
    }

    public AccessRule[] getAccessRules() {
        return this.accessRules;
    }

    public AccessRestriction getViolatedRestriction(char[] cArray) {
        for (AccessRule accessRule : this.accessRules) {
            if (!CharOperation.pathMatch(accessRule.pattern, cArray, true, '/')) continue;
            switch (accessRule.getProblemId()) {
                case 0x1000118: 
                case 0x1000133: {
                    return new AccessRestriction(accessRule, this.messageTemplates);
                }
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("AccessRuleSet {");
        if (bl) {
            stringBuffer.append('\n');
        }
        int n2 = this.accessRules.length;
        for (n = 0; n < n2; ++n) {
            if (bl) {
                stringBuffer.append('\t');
            }
            AccessRule accessRule = this.accessRules[n];
            stringBuffer.append(accessRule);
            if (bl) {
                stringBuffer.append('\n');
                continue;
            }
            if (n >= n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("} [templates:\"");
        for (n = 0; n < this.messageTemplates.length; ++n) {
            stringBuffer.append(this.messageTemplates[n]);
        }
        stringBuffer.append("\"]");
        return stringBuffer.toString();
    }
}

