/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SingleTypeReference
extends TypeReference {
    public char[] token;

    public SingleTypeReference(char[] cArray, long l) {
        this.token = cArray;
        this.sourceStart = (int)(l >>> 32);
        this.sourceEnd = (int)(l & 0xFFFFFFFFL);
    }

    @Override
    public TypeReference copyDims(int n) {
        return new ArrayTypeReference(this.token, n, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    @Override
    public char[] getLastToken() {
        return this.token;
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.resolvedType = scope.getType(this.token);
        if (scope.kind == 3 && this.resolvedType.isValidBinding() && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this, null)) {
            return null;
        }
        return this.resolvedType;
    }

    @Override
    public char[][] getTypeName() {
        return new char[][]{this.token};
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return stringBuffer.append(this.token);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        TypeBinding typeBinding = blockScope.getMemberType(this.token, referenceBinding);
        if (!typeBinding.isValidBinding()) {
            this.resolvedType = typeBinding;
            blockScope.problemReporter().invalidEnclosingType(this, typeBinding, referenceBinding);
            return null;
        }
        if (this.isTypeUseDeprecated(typeBinding, blockScope)) {
            blockScope.problemReporter().deprecatedType(typeBinding, this);
        }
        if ((typeBinding = blockScope.environment().convertToRawType(typeBinding)).isRawType() && (this.bits & 0x40000000) == 0 && blockScope.compilerOptions().getSeverity(0x200000000000L) != -1) {
            blockScope.problemReporter().rawTypeReference(this, typeBinding);
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

