/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class ConstructorDeclaration
extends AbstractMethodDeclaration {
    public ExplicitConstructorCall constructorCall;
    public boolean isDefaultConstructor = false;
    public TypeParameter[] typeParameters;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    @Override
    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo) {
        this.analyseCode(classScope, initializationFlowContext, flowInfo, 0);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo, int n) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        int n2 = flowInfo.reachMode();
        flowInfo.setReachMode(n);
        if (!(this.binding == null || this.binding.isUsed() || !this.binding.isPrivate() && (this.binding.declaringClass.tagBits & 0x30L) != 16L || classScope.referenceCompilationUnit().compilationResult.hasSyntaxError)) {
            this.scope.problemReporter().unusedPrivateConstructor(this);
        }
        if (this.isRecursive(null)) {
            this.scope.problemReporter().recursiveConstructorInvocation(this.constructorCall);
        }
        try {
            Object object;
            int n3;
            FieldBinding[] fieldBindingArray;
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(initializationFlowContext.parent, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            initializationFlowContext.checkInitializerExceptions(this.scope, exceptionHandlingFlowContext, flowInfo);
            if (this.binding.declaringClass.isAnonymousType() && (fieldBindingArray = exceptionHandlingFlowContext.extendedExceptions) != null && (n3 = fieldBindingArray.size()) > 0) {
                ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n3];
                fieldBindingArray.toArray(referenceBindingArray);
                this.binding.thrownExceptions = referenceBindingArray;
            }
            if (this.arguments != null) {
                n3 = this.arguments.length;
                for (int i = 0; i < n3; ++i) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[i].binding);
                }
            }
            if (this.constructorCall != null) {
                if (this.constructorCall.accessMode == 3) {
                    fieldBindingArray = this.binding.declaringClass.fields();
                    int n4 = fieldBindingArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        object = fieldBindingArray[n3];
                        if (((FieldBinding)object).isStatic()) continue;
                        flowInfo.markAsDefinitelyAssigned((FieldBinding)object);
                    }
                }
                flowInfo = this.constructorCall.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo);
            }
            flowInfo.setReachMode(n2);
            if (this.statements != null) {
                boolean bl = false;
                int n5 = this.statements.length;
                for (n3 = 0; n3 < n5; ++n3) {
                    object = this.statements[n3];
                    if (!((Statement)object).complainIfUnreachable(flowInfo, this.scope, bl)) {
                        flowInfo = ((Statement)object).analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo);
                        continue;
                    }
                    bl = true;
                }
            }
            this.needFreeReturn = (flowInfo.tagBits & 1) == 0;
            flowInfo.setReachMode(n);
            if (this.constructorCall != null && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(exceptionHandlingFlowContext.initsOnReturn);
                FieldBinding[] fieldBindingArray2 = this.binding.declaringClass.fields();
                int n6 = fieldBindingArray2.length;
                for (n3 = 0; n3 < n6; ++n3) {
                    object = fieldBindingArray2[n3];
                    if (((FieldBinding)object).isStatic() || !((VariableBinding)object).isFinal() || flowInfo.isDefinitelyAssigned(fieldBindingArray2[n3])) continue;
                    this.scope.problemReporter().uninitializedBlankFinalField((FieldBinding)object, this.isDefaultConstructor ? this.scope.referenceType() : this);
                }
            }
            exceptionHandlingFlowContext.complainIfUnusedExceptionHandlers(this);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int n2 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n2];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n2);
            classFile.addProblemConstructor(this, this.binding, categorizedProblemArray2);
            return;
        }
        try {
            n = classFile.contentsOffset;
            this.internalGenerateCode(classScope, classFile);
        }
        catch (AbortMethod abortMethod) {
            if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.internalGenerateCode(classScope, classFile);
                }
                catch (AbortMethod abortMethod2) {
                    CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
                    int n3 = categorizedProblemArray.length;
                    CategorizedProblem[] categorizedProblemArray3 = new CategorizedProblem[n3];
                    System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray3, 0, n3);
                    classFile.addProblemConstructor(this, this.binding, categorizedProblemArray3, n);
                }
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int n4 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray4 = new CategorizedProblem[n4];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray4, 0, n4);
            classFile.addProblemConstructor(this, this.binding, categorizedProblemArray4, n);
        }
    }

    public void generateSyntheticFieldInitializationsIfNecessary(MethodScope methodScope, CodeStream codeStream, ReferenceBinding referenceBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding;
        int n;
        int n2;
        if (!referenceBinding.isNestedType()) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)referenceBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray = nestedTypeBinding.syntheticEnclosingInstances();
        int n3 = n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
        for (n = 0; n < n2; ++n) {
            syntheticArgumentBinding = syntheticArgumentBindingArray[n];
            if (syntheticArgumentBinding.matchingField == null) continue;
            codeStream.aload_0();
            codeStream.load(syntheticArgumentBinding);
            codeStream.putfield(syntheticArgumentBinding.matchingField);
        }
        syntheticArgumentBindingArray = nestedTypeBinding.syntheticOuterLocalVariables();
        int n4 = n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
        for (n = 0; n < n2; ++n) {
            syntheticArgumentBinding = syntheticArgumentBindingArray[n];
            if (syntheticArgumentBinding.matchingField == null) continue;
            codeStream.aload_0();
            codeStream.load(syntheticArgumentBinding);
            codeStream.putfield(syntheticArgumentBinding.matchingField);
        }
    }

    private void internalGenerateCode(ClassScope classScope, ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttribute(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            boolean bl;
            int n3;
            Object object;
            TypeDeclaration typeDeclaration = classScope.referenceContext;
            int n4 = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            ReferenceBinding referenceBinding = this.binding.declaringClass;
            int n5 = referenceBinding.isEnum() ? 2 : 0;
            int n6 = 1 + n5;
            if (referenceBinding.isNestedType()) {
                object = (NestedTypeBinding)referenceBinding;
                this.scope.extraSyntheticArguments = ((NestedTypeBinding)object).syntheticOuterLocalVariables();
                this.scope.computeLocalVariablePositions(((NestedTypeBinding)object).enclosingInstancesSlotSize + 1 + n5, codeStream);
                n6 += ((NestedTypeBinding)object).enclosingInstancesSlotSize;
                n6 += ((NestedTypeBinding)object).outerLocalVariablesSlotSize;
            } else {
                this.scope.computeLocalVariablePositions(1 + n5, codeStream);
            }
            if (this.arguments != null) {
                n3 = this.arguments.length;
                for (int i = 0; i < n3; ++i) {
                    LocalVariableBinding localVariableBinding = this.arguments[i].binding;
                    codeStream.addVisibleLocalVariable(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    TypeBinding typeBinding = localVariableBinding.type;
                    if (typeBinding == TypeBinding.LONG || typeBinding == TypeBinding.DOUBLE) {
                        n6 += 2;
                        continue;
                    }
                    ++n6;
                }
            }
            object = typeDeclaration.initializerScope;
            ((MethodScope)object).computeLocalVariablePositions(n6, codeStream);
            n3 = this.constructorCall == null || this.constructorCall.accessMode != 3 ? 1 : 0;
            boolean bl2 = bl = this.scope.compilerOptions().targetJDK >= 0x300000L;
            if (n3 != 0 && bl) {
                this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, referenceBinding);
            }
            if (this.constructorCall != null) {
                this.constructorCall.generateCode(this.scope, codeStream);
            }
            if (n3 != 0) {
                if (!bl) {
                    this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, referenceBinding);
                }
                if (typeDeclaration.fields != null) {
                    for (FieldDeclaration fieldDeclaration : typeDeclaration.fields) {
                        if (fieldDeclaration.isStatic()) continue;
                        fieldDeclaration.generateCode((BlockScope)object, codeStream);
                    }
                }
            }
            if (this.statements != null) {
                int n7 = this.statements.length;
                for (int i = 0; i < n7; ++i) {
                    this.statements[i].generateCode(this.scope, codeStream);
                }
            }
            if (this.needFreeReturn) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.bodyEnd);
            classFile.completeCodeAttribute(n4);
            ++n2;
        }
        classFile.completeMethodInfo(n, n2);
        if (this.ignoreFurtherInvestigation) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public boolean isDefaultConstructor() {
        return this.isDefaultConstructor;
    }

    @Override
    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList arrayList) {
        if (this.binding == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)this.scope.referenceType().declarationOf(this.constructorCall.binding.original());
        if (this == constructorDeclaration) {
            return true;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int n = arrayList.indexOf(this);
            if (n >= 0) {
                return n == 0;
            }
        }
        arrayList.add(this);
        return constructorDeclaration.isRecursive(arrayList);
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.isDefaultConstructor && this.constructorCall == null) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        parser.parse(this, compilationUnitDeclaration);
    }

    @Override
    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        stringBuffer.append(" {");
        if (this.constructorCall != null) {
            stringBuffer.append('\n');
            this.constructorCall.printStatement(n, stringBuffer);
        }
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                stringBuffer.append('\n');
                this.statements[i].printStatement(n, stringBuffer);
            }
        }
        stringBuffer.append('\n');
        ConstructorDeclaration.printIndent(n == 0 ? 0 : n - 1, stringBuffer).append('}');
        return stringBuffer;
    }

    @Override
    public void resolveJavadoc() {
        if (this.binding == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if (!this.isDefaultConstructor) {
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    @Override
    public void resolveStatements() {
        if (!CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().missingReturnType(this);
        }
        if (this.typeParameters != null) {
            int n = this.typeParameters.length;
            for (int i = 0; i < n; ++i) {
                this.typeParameters[i].resolve(this.scope);
            }
        }
        if (this.constructorCall != null) {
            if (this.binding != null && this.binding.declaringClass.id == 1 && this.constructorCall.accessMode != 3) {
                if (this.constructorCall.accessMode == 2) {
                    this.scope.problemReporter().cannotUseSuperInJavaLangObject(this.constructorCall);
                }
                this.constructorCall = null;
            } else {
                this.constructorCall.resolve(this.scope);
            }
        }
        if ((this.modifiers & 0x1000000) != 0) {
            this.scope.problemReporter().methodNeedBody(this);
        }
        super.resolveStatements();
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.annotations != null) {
                n2 = this.annotations.length;
                for (n = 0; n < n2; ++n) {
                    this.annotations[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.typeParameters != null) {
                n2 = this.typeParameters.length;
                for (n = 0; n < n2; ++n) {
                    this.typeParameters[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.thrownExceptions != null) {
                n2 = this.thrownExceptions.length;
                for (n = 0; n < n2; ++n) {
                    this.thrownExceptions[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(aSTVisitor, this.scope);
            }
            if (this.statements != null) {
                n2 = this.statements.length;
                for (n = 0; n < n2; ++n) {
                    this.statements[n].traverse(aSTVisitor, this.scope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    @Override
    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

