/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class AllocationExpression
extends Expression
implements InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    MethodBinding syntheticAccessor;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public FieldDeclaration enumConstant;

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)this.binding.declaringClass.erasure(), blockScope, flowInfo);
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                flowInfo = this.arguments[i].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            }
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), blockScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding referenceBinding, BlockScope blockScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedTypeBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        if (referenceBinding.isLocalType() && !referenceBinding.isAnonymousType() && !blockScope.isDefinedInType(referenceBinding) && (syntheticArgumentBindingArray = (nestedTypeBinding = (NestedTypeBinding)referenceBinding).syntheticOuterLocalVariables()) != null) {
            for (SyntheticArgumentBinding syntheticArgumentBinding : syntheticArgumentBindingArray) {
                LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
                if (localVariableBinding == null || localVariableBinding.declaration == null || flowInfo.isDefinitelyAssigned(localVariableBinding)) continue;
                blockScope.problemReporter().uninitializedLocalVariable(localVariableBinding, this);
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
        codeStream.new_(referenceBinding);
        if (bl) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invokespecial(this.codegenBinding);
        } else {
            int n2 = this.syntheticAccessor.parameters.length - this.codegenBinding.parameters.length;
            for (int i = 0; i < n2; ++i) {
                codeStream.aconst_null();
            }
            codeStream.invokespecial(this.syntheticAccessor);
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, false);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.codegenBinding.isPrivate()) {
            ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
            if (blockScope.enclosingSourceType() != referenceBinding) {
                if ((referenceBinding.tagBits & 0x10L) != 0L && blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    this.codegenBinding.tagBits |= 0x400L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                }
            }
        }
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.type != null) {
            stringBuffer.append("new ");
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.type != null) {
            this.type.printExpression(0, stringBuffer);
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
            }
        }
        return stringBuffer.append(')');
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        int n;
        TypeBinding[] typeBindingArray;
        this.constant = Constant.NotAConstant;
        if (this.type == null) {
            this.resolvedType = blockScope.enclosingReceiverType();
        } else {
            this.resolvedType = this.type.resolveType(blockScope, true);
            if (this.type instanceof ParameterizedQualifiedTypeReference) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
                if (referenceBinding == null) {
                    return null;
                }
                block0: while ((referenceBinding.modifiers & 8) == 0 && !referenceBinding.isRawType()) {
                    if ((referenceBinding = referenceBinding.enclosingType()) != null) continue;
                    typeBindingArray = (ParameterizedQualifiedTypeReference)this.type;
                    for (n = typeBindingArray.typeArguments.length - 2; n >= 0; --n) {
                        if (typeBindingArray.typeArguments[n] == null) continue;
                        blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, this.resolvedType);
                        break block0;
                    }
                }
            }
        }
        if (this.typeArguments != null) {
            int n2 = this.typeArguments.length;
            boolean bl = false;
            this.genericTypeArguments = new TypeBinding[n2];
            for (n = 0; n < n2; ++n) {
                this.genericTypeArguments[n] = this.typeArguments[n].resolveType(blockScope, true);
                if (this.genericTypeArguments[n] != null) continue;
                bl = true;
            }
            if (bl) {
                return null;
            }
        }
        boolean bl = false;
        typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            n = 0;
            int n3 = this.arguments.length;
            typeBindingArray = new TypeBinding[n3];
            for (int i = 0; i < n3; ++i) {
                Expression expression = this.arguments[i];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl = true;
                }
                if ((typeBindingArray[i] = expression.resolveType(blockScope)) != null) continue;
                n = 1;
            }
            if (n != 0) {
                if (this.resolvedType instanceof ReferenceBinding) {
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n3];
                    int n4 = n3;
                    while (--n4 >= 0) {
                        typeBindingArray2[n4] = typeBindingArray[n4] == null ? this.resolvedType : typeBindingArray[n4];
                    }
                    this.binding = blockScope.findMethod((ReferenceBinding)this.resolvedType, TypeConstants.INIT, typeBindingArray2, this);
                }
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (this.type != null && !this.resolvedType.canBeInstantiated()) {
            blockScope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        this.binding = blockScope.getConstructor(referenceBinding, typeBindingArray, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = referenceBinding;
            }
            blockScope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        AllocationExpression.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl, this);
        return referenceBinding;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    @Override
    public void setDepth(int n) {
    }

    @Override
    public void setFieldIndex(int n) {
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = this.typeArguments.length;
                for (n = 0; n < n2; ++n) {
                    this.typeArguments[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

