/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrame;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.util.Messages;

public class ClassFile
implements TypeConstants,
TypeIds {
    private byte[] bytes;
    public CodeStream codeStream;
    public ConstantPool constantPool;
    public int constantPoolOffset;
    public byte[] contents;
    public int contentsOffset;
    protected boolean creatingProblemType;
    public ClassFile enclosingClassFile;
    public byte[] header;
    public int headerOffset;
    public ReferenceBinding[] innerClassesBindings;
    public int methodCount;
    public int methodCountOffset;
    public int numberOfInnerClasses;
    public boolean isShared = false;
    public int produceAttributes;
    public SourceTypeBinding referenceBinding;
    public long targetJDK;
    public static final int INITIAL_CONTENTS_SIZE = 400;
    public static final int INITIAL_HEADER_SIZE = 1500;
    public static final int INNER_CLASSES_SIZE = 5;

    public static String buildAllDirectoriesInto(String string, String string2) throws IOException {
        String string3;
        String string4;
        char c = File.separatorChar;
        String string5 = File.separator;
        string = string.replace('/', c);
        int n = (string2 = string2.replace('/', c)).lastIndexOf(c);
        if (n == -1) {
            if (string.endsWith(string5)) {
                string4 = string.substring(0, string.length() - 1);
                string3 = string + string2;
            } else {
                string4 = string;
                string3 = string + string5 + string2;
            }
        } else if (string.endsWith(string5)) {
            string4 = string + string2.substring(0, n);
            string3 = string + string2;
        } else {
            string4 = string + string5 + string2.substring(0, n);
            string3 = string + string5 + string2;
        }
        File file = new File(string4);
        file.mkdirs();
        if (file.isDirectory()) {
            return string3;
        }
        if (string.endsWith(string5)) {
            string = string.substring(0, string.length() - 1);
        }
        file = new File(string);
        boolean bl = false;
        if (file.exists()) {
            bl = true;
        } else if (!file.mkdirs()) {
            if (file.exists()) {
                bl = true;
            } else {
                throw new IOException(Messages.bind(Messages.output_notValidAll, file.getAbsolutePath()));
            }
        }
        if (bl && !file.isDirectory()) {
            throw new IOException(Messages.bind(Messages.output_isFile, file.getAbsolutePath()));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(string5);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string5);
        String string6 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            file = new File(stringBuffer.append(string6).append(string5).toString());
            bl = false;
            if (file.exists()) {
                bl = true;
            } else if (!file.mkdir()) {
                if (file.exists()) {
                    bl = true;
                } else {
                    throw new IOException(Messages.bind(Messages.output_notValid, stringBuffer.substring(string.length() + 1, stringBuffer.length() - 1), string));
                }
            }
            if (bl && !file.isDirectory()) {
                throw new IOException(Messages.bind(Messages.output_isFile, file.getAbsolutePath()));
            }
            string6 = stringTokenizer.nextToken();
        }
        return stringBuffer.append(string6).toString();
    }

    public static void createProblemType(TypeDeclaration typeDeclaration, CompilationResult compilationResult) {
        FieldBinding[] fieldBindingArray;
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        ClassFile classFile = ClassFile.getNewInstance(sourceTypeBinding);
        classFile.initialize(sourceTypeBinding, null, true);
        if (sourceTypeBinding.isMemberType()) {
            classFile.recordEnclosingTypeAttributes(sourceTypeBinding);
        }
        if ((fieldBindingArray = sourceTypeBinding.fields()) != null && fieldBindingArray != Binding.NO_FIELDS) {
            classFile.addFieldInfos();
        } else {
            classFile.contents[classFile.contentsOffset++] = 0;
            classFile.contents[classFile.contentsOffset++] = 0;
        }
        classFile.setForMethodInfos();
        CategorizedProblem[] categorizedProblemArray = compilationResult.getErrors();
        if (categorizedProblemArray == null) {
            categorizedProblemArray = new CategorizedProblem[]{};
        }
        int n = categorizedProblemArray.length;
        CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n];
        System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n);
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
        if (abstractMethodDeclarationArray != null) {
            MethodBinding methodBinding;
            if (sourceTypeBinding.isInterface()) {
                classFile.addProblemClinit(categorizedProblemArray2);
                for (AbstractMethodDeclaration aSTNode : abstractMethodDeclarationArray) {
                    methodBinding = aSTNode.binding;
                    if (methodBinding == null || methodBinding.isConstructor()) continue;
                    classFile.addAbstractMethod(aSTNode, methodBinding);
                }
            } else {
                for (AbstractMethodDeclaration abstractMethodDeclaration : abstractMethodDeclarationArray) {
                    methodBinding = abstractMethodDeclaration.binding;
                    if (methodBinding == null) continue;
                    if (methodBinding.isConstructor()) {
                        classFile.addProblemConstructor(abstractMethodDeclaration, methodBinding, categorizedProblemArray2);
                        continue;
                    }
                    classFile.addProblemMethod(abstractMethodDeclaration, methodBinding, categorizedProblemArray2);
                }
            }
            classFile.addDefaultAbstractMethods();
        }
        if (typeDeclaration.memberTypes != null) {
            for (TypeDeclaration typeDeclaration2 : typeDeclaration.memberTypes) {
                if (typeDeclaration2.binding == null) continue;
                classFile.recordNestedMemberAttribute(typeDeclaration2.binding);
                ClassFile.createProblemType(typeDeclaration2, compilationResult);
            }
        }
        classFile.addAttributes();
        compilationResult.record(sourceTypeBinding.constantPoolName(), classFile);
    }

    public static ClassFile getNewInstance(SourceTypeBinding sourceTypeBinding) {
        LookupEnvironment lookupEnvironment = sourceTypeBinding.scope.environment();
        return lookupEnvironment.classFilePool.acquire(sourceTypeBinding);
    }

    public static final int searchLineNumber(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 == 0) {
            return 1;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = (n3 + n4) / 2;
            int n6 = nArray[n5];
            if (n < n6) {
                n4 = n5 - 1;
                continue;
            }
            if (n > n6) {
                n3 = n5 + 1;
                continue;
            }
            return n5 + 1;
        }
        if (n < nArray[n5]) {
            return n5 + 1;
        }
        return n5 + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToDisk(boolean bl, String string, String string2, ClassFile classFile) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        if (bl) {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(ClassFile.buildAllDirectoriesInto(string, string2))));
        } else {
            String string3 = null;
            char c = File.separatorChar;
            String string4 = File.separator;
            string = string.replace('/', c);
            int n = string2.lastIndexOf(c);
            if (n == -1) {
                string3 = string.endsWith(string4) ? string + string2 : string + string4 + string2;
            } else {
                int n2 = string2.length();
                string3 = string.endsWith(string4) ? string + string2.substring(n + 1, n2) : string + string4 + string2.substring(n + 1, n2);
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string3)));
        }
        try {
            bufferedOutputStream.write(classFile.header, 0, classFile.headerOffset);
            bufferedOutputStream.write(classFile.contents, 0, classFile.contentsOffset);
        }
        finally {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    protected ClassFile() {
    }

    public ClassFile(SourceTypeBinding sourceTypeBinding) {
        this.constantPool = new ConstantPool(this);
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        this.referenceBinding = sourceTypeBinding;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
            this.codeStream = new StackMapFrameCodeStream(this);
        } else {
            this.codeStream = new CodeStream(this);
        }
        this.initByteArrays();
    }

    public void addAbstractMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding) {
        methodBinding.modifiers = 1025;
        this.generateMethodInfoHeader(methodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding);
        this.completeMethodInfo(n, n2);
    }

    public void addAttributes() {
        Annotation[] annotationArray;
        TypeDeclaration typeDeclaration;
        char[] cArray;
        int n;
        int n2;
        int n3;
        int n4;
        this.contents[this.methodCountOffset++] = (byte)(this.methodCount >> 8);
        this.contents[this.methodCountOffset] = (byte)this.methodCount;
        int n5 = 0;
        int n6 = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceAttributes & 1) != 0) {
            String string = new String(this.referenceBinding.scope.referenceCompilationUnit().getFileName());
            n4 = (string = string.replace('\\', '/')).lastIndexOf(47);
            if (n4 != -1) {
                string = string.substring(n4 + 1, string.length());
            }
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.SourceName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n2 = this.constantPool.literalIndex(string.toCharArray());
            this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
            this.contents[this.contentsOffset++] = (byte)n2;
            ++n5;
        }
        if (this.referenceBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int n7 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
            this.contents[this.contentsOffset++] = (byte)n7;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if (this.numberOfInnerClasses != 0) {
            int n8 = 8 * this.numberOfInnerClasses + 8;
            if (n8 + this.contentsOffset >= this.contents.length) {
                this.resizeContents(n8);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.InnerClassName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            n3 = (this.numberOfInnerClasses << 3) + 2;
            this.contents[this.contentsOffset++] = (byte)(n3 >> 24);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 16);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = (byte)(this.numberOfInnerClasses >> 8);
            this.contents[this.contentsOffset++] = (byte)this.numberOfInnerClasses;
            for (n2 = 0; n2 < this.numberOfInnerClasses; ++n2) {
                int n9;
                ReferenceBinding referenceBinding = this.innerClassesBindings[n2];
                int n10 = referenceBinding.getAccessFlags();
                n = this.constantPool.literalIndexForType(referenceBinding.constantPoolName());
                this.contents[this.contentsOffset++] = (byte)(n >> 8);
                this.contents[this.contentsOffset++] = (byte)n;
                if (referenceBinding.isMemberType()) {
                    n9 = this.constantPool.literalIndexForType(referenceBinding.enclosingType().constantPoolName());
                    this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n9;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (!referenceBinding.isAnonymousType()) {
                    n9 = this.constantPool.literalIndex(referenceBinding.sourceName());
                    this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n9;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (referenceBinding.isAnonymousType()) {
                    n10 &= 0xFFFFFFEF;
                } else if (referenceBinding.isMemberType() && referenceBinding.isInterface()) {
                    n10 |= 8;
                }
                this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
                this.contents[this.contentsOffset++] = (byte)n10;
            }
            ++n5;
        }
        if ((cArray = this.referenceBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n3 = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            ++n5;
        }
        if (this.targetJDK >= 0x310000L && this.referenceBinding.isNestedType() && !this.referenceBinding.isMemberType()) {
            MethodBinding methodBinding;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.EnclosingMethodName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 4;
            n3 = this.constantPool.literalIndexForType(this.referenceBinding.enclosingType().constantPoolName());
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            n2 = 0;
            byte by = 0;
            if (this.referenceBinding instanceof LocalTypeBinding && (methodBinding = ((LocalTypeBinding)this.referenceBinding).enclosingMethod) != null) {
                n = this.constantPool.literalIndexForNameAndType(methodBinding.selector, methodBinding.signature());
                n2 = (byte)(n >> 8);
                by = (byte)n;
            }
            this.contents[this.contentsOffset++] = n2;
            this.contents[this.contentsOffset++] = by;
            ++n5;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && (typeDeclaration = this.referenceBinding.scope.referenceContext) != null && (annotationArray = typeDeclaration.annotations) != null) {
            n5 += this.generateRuntimeAnnotations(annotationArray);
        }
        if (this.referenceBinding.isHierarchyInconsistent()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int n11 = this.constantPool.literalIndex(AttributeNamesConstants.InconsistentHierarchy);
            this.contents[this.contentsOffset++] = (byte)(n11 >> 8);
            this.contents[this.contentsOffset++] = (byte)n11;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if (n6 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n6++] = (byte)(n5 >> 8);
        this.contents[n6] = (byte)n5;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int n12 = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(n12 >> 8);
        this.header[this.constantPoolOffset] = (byte)n12;
    }

    public void addDefaultAbstractMethods() {
        MethodBinding[] methodBindingArray = this.referenceBinding.getDefaultAbstractMethods();
        int n = methodBindingArray.length;
        for (int i = 0; i < n; ++i) {
            this.generateMethodInfoHeader(methodBindingArray[i]);
            int n2 = this.contentsOffset;
            int n3 = this.generateMethodInfoAttribute(methodBindingArray[i]);
            this.completeMethodInfo(n2, n3);
        }
    }

    private int addFieldAttributes(FieldBinding fieldBinding, int n) {
        Annotation[] annotationArray;
        FieldDeclaration fieldDeclaration;
        char[] cArray;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        Constant constant = fieldBinding.constant();
        if (constant != Constant.NotAConstant) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.ConstantValueName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            ++n5;
            switch (constant.typeID()) {
                case 5: {
                    n3 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                    this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    n2 = this.constantPool.literalIndex(constant.intValue());
                    this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n2;
                    break;
                }
                case 9: {
                    int n6 = this.constantPool.literalIndex(constant.floatValue());
                    this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n6;
                    break;
                }
                case 8: {
                    int n7 = this.constantPool.literalIndex(constant.doubleValue());
                    this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n7;
                    break;
                }
                case 7: {
                    int n8 = this.constantPool.literalIndex(constant.longValue());
                    this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n8;
                    break;
                }
                case 11: {
                    int n9 = this.constantPool.literalIndex(((StringConstant)constant).stringValue());
                    if (n9 == -1) {
                        if (!this.creatingProblemType) {
                            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
                            int n10 = fieldDeclarationArray.length;
                            for (int i = 0; i < n10; ++i) {
                                if (fieldDeclarationArray[i].binding != fieldBinding) continue;
                                typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(fieldDeclarationArray[i]);
                            }
                            break;
                        }
                        this.contentsOffset = n;
                        break;
                    }
                    this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n9;
                }
            }
        }
        if (this.targetJDK < 0x310000L && fieldBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if (fieldBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if ((cArray = fieldBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n2 = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
            this.contents[this.contentsOffset++] = (byte)n2;
            ++n5;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && (fieldDeclaration = fieldBinding.sourceField()) != null && (annotationArray = fieldDeclaration.annotations) != null) {
            n5 += this.generateRuntimeAnnotations(annotationArray);
        }
        return n5;
    }

    private void addFieldInfo(FieldBinding fieldBinding) {
        if (this.contentsOffset + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n = fieldBinding.getAccessFlags();
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEFFF;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(fieldBinding.name);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(fieldBinding.type.signature());
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = this.contentsOffset;
        int n5 = 0;
        this.contentsOffset += 2;
        n5 += this.addFieldAttributes(fieldBinding, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n4++] = (byte)(n5 >> 8);
        this.contents[n4] = (byte)n5;
    }

    public void addFieldInfos() {
        int n;
        int n2;
        SourceTypeBinding sourceTypeBinding = this.referenceBinding;
        FieldBinding[] fieldBindingArray = sourceTypeBinding.syntheticFields();
        int n3 = sourceTypeBinding.fieldCount() + (fieldBindingArray == null ? 0 : fieldBindingArray.length);
        if (n3 > 65535) {
            this.referenceBinding.scope.problemReporter().tooManyFields(this.referenceBinding.scope.referenceType());
        }
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        FieldDeclaration[] fieldDeclarationArray = sourceTypeBinding.scope.referenceContext.fields;
        int n4 = n2 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
        for (n = 0; n < n2; ++n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n];
            if (fieldDeclaration.binding == null) continue;
            this.addFieldInfo(fieldDeclaration.binding);
        }
        if (fieldBindingArray != null) {
            n2 = fieldBindingArray.length;
            for (n = 0; n < n2; ++n) {
                this.addFieldInfo(fieldBindingArray[n]);
            }
        }
    }

    private void addInnerClasses(ReferenceBinding referenceBinding) {
        int n;
        for (n = 0; n < this.numberOfInnerClasses; ++n) {
            if (this.innerClassesBindings[n] != referenceBinding) continue;
            return;
        }
        n = this.innerClassesBindings.length;
        if (this.numberOfInnerClasses == n) {
            this.innerClassesBindings = new ReferenceBinding[n * 2];
            System.arraycopy(this.innerClassesBindings, 0, this.innerClassesBindings, 0, n);
        }
        this.innerClassesBindings[this.numberOfInnerClasses++] = referenceBinding;
    }

    private void addMissingAbstractProblemMethod(MethodDeclaration methodDeclaration, MethodBinding methodBinding, CategorizedProblem categorizedProblem, CompilationResult compilationResult) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        StringBuffer stringBuffer = new StringBuffer(25);
        stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
        stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
        String string = stringBuffer.toString();
        this.codeStream.init(this);
        this.codeStream.preserveUnusedLocals = true;
        this.codeStream.initializeMaxLocals(methodBinding);
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForMissingAbstractProblemMethod(methodBinding, n3, compilationResult.getLineSeparatorPositions(), categorizedProblem.getSourceLineNumber());
        this.completeMethodInfo(n, n2);
    }

    public void addProblemClinit(CategorizedProblem[] categorizedProblemArray) {
        this.generateMethodInfoHeaderForClinit();
        this.contentsOffset -= 2;
        int n = this.contentsOffset;
        this.contentsOffset += 2;
        int n2 = 0;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.resetForProblemClinit(this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[i];
                if (categorizedProblem == null || !categorizedProblem.isError()) continue;
                stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                ++n6;
                if (n4 == 0) {
                    n4 = categorizedProblem.getSourceLineNumber();
                }
                categorizedProblemArray[i] = null;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        ++n2;
        this.completeCodeAttributeForClinit(n3, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding, true);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[i];
                if (categorizedProblem == null || !categorizedProblem.isError()) continue;
                stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                ++n6;
                if (n4 != 0) continue;
                n4 = categorizedProblem.getSourceLineNumber();
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(n, n2);
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemConstructor(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        if (methodBinding.isAbstract() && methodBinding.declaringClass.isInterface()) {
            abstractMethodDeclaration.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding, true);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[i];
                if (categorizedProblem == null || !categorizedProblem.isError() || categorizedProblem.getSourceStart() < abstractMethodDeclaration.declarationSourceStart || categorizedProblem.getSourceEnd() > abstractMethodDeclaration.declarationSourceEnd) continue;
                stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                ++n6;
                if (n4 == 0) {
                    n4 = categorizedProblem.getSourceLineNumber();
                }
                categorizedProblemArray[i] = null;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(n, n2);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemMethod(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addSpecialMethods() {
        this.generateMissingAbstractMethods(this.referenceBinding.scope.referenceType().missingAbstractMethods, this.referenceBinding.scope.referenceCompilationUnit().compilationResult);
        MethodBinding[] methodBindingArray = this.referenceBinding.getDefaultAbstractMethods();
        int n = methodBindingArray.length;
        for (int i = 0; i < n; ++i) {
            this.generateMethodInfoHeader(methodBindingArray[i]);
            int n2 = this.contentsOffset;
            int n3 = this.generateMethodInfoAttribute(methodBindingArray[i]);
            this.completeMethodInfo(n2, n3);
        }
        SyntheticMethodBinding[] syntheticMethodBindingArray = this.referenceBinding.syntheticMethods();
        if (syntheticMethodBindingArray != null) {
            block10: for (SyntheticMethodBinding syntheticMethodBinding : syntheticMethodBindingArray) {
                switch (syntheticMethodBinding.kind) {
                    case 1: {
                        this.addSyntheticFieldReadAccessMethod(syntheticMethodBinding);
                        continue block10;
                    }
                    case 2: {
                        this.addSyntheticFieldWriteAccessMethod(syntheticMethodBinding);
                        continue block10;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        this.addSyntheticMethodAccessMethod(syntheticMethodBinding);
                        continue block10;
                    }
                    case 4: {
                        this.addSyntheticConstructorAccessMethod(syntheticMethodBinding);
                        continue block10;
                    }
                    case 7: {
                        this.addSyntheticEnumValuesMethod(syntheticMethodBinding);
                        continue block10;
                    }
                    case 8: {
                        this.addSyntheticEnumValueOfMethod(syntheticMethodBinding);
                        continue block10;
                    }
                    case 9: {
                        this.addSyntheticSwitchTable(syntheticMethodBinding);
                    }
                }
            }
        }
    }

    public void addSyntheticConstructorAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForConstructorAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValueOfMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValueOf(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValuesMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValues(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldReadAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldReadAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldWriteAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldWriteAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticMethodAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForMethodAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticSwitchTable(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForSwitchTable(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(true, syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void completeCodeAttribute(int n) {
        Set set;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        Object object2;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        Object object3;
        int n12;
        this.contents = this.codeStream.bCodeStream;
        int n13 = this.codeStream.classFileOffset;
        int n14 = this.codeStream.position;
        if (n14 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration);
        }
        if (n13 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n15 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n15 >> 8);
        this.contents[n + 7] = (byte)n15;
        int n16 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n16 >> 8);
        this.contents[n + 9] = (byte)n16;
        this.contents[n + 10] = (byte)(n14 >> 24);
        this.contents[n + 11] = (byte)(n14 >> 16);
        this.contents[n + 12] = (byte)(n14 >> 8);
        this.contents[n + 13] = (byte)n14;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n17 = 0;
        int n18 = this.codeStream.exceptionLabelsCounter;
        for (n12 = 0; n12 < n18; ++n12) {
            n17 += this.codeStream.exceptionLabels[n12].count / 2;
        }
        n12 = n17 * 8 + 2;
        if (n12 + n13 >= this.contents.length) {
            this.resizeContents(n12);
        }
        this.contents[n13++] = (byte)(n17 >> 8);
        this.contents[n13++] = (byte)n17;
        int n19 = this.codeStream.exceptionLabelsCounter;
        for (n18 = 0; n18 < n19; ++n18) {
            object3 = exceptionLabelArray[n18];
            if (object3 == null) continue;
            n11 = 0;
            n10 = ((ExceptionLabel)object3).count;
            if ((n10 & 1) != 0) {
                this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
            }
            while (n11 < n10) {
                n9 = ((ExceptionLabel)object3).ranges[n11++];
                this.contents[n13++] = (byte)(n9 >> 8);
                this.contents[n13++] = (byte)n9;
                n8 = ((ExceptionLabel)object3).ranges[n11++];
                this.contents[n13++] = (byte)(n8 >> 8);
                this.contents[n13++] = (byte)n8;
                n7 = ((ExceptionLabel)object3).position;
                this.contents[n13++] = (byte)(n7 >> 8);
                this.contents[n13++] = (byte)n7;
                if (((ExceptionLabel)object3).exceptionType == null) {
                    this.contents[n13++] = 0;
                    this.contents[n13++] = 0;
                    continue;
                }
                object2 = ((ExceptionLabel)object3).exceptionType == TypeBinding.NULL ? (Object)this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : (Object)this.constantPool.literalIndexForType(((ExceptionLabel)object3).exceptionType.constantPoolName());
                this.contents[n13++] = (byte)(object2 >> 8);
                this.contents[n13++] = (byte)object2;
            }
        }
        n18 = n13;
        n19 = 0;
        if ((n13 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            object3 = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                n11 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (n13 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n13++] = (byte)(n11 >> 8);
                this.contents[n13++] = (byte)n11;
                n10 = n13;
                n13 += 6;
                n9 = 0;
                n8 = this.codeStream.pcToSourceMapSize;
                n7 = 0;
                while (n7 < n8) {
                    if (n13 + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    object2 = object3[n7++];
                    this.contents[n13++] = (byte)(object2 >> 8);
                    this.contents[n13++] = (byte)object2;
                    Object object4 = object3[n7++];
                    this.contents[n13++] = (byte)(object4 >> 8);
                    this.contents[n13++] = (byte)object4;
                    ++n9;
                }
                n7 = n9 * 4 + 2;
                this.contents[n10++] = (byte)(n7 >> 24);
                this.contents[n10++] = (byte)(n7 >> 16);
                this.contents[n10++] = (byte)(n7 >> 8);
                this.contents[n10++] = (byte)n7;
                this.contents[n10++] = (byte)(n9 >> 8);
                this.contents[n10++] = (byte)n9;
                ++n19;
            }
        }
        if ((this.produceAttributes & 4) != 0) {
            int n20;
            int n21;
            int n22 = 0;
            n11 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            n10 = this.codeStream.methodDeclaration.isStatic() ? 1 : 0;
            n9 = 8 + 10 * (n10 != 0 ? 0 : 1);
            for (n8 = 0; n8 < this.codeStream.allLocalsCounter; ++n8) {
                n9 += 10 * this.codeStream.locals[n8].initializationCount;
            }
            if (n13 + n9 >= this.contents.length) {
                this.resizeContents(n9);
            }
            this.contents[n13++] = (byte)(n11 >> 8);
            this.contents[n13++] = (byte)n11;
            n8 = n13;
            n13 += 6;
            SourceTypeBinding sourceTypeBinding = null;
            if (n10 == 0) {
                ++n22;
                this.contents[n13++] = 0;
                this.contents[n13++] = 0;
                this.contents[n13++] = (byte)(n14 >> 8);
                this.contents[n13++] = (byte)n14;
                n7 = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[n13++] = (byte)(n7 >> 8);
                this.contents[n13++] = (byte)n7;
                sourceTypeBinding = (SourceTypeBinding)this.codeStream.methodDeclaration.binding.declaringClass;
                object2 = this.constantPool.literalIndex(sourceTypeBinding.signature());
                this.contents[n13++] = (byte)(object2 >> 8);
                this.contents[n13++] = (byte)object2;
                this.contents[n13++] = 0;
                this.contents[n13++] = 0;
            }
            int n23 = 0;
            object = null;
            int n24 = 0;
            n6 = this.codeStream.allLocalsCounter;
            for (n5 = 0; n5 < n6; ++n5) {
                boolean bl;
                LocalVariableBinding localVariableBinding = this.codeStream.locals[n5];
                TypeBinding typeBinding = localVariableBinding.type;
                boolean bl2 = bl = typeBinding.isParameterizedType() || typeBinding.isTypeVariable();
                if (localVariableBinding.initializationCount != 0 && bl) {
                    if (object == null) {
                        object = new LocalVariableBinding[n6];
                    }
                    object[n23++] = localVariableBinding;
                }
                for (n4 = 0; n4 < localVariableBinding.initializationCount; ++n4) {
                    n3 = localVariableBinding.initializationPCs[n4 << 1];
                    n21 = localVariableBinding.initializationPCs[(n4 << 1) + 1];
                    if (n3 == n21) continue;
                    if (n21 == -1) {
                        localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                    }
                    if (bl) {
                        ++n24;
                    }
                    ++n22;
                    this.contents[n13++] = (byte)(n3 >> 8);
                    this.contents[n13++] = (byte)n3;
                    n20 = n21 - n3;
                    this.contents[n13++] = (byte)(n20 >> 8);
                    this.contents[n13++] = (byte)n20;
                    n7 = this.constantPool.literalIndex(localVariableBinding.name);
                    this.contents[n13++] = (byte)(n7 >> 8);
                    this.contents[n13++] = (byte)n7;
                    object2 = this.constantPool.literalIndex(typeBinding.signature());
                    this.contents[n13++] = (byte)(object2 >> 8);
                    this.contents[n13++] = (byte)object2;
                    n2 = localVariableBinding.resolvedPosition;
                    this.contents[n13++] = (byte)(n2 >> 8);
                    this.contents[n13++] = (byte)n2;
                }
            }
            n5 = n22 * 10 + 2;
            this.contents[n8++] = (byte)(n5 >> 24);
            this.contents[n8++] = (byte)(n5 >> 16);
            this.contents[n8++] = (byte)(n5 >> 8);
            this.contents[n8++] = (byte)n5;
            this.contents[n8++] = (byte)(n22 >> 8);
            this.contents[n8] = (byte)n22;
            ++n19;
            int n25 = n6 = n10 == 0 && sourceTypeBinding != null && sourceTypeBinding.typeVariables != Binding.NO_TYPE_VARIABLES ? 1 : 0;
            if (n23 != 0 || n6 != 0) {
                n9 = 8 + (n24 += n6 != 0 ? 1 : 0) * 10;
                if (n13 + n9 >= this.contents.length) {
                    this.resizeContents(n9);
                }
                int n26 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n13++] = (byte)(n26 >> 8);
                this.contents[n13++] = (byte)n26;
                n5 = n24 * 10 + 2;
                this.contents[n13++] = (byte)(n5 >> 24);
                this.contents[n13++] = (byte)(n5 >> 16);
                this.contents[n13++] = (byte)(n5 >> 8);
                this.contents[n13++] = (byte)n5;
                this.contents[n13++] = (byte)(n24 >> 8);
                this.contents[n13++] = (byte)n24;
                if (n6 != 0) {
                    this.contents[n13++] = 0;
                    this.contents[n13++] = 0;
                    this.contents[n13++] = (byte)(n14 >> 8);
                    this.contents[n13++] = (byte)n14;
                    n7 = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[n13++] = (byte)(n7 >> 8);
                    this.contents[n13++] = (byte)n7;
                    object2 = this.constantPool.literalIndex(sourceTypeBinding.genericTypeSignature());
                    this.contents[n13++] = (byte)(object2 >> 8);
                    this.contents[n13++] = (byte)object2;
                    this.contents[n13++] = 0;
                    this.contents[n13++] = 0;
                }
                for (int i = 0; i < n23; ++i) {
                    Object object5 = object[i];
                    for (n4 = 0; n4 < ((LocalVariableBinding)object5).initializationCount; ++n4) {
                        n3 = ((LocalVariableBinding)object5).initializationPCs[n4 << 1];
                        n21 = ((LocalVariableBinding)object5).initializationPCs[(n4 << 1) + 1];
                        if (n3 == n21) continue;
                        this.contents[n13++] = (byte)(n3 >> 8);
                        this.contents[n13++] = (byte)n3;
                        n20 = n21 - n3;
                        this.contents[n13++] = (byte)(n20 >> 8);
                        this.contents[n13++] = (byte)n20;
                        n7 = this.constantPool.literalIndex(((LocalVariableBinding)object5).name);
                        this.contents[n13++] = (byte)(n7 >> 8);
                        this.contents[n13++] = (byte)n7;
                        object2 = this.constantPool.literalIndex(((LocalVariableBinding)object5).type.genericTypeSignature());
                        this.contents[n13++] = (byte)(object2 >> 8);
                        this.contents[n13++] = (byte)object2;
                        n2 = ((LocalVariableBinding)object5).resolvedPosition;
                        this.contents[n13++] = (byte)(n2 >> 8);
                        this.contents[n13++] = (byte)n2;
                    }
                }
                ++n19;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (n10 = (n11 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            int n27;
            ArrayList arrayList = new ArrayList(n11);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            n8 = n13;
            if (n13 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n7 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n13++] = (byte)(n7 >> 8);
            this.contents[n13++] = (byte)n7;
            object2 = n13;
            if ((n13 += 4) + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            n10 = 0;
            int n28 = n13;
            if ((n13 += 2) + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            object = (LocalVariableBinding[])arrayList2.get(0);
            LocalVariableBinding[] localVariableBindingArray = null;
            n5 = arrayList2.size();
            n6 = 0;
            block72: for (n27 = 0; n27 < n11 && (Integer)arrayList.get(n27) < n14; ++n27) {
                localVariableBindingArray = object;
                object = null;
                while (n6 < n5) {
                    object = (StackMapFrame)arrayList2.get(n6);
                    if (((StackMapFrame)object).pc == (Integer)arrayList.get(n27)) break;
                    ++n6;
                }
                if (object == null) break;
                ++n10;
                int n29 = ((StackMapFrame)object).getOffsetDelta((StackMapFrame)localVariableBindingArray);
                switch (((StackMapFrame)object).getFrameType((StackMapFrame)localVariableBindingArray)) {
                    case 2: {
                        int n30;
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n31 = ((StackMapFrame)object).numberOfDifferentLocals((StackMapFrame)localVariableBindingArray);
                        this.contents[n13++] = (byte)(251 + n31);
                        this.contents[n13++] = (byte)(n29 >> 8);
                        this.contents[n13++] = (byte)n29;
                        n4 = ((StackMapFrame)object).getIndexOfDifferentLocals(n31);
                        n3 = ((StackMapFrame)object).getNumberOfLocals();
                        for (int i = n4; i < ((StackMapFrame)object).locals.length && n31 > 0; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = ((StackMapFrame)object).locals[i]) == null) {
                                this.contents[n13++] = 0;
                                continue;
                            }
                            block8 : switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n13++] = 1;
                                    break;
                                }
                                case 9: {
                                    this.contents[n13++] = 2;
                                    break;
                                }
                                case 7: {
                                    this.contents[n13++] = 4;
                                    ++i;
                                    break;
                                }
                                case 8: {
                                    this.contents[n13++] = 3;
                                    ++i;
                                    break;
                                }
                                case 12: {
                                    this.contents[n13++] = 5;
                                    break;
                                }
                                default: {
                                    this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n2 = verificationTypeInfo.offset;
                                            this.contents[n13++] = (byte)(n2 >> 8);
                                            this.contents[n13++] = (byte)n2;
                                            break block8;
                                        }
                                        case 7: {
                                            n30 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n13++] = (byte)(n30 >> 8);
                                            this.contents[n13++] = (byte)n30;
                                        }
                                    }
                                }
                            }
                            --n31;
                        }
                        continue block72;
                    }
                    case 0: {
                        if (n13 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n13++] = (byte)n29;
                        continue block72;
                    }
                    case 3: {
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n13++] = -5;
                        this.contents[n13++] = (byte)(n29 >> 8);
                        this.contents[n13++] = (byte)n29;
                        continue block72;
                    }
                    case 1: {
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n31 = -((StackMapFrame)object).numberOfDifferentLocals((StackMapFrame)localVariableBindingArray);
                        this.contents[n13++] = (byte)(251 - n31);
                        this.contents[n13++] = (byte)(n29 >> 8);
                        this.contents[n13++] = (byte)n29;
                        continue block72;
                    }
                    case 5: {
                        int n30;
                        if (n13 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n13++] = (byte)(n29 + 64);
                        if (((StackMapFrame)object).stackItems[0] == null) {
                            this.contents[n13++] = 0;
                            continue block72;
                        }
                        switch (((StackMapFrame)object).stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n13++] = 1;
                                continue block72;
                            }
                            case 9: {
                                this.contents[n13++] = 2;
                                continue block72;
                            }
                            case 7: {
                                this.contents[n13++] = 4;
                                continue block72;
                            }
                            case 8: {
                                this.contents[n13++] = 3;
                                continue block72;
                            }
                            case 12: {
                                this.contents[n13++] = 5;
                                continue block72;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = ((StackMapFrame)object).stackItems[0];
                        byte by = (byte)verificationTypeInfo.tag;
                        this.contents[n13++] = by;
                        switch (by) {
                            case 8: {
                                n2 = verificationTypeInfo.offset;
                                this.contents[n13++] = (byte)(n2 >> 8);
                                this.contents[n13++] = (byte)n2;
                                break;
                            }
                            case 7: {
                                n30 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n13++] = (byte)(n30 >> 8);
                                this.contents[n13++] = (byte)n30;
                            }
                        }
                        continue block72;
                    }
                    case 6: {
                        int n30;
                        if (n13 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n13++] = -9;
                        this.contents[n13++] = (byte)(n29 >> 8);
                        this.contents[n13++] = (byte)n29;
                        if (((StackMapFrame)object).stackItems[0] == null) {
                            this.contents[n13++] = 0;
                            continue block72;
                        }
                        switch (((StackMapFrame)object).stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n13++] = 1;
                                continue block72;
                            }
                            case 9: {
                                this.contents[n13++] = 2;
                                continue block72;
                            }
                            case 7: {
                                this.contents[n13++] = 4;
                                continue block72;
                            }
                            case 8: {
                                this.contents[n13++] = 3;
                                continue block72;
                            }
                            case 12: {
                                this.contents[n13++] = 5;
                                continue block72;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = ((StackMapFrame)object).stackItems[0];
                        byte by = (byte)verificationTypeInfo.tag;
                        this.contents[n13++] = by;
                        switch (by) {
                            case 8: {
                                n2 = verificationTypeInfo.offset;
                                this.contents[n13++] = (byte)(n2 >> 8);
                                this.contents[n13++] = (byte)n2;
                                break;
                            }
                            case 7: {
                                n30 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n13++] = (byte)(n30 >> 8);
                                this.contents[n13++] = (byte)n30;
                            }
                        }
                        continue block72;
                    }
                    default: {
                        int n32;
                        int n33;
                        if (n13 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n13++] = -1;
                        this.contents[n13++] = (byte)(n29 >> 8);
                        this.contents[n13++] = (byte)n29;
                        int n34 = n13;
                        n13 += 2;
                        byte by = 0;
                        n3 = ((StackMapFrame)object).getNumberOfLocals();
                        n2 = 0;
                        int n30 = ((StackMapFrame)object).locals == null ? 0 : ((StackMapFrame)object).locals.length;
                        for (n33 = 0; n33 < n30 && by < n3; ++n33) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = ((StackMapFrame)object).locals[n33]) == null) {
                                this.contents[n13++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n13++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n13++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n13++] = 4;
                                        ++n33;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n13++] = 3;
                                        ++n33;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n13++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n35 = verificationTypeInfo.offset;
                                                this.contents[n13++] = (byte)(n35 >> 8);
                                                this.contents[n13++] = (byte)n35;
                                                break block41;
                                            }
                                            case 7: {
                                                n32 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n13++] = (byte)(n32 >> 8);
                                                this.contents[n13++] = (byte)n32;
                                            }
                                        }
                                    }
                                }
                                by = (byte)(by + 1);
                            }
                            ++n2;
                        }
                        if (n13 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n34++] = (byte)(n2 >> 8);
                        this.contents[n34] = (byte)n2;
                        n33 = ((StackMapFrame)object).numberOfStackItems;
                        this.contents[n13++] = (byte)(n33 >> 8);
                        this.contents[n13++] = (byte)n33;
                        block76: for (int i = 0; i < n33; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = ((StackMapFrame)object).stackItems[i]) == null) {
                                this.contents[n13++] = 0;
                                continue;
                            }
                            switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n13++] = 1;
                                    continue block76;
                                }
                                case 9: {
                                    this.contents[n13++] = 2;
                                    continue block76;
                                }
                                case 7: {
                                    this.contents[n13++] = 4;
                                    continue block76;
                                }
                                case 8: {
                                    this.contents[n13++] = 3;
                                    continue block76;
                                }
                                case 12: {
                                    this.contents[n13++] = 5;
                                    continue block76;
                                }
                                default: {
                                    this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n32 = verificationTypeInfo.offset;
                                            this.contents[n13++] = (byte)(n32 >> 8);
                                            this.contents[n13++] = (byte)n32;
                                            continue block76;
                                        }
                                        case 7: {
                                            int n36 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n13++] = (byte)(n36 >> 8);
                                            this.contents[n13++] = (byte)n36;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (n10 != 0) {
                this.contents[n28++] = (byte)(n10 >> 8);
                this.contents[n28] = (byte)n10;
                n27 = n13 - object2 - 4;
                this.contents[object2++] = (byte)(n27 >> 24);
                this.contents[object2++] = (byte)(n27 >> 16);
                this.contents[object2++] = (byte)(n27 >> 8);
                this.contents[object2] = (byte)n27;
                ++n19;
            } else {
                n13 = n8;
            }
        }
        this.contents[n18++] = (byte)(n19 >> 8);
        this.contents[n18] = (byte)n19;
        int n37 = n13 - (n + 6);
        this.contents[n + 2] = (byte)(n37 >> 24);
        this.contents[n + 3] = (byte)(n37 >> 16);
        this.contents[n + 4] = (byte)(n37 >> 8);
        this.contents[n + 5] = (byte)n37;
        this.contentsOffset = n13;
    }

    /*
     * WARNING - void declaration
     */
    public void completeCodeAttributeForClinit(int n) {
        Set set;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        Object object2;
        int n12;
        this.contents = this.codeStream.bCodeStream;
        int n13 = this.codeStream.classFileOffset;
        int n14 = this.codeStream.position;
        if (n14 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n13 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n15 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n15 >> 8);
        this.contents[n + 7] = (byte)n15;
        int n16 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n16 >> 8);
        this.contents[n + 9] = (byte)n16;
        this.contents[n + 10] = (byte)(n14 >> 24);
        this.contents[n + 11] = (byte)(n14 >> 16);
        this.contents[n + 12] = (byte)(n14 >> 8);
        this.contents[n + 13] = (byte)n14;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n17 = 0;
        int n18 = this.codeStream.exceptionLabelsCounter;
        for (n12 = 0; n12 < n18; ++n12) {
            n17 += this.codeStream.exceptionLabels[n12].count / 2;
        }
        n12 = n17 * 8 + 2;
        if (n12 + n13 >= this.contents.length) {
            this.resizeContents(n12);
        }
        this.contents[n13++] = (byte)(n17 >> 8);
        this.contents[n13++] = (byte)n17;
        int n19 = this.codeStream.exceptionLabelsCounter;
        for (n18 = 0; n18 < n19; ++n18) {
            object2 = exceptionLabelArray[n18];
            if (object2 == null) continue;
            n11 = 0;
            n10 = ((ExceptionLabel)object2).count;
            if ((n10 & 1) != 0) {
                this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
            }
            while (n11 < n10) {
                n9 = ((ExceptionLabel)object2).ranges[n11++];
                this.contents[n13++] = (byte)(n9 >> 8);
                this.contents[n13++] = (byte)n9;
                n8 = ((ExceptionLabel)object2).ranges[n11++];
                this.contents[n13++] = (byte)(n8 >> 8);
                this.contents[n13++] = (byte)n8;
                n7 = ((ExceptionLabel)object2).position;
                this.contents[n13++] = (byte)(n7 >> 8);
                this.contents[n13++] = (byte)n7;
                if (((ExceptionLabel)object2).exceptionType == null) {
                    this.contents[n13++] = 0;
                    this.contents[n13++] = 0;
                    continue;
                }
                object = ((ExceptionLabel)object2).exceptionType == TypeBinding.NULL ? (Object)this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : (Object)this.constantPool.literalIndexForType(((ExceptionLabel)object2).exceptionType.constantPoolName());
                this.contents[n13++] = (byte)(object >> 8);
                this.contents[n13++] = (byte)object;
            }
        }
        n18 = n13;
        n19 = 0;
        if ((n13 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            object2 = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                n11 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (n13 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n13++] = (byte)(n11 >> 8);
                this.contents[n13++] = (byte)n11;
                n10 = n13;
                n13 += 6;
                n9 = 0;
                n8 = this.codeStream.pcToSourceMapSize;
                n7 = 0;
                while (n7 < n8) {
                    if (n13 + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    object = object2[n7++];
                    this.contents[n13++] = (byte)(object >> 8);
                    this.contents[n13++] = (byte)object;
                    Object n6 = object2[n7++];
                    this.contents[n13++] = (byte)(n6 >> 8);
                    this.contents[n13++] = (byte)n6;
                    ++n9;
                }
                n7 = n9 * 4 + 2;
                this.contents[n10++] = (byte)(n7 >> 24);
                this.contents[n10++] = (byte)(n7 >> 16);
                this.contents[n10++] = (byte)(n7 >> 8);
                this.contents[n10++] = (byte)n7;
                this.contents[n10++] = (byte)(n9 >> 8);
                this.contents[n10++] = (byte)n9;
                ++n19;
            }
        }
        if ((this.produceAttributes & 4) != 0) {
            int n20 = 0;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int verificationTypeInfo;
                void var18_27;
                int n6;
                n11 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
                if (n13 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n13++] = (byte)(n11 >> 8);
                this.contents[n13++] = (byte)n11;
                n10 = n13;
                n13 += 6;
                n7 = 0;
                LocalVariableBinding[] localVariableBindingArray = null;
                boolean arrayList2 = false;
                int n21 = this.codeStream.allLocalsCounter;
                for (n6 = 0; n6 < n21; ++n6) {
                    boolean n25;
                    LocalVariableBinding n27 = this.codeStream.locals[n6];
                    TypeBinding n28 = n27.type;
                    boolean bl = n25 = n28.isParameterizedType() || n28.isTypeVariable();
                    if (n27.initializationCount != 0 && n25) {
                        if (localVariableBindingArray == null) {
                            localVariableBindingArray = new LocalVariableBinding[n21];
                        }
                        localVariableBindingArray[n7++] = n27;
                    }
                    for (n5 = 0; n5 < n27.initializationCount; ++n5) {
                        n4 = n27.initializationPCs[n5 << 1];
                        n3 = n27.initializationPCs[(n5 << 1) + 1];
                        if (n4 == n3) continue;
                        if (n3 == -1) {
                            n27.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(n27.name)), (ASTNode)((Object)n27.declaringScope.methodScope().referenceContext));
                        }
                        if (n13 + 10 >= this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++n20;
                        if (n25) {
                            ++var18_27;
                        }
                        this.contents[n13++] = (byte)(n4 >> 8);
                        this.contents[n13++] = (byte)n4;
                        n2 = n3 - n4;
                        this.contents[n13++] = (byte)(n2 >> 8);
                        this.contents[n13++] = (byte)n2;
                        n9 = this.constantPool.literalIndex(n27.name);
                        this.contents[n13++] = (byte)(n9 >> 8);
                        this.contents[n13++] = (byte)n9;
                        n8 = this.constantPool.literalIndex(n28.signature());
                        this.contents[n13++] = (byte)(n8 >> 8);
                        this.contents[n13++] = (byte)n8;
                        verificationTypeInfo = n27.resolvedPosition;
                        this.contents[n13++] = (byte)(verificationTypeInfo >> 8);
                        this.contents[n13++] = (byte)verificationTypeInfo;
                    }
                }
                n6 = n20 * 10 + 2;
                this.contents[n10++] = (byte)(n6 >> 24);
                this.contents[n10++] = (byte)(n6 >> 16);
                this.contents[n10++] = (byte)(n6 >> 8);
                this.contents[n10++] = (byte)n6;
                this.contents[n10++] = (byte)(n20 >> 8);
                this.contents[n10] = (byte)n20;
                ++n19;
                if (n7 != 0) {
                    n21 = 8 + var18_27 * 10;
                    if (n13 + n21 >= this.contents.length) {
                        this.resizeContents(n21);
                    }
                    int n22 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                    this.contents[n13++] = (byte)(n22 >> 8);
                    this.contents[n13++] = (byte)n22;
                    n6 = var18_27 * 10 + 2;
                    this.contents[n13++] = (byte)(n6 >> 24);
                    this.contents[n13++] = (byte)(n6 >> 16);
                    this.contents[n13++] = (byte)(n6 >> 8);
                    this.contents[n13++] = (byte)n6;
                    this.contents[n13++] = (byte)(var18_27 >> 8);
                    this.contents[n13++] = (byte)var18_27;
                    for (int i = 0; i < n7; ++i) {
                        LocalVariableBinding localVariableBinding = localVariableBindingArray[i];
                        for (n5 = 0; n5 < localVariableBinding.initializationCount; ++n5) {
                            n4 = localVariableBinding.initializationPCs[n5 << 1];
                            n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                            if (n4 == n3) continue;
                            this.contents[n13++] = (byte)(n4 >> 8);
                            this.contents[n13++] = (byte)n4;
                            n2 = n3 - n4;
                            this.contents[n13++] = (byte)(n2 >> 8);
                            this.contents[n13++] = (byte)n2;
                            n9 = this.constantPool.literalIndex(localVariableBinding.name);
                            this.contents[n13++] = (byte)(n9 >> 8);
                            this.contents[n13++] = (byte)n9;
                            n8 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                            this.contents[n13++] = (byte)(n8 >> 8);
                            this.contents[n13++] = (byte)n8;
                            verificationTypeInfo = localVariableBinding.resolvedPosition;
                            this.contents[n13++] = (byte)(verificationTypeInfo >> 8);
                            this.contents[n13++] = (byte)verificationTypeInfo;
                        }
                    }
                    ++n19;
                }
            }
        }
        if ((this.produceAttributes & 8) != 0 && (n10 = (n11 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            int n23;
            ArrayList arrayList = new ArrayList(n11);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n13 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n13++] = (byte)(n8 >> 8);
            this.contents[n13++] = (byte)n8;
            n7 = n13;
            n10 = 0;
            int n26 = n13 += 4;
            n13 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n24 = arrayList2.size();
            int n25 = 0;
            block71: for (n23 = 0; n23 < n11 && (Integer)arrayList.get(n23) < n14; ++n23) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = null;
                while (n25 < n24) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n25);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n23)) break;
                    ++n25;
                }
                if (stackMapFrame == null) break;
                ++n10;
                n5 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n27;
                        int n28;
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n4 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n13++] = (byte)(251 + n4);
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        n3 = stackMapFrame.getIndexOfDifferentLocals(n4);
                        n2 = stackMapFrame.getNumberOfLocals();
                        for (int verificationTypeInfo = n3; verificationTypeInfo < stackMapFrame.locals.length && n4 > 0; ++verificationTypeInfo) {
                            VerificationTypeInfo verificationTypeInfo2;
                            if (n13 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo2 = stackMapFrame.locals[verificationTypeInfo]) == null) {
                                this.contents[n13++] = 0;
                                continue;
                            }
                            block8 : switch (verificationTypeInfo2.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n13++] = 1;
                                    break;
                                }
                                case 9: {
                                    this.contents[n13++] = 2;
                                    break;
                                }
                                case 7: {
                                    this.contents[n13++] = 4;
                                    ++verificationTypeInfo;
                                    break;
                                }
                                case 8: {
                                    this.contents[n13++] = 3;
                                    ++verificationTypeInfo;
                                    break;
                                }
                                case 12: {
                                    this.contents[n13++] = 5;
                                    break;
                                }
                                default: {
                                    this.contents[n13++] = (byte)verificationTypeInfo2.tag;
                                    switch (verificationTypeInfo2.tag) {
                                        case 8: {
                                            n28 = verificationTypeInfo2.offset;
                                            this.contents[n13++] = (byte)(n28 >> 8);
                                            this.contents[n13++] = (byte)n28;
                                            break block8;
                                        }
                                        case 7: {
                                            n27 = this.constantPool.literalIndexForType(verificationTypeInfo2.constantPoolName());
                                            this.contents[n13++] = (byte)(n27 >> 8);
                                            this.contents[n13++] = (byte)n27;
                                        }
                                    }
                                }
                            }
                            --n4;
                        }
                        continue block71;
                    }
                    case 0: {
                        if (n13 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n13++] = (byte)n5;
                        continue block71;
                    }
                    case 3: {
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n13++] = -5;
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        continue block71;
                    }
                    case 1: {
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n4 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n13++] = (byte)(251 - n4);
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        continue block71;
                    }
                    case 5: {
                        int n29;
                        int n28;
                        if (n13 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n13++] = (byte)(n5 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n13++] = 0;
                            continue block71;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n13++] = 1;
                                continue block71;
                            }
                            case 9: {
                                this.contents[n13++] = 2;
                                continue block71;
                            }
                            case 7: {
                                this.contents[n13++] = 4;
                                continue block71;
                            }
                            case 8: {
                                this.contents[n13++] = 3;
                                continue block71;
                            }
                            case 12: {
                                this.contents[n13++] = 5;
                                continue block71;
                            }
                        }
                        VerificationTypeInfo n34 = stackMapFrame.stackItems[0];
                        this.contents[n13++] = (byte)n34.tag;
                        switch (n34.tag) {
                            case 8: {
                                n29 = n34.offset;
                                this.contents[n13++] = (byte)(n29 >> 8);
                                this.contents[n13++] = (byte)n29;
                                break;
                            }
                            case 7: {
                                n28 = this.constantPool.literalIndexForType(n34.constantPoolName());
                                this.contents[n13++] = (byte)(n28 >> 8);
                                this.contents[n13++] = (byte)n28;
                            }
                        }
                        continue block71;
                    }
                    case 6: {
                        int n29;
                        int n28;
                        if (n13 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n13++] = -9;
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n13++] = 0;
                            continue block71;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n13++] = 1;
                                continue block71;
                            }
                            case 9: {
                                this.contents[n13++] = 2;
                                continue block71;
                            }
                            case 7: {
                                this.contents[n13++] = 4;
                                continue block71;
                            }
                            case 8: {
                                this.contents[n13++] = 3;
                                continue block71;
                            }
                            case 12: {
                                this.contents[n13++] = 5;
                                continue block71;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n29 = verificationTypeInfo.offset;
                                this.contents[n13++] = (byte)(n29 >> 8);
                                this.contents[n13++] = (byte)n29;
                                break;
                            }
                            case 7: {
                                n28 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n13++] = (byte)(n28 >> 8);
                                this.contents[n13++] = (byte)n28;
                            }
                        }
                        continue block71;
                    }
                    default: {
                        int n30;
                        int n31;
                        if (n13 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n13++] = -1;
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        int n32 = n13;
                        n13 += 2;
                        int n29 = 0;
                        n2 = stackMapFrame.getNumberOfLocals();
                        int n28 = 0;
                        int n27 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        for (n31 = 0; n31 < n27 && n29 < n2; ++n31) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n31]) == null) {
                                this.contents[n13++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n13++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n13++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n13++] = 4;
                                        ++n31;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n13++] = 3;
                                        ++n31;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n13++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n33 = verificationTypeInfo.offset;
                                                this.contents[n13++] = (byte)(n33 >> 8);
                                                this.contents[n13++] = (byte)n33;
                                                break block41;
                                            }
                                            case 7: {
                                                n30 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n13++] = (byte)(n30 >> 8);
                                                this.contents[n13++] = (byte)n30;
                                            }
                                        }
                                    }
                                }
                                ++n29;
                            }
                            ++n28;
                        }
                        if (n13 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n32++] = (byte)(n28 >> 8);
                        this.contents[n32] = (byte)n28;
                        n31 = stackMapFrame.numberOfStackItems;
                        this.contents[n13++] = (byte)(n31 >> 8);
                        this.contents[n13++] = (byte)n31;
                        block75: for (int i = 0; i < n31; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[i]) == null) {
                                this.contents[n13++] = 0;
                                continue;
                            }
                            switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n13++] = 1;
                                    continue block75;
                                }
                                case 9: {
                                    this.contents[n13++] = 2;
                                    continue block75;
                                }
                                case 7: {
                                    this.contents[n13++] = 4;
                                    continue block75;
                                }
                                case 8: {
                                    this.contents[n13++] = 3;
                                    continue block75;
                                }
                                case 12: {
                                    this.contents[n13++] = 5;
                                    continue block75;
                                }
                                default: {
                                    this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n30 = verificationTypeInfo.offset;
                                            this.contents[n13++] = (byte)(n30 >> 8);
                                            this.contents[n13++] = (byte)n30;
                                            continue block75;
                                        }
                                        case 7: {
                                            int n34 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n13++] = (byte)(n34 >> 8);
                                            this.contents[n13++] = (byte)n34;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.contents[n26++] = (byte)(n10 >> 8);
            this.contents[n26] = (byte)n10;
            n23 = n13 - n7 - 4;
            this.contents[n7++] = (byte)(n23 >> 24);
            this.contents[n7++] = (byte)(n23 >> 16);
            this.contents[n7++] = (byte)(n23 >> 8);
            this.contents[n7] = (byte)n23;
            ++n19;
        }
        if (n18 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n18++] = (byte)(n19 >> 8);
        this.contents[n18] = (byte)n19;
        int n37 = n13 - (n + 6);
        this.contents[n + 2] = (byte)(n37 >> 24);
        this.contents[n + 3] = (byte)(n37 >> 16);
        this.contents[n + 4] = (byte)(n37 >> 8);
        this.contents[n + 5] = (byte)n37;
        this.contentsOffset = n13;
    }

    public void completeCodeAttributeForClinit(int n, int n2) {
        Set set;
        int n3;
        int n4;
        int n5;
        this.contents = this.codeStream.bCodeStream;
        int n6 = this.codeStream.classFileOffset;
        int n7 = this.codeStream.position;
        if (n7 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n6 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n8 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n8 >> 8);
        this.contents[n + 7] = (byte)n8;
        int n9 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n9 >> 8);
        this.contents[n + 9] = (byte)n9;
        this.contents[n + 10] = (byte)(n7 >> 24);
        this.contents[n + 11] = (byte)(n7 >> 16);
        this.contents[n + 12] = (byte)(n7 >> 8);
        this.contents[n + 13] = (byte)n7;
        this.contents[n6++] = 0;
        this.contents[n6++] = 0;
        int n10 = n6;
        int n11 = 0;
        if ((n6 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n6 + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            n5 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n6++] = (byte)(n5 >> 8);
            this.contents[n6++] = (byte)n5;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 6;
            this.contents[n6++] = 0;
            this.contents[n6++] = 1;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = (byte)(n2 >> 8);
            this.contents[n6++] = (byte)n2;
            ++n11;
        }
        if ((this.produceAttributes & 4) != 0) {
            n5 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n6++] = (byte)(n5 >> 8);
            this.contents[n6++] = (byte)n5;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 2;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            ++n11;
        }
        if ((this.produceAttributes & 8) != 0 && (n4 = (n3 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            int n12;
            ArrayList arrayList = new ArrayList(n3);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int n13 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n6++] = (byte)(n13 >> 8);
            this.contents[n6++] = (byte)n13;
            int n14 = n6;
            n4 = 0;
            int n15 = n6 += 4;
            n6 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n16 = arrayList2.size();
            int n17 = 0;
            block63: for (n12 = 0; n12 < n3 && (Integer)arrayList.get(n12) < n7; ++n12) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = null;
                while (n17 < n16) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n17);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n12)) break;
                    ++n17;
                }
                if (stackMapFrame == null) break;
                ++n4;
                int n18 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n19;
                        int n20;
                        int n21;
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n22 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 + n22);
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        int n23 = stackMapFrame.getIndexOfDifferentLocals(n22);
                        int n24 = stackMapFrame.getNumberOfLocals();
                        for (n21 = n23; n21 < stackMapFrame.locals.length && n22 > 0; ++n21) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n21]) == null) {
                                this.contents[n6++] = 0;
                                continue;
                            }
                            block8 : switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n6++] = 1;
                                    break;
                                }
                                case 9: {
                                    this.contents[n6++] = 2;
                                    break;
                                }
                                case 7: {
                                    this.contents[n6++] = 4;
                                    ++n21;
                                    break;
                                }
                                case 8: {
                                    this.contents[n6++] = 3;
                                    ++n21;
                                    break;
                                }
                                case 12: {
                                    this.contents[n6++] = 5;
                                    break;
                                }
                                default: {
                                    this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n20 = verificationTypeInfo.offset;
                                            this.contents[n6++] = (byte)(n20 >> 8);
                                            this.contents[n6++] = (byte)n20;
                                            break block8;
                                        }
                                        case 7: {
                                            n19 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n6++] = (byte)(n19 >> 8);
                                            this.contents[n6++] = (byte)n19;
                                        }
                                    }
                                }
                            }
                            --n22;
                        }
                        continue block63;
                    }
                    case 0: {
                        if (n6 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n6++] = (byte)n18;
                        continue block63;
                    }
                    case 3: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n6++] = -5;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        continue block63;
                    }
                    case 1: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n22 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 - n22);
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        continue block63;
                    }
                    case 5: {
                        int n25;
                        int n20;
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n6++] = (byte)(n18 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            continue block63;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                continue block63;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                continue block63;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                continue block63;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                continue block63;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                continue block63;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n25 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n25 >> 8);
                                this.contents[n6++] = (byte)n25;
                                break;
                            }
                            case 7: {
                                n20 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n20 >> 8);
                                this.contents[n6++] = (byte)n20;
                            }
                        }
                        continue block63;
                    }
                    case 6: {
                        int n25;
                        int n20;
                        if (n6 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n6++] = -9;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            continue block63;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                continue block63;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                continue block63;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                continue block63;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                continue block63;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                continue block63;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n25 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n25 >> 8);
                                this.contents[n6++] = (byte)n25;
                                break;
                            }
                            case 7: {
                                n20 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n20 >> 8);
                                this.contents[n6++] = (byte)n20;
                            }
                        }
                        continue block63;
                    }
                    default: {
                        int n26;
                        int n27;
                        if (n6 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n6++] = -1;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        int n21 = n6;
                        n6 += 2;
                        int n25 = 0;
                        int n24 = stackMapFrame.getNumberOfLocals();
                        int n20 = 0;
                        int n19 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        for (n27 = 0; n27 < n19 && n25 < n24; ++n27) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n27]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n27;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n27;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n28 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n28 >> 8);
                                                this.contents[n6++] = (byte)n28;
                                                break block41;
                                            }
                                            case 7: {
                                                n26 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n26 >> 8);
                                                this.contents[n6++] = (byte)n26;
                                            }
                                        }
                                    }
                                }
                                ++n25;
                            }
                            ++n20;
                        }
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n21++] = (byte)(n20 >> 8);
                        this.contents[n21] = (byte)n20;
                        n27 = stackMapFrame.numberOfStackItems;
                        this.contents[n6++] = (byte)(n27 >> 8);
                        this.contents[n6++] = (byte)n27;
                        block67: for (int i = 0; i < n27; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[i]) == null) {
                                this.contents[n6++] = 0;
                                continue;
                            }
                            switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n6++] = 1;
                                    continue block67;
                                }
                                case 9: {
                                    this.contents[n6++] = 2;
                                    continue block67;
                                }
                                case 7: {
                                    this.contents[n6++] = 4;
                                    continue block67;
                                }
                                case 8: {
                                    this.contents[n6++] = 3;
                                    continue block67;
                                }
                                case 12: {
                                    this.contents[n6++] = 5;
                                    continue block67;
                                }
                                default: {
                                    this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n26 = verificationTypeInfo.offset;
                                            this.contents[n6++] = (byte)(n26 >> 8);
                                            this.contents[n6++] = (byte)n26;
                                            continue block67;
                                        }
                                        case 7: {
                                            int n29 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n6++] = (byte)(n29 >> 8);
                                            this.contents[n6++] = (byte)n29;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.contents[n15++] = (byte)(n4 >> 8);
            this.contents[n15] = (byte)n4;
            n12 = n6 - n14 - 4;
            this.contents[n14++] = (byte)(n12 >> 24);
            this.contents[n14++] = (byte)(n12 >> 16);
            this.contents[n14++] = (byte)(n12 >> 8);
            this.contents[n14] = (byte)n12;
            ++n11;
        }
        if (n10 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n10++] = (byte)(n11 >> 8);
        this.contents[n10] = (byte)n11;
        int n30 = n6 - (n + 6);
        this.contents[n + 2] = (byte)(n30 >> 24);
        this.contents[n + 3] = (byte)(n30 >> 16);
        this.contents[n + 4] = (byte)(n30 >> 8);
        this.contents[n + 5] = (byte)n30;
        this.contentsOffset = n6;
    }

    public void completeCodeAttributeForMissingAbstractProblemMethod(MethodBinding methodBinding, int n, int[] nArray, int n2) {
        Set set;
        int n3;
        int n4;
        int n5;
        this.contents = this.codeStream.bCodeStream;
        int n6 = this.codeStream.classFileOffset;
        int n7 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n7 >> 8);
        this.contents[n + 7] = (byte)n7;
        int n8 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n8 >> 8);
        this.contents[n + 9] = (byte)n8;
        int n9 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n9 >> 24);
        this.contents[n + 11] = (byte)(n9 >> 16);
        this.contents[n + 12] = (byte)(n9 >> 8);
        this.contents[n + 13] = (byte)n9;
        if (n6 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n6++] = 0;
        this.contents[n6++] = 0;
        int n10 = n6;
        int n11 = 0;
        if ((n6 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n6 + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            n5 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n6++] = (byte)(n5 >> 8);
            this.contents[n6++] = (byte)n5;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 6;
            this.contents[n6++] = 0;
            this.contents[n6++] = 1;
            if (n2 == 0) {
                n2 = ClassFile.searchLineNumber(nArray, methodBinding.sourceStart());
            }
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = (byte)(n2 >> 8);
            this.contents[n6++] = (byte)n2;
            ++n11;
        }
        if ((this.produceAttributes & 8) != 0 && (n4 = (n3 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            int n12;
            ArrayList arrayList = new ArrayList(n3);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int n13 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n6++] = (byte)(n13 >> 8);
            this.contents[n6++] = (byte)n13;
            int n14 = n6;
            n4 = 0;
            int n15 = n6 += 4;
            n6 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n16 = arrayList2.size();
            int n17 = 0;
            block63: for (n12 = 0; n12 < n3 && (Integer)arrayList.get(n12) < n9; ++n12) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = null;
                while (n17 < n16) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n17);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n12)) break;
                    ++n17;
                }
                if (stackMapFrame == null) break;
                ++n4;
                int n18 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n19;
                        int n20;
                        int n21;
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n22 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 + n22);
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        int n23 = stackMapFrame.getIndexOfDifferentLocals(n22);
                        int n24 = stackMapFrame.getNumberOfLocals();
                        for (n21 = n23; n21 < stackMapFrame.locals.length && n22 > 0; ++n21) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n21]) == null) {
                                this.contents[n6++] = 0;
                                continue;
                            }
                            block8 : switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n6++] = 1;
                                    break;
                                }
                                case 9: {
                                    this.contents[n6++] = 2;
                                    break;
                                }
                                case 7: {
                                    this.contents[n6++] = 4;
                                    ++n21;
                                    break;
                                }
                                case 8: {
                                    this.contents[n6++] = 3;
                                    ++n21;
                                    break;
                                }
                                case 12: {
                                    this.contents[n6++] = 5;
                                    break;
                                }
                                default: {
                                    this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n20 = verificationTypeInfo.offset;
                                            this.contents[n6++] = (byte)(n20 >> 8);
                                            this.contents[n6++] = (byte)n20;
                                            break block8;
                                        }
                                        case 7: {
                                            n19 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n6++] = (byte)(n19 >> 8);
                                            this.contents[n6++] = (byte)n19;
                                        }
                                    }
                                }
                            }
                            --n22;
                        }
                        continue block63;
                    }
                    case 0: {
                        if (n6 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n6++] = (byte)n18;
                        continue block63;
                    }
                    case 3: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n6++] = -5;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        continue block63;
                    }
                    case 1: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n22 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 - n22);
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        continue block63;
                    }
                    case 5: {
                        int n25;
                        int n20;
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n6++] = (byte)(n18 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            continue block63;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                continue block63;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                continue block63;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                continue block63;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                continue block63;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                continue block63;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n25 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n25 >> 8);
                                this.contents[n6++] = (byte)n25;
                                break;
                            }
                            case 7: {
                                n20 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n20 >> 8);
                                this.contents[n6++] = (byte)n20;
                            }
                        }
                        continue block63;
                    }
                    case 6: {
                        int n25;
                        int n20;
                        if (n6 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n6++] = -9;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            continue block63;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                continue block63;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                continue block63;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                continue block63;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                continue block63;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                continue block63;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n25 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n25 >> 8);
                                this.contents[n6++] = (byte)n25;
                                break;
                            }
                            case 7: {
                                n20 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n20 >> 8);
                                this.contents[n6++] = (byte)n20;
                            }
                        }
                        continue block63;
                    }
                    default: {
                        int n26;
                        int n27;
                        if (n6 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n6++] = -1;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        int n21 = n6;
                        n6 += 2;
                        int n25 = 0;
                        int n24 = stackMapFrame.getNumberOfLocals();
                        int n20 = 0;
                        int n19 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        for (n27 = 0; n27 < n19 && n25 < n24; ++n27) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n27]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n27;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n27;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n28 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n28 >> 8);
                                                this.contents[n6++] = (byte)n28;
                                                break block41;
                                            }
                                            case 7: {
                                                n26 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n26 >> 8);
                                                this.contents[n6++] = (byte)n26;
                                            }
                                        }
                                    }
                                }
                                ++n25;
                            }
                            ++n20;
                        }
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n21++] = (byte)(n20 >> 8);
                        this.contents[n21] = (byte)n20;
                        n27 = stackMapFrame.numberOfStackItems;
                        this.contents[n6++] = (byte)(n27 >> 8);
                        this.contents[n6++] = (byte)n27;
                        block67: for (int i = 0; i < n27; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[i]) == null) {
                                this.contents[n6++] = 0;
                                continue;
                            }
                            switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n6++] = 1;
                                    continue block67;
                                }
                                case 9: {
                                    this.contents[n6++] = 2;
                                    continue block67;
                                }
                                case 7: {
                                    this.contents[n6++] = 4;
                                    continue block67;
                                }
                                case 8: {
                                    this.contents[n6++] = 3;
                                    continue block67;
                                }
                                case 12: {
                                    this.contents[n6++] = 5;
                                    continue block67;
                                }
                                default: {
                                    this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n26 = verificationTypeInfo.offset;
                                            this.contents[n6++] = (byte)(n26 >> 8);
                                            this.contents[n6++] = (byte)n26;
                                            continue block67;
                                        }
                                        case 7: {
                                            int n29 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n6++] = (byte)(n29 >> 8);
                                            this.contents[n6++] = (byte)n29;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.contents[n15++] = (byte)(n4 >> 8);
            this.contents[n15] = (byte)n4;
            n12 = n6 - n14 - 4;
            this.contents[n14++] = (byte)(n12 >> 24);
            this.contents[n14++] = (byte)(n12 >> 16);
            this.contents[n14++] = (byte)(n12 >> 8);
            this.contents[n14] = (byte)n12;
            ++n11;
        }
        if (n10 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n10++] = (byte)(n11 >> 8);
        this.contents[n10] = (byte)n11;
        n5 = n6 - (n + 6);
        this.contents[n + 2] = (byte)(n5 >> 24);
        this.contents[n + 3] = (byte)(n5 >> 16);
        this.contents[n + 4] = (byte)(n5 >> 8);
        this.contents[n + 5] = (byte)n5;
        this.contentsOffset = n6;
    }

    public void completeCodeAttributeForProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, int n, int[] nArray, int n2) {
        Set set;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        int n8;
        Object object2;
        int n9;
        int n10;
        int n11;
        this.contents = this.codeStream.bCodeStream;
        int n12 = this.codeStream.classFileOffset;
        int n13 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n13 >> 8);
        this.contents[n + 7] = (byte)n13;
        int n14 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n14 >> 8);
        this.contents[n + 9] = (byte)n14;
        int n15 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n15 >> 24);
        this.contents[n + 11] = (byte)(n15 >> 16);
        this.contents[n + 12] = (byte)(n15 >> 8);
        this.contents[n + 13] = (byte)n15;
        if (n12 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n12++] = 0;
        this.contents[n12++] = 0;
        int n16 = n12;
        int n17 = 0;
        if ((n12 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n12 + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            n11 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n12++] = (byte)(n11 >> 8);
            this.contents[n12++] = (byte)n11;
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = 6;
            this.contents[n12++] = 0;
            this.contents[n12++] = 1;
            if (n2 == 0) {
                n2 = ClassFile.searchLineNumber(nArray, methodBinding.sourceStart());
            }
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = (byte)(n2 >> 8);
            this.contents[n12++] = (byte)n2;
            ++n17;
        }
        if ((this.produceAttributes & 4) != 0) {
            int n18;
            Object object3;
            Object[] objectArray;
            Object object4;
            n10 = 0;
            n9 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n12 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n12++] = (byte)(n9 >> 8);
            this.contents[n12++] = (byte)n9;
            int n19 = n12;
            n12 += 6;
            SourceTypeBinding sourceTypeBinding = null;
            boolean bl = this.codeStream.methodDeclaration.isStatic();
            if (!bl) {
                ++n10;
                if (n12 + 10 >= this.contents.length) {
                    this.resizeContents(10);
                }
                this.contents[n12++] = 0;
                this.contents[n12++] = 0;
                this.contents[n12++] = (byte)(n15 >> 8);
                this.contents[n12++] = (byte)n15;
                object2 = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[n12++] = (byte)(object2 >> 8);
                this.contents[n12++] = (byte)object2;
                sourceTypeBinding = (SourceTypeBinding)this.codeStream.methodDeclaration.binding.declaringClass;
                n8 = this.constantPool.literalIndex(sourceTypeBinding.signature());
                this.contents[n12++] = (byte)(n8 >> 8);
                this.contents[n12++] = (byte)n8;
                this.contents[n12++] = 0;
                this.contents[n12++] = 0;
            }
            int n20 = 0;
            object = null;
            n7 = 0;
            if (methodBinding.isConstructor()) {
                ReferenceBinding referenceBinding = methodBinding.declaringClass;
                if (referenceBinding.isNestedType()) {
                    object4 = (NestedTypeBinding)referenceBinding;
                    n11 = ((NestedTypeBinding)object4).enclosingInstancesSlotSize;
                    objectArray = ((NestedTypeBinding)object4).syntheticEnclosingInstances();
                    if (objectArray != null) {
                        n6 = objectArray.length;
                        for (int i = 0; i < n6; ++i) {
                            object3 = objectArray[i];
                            TypeBinding typeBinding = object3.type;
                            if (typeBinding.isParameterizedType() || typeBinding.isTypeVariable()) {
                                if (object == null) {
                                    object = new LocalVariableBinding[n6];
                                }
                                object[n20++] = object3;
                                ++n7;
                            }
                            if (n12 + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++n10;
                            this.contents[n12++] = 0;
                            this.contents[n12++] = 0;
                            this.contents[n12++] = (byte)(n15 >> 8);
                            this.contents[n12++] = (byte)n15;
                            object2 = this.constantPool.literalIndex(object3.name);
                            this.contents[n12++] = (byte)(object2 >> 8);
                            this.contents[n12++] = (byte)object2;
                            n8 = this.constantPool.literalIndex(typeBinding.signature());
                            this.contents[n12++] = (byte)(n8 >> 8);
                            this.contents[n12++] = (byte)n8;
                            n18 = object3.resolvedPosition;
                            this.contents[n12++] = (byte)(n18 >> 8);
                            this.contents[n12++] = (byte)n18;
                        }
                    }
                } else {
                    n11 = 1;
                }
            } else {
                n11 = methodBinding.isStatic() ? 0 : 1;
            }
            n5 = 0;
            object4 = null;
            objectArray = null;
            TypeBinding[] typeBindingArray = null;
            if (abstractMethodDeclaration.binding != null) {
                TypeBinding[] typeBindingArray2 = abstractMethodDeclaration.binding.parameters;
                object3 = abstractMethodDeclaration.arguments;
                if (typeBindingArray2 != null && object3 != null) {
                    n18 = typeBindingArray2.length;
                    for (int i = 0; i < n18; ++i) {
                        TypeBinding typeBinding = typeBindingArray2[i];
                        if (n12 + 10 >= this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++n10;
                        this.contents[n12++] = 0;
                        this.contents[n12++] = 0;
                        this.contents[n12++] = (byte)(n15 >> 8);
                        this.contents[n12++] = (byte)n15;
                        object2 = this.constantPool.literalIndex(object3[i].name);
                        this.contents[n12++] = (byte)(object2 >> 8);
                        this.contents[n12++] = (byte)object2;
                        int n21 = n11;
                        if (typeBinding.isParameterizedType() || typeBinding.isTypeVariable()) {
                            if (n5 == 0) {
                                object4 = new int[n18];
                                objectArray = new int[n18];
                                typeBindingArray = new TypeBinding[n18];
                            }
                            object4[n5] = (NestedTypeBinding)object2;
                            objectArray[n5] = (SyntheticArgumentBinding)n21;
                            typeBindingArray[n5++] = typeBinding;
                        }
                        n8 = this.constantPool.literalIndex(typeBinding.signature());
                        this.contents[n12++] = (byte)(n8 >> 8);
                        this.contents[n12++] = (byte)n8;
                        n11 = typeBinding == TypeBinding.LONG || typeBinding == TypeBinding.DOUBLE ? (n11 += 2) : ++n11;
                        this.contents[n12++] = (byte)(n21 >> 8);
                        this.contents[n12++] = (byte)n21;
                    }
                }
            }
            n6 = n10 * 10 + 2;
            this.contents[n19++] = (byte)(n6 >> 24);
            this.contents[n19++] = (byte)(n6 >> 16);
            this.contents[n19++] = (byte)(n6 >> 8);
            this.contents[n19++] = (byte)n6;
            this.contents[n19++] = (byte)(n10 >> 8);
            this.contents[n19] = (byte)n10;
            ++n17;
            int n22 = n4 = !bl && sourceTypeBinding != null && sourceTypeBinding.typeVariables != Binding.NO_TYPE_VARIABLES ? 1 : 0;
            if (n20 != 0 || n5 != 0 || n4 != 0) {
                int n23;
                n10 = n7 + n5 + (n4 != 0 ? 1 : 0);
                int n24 = 8 + n10 * 10;
                if (n12 + n24 >= this.contents.length) {
                    this.resizeContents(n24);
                }
                n18 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n12++] = (byte)(n18 >> 8);
                this.contents[n12++] = (byte)n18;
                n6 = n10 * 10 + 2;
                this.contents[n12++] = (byte)(n6 >> 24);
                this.contents[n12++] = (byte)(n6 >> 16);
                this.contents[n12++] = (byte)(n6 >> 8);
                this.contents[n12++] = (byte)n6;
                this.contents[n12++] = (byte)(n10 >> 8);
                this.contents[n12++] = (byte)n10;
                if (n4 != 0) {
                    ++n10;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object2 = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[n12++] = (byte)(object2 >> 8);
                    this.contents[n12++] = (byte)object2;
                    n8 = this.constantPool.literalIndex(sourceTypeBinding.genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                }
                for (n23 = 0; n23 < n20; ++n23) {
                    LocalVariableBinding localVariableBinding = object[n23];
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object2 = this.constantPool.literalIndex(localVariableBinding.name);
                    this.contents[n12++] = (byte)(object2 >> 8);
                    this.contents[n12++] = (byte)object2;
                    n8 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    n3 = localVariableBinding.resolvedPosition;
                    this.contents[n12++] = (byte)(n3 >> 8);
                    this.contents[n12++] = (byte)n3;
                }
                for (n23 = 0; n23 < n5; ++n23) {
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object2 = object4[n23];
                    this.contents[n12++] = (byte)(object2 >> 8);
                    this.contents[n12++] = (byte)object2;
                    n8 = this.constantPool.literalIndex(typeBindingArray[n23].genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    SyntheticArgumentBinding syntheticArgumentBinding = objectArray[n23];
                    this.contents[n12++] = (byte)(syntheticArgumentBinding >> 8);
                    this.contents[n12++] = (byte)syntheticArgumentBinding;
                }
                ++n17;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (n9 = (n10 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            int n25;
            ArrayList arrayList = new ArrayList(n10);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n12 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n12++] = (byte)(n8 >> 8);
            this.contents[n12++] = (byte)n8;
            object2 = n12;
            n9 = 0;
            int n26 = n12 += 4;
            n12 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            object = null;
            n7 = arrayList2.size();
            n5 = 0;
            block67: for (n25 = 0; n25 < n10 && (Integer)arrayList.get(n25) < n15; ++n25) {
                object = stackMapFrame;
                stackMapFrame = null;
                while (n5 < n7) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n5);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n25)) break;
                    ++n5;
                }
                if (stackMapFrame == null) break;
                ++n9;
                int n27 = stackMapFrame.getOffsetDelta((StackMapFrame)object);
                switch (stackMapFrame.getFrameType((StackMapFrame)object)) {
                    case 2: {
                        int n28;
                        int n29;
                        if (n12 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n30 = stackMapFrame.numberOfDifferentLocals((StackMapFrame)object);
                        this.contents[n12++] = (byte)(251 + n30);
                        this.contents[n12++] = (byte)(n27 >> 8);
                        this.contents[n12++] = (byte)n27;
                        n6 = stackMapFrame.getIndexOfDifferentLocals(n30);
                        n4 = stackMapFrame.getNumberOfLocals();
                        for (int i = n6; i < stackMapFrame.locals.length && n30 > 0; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n12 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[i]) == null) {
                                this.contents[n12++] = 0;
                                continue;
                            }
                            block8 : switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n12++] = 1;
                                    break;
                                }
                                case 9: {
                                    this.contents[n12++] = 2;
                                    break;
                                }
                                case 7: {
                                    this.contents[n12++] = 4;
                                    ++i;
                                    break;
                                }
                                case 8: {
                                    this.contents[n12++] = 3;
                                    ++i;
                                    break;
                                }
                                case 12: {
                                    this.contents[n12++] = 5;
                                    break;
                                }
                                default: {
                                    this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n29 = verificationTypeInfo.offset;
                                            this.contents[n12++] = (byte)(n29 >> 8);
                                            this.contents[n12++] = (byte)n29;
                                            break block8;
                                        }
                                        case 7: {
                                            n28 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n12++] = (byte)(n28 >> 8);
                                            this.contents[n12++] = (byte)n28;
                                        }
                                    }
                                }
                            }
                            --n30;
                        }
                        continue block67;
                    }
                    case 0: {
                        if (n12 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n12++] = (byte)n27;
                        continue block67;
                    }
                    case 3: {
                        if (n12 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n12++] = -5;
                        this.contents[n12++] = (byte)(n27 >> 8);
                        this.contents[n12++] = (byte)n27;
                        continue block67;
                    }
                    case 1: {
                        if (n12 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n31 = -stackMapFrame.numberOfDifferentLocals((StackMapFrame)object);
                        this.contents[n12++] = (byte)(251 - n31);
                        this.contents[n12++] = (byte)(n27 >> 8);
                        this.contents[n12++] = (byte)n27;
                        continue block67;
                    }
                    case 5: {
                        int n32;
                        int n29;
                        if (n12 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n12++] = (byte)(n27 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n12++] = 0;
                            continue block67;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n12++] = 1;
                                continue block67;
                            }
                            case 9: {
                                this.contents[n12++] = 2;
                                continue block67;
                            }
                            case 7: {
                                this.contents[n12++] = 4;
                                continue block67;
                            }
                            case 8: {
                                this.contents[n12++] = 3;
                                continue block67;
                            }
                            case 12: {
                                this.contents[n12++] = 5;
                                continue block67;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n12++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n32 = verificationTypeInfo.offset;
                                this.contents[n12++] = (byte)(n32 >> 8);
                                this.contents[n12++] = (byte)n32;
                                break;
                            }
                            case 7: {
                                n29 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n12++] = (byte)(n29 >> 8);
                                this.contents[n12++] = (byte)n29;
                            }
                        }
                        continue block67;
                    }
                    case 6: {
                        int n32;
                        int n29;
                        if (n12 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n12++] = -9;
                        this.contents[n12++] = (byte)(n27 >> 8);
                        this.contents[n12++] = (byte)n27;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n12++] = 0;
                            continue block67;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n12++] = 1;
                                continue block67;
                            }
                            case 9: {
                                this.contents[n12++] = 2;
                                continue block67;
                            }
                            case 7: {
                                this.contents[n12++] = 4;
                                continue block67;
                            }
                            case 8: {
                                this.contents[n12++] = 3;
                                continue block67;
                            }
                            case 12: {
                                this.contents[n12++] = 5;
                                continue block67;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n12++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n32 = verificationTypeInfo.offset;
                                this.contents[n12++] = (byte)(n32 >> 8);
                                this.contents[n12++] = (byte)n32;
                                break;
                            }
                            case 7: {
                                n29 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n12++] = (byte)(n29 >> 8);
                                this.contents[n12++] = (byte)n29;
                            }
                        }
                        continue block67;
                    }
                    default: {
                        int n33;
                        if (n12 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n12++] = -1;
                        this.contents[n12++] = (byte)(n27 >> 8);
                        this.contents[n12++] = (byte)n27;
                        int n34 = n12;
                        n12 += 2;
                        int n32 = 0;
                        n4 = stackMapFrame.getNumberOfLocals();
                        int n29 = 0;
                        int n28 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        for (n3 = 0; n3 < n28 && n32 < n4; ++n3) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n12 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n3]) == null) {
                                this.contents[n12++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n12++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n12++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n12++] = 4;
                                        ++n3;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n12++] = 3;
                                        ++n3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n12++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n35 = verificationTypeInfo.offset;
                                                this.contents[n12++] = (byte)(n35 >> 8);
                                                this.contents[n12++] = (byte)n35;
                                                break block41;
                                            }
                                            case 7: {
                                                n33 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n12++] = (byte)(n33 >> 8);
                                                this.contents[n12++] = (byte)n33;
                                            }
                                        }
                                    }
                                }
                                ++n32;
                            }
                            ++n29;
                        }
                        if (n12 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n34++] = (byte)(n29 >> 8);
                        this.contents[n34] = (byte)n29;
                        n3 = stackMapFrame.numberOfStackItems;
                        this.contents[n12++] = (byte)(n3 >> 8);
                        this.contents[n12++] = (byte)n3;
                        block71: for (int i = 0; i < n3; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n12 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[i]) == null) {
                                this.contents[n12++] = 0;
                                continue;
                            }
                            switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n12++] = 1;
                                    continue block71;
                                }
                                case 9: {
                                    this.contents[n12++] = 2;
                                    continue block71;
                                }
                                case 7: {
                                    this.contents[n12++] = 4;
                                    continue block71;
                                }
                                case 8: {
                                    this.contents[n12++] = 3;
                                    continue block71;
                                }
                                case 12: {
                                    this.contents[n12++] = 5;
                                    continue block71;
                                }
                                default: {
                                    this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n33 = verificationTypeInfo.offset;
                                            this.contents[n12++] = (byte)(n33 >> 8);
                                            this.contents[n12++] = (byte)n33;
                                            continue block71;
                                        }
                                        case 7: {
                                            int n36 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n12++] = (byte)(n36 >> 8);
                                            this.contents[n12++] = (byte)n36;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.contents[n26++] = (byte)(n9 >> 8);
            this.contents[n26] = (byte)n9;
            n25 = n12 - object2 - 4;
            this.contents[object2++] = (byte)(n25 >> 24);
            this.contents[object2++] = (byte)(n25 >> 16);
            this.contents[object2++] = (byte)(n25 >> 8);
            this.contents[object2] = (byte)n25;
            ++n17;
        }
        if (n16 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n16++] = (byte)(n17 >> 8);
        this.contents[n16] = (byte)n17;
        int n37 = n12 - (n + 6);
        this.contents[n + 2] = (byte)(n37 >> 24);
        this.contents[n + 3] = (byte)(n37 >> 16);
        this.contents[n + 4] = (byte)(n37 >> 8);
        this.contents[n + 5] = (byte)n37;
        this.contentsOffset = n12;
    }

    public void completeCodeAttributeForSyntheticMethod(boolean bl, SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        Set set;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        this.contents = this.codeStream.bCodeStream;
        int n15 = this.codeStream.classFileOffset;
        int n16 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n16 >> 8);
        this.contents[n + 7] = (byte)n16;
        int n17 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n17 >> 8);
        this.contents[n + 9] = (byte)n17;
        int n18 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n18 >> 24);
        this.contents[n + 11] = (byte)(n18 >> 16);
        this.contents[n + 12] = (byte)(n18 >> 8);
        this.contents[n + 13] = (byte)n18;
        if (n15 + 40 >= this.contents.length) {
            this.resizeContents(40);
        }
        if (bl) {
            ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
            n14 = 0;
            n13 = this.codeStream.exceptionLabelsCounter;
            for (n12 = 0; n12 < n13; ++n12) {
                n14 += this.codeStream.exceptionLabels[n12].count / 2;
            }
            n12 = n14 * 8 + 2;
            if (n12 + n15 >= this.contents.length) {
                this.resizeContents(n12);
            }
            this.contents[n15++] = (byte)(n14 >> 8);
            this.contents[n15++] = (byte)n14;
            n11 = this.codeStream.exceptionLabelsCounter;
            for (n13 = 0; n13 < n11; ++n13) {
                ExceptionLabel exceptionLabel = exceptionLabelArray[n13];
                if (exceptionLabel == null) continue;
                n10 = 0;
                n9 = exceptionLabel.count;
                if ((n9 & 1) != 0) {
                    this.referenceBinding.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(syntheticMethodBinding.selector), this.referenceBinding.scope.problemReporter().referenceContext));
                }
                while (n10 < n9) {
                    int n19 = exceptionLabel.ranges[n10++];
                    this.contents[n15++] = (byte)(n19 >> 8);
                    this.contents[n15++] = (byte)n19;
                    n8 = exceptionLabel.ranges[n10++];
                    this.contents[n15++] = (byte)(n8 >> 8);
                    this.contents[n15++] = (byte)n8;
                    n7 = exceptionLabel.position;
                    this.contents[n15++] = (byte)(n7 >> 8);
                    this.contents[n15++] = (byte)n7;
                    if (exceptionLabel.exceptionType == null) {
                        this.contents[n15++] = 0;
                        this.contents[n15++] = 0;
                        continue;
                    }
                    switch (exceptionLabel.exceptionType.id) {
                        case 12: {
                            n6 = this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName);
                            break;
                        }
                        case 7: {
                            n6 = this.constantPool.literalIndexForType(ConstantPool.JavaLangNoSuchFieldErrorConstantPoolName);
                            break;
                        }
                        default: {
                            n6 = this.constantPool.literalIndexForType(exceptionLabel.exceptionType.constantPoolName());
                        }
                    }
                    this.contents[n15++] = (byte)(n6 >> 8);
                    this.contents[n15++] = (byte)n6;
                }
            }
        } else {
            this.contents[n15++] = 0;
            this.contents[n15++] = 0;
        }
        int n20 = n15;
        n14 = 0;
        if ((n15 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n15 + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            n12 = 0;
            n13 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n15++] = (byte)(n13 >> 8);
            this.contents[n15++] = (byte)n13;
            n11 = n15;
            n15 += 6;
            n12 = ClassFile.searchLineNumber(nArray, syntheticMethodBinding.sourceStart);
            this.contents[n15++] = 0;
            this.contents[n15++] = 0;
            this.contents[n15++] = (byte)(n12 >> 8);
            this.contents[n15++] = (byte)n12;
            this.contents[n11++] = 0;
            this.contents[n11++] = 0;
            this.contents[n11++] = 0;
            this.contents[n11++] = 6;
            this.contents[n11++] = 0;
            this.contents[n11++] = 1;
            ++n14;
        }
        if ((this.produceAttributes & 4) != 0) {
            int n21;
            n12 = 0;
            n13 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n15 + 8 > this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n15++] = (byte)(n13 >> 8);
            this.contents[n15++] = (byte)n13;
            n11 = n15;
            n15 += 6;
            n9 = 0;
            LocalVariableBinding[] localVariableBindingArray = null;
            n8 = 0;
            n6 = this.codeStream.allLocalsCounter;
            for (n7 = 0; n7 < n6; ++n7) {
                boolean bl2;
                LocalVariableBinding localVariableBinding = this.codeStream.locals[n7];
                TypeBinding typeBinding = localVariableBinding.type;
                boolean bl3 = bl2 = typeBinding.isParameterizedType() || typeBinding.isTypeVariable();
                if (localVariableBinding.initializationCount != 0 && bl2) {
                    if (localVariableBindingArray == null) {
                        localVariableBindingArray = new LocalVariableBinding[n6];
                    }
                    localVariableBindingArray[n9++] = localVariableBinding;
                }
                for (n5 = 0; n5 < localVariableBinding.initializationCount; ++n5) {
                    n4 = localVariableBinding.initializationPCs[n5 << 1];
                    n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                    if (n4 == n3) continue;
                    if (n3 == -1) {
                        localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                    }
                    if (n15 + 10 > this.contents.length) {
                        this.resizeContents(10);
                    }
                    ++n12;
                    if (bl2) {
                        ++n8;
                    }
                    this.contents[n15++] = (byte)(n4 >> 8);
                    this.contents[n15++] = (byte)n4;
                    n2 = n3 - n4;
                    this.contents[n15++] = (byte)(n2 >> 8);
                    this.contents[n15++] = (byte)n2;
                    int n22 = this.constantPool.literalIndex(localVariableBinding.name);
                    this.contents[n15++] = (byte)(n22 >> 8);
                    this.contents[n15++] = (byte)n22;
                    n10 = this.constantPool.literalIndex(typeBinding.signature());
                    this.contents[n15++] = (byte)(n10 >> 8);
                    this.contents[n15++] = (byte)n10;
                    n21 = localVariableBinding.resolvedPosition;
                    this.contents[n15++] = (byte)(n21 >> 8);
                    this.contents[n15++] = (byte)n21;
                }
            }
            n7 = n12 * 10 + 2;
            this.contents[n11++] = (byte)(n7 >> 24);
            this.contents[n11++] = (byte)(n7 >> 16);
            this.contents[n11++] = (byte)(n7 >> 8);
            this.contents[n11++] = (byte)n7;
            this.contents[n11++] = (byte)(n12 >> 8);
            this.contents[n11] = (byte)n12;
            ++n14;
            if (n9 != 0) {
                n6 = 8 + n8 * 10;
                if (n15 + n6 >= this.contents.length) {
                    this.resizeContents(n6);
                }
                int n23 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n15++] = (byte)(n23 >> 8);
                this.contents[n15++] = (byte)n23;
                n7 = n8 * 10 + 2;
                this.contents[n15++] = (byte)(n7 >> 24);
                this.contents[n15++] = (byte)(n7 >> 16);
                this.contents[n15++] = (byte)(n7 >> 8);
                this.contents[n15++] = (byte)n7;
                this.contents[n15++] = (byte)(n8 >> 8);
                this.contents[n15++] = (byte)n8;
                for (int i = 0; i < n9; ++i) {
                    LocalVariableBinding localVariableBinding = localVariableBindingArray[i];
                    for (n5 = 0; n5 < localVariableBinding.initializationCount; ++n5) {
                        n4 = localVariableBinding.initializationPCs[n5 << 1];
                        n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                        if (n4 == n3) continue;
                        this.contents[n15++] = (byte)(n4 >> 8);
                        this.contents[n15++] = (byte)n4;
                        n2 = n3 - n4;
                        this.contents[n15++] = (byte)(n2 >> 8);
                        this.contents[n15++] = (byte)n2;
                        int n24 = this.constantPool.literalIndex(localVariableBinding.name);
                        this.contents[n15++] = (byte)(n24 >> 8);
                        this.contents[n15++] = (byte)n24;
                        n10 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                        this.contents[n15++] = (byte)(n10 >> 8);
                        this.contents[n15++] = (byte)n10;
                        n21 = localVariableBinding.resolvedPosition;
                        this.contents[n15++] = (byte)(n21 >> 8);
                        this.contents[n15++] = (byte)n21;
                    }
                }
                ++n14;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (n11 = (n13 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            int n25;
            ArrayList arrayList = new ArrayList(n13);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n15 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n10 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n15++] = (byte)(n10 >> 8);
            this.contents[n15++] = (byte)n10;
            n9 = n15;
            n11 = 0;
            int n26 = n15 += 4;
            n15 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n27 = arrayList2.size();
            int n28 = 0;
            block74: for (n25 = 0; n25 < n13 && (Integer)arrayList.get(n25) < n18; ++n25) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = null;
                while (n28 < n27) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n28);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n25)) break;
                    ++n28;
                }
                if (stackMapFrame == null) break;
                ++n11;
                n5 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n29;
                        int n30;
                        if (n15 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n4 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n15++] = (byte)(251 + n4);
                        this.contents[n15++] = (byte)(n5 >> 8);
                        this.contents[n15++] = (byte)n5;
                        n3 = stackMapFrame.getIndexOfDifferentLocals(n4);
                        n2 = stackMapFrame.getNumberOfLocals();
                        for (int i = n3; i < stackMapFrame.locals.length && n4 > 0; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n15 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[i]) == null) {
                                this.contents[n15++] = 0;
                                continue;
                            }
                            block12 : switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n15++] = 1;
                                    break;
                                }
                                case 9: {
                                    this.contents[n15++] = 2;
                                    break;
                                }
                                case 7: {
                                    this.contents[n15++] = 4;
                                    ++i;
                                    break;
                                }
                                case 8: {
                                    this.contents[n15++] = 3;
                                    ++i;
                                    break;
                                }
                                case 12: {
                                    this.contents[n15++] = 5;
                                    break;
                                }
                                default: {
                                    this.contents[n15++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n30 = verificationTypeInfo.offset;
                                            this.contents[n15++] = (byte)(n30 >> 8);
                                            this.contents[n15++] = (byte)n30;
                                            break block12;
                                        }
                                        case 7: {
                                            n29 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n15++] = (byte)(n29 >> 8);
                                            this.contents[n15++] = (byte)n29;
                                        }
                                    }
                                }
                            }
                            --n4;
                        }
                        continue block74;
                    }
                    case 0: {
                        if (n15 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n15++] = (byte)n5;
                        continue block74;
                    }
                    case 3: {
                        if (n15 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n15++] = -5;
                        this.contents[n15++] = (byte)(n5 >> 8);
                        this.contents[n15++] = (byte)n5;
                        continue block74;
                    }
                    case 1: {
                        if (n15 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n4 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n15++] = (byte)(251 - n4);
                        this.contents[n15++] = (byte)(n5 >> 8);
                        this.contents[n15++] = (byte)n5;
                        continue block74;
                    }
                    case 5: {
                        int n31;
                        int n30;
                        if (n15 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n15++] = (byte)(n5 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n15++] = 0;
                            continue block74;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n15++] = 1;
                                continue block74;
                            }
                            case 9: {
                                this.contents[n15++] = 2;
                                continue block74;
                            }
                            case 7: {
                                this.contents[n15++] = 4;
                                continue block74;
                            }
                            case 8: {
                                this.contents[n15++] = 3;
                                continue block74;
                            }
                            case 12: {
                                this.contents[n15++] = 5;
                                continue block74;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n15++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n31 = verificationTypeInfo.offset;
                                this.contents[n15++] = (byte)(n31 >> 8);
                                this.contents[n15++] = (byte)n31;
                                break;
                            }
                            case 7: {
                                n30 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n15++] = (byte)(n30 >> 8);
                                this.contents[n15++] = (byte)n30;
                            }
                        }
                        continue block74;
                    }
                    case 6: {
                        int n31;
                        int n30;
                        if (n15 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n15++] = -9;
                        this.contents[n15++] = (byte)(n5 >> 8);
                        this.contents[n15++] = (byte)n5;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n15++] = 0;
                            continue block74;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n15++] = 1;
                                continue block74;
                            }
                            case 9: {
                                this.contents[n15++] = 2;
                                continue block74;
                            }
                            case 7: {
                                this.contents[n15++] = 4;
                                continue block74;
                            }
                            case 8: {
                                this.contents[n15++] = 3;
                                continue block74;
                            }
                            case 12: {
                                this.contents[n15++] = 5;
                                continue block74;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n15++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                n31 = verificationTypeInfo.offset;
                                this.contents[n15++] = (byte)(n31 >> 8);
                                this.contents[n15++] = (byte)n31;
                                break;
                            }
                            case 7: {
                                n30 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n15++] = (byte)(n30 >> 8);
                                this.contents[n15++] = (byte)n30;
                            }
                        }
                        continue block74;
                    }
                    default: {
                        int n32;
                        int n33;
                        if (n15 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n15++] = -1;
                        this.contents[n15++] = (byte)(n5 >> 8);
                        this.contents[n15++] = (byte)n5;
                        int n34 = n15;
                        n15 += 2;
                        int n31 = 0;
                        n2 = stackMapFrame.getNumberOfLocals();
                        int n30 = 0;
                        int n29 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        for (n33 = 0; n33 < n29 && n31 < n2; ++n33) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n15 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n33]) == null) {
                                this.contents[n15++] = 0;
                            } else {
                                block45 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n15++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n15++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n15++] = 4;
                                        ++n33;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n15++] = 3;
                                        ++n33;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n15++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n15++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n35 = verificationTypeInfo.offset;
                                                this.contents[n15++] = (byte)(n35 >> 8);
                                                this.contents[n15++] = (byte)n35;
                                                break block45;
                                            }
                                            case 7: {
                                                n32 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n15++] = (byte)(n32 >> 8);
                                                this.contents[n15++] = (byte)n32;
                                            }
                                        }
                                    }
                                }
                                ++n31;
                            }
                            ++n30;
                        }
                        if (n15 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n34++] = (byte)(n30 >> 8);
                        this.contents[n34] = (byte)n30;
                        n33 = stackMapFrame.numberOfStackItems;
                        this.contents[n15++] = (byte)(n33 >> 8);
                        this.contents[n15++] = (byte)n33;
                        block78: for (int i = 0; i < n33; ++i) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n15 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[i]) == null) {
                                this.contents[n15++] = 0;
                                continue;
                            }
                            switch (verificationTypeInfo.id()) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 10: {
                                    this.contents[n15++] = 1;
                                    continue block78;
                                }
                                case 9: {
                                    this.contents[n15++] = 2;
                                    continue block78;
                                }
                                case 7: {
                                    this.contents[n15++] = 4;
                                    continue block78;
                                }
                                case 8: {
                                    this.contents[n15++] = 3;
                                    continue block78;
                                }
                                case 12: {
                                    this.contents[n15++] = 5;
                                    continue block78;
                                }
                                default: {
                                    this.contents[n15++] = (byte)verificationTypeInfo.tag;
                                    switch (verificationTypeInfo.tag) {
                                        case 8: {
                                            n32 = verificationTypeInfo.offset;
                                            this.contents[n15++] = (byte)(n32 >> 8);
                                            this.contents[n15++] = (byte)n32;
                                            continue block78;
                                        }
                                        case 7: {
                                            int n36 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                            this.contents[n15++] = (byte)(n36 >> 8);
                                            this.contents[n15++] = (byte)n36;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.contents[n26++] = (byte)(n11 >> 8);
            this.contents[n26] = (byte)n11;
            n25 = n15 - n9 - 4;
            this.contents[n9++] = (byte)(n25 >> 24);
            this.contents[n9++] = (byte)(n25 >> 16);
            this.contents[n9++] = (byte)(n25 >> 8);
            this.contents[n9] = (byte)n25;
            ++n14;
        }
        if (n20 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n20++] = (byte)(n14 >> 8);
        this.contents[n20] = (byte)n14;
        int n37 = n15 - (n + 6);
        this.contents[n + 2] = (byte)(n37 >> 24);
        this.contents[n + 3] = (byte)(n37 >> 16);
        this.contents[n + 4] = (byte)(n37 >> 8);
        this.contents[n + 5] = (byte)n37;
        this.contentsOffset = n15;
    }

    public void completeCodeAttributeForSyntheticMethod(SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        this.completeCodeAttributeForSyntheticMethod(false, syntheticMethodBinding, n, nArray);
    }

    public void completeMethodInfo(int n, int n2) {
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public char[] fileName() {
        return this.constantPool.UTF8Cache.returnKeyFor(2);
    }

    private void generateAnnotation(Annotation annotation, int n) {
        TypeBinding typeBinding;
        if (this.contentsOffset + 4 >= this.contents.length) {
            this.resizeContents(4);
        }
        if ((typeBinding = annotation.resolvedType) == null) {
            this.contentsOffset = n;
            return;
        }
        int n2 = this.constantPool.literalIndex(typeBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairArray = normalAnnotation.memberValuePairs;
            if (memberValuePairArray != null) {
                int n3 = memberValuePairArray.length;
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                for (int i = 0; i < n3; ++i) {
                    MemberValuePair memberValuePair = memberValuePairArray[i];
                    if (this.contentsOffset + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    int n4 = this.constantPool.literalIndex(memberValuePair.name);
                    this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n4;
                    MethodBinding methodBinding = memberValuePair.binding;
                    if (methodBinding == null) {
                        this.contentsOffset = n;
                        continue;
                    }
                    this.generateElementValue(memberValuePair.value, methodBinding.returnType, n);
                }
            } else {
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 1;
            if (this.contentsOffset + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            int n5 = this.constantPool.literalIndex(VALUE);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
            this.contents[this.contentsOffset++] = (byte)n5;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                this.contentsOffset = n;
            } else {
                this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType, n);
            }
        } else {
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
        }
    }

    public void generateCodeAttributeHeader() {
        if (this.contentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n = this.constantPool.literalIndex(AttributeNamesConstants.CodeName);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.contentsOffset += 12;
    }

    private void generateElementValue(Expression expression, TypeBinding typeBinding, int n) {
        Constant constant = expression.constant;
        TypeBinding typeBinding2 = expression.resolvedType;
        if (typeBinding2 == null) {
            this.contentsOffset = n;
        } else {
            if (typeBinding.isArrayType() && !typeBinding2.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 1;
            }
            if (constant != null && constant != Constant.NotAConstant) {
                this.generateElementValue(n, expression, constant, typeBinding.leafComponentType());
            } else {
                this.generateElementValueForNonConstantExpression(expression, n, typeBinding2);
            }
        }
    }

    private void generateElementValue(int n, Expression expression, Constant constant, TypeBinding typeBinding) {
        if (this.contentsOffset + 3 >= this.contents.length) {
            this.resizeContents(3);
        }
        switch (typeBinding.id) {
            case 5: {
                this.contents[this.contentsOffset++] = 90;
                int n2 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                this.contents[this.contentsOffset++] = (byte)n2;
                break;
            }
            case 3: {
                this.contents[this.contentsOffset++] = 66;
                int n3 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                break;
            }
            case 2: {
                this.contents[this.contentsOffset++] = 67;
                int n4 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                this.contents[this.contentsOffset++] = (byte)n4;
                break;
            }
            case 10: {
                this.contents[this.contentsOffset++] = 73;
                int n5 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                this.contents[this.contentsOffset++] = (byte)n5;
                break;
            }
            case 4: {
                this.contents[this.contentsOffset++] = 83;
                int n6 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                this.contents[this.contentsOffset++] = (byte)n6;
                break;
            }
            case 9: {
                this.contents[this.contentsOffset++] = 70;
                int n7 = this.constantPool.literalIndex(constant.floatValue());
                this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                this.contents[this.contentsOffset++] = (byte)n7;
                break;
            }
            case 8: {
                this.contents[this.contentsOffset++] = 68;
                int n8 = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                this.contents[this.contentsOffset++] = (byte)n8;
                break;
            }
            case 7: {
                this.contents[this.contentsOffset++] = 74;
                int n9 = this.constantPool.literalIndex(constant.longValue());
                this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                this.contents[this.contentsOffset++] = (byte)n9;
                break;
            }
            case 11: {
                this.contents[this.contentsOffset++] = 115;
                int n10 = this.constantPool.literalIndex(((StringConstant)constant).stringValue().toCharArray());
                if (n10 == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(expression);
                        break;
                    }
                    this.contentsOffset = n;
                    break;
                }
                this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
                this.contents[this.contentsOffset++] = (byte)n10;
            }
        }
    }

    private void generateElementValueForNonConstantExpression(Expression expression, int n, TypeBinding typeBinding) {
        if (typeBinding != null) {
            if (typeBinding.isEnum()) {
                NameReference nameReference;
                if (this.contentsOffset + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[this.contentsOffset++] = 101;
                FieldBinding fieldBinding = null;
                if (expression instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)expression;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (expression instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)expression;
                    fieldBinding = (FieldBinding)((SingleNameReference)nameReference).binding;
                } else {
                    this.contentsOffset = n;
                }
                if (fieldBinding != null) {
                    int n2 = this.constantPool.literalIndex(fieldBinding.type.signature());
                    int n3 = this.constantPool.literalIndex(fieldBinding.name);
                    this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n2;
                    this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n3;
                }
            } else if (typeBinding.isAnnotationType()) {
                if (this.contentsOffset + 1 >= this.contents.length) {
                    this.resizeContents(1);
                }
                this.contents[this.contentsOffset++] = 64;
                this.generateAnnotation((Annotation)expression, n);
            } else if (typeBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    int n4 = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n4;
                    for (int i = 0; i < n4; ++i) {
                        this.generateElementValue(arrayInitializer.expressions[i], typeBinding.leafComponentType(), n);
                    }
                } else {
                    this.contentsOffset = n;
                }
            } else {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 99;
                if (expression instanceof ClassLiteralAccess) {
                    ClassLiteralAccess classLiteralAccess = (ClassLiteralAccess)expression;
                    int n5 = this.constantPool.literalIndex(classLiteralAccess.targetType.signature());
                    this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n5;
                } else {
                    this.contentsOffset = n;
                }
            }
        } else {
            this.contentsOffset = n;
        }
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding) {
        return this.generateMethodInfoAttribute(methodBinding, false);
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, AnnotationMethodDeclaration annotationMethodDeclaration) {
        int n = this.generateMethodInfoAttribute(methodBinding);
        int n2 = this.contentsOffset;
        if ((annotationMethodDeclaration.modifiers & 0x20000) != 0) {
            int n3 = this.constantPool.literalIndex(AttributeNamesConstants.AnnotationDefaultName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            int n4 = this.contentsOffset;
            this.contentsOffset += 4;
            if (this.contentsOffset + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            this.generateElementValue(annotationMethodDeclaration.defaultValue, annotationMethodDeclaration.binding.returnType, n2);
            if (this.contentsOffset != n2) {
                int n5 = this.contentsOffset - n4 - 4;
                this.contents[n4++] = (byte)(n5 >> 24);
                this.contents[n4++] = (byte)(n5 >> 16);
                this.contents[n4++] = (byte)(n5 >> 8);
                this.contents[n4++] = (byte)n5;
                ++n;
            }
        }
        return n;
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, boolean bl) {
        AbstractMethodDeclaration abstractMethodDeclaration;
        char[] cArray;
        int n;
        int n2;
        int n3;
        this.contentsOffset += 2;
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            n3 = referenceBindingArray.length;
            n2 = 8 + n3 * 2;
            if (n2 + this.contentsOffset >= this.contents.length) {
                this.resizeContents(n2);
            }
            n = this.constantPool.literalIndex(AttributeNamesConstants.ExceptionsName);
            this.contents[this.contentsOffset++] = (byte)(n >> 8);
            this.contents[this.contentsOffset++] = (byte)n;
            int n5 = n3 * 2 + 2;
            this.contents[this.contentsOffset++] = (byte)(n5 >> 24);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 16);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
            this.contents[this.contentsOffset++] = (byte)n5;
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            for (int i = 0; i < n3; ++i) {
                int n6 = this.constantPool.literalIndexForType(referenceBindingArray[i].constantPoolName());
                this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                this.contents[this.contentsOffset++] = (byte)n6;
            }
            ++n4;
        }
        if (methodBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n4;
        }
        if (this.targetJDK < 0x310000L && methodBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n4;
        }
        if ((cArray = methodBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n2 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
            this.contents[this.contentsOffset++] = (byte)n2;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n >> 8);
            this.contents[this.contentsOffset++] = (byte)n;
            ++n4;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && !bl && (abstractMethodDeclaration = methodBinding.sourceMethod()) != null) {
            Argument[] argumentArray;
            Annotation[] annotationArray = abstractMethodDeclaration.annotations;
            if (annotationArray != null) {
                n4 += this.generateRuntimeAnnotations(annotationArray);
            }
            if ((methodBinding.tagBits & 0x400L) != 0L && (argumentArray = abstractMethodDeclaration.arguments) != null) {
                n4 += this.generateRuntimeAnnotationsForParameters(argumentArray);
            }
        }
        return n4;
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers);
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding, int n) {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEFFF;
        }
        if ((methodBinding.tagBits & 0x400L) != 0L) {
            n &= 0xFFFFFFFD;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(methodBinding.selector);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(methodBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
    }

    public void generateMethodInfoHeaderForClinit() {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 8;
        int n = this.constantPool.literalIndex(ConstantPool.Clinit);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(ConstantPool.ClinitSignature);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 1;
    }

    public void generateMissingAbstractMethods(MethodDeclaration[] methodDeclarationArray, CompilationResult compilationResult) {
        if (methodDeclarationArray != null) {
            for (MethodDeclaration methodDeclaration : methodDeclarationArray) {
                MethodBinding methodBinding = methodDeclaration.binding;
                String string = new String(methodBinding.readableName());
                CategorizedProblem[] categorizedProblemArray = compilationResult.problems;
                int n = compilationResult.problemCount;
                for (int i = 0; i < n; ++i) {
                    CategorizedProblem categorizedProblem = categorizedProblemArray[i];
                    if (categorizedProblem == null || categorizedProblem.getID() != 67109264 || categorizedProblem.getMessage().indexOf(string) == -1) continue;
                    this.addMissingAbstractProblemMethod(methodDeclaration, methodBinding, categorizedProblem, compilationResult);
                }
            }
        }
    }

    private int generateRuntimeAnnotations(Annotation[] annotationArray) {
        Annotation annotation;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = annotationArray.length;
        int n7 = 0;
        int n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            Annotation annotation2 = annotationArray[n4];
            if (this.isRuntimeInvisible(annotation2)) {
                ++n8;
                continue;
            }
            if (!this.isRuntimeVisible(annotation2)) continue;
            ++n7;
        }
        if (n8 != 0) {
            n4 = this.contentsOffset;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int n9 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
            this.contents[this.contentsOffset++] = (byte)n9;
            n3 = this.contentsOffset;
            this.contentsOffset += 4;
            n2 = this.contentsOffset;
            this.contentsOffset += 2;
            this.contents[n2++] = (byte)(n8 >> 8);
            this.contents[n2++] = (byte)n8;
            for (n = 0; n < n6 && n8 != 0; ++n) {
                annotation = annotationArray[n];
                if (!this.isRuntimeInvisible(annotation)) continue;
                this.generateAnnotation(annotation, n4);
                --n8;
                if (this.contentsOffset == n4) break;
            }
            if (this.contentsOffset != n4) {
                n = this.contentsOffset - n3 - 4;
                this.contents[n3++] = (byte)(n >> 24);
                this.contents[n3++] = (byte)(n >> 16);
                this.contents[n3++] = (byte)(n >> 8);
                this.contents[n3++] = (byte)n;
                ++n5;
            } else {
                this.contentsOffset = n4;
            }
        }
        if (n7 != 0) {
            n4 = this.contentsOffset;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int n10 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
            this.contents[this.contentsOffset++] = (byte)n10;
            n3 = this.contentsOffset;
            this.contentsOffset += 4;
            n2 = this.contentsOffset;
            this.contentsOffset += 2;
            this.contents[n2++] = (byte)(n7 >> 8);
            this.contents[n2++] = (byte)n7;
            for (n = 0; n < n6 && n7 != 0; ++n) {
                annotation = annotationArray[n];
                if (!this.isRuntimeVisible(annotation)) continue;
                --n7;
                this.generateAnnotation(annotation, n4);
                if (this.contentsOffset == n4) break;
            }
            if (this.contentsOffset != n4) {
                n = this.contentsOffset - n3 - 4;
                this.contents[n3++] = (byte)(n >> 24);
                this.contents[n3++] = (byte)(n >> 16);
                this.contents[n3++] = (byte)(n >> 8);
                this.contents[n3++] = (byte)n;
                ++n5;
            } else {
                this.contentsOffset = n4;
            }
        }
        return n5;
    }

    private int generateRuntimeAnnotationsForParameters(Argument[] argumentArray) {
        Argument argument;
        int n;
        int n2;
        int n3;
        int n4 = argumentArray.length;
        int n5 = 0;
        int n6 = 0;
        int[][] nArray = new int[n4][2];
        for (n3 = 0; n3 < n4; ++n3) {
            Argument argument2 = argumentArray[n3];
            Annotation[] annotationArray = argument2.annotations;
            if (annotationArray == null) continue;
            for (Annotation annotation : annotationArray) {
                if (this.isRuntimeInvisible(annotation)) {
                    int[] nArray2 = nArray[n3];
                    nArray2[1] = nArray2[1] + 1;
                    ++n5;
                    continue;
                }
                if (!this.isRuntimeVisible(annotation)) continue;
                int[] nArray3 = nArray[n3];
                nArray3[0] = nArray3[0] + 1;
                ++n6;
            }
        }
        n3 = 0;
        int n7 = this.contentsOffset;
        if (n5 != 0) {
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            int n8 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
            this.contents[this.contentsOffset++] = (byte)n8;
            n2 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n4;
            block2: for (n = 0; n < n4; ++n) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n5 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                    continue;
                }
                int n9 = nArray[n][1];
                this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                this.contents[this.contentsOffset++] = (byte)n9;
                if (n9 == 0) continue;
                argument = argumentArray[n];
                for (Annotation annotation : argument.annotations) {
                    if (!this.isRuntimeInvisible(annotation)) continue;
                    this.generateAnnotation(annotation, n7);
                    if (this.contentsOffset == n7) break block2;
                    --n5;
                }
            }
            if (this.contentsOffset != n7) {
                n = this.contentsOffset - n2 - 4;
                this.contents[n2++] = (byte)(n >> 24);
                this.contents[n2++] = (byte)(n >> 16);
                this.contents[n2++] = (byte)(n >> 8);
                this.contents[n2++] = (byte)n;
                ++n3;
            } else {
                this.contentsOffset = n7;
            }
        }
        if (n6 != 0) {
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            int n10 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
            this.contents[this.contentsOffset++] = (byte)n10;
            n2 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n4;
            block4: for (n = 0; n < n4; ++n) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n6 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                    continue;
                }
                int n11 = nArray[n][0];
                this.contents[this.contentsOffset++] = (byte)(n11 >> 8);
                this.contents[this.contentsOffset++] = (byte)n11;
                if (n11 == 0) continue;
                argument = argumentArray[n];
                for (Annotation annotation : argument.annotations) {
                    if (!this.isRuntimeVisible(annotation)) continue;
                    this.generateAnnotation(annotation, n7);
                    if (this.contentsOffset == n7) break block4;
                    --n6;
                }
            }
            if (this.contentsOffset != n7) {
                n = this.contentsOffset - n2 - 4;
                this.contents[n2++] = (byte)(n >> 24);
                this.contents[n2++] = (byte)(n >> 16);
                this.contents[n2++] = (byte)(n >> 8);
                this.contents[n2++] = (byte)n;
                ++n3;
            } else {
                this.contentsOffset = n7;
            }
        }
        return n3;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = new byte[this.headerOffset + this.contentsOffset];
            System.arraycopy(this.header, 0, this.bytes, 0, this.headerOffset);
            System.arraycopy(this.contents, 0, this.bytes, this.headerOffset, this.contentsOffset);
        }
        return this.bytes;
    }

    public char[][] getCompoundName() {
        return CharOperation.splitOn('/', this.fileName());
    }

    protected void initByteArrays() {
        int n = this.referenceBinding.methods().length + this.referenceBinding.fields().length;
        this.header = new byte[1500];
        this.contents = new byte[n < 15 ? 400 : 1500];
    }

    public void initialize(SourceTypeBinding sourceTypeBinding, ClassFile classFile, boolean bl) {
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 8);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 0);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 24);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 16);
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool.initialize(this);
        int n = sourceTypeBinding.getAccessFlags();
        if (sourceTypeBinding.isPrivate()) {
            n &= 0xFFFFFFFE;
        }
        if (sourceTypeBinding.isProtected()) {
            n |= 1;
        }
        n &= 0xFFFFF6D1;
        if (!sourceTypeBinding.isInterface()) {
            n |= 0x20;
        }
        this.enclosingClassFile = classFile;
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndexForType(sourceTypeBinding.constantPoolName());
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = sourceTypeBinding.isInterface() ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : (sourceTypeBinding.superclass == null ? 0 : this.constantPool.literalIndexForType(sourceTypeBinding.superclass.constantPoolName()));
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces();
        int n4 = referenceBindingArray.length;
        this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
        this.contents[this.contentsOffset++] = (byte)n4;
        for (int i = 0; i < n4; ++i) {
            int n5 = this.constantPool.literalIndexForType(referenceBindingArray[i].constantPoolName());
            this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
            this.contents[this.contentsOffset++] = (byte)n5;
        }
        this.innerClassesBindings = new ReferenceBinding[5];
        this.creatingProblemType = bl;
        if (this.enclosingClassFile == null) {
            this.codeStream.maxFieldCount = sourceTypeBinding.scope.referenceType().maxFieldCount;
        } else {
            ClassFile classFile2 = this.outerMostEnclosingClassFile();
            this.codeStream.maxFieldCount = classFile2.codeStream.maxFieldCount;
        }
    }

    private boolean isRuntimeInvisible(Annotation annotation) {
        TypeBinding typeBinding = annotation.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x180000000000L) == 0L) {
            return true;
        }
        return (l & 0x180000000000L) == 0x100000000000L;
    }

    private boolean isRuntimeVisible(Annotation annotation) {
        TypeBinding typeBinding = annotation.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x180000000000L) == 0L) {
            return false;
        }
        return (l & 0x180000000000L) == 0x180000000000L;
    }

    public ClassFile outerMostEnclosingClassFile() {
        ClassFile classFile = this;
        while (classFile.enclosingClassFile != null) {
            classFile = classFile.enclosingClassFile;
        }
        return classFile;
    }

    public void recordEnclosingTypeAttributes(ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2;
        int n = 0;
        for (referenceBinding2 = this.referenceBinding.enclosingType(); referenceBinding2 != null; referenceBinding2 = referenceBinding2.enclosingType()) {
            ++n;
        }
        referenceBinding2 = this.referenceBinding;
        if (n >= 2) {
            int n2;
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
            for (n2 = n - 1; n2 >= 0; --n2) {
                referenceBindingArray[n2] = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.addInnerClasses(referenceBindingArray[n2]);
            }
        } else {
            this.addInnerClasses(this.referenceBinding);
        }
    }

    public void recordNestedLocalAttribute(ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2;
        int n = 0;
        for (referenceBinding2 = this.referenceBinding.enclosingType(); referenceBinding2 != null; referenceBinding2 = referenceBinding2.enclosingType()) {
            ++n;
        }
        referenceBinding2 = this.referenceBinding;
        if (n >= 2) {
            int n2;
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
            for (n2 = n - 1; n2 >= 0; --n2) {
                referenceBindingArray[n2] = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.addInnerClasses(referenceBindingArray[n2]);
            }
        } else {
            this.addInnerClasses(referenceBinding);
        }
    }

    public void recordNestedMemberAttribute(ReferenceBinding referenceBinding) {
        this.addInnerClasses(referenceBinding);
    }

    public void reset(SourceTypeBinding sourceTypeBinding) {
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.referenceBinding = sourceTypeBinding;
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
        }
        this.bytes = null;
        this.constantPool.reset();
        this.codeStream.reset(this);
        this.constantPoolOffset = 0;
        this.contentsOffset = 0;
        this.creatingProblemType = false;
        this.enclosingClassFile = null;
        this.headerOffset = 0;
        this.methodCount = 0;
        this.methodCountOffset = 0;
        this.numberOfInnerClasses = 0;
    }

    private final void resizeContents(int n) {
        int n2 = this.contents.length;
        int n3 = n2;
        if (n3 < n) {
            n3 = n;
        }
        this.contents = new byte[n2 + n3];
        System.arraycopy(this.contents, 0, this.contents, 0, n2);
    }

    public void setForMethodInfos() {
        this.methodCountOffset = this.contentsOffset;
        this.contentsOffset += 2;
    }
}

