/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    private int targetOffset = 0;
    protected String methodName = null;
    protected int paramCount = 0;
    protected Class[] paramTypes = null;
    private String[] paramClassNames = null;
    protected boolean useExactMatch = false;

    public CallMethodRule(Digester digester, String string, int n) {
        this(string, n);
    }

    public CallMethodRule(Digester digester, String string, int n, String[] stringArray) {
        this(string, n, stringArray);
    }

    public CallMethodRule(Digester digester, String string, int n, Class[] classArray) {
        this(string, n, classArray);
    }

    public CallMethodRule(String string, int n) {
        this(0, string, n);
    }

    public CallMethodRule(int n, String string, int n2) {
        this.targetOffset = n;
        this.methodName = string;
        this.paramCount = n2;
        if (n2 == 0) {
            this.paramTypes = new Class[]{String.class};
        } else {
            this.paramTypes = new Class[n2];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                this.paramTypes[i] = String.class;
            }
        }
    }

    public CallMethodRule(String string) {
        this(0, string, 0, (Class[])null);
    }

    public CallMethodRule(int n, String string) {
        this(n, string, 0, (Class[])null);
    }

    public CallMethodRule(String string, int n, String[] stringArray) {
        this(0, string, n, stringArray);
    }

    public CallMethodRule(int n, String string, int n2, String[] stringArray) {
        this.targetOffset = n;
        this.methodName = string;
        this.paramCount = n2;
        if (stringArray == null) {
            this.paramTypes = new Class[n2];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                this.paramTypes[i] = String.class;
            }
        } else {
            this.paramClassNames = new String[stringArray.length];
            for (int i = 0; i < this.paramClassNames.length; ++i) {
                this.paramClassNames[i] = stringArray[i];
            }
        }
    }

    public CallMethodRule(String string, int n, Class[] classArray) {
        this(0, string, n, classArray);
    }

    public CallMethodRule(int n, String string, int n2, Class[] classArray) {
        this.targetOffset = n;
        this.methodName = string;
        this.paramCount = n2;
        if (classArray == null) {
            this.paramTypes = new Class[n2];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                this.paramTypes[i] = String.class;
            }
        } else {
            this.paramTypes = new Class[classArray.length];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                this.paramTypes[i] = classArray[i];
            }
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean bl) {
        this.useExactMatch = bl;
    }

    @Override
    public void setDigester(Digester digester) {
        super.setDigester(digester);
        if (this.paramClassNames != null) {
            this.paramTypes = new Class[this.paramClassNames.length];
            for (int i = 0; i < this.paramClassNames.length; ++i) {
                try {
                    this.paramTypes[i] = digester.getClassLoader().loadClass(this.paramClassNames[i]);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    digester.getLogger().error("(CallMethodRule) Cannot load class " + this.paramClassNames[i], classNotFoundException);
                    this.paramTypes[i] = null;
                }
            }
        }
    }

    @Override
    public void begin(Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            Object[] objectArray = new Object[this.paramCount];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
            this.digester.pushParams(objectArray);
        }
    }

    @Override
    public void body(String string) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = string.trim();
        }
    }

    @Override
    public void end() throws Exception {
        Object object;
        int n;
        Object[] objectArray = null;
        if (this.paramCount > 0) {
            objectArray = (Object[])this.digester.popParams();
            if (this.digester.log.isTraceEnabled()) {
                n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.digester.log.trace("[CallMethodRule](" + i + ")" + objectArray[i]);
                }
            }
            if (this.paramCount == 1 && objectArray[0] == null) {
                return;
            }
        } else if (this.paramTypes != null && this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            objectArray = new Object[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[1];
                this.paramTypes[0] = String.class;
            }
        }
        Object[] objectArray2 = new Object[this.paramTypes.length];
        for (n = 0; n < this.paramTypes.length; ++n) {
            objectArray2[n] = objectArray[n] == null || objectArray[n] instanceof String && !String.class.isAssignableFrom(this.paramTypes[n]) ? ConvertUtils.convert((String)objectArray[n], this.paramTypes[n]) : objectArray[n];
        }
        Object object2 = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (object2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[CallMethodRule]{");
            stringBuffer.append(this.digester.match);
            stringBuffer.append("} Call target is null (");
            stringBuffer.append("targetOffset=");
            stringBuffer.append(this.targetOffset);
            stringBuffer.append(",stackdepth=");
            stringBuffer.append(this.digester.getCount());
            stringBuffer.append(")");
            throw new SAXException(stringBuffer.toString());
        }
        if (this.digester.log.isDebugEnabled()) {
            object = new StringBuffer("[CallMethodRule]{");
            ((StringBuffer)object).append(this.digester.match);
            ((StringBuffer)object).append("} Call ");
            ((StringBuffer)object).append(object2.getClass().getName());
            ((StringBuffer)object).append(".");
            ((StringBuffer)object).append(this.methodName);
            ((StringBuffer)object).append("(");
            for (int i = 0; i < objectArray2.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object).append(",");
                }
                if (objectArray2[i] == null) {
                    ((StringBuffer)object).append("null");
                } else {
                    ((StringBuffer)object).append(objectArray2[i].toString());
                }
                ((StringBuffer)object).append("/");
                if (this.paramTypes[i] == null) {
                    ((StringBuffer)object).append("null");
                    continue;
                }
                ((StringBuffer)object).append(this.paramTypes[i].getName());
            }
            ((StringBuffer)object).append(")");
            this.digester.log.debug(((StringBuffer)object).toString());
        }
        object = null;
        object = this.useExactMatch ? MethodUtils.invokeExactMethod(object2, this.methodName, objectArray2, this.paramTypes) : MethodUtils.invokeMethod(object2, this.methodName, objectArray2, this.paramTypes);
        this.processMethodCallResult(object);
    }

    @Override
    public void finish() throws Exception {
        this.bodyText = null;
    }

    protected void processMethodCallResult(Object object) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CallMethodRule[");
        stringBuffer.append("methodName=");
        stringBuffer.append(this.methodName);
        stringBuffer.append(", paramCount=");
        stringBuffer.append(this.paramCount);
        stringBuffer.append(", paramTypes={");
        if (this.paramTypes != null) {
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.paramTypes[i].getName());
            }
        }
        stringBuffer.append("}");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

