/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.sql.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class SqlDateConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public SqlDateConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public SqlDateConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (object instanceof Date) {
            return object;
        }
        try {
            return Date.valueOf(object.toString());
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(exception);
        }
    }
}

