/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class BooleanArrayConverter
extends AbstractArrayConverter {
    private static boolean[] model = new boolean[0];

    public BooleanArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public BooleanArrayConverter(Object object) {
        this.defaultValue = object;
        this.useDefault = true;
    }

    @Override
    public Object convert(Class clazz, Object object) {
        if (object == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == object.getClass()) {
            return object;
        }
        if (strings.getClass() == object.getClass()) {
            try {
                String[] stringArray = (String[])object;
                boolean[] blArray = new boolean[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1")) {
                        blArray[i] = true;
                        continue;
                    }
                    if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0")) {
                        blArray[i] = false;
                        continue;
                    }
                    if (this.useDefault) {
                        return this.defaultValue;
                    }
                    throw new ConversionException(object.toString());
                }
                return blArray;
            }
            catch (Exception exception) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString(), exception);
            }
        }
        try {
            List list = this.parseElements(object.toString());
            boolean[] blArray = new boolean[list.size()];
            for (int i = 0; i < blArray.length; ++i) {
                String string = (String)list.get(i);
                if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1")) {
                    blArray[i] = true;
                    continue;
                }
                if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0")) {
                    blArray[i] = false;
                    continue;
                }
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(object.toString());
            }
            return blArray;
        }
        catch (Exception exception) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(object.toString(), exception);
        }
    }
}

