/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;

public class JasperViewer
extends JFrame {
    private JRViewer viewer = null;
    private boolean isExitOnClose = true;
    private JPanel pnlMain;

    public JasperViewer(String string, boolean bl) throws JRException {
        this(string, bl, true);
    }

    public JasperViewer(InputStream inputStream, boolean bl) throws JRException {
        this(inputStream, bl, true);
    }

    public JasperViewer(JasperPrint jasperPrint) {
        this(jasperPrint, true);
    }

    public JasperViewer(String string, boolean bl, boolean bl2) throws JRException {
        this(string, bl, bl2, null);
    }

    public JasperViewer(InputStream inputStream, boolean bl, boolean bl2) throws JRException {
        this(inputStream, bl, bl2, null);
    }

    public JasperViewer(JasperPrint jasperPrint, boolean bl) {
        this(jasperPrint, bl, null);
    }

    public JasperViewer(String string, boolean bl, boolean bl2, Locale locale) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = bl2;
        this.initComponents();
        this.viewer = new JRViewer(string, bl, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(InputStream inputStream, boolean bl, boolean bl2, Locale locale) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = bl2;
        this.initComponents();
        this.viewer = new JRViewer(inputStream, bl, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(JasperPrint jasperPrint, boolean bl, Locale locale) {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = bl;
        this.initComponents();
        this.viewer = new JRViewer(jasperPrint, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    private void initComponents() {
        int n;
        this.pnlMain = new JPanel();
        this.setTitle("JasperViewer");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/jricon.GIF")).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JasperViewer.this.exitForm();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n2 = toolkit.getScreenResolution();
        float f = (float)n2 / 72.0f;
        int n3 = (int)(550.0f * f);
        if ((double)n3 > dimension.getHeight()) {
            n3 = (int)dimension.getHeight();
        }
        if ((double)(n = (int)(750.0f * f)) > dimension.getWidth()) {
            n = (int)dimension.getWidth();
        }
        Dimension dimension2 = new Dimension(n, n3);
        this.setSize(dimension2);
        this.setLocation((dimension.width - n) / 2, (dimension.height - n3) / 2);
    }

    void exitForm() {
        if (this.isExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.viewer.clear();
            this.viewer = null;
            this.getContentPane().removeAll();
            this.dispose();
        }
    }

    public void setZoomRatio(float f) {
        this.viewer.setZoomRatio(f);
    }

    public void setFitWidthZoomRatio() {
        this.viewer.setFitWidthZoomRatio();
    }

    public void setFitPageZoomRatio() {
        this.viewer.setFitPageZoomRatio();
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            JasperViewer.usage();
            return;
        }
        for (int i = 0; stringArray.length > i; ++i) {
            if (stringArray[i].startsWith("-F")) {
                string = stringArray[i].substring(2);
            }
            if (!stringArray[i].startsWith("-XML")) continue;
            bl = true;
        }
        try {
            JasperViewer.viewReport(string, bl);
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("JasperViewer usage:");
        System.out.println("\tjava JasperViewer -XML -Ffile");
    }

    public static void viewReport(String string, boolean bl) throws JRException {
        JasperViewer.viewReport(string, bl, true, null);
    }

    public static void viewReport(InputStream inputStream, boolean bl) throws JRException {
        JasperViewer.viewReport(inputStream, bl, true, null);
    }

    public static void viewReport(JasperPrint jasperPrint) {
        JasperViewer.viewReport(jasperPrint, true, null);
    }

    public static void viewReport(String string, boolean bl, boolean bl2) throws JRException {
        JasperViewer.viewReport(string, bl, bl2, null);
    }

    public static void viewReport(InputStream inputStream, boolean bl, boolean bl2) throws JRException {
        JasperViewer.viewReport(inputStream, bl, bl2, null);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean bl) {
        JasperViewer.viewReport(jasperPrint, bl, null);
    }

    public static void viewReport(String string, boolean bl, boolean bl2, Locale locale) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(string, bl, bl2, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(InputStream inputStream, boolean bl, boolean bl2, Locale locale) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(inputStream, bl, bl2, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean bl, Locale locale) {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint, bl, locale);
        jasperViewer.setVisible(true);
    }
}

