/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRBoxFactory;
import net.sf.jasperreports.engine.xml.JRPrintElementFactory;
import net.sf.jasperreports.engine.xml.JRPrintEllipseFactory;
import net.sf.jasperreports.engine.xml.JRPrintFontFactory;
import net.sf.jasperreports.engine.xml.JRPrintFrameFactory;
import net.sf.jasperreports.engine.xml.JRPrintGraphicElementFactory;
import net.sf.jasperreports.engine.xml.JRPrintHyperlinkParameterFactory;
import net.sf.jasperreports.engine.xml.JRPrintHyperlinkParameterValueFactory;
import net.sf.jasperreports.engine.xml.JRPrintImageFactory;
import net.sf.jasperreports.engine.xml.JRPrintImageSourceFactory;
import net.sf.jasperreports.engine.xml.JRPrintLineFactory;
import net.sf.jasperreports.engine.xml.JRPrintPageFactory;
import net.sf.jasperreports.engine.xml.JRPrintRectangleFactory;
import net.sf.jasperreports.engine.xml.JRPrintTextFactory;
import net.sf.jasperreports.engine.xml.JRReportFontFactory;
import net.sf.jasperreports.engine.xml.JRStyleFactory;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.JasperPrintFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.SetNestedPropertiesRule;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class JRPrintXmlLoader
implements ErrorHandler {
    private JasperPrint jasperPrint = null;
    private List errors = new ArrayList();

    protected JRPrintXmlLoader() {
    }

    public void setJasperPrint(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
    }

    public static JasperPrint load(String string) throws JRException {
        JasperPrint jasperPrint = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            JRPrintXmlLoader jRPrintXmlLoader = new JRPrintXmlLoader();
            jasperPrint = jRPrintXmlLoader.loadXML(fileInputStream);
        }
        catch (IOException iOException) {
            throw new JRException(iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return jasperPrint;
    }

    public static JasperPrint load(InputStream inputStream) throws JRException {
        JasperPrint jasperPrint = null;
        JRPrintXmlLoader jRPrintXmlLoader = new JRPrintXmlLoader();
        jasperPrint = jRPrintXmlLoader.loadXML(inputStream);
        return jasperPrint;
    }

    private JasperPrint loadXML(InputStream inputStream) throws JRException {
        Object object;
        try {
            object = this.prepareDigester();
            ((Digester)object).parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JRException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new JRException(sAXException);
        }
        catch (IOException iOException) {
            throw new JRException(iOException);
        }
        if (this.errors.size() > 0) {
            object = (Exception)this.errors.get(0);
            if (object instanceof JRException) {
                throw (JRException)object;
            }
            throw new JRException((Throwable)object);
        }
        return this.jasperPrint;
    }

    private JRXmlDigester prepareDigester() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        boolean bl = JRProperties.getBooleanProperty("net.sf.jasperreports.export.xml.validation");
        sAXParserFactory.setValidating(bl);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setFeature("http://xml.org/sax/features/validation", bl);
        JRXmlDigester jRXmlDigester = new JRXmlDigester(xMLReader);
        jRXmlDigester.push(this);
        jRXmlDigester.setErrorHandler(this);
        jRXmlDigester.setValidating(true);
        jRXmlDigester.addFactoryCreate("jasperPrint", JasperPrintFactory.class.getName());
        jRXmlDigester.addSetNext("jasperPrint", "setJasperPrint", JasperPrint.class.getName());
        jRXmlDigester.addFactoryCreate("jasperPrint/reportFont", JRReportFontFactory.class.getName());
        jRXmlDigester.addSetNext("jasperPrint/reportFont", "addFont", JRReportFont.class.getName());
        jRXmlDigester.addFactoryCreate("jasperPrint/style", JRStyleFactory.class.getName());
        jRXmlDigester.addSetNext("jasperPrint/style", "addStyle", JRStyle.class.getName());
        jRXmlDigester.addFactoryCreate("jasperPrint/page", JRPrintPageFactory.class.getName());
        jRXmlDigester.addSetNext("jasperPrint/page", "addPage", JRPrintPage.class.getName());
        jRXmlDigester.addFactoryCreate("*/line", JRPrintLineFactory.class.getName());
        jRXmlDigester.addSetNext("*/line", "addElement", JRPrintElement.class.getName());
        jRXmlDigester.addFactoryCreate("*/reportElement", JRPrintElementFactory.class.getName());
        jRXmlDigester.addFactoryCreate("*/graphicElement", JRPrintGraphicElementFactory.class.getName());
        jRXmlDigester.addFactoryCreate("*/rectangle", JRPrintRectangleFactory.class.getName());
        jRXmlDigester.addSetNext("*/rectangle", "addElement", JRPrintElement.class.getName());
        jRXmlDigester.addFactoryCreate("*/ellipse", JRPrintEllipseFactory.class.getName());
        jRXmlDigester.addSetNext("*/ellipse", "addElement", JRPrintElement.class.getName());
        jRXmlDigester.addFactoryCreate("*/image", JRPrintImageFactory.class.getName());
        jRXmlDigester.addSetNext("*/image", "addElement", JRPrintElement.class.getName());
        jRXmlDigester.addFactoryCreate("*/box", JRBoxFactory.class.getName());
        jRXmlDigester.addSetNext("*/box", "setBox", JRBox.class.getName());
        jRXmlDigester.addFactoryCreate("*/image/imageSource", JRPrintImageSourceFactory.class.getName());
        jRXmlDigester.addCallMethod("*/image/imageSource", "setImageSource", 0);
        jRXmlDigester.addFactoryCreate("*/text", JRPrintTextFactory.class.getName());
        jRXmlDigester.addSetNext("*/text", "addElement", JRPrintElement.class.getName());
        SetNestedPropertiesRule setNestedPropertiesRule = new SetNestedPropertiesRule(new String[]{"textContent", "reportElement", "box", "font"}, new String[]{"text"});
        setNestedPropertiesRule.setTrimData(false);
        setNestedPropertiesRule.setAllowUnknownChildElements(true);
        jRXmlDigester.addRule("*/text", setNestedPropertiesRule);
        jRXmlDigester.addFactoryCreate("*/text/font", JRPrintFontFactory.class.getName());
        jRXmlDigester.addSetNext("*/text/font", "setFont", JRFont.class.getName());
        this.addFrameRules(jRXmlDigester);
        this.addHyperlinkParameterRules(jRXmlDigester);
        return jRXmlDigester;
    }

    private void addFrameRules(JRXmlDigester jRXmlDigester) {
        jRXmlDigester.addFactoryCreate("*/frame", JRPrintFrameFactory.class.getName());
        jRXmlDigester.addSetNext("*/frame", "addElement", JRPrintElement.class.getName());
    }

    protected void addHyperlinkParameterRules(JRXmlDigester jRXmlDigester) {
        String string = "*/hyperlinkParameter";
        jRXmlDigester.addFactoryCreate(string, JRPrintHyperlinkParameterFactory.class);
        jRXmlDigester.addSetNext(string, "addHyperlinkParameter", JRPrintHyperlinkParameter.class.getName());
        String string2 = string + "/" + "hyperlinkParameterValue";
        jRXmlDigester.addFactoryCreate(string2, JRPrintHyperlinkParameterValueFactory.class);
        jRXmlDigester.addCallMethod(string2, "setData", 0);
    }

    public void addError(Exception exception) {
        this.errors.add(exception);
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        this.errors.add(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        this.errors.add(sAXParseException);
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        this.errors.add(sAXParseException);
    }
}

