/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.design.JRDesignFont;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.Attributes;

public abstract class JRFontFactory
extends JRBaseFactory {
    private static final String ATTRIBUTE_reportFont = "reportFont";
    private static final String ATTRIBUTE_fontName = "fontName";
    private static final String ATTRIBUTE_isBold = "isBold";
    private static final String ATTRIBUTE_isItalic = "isItalic";
    private static final String ATTRIBUTE_isUnderline = "isUnderline";
    private static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    private static final String ATTRIBUTE_size = "size";
    private static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    private static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    private static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";

    public abstract JRFont getFont();

    @Override
    public Object createObject(Attributes attributes) {
        JRFont jRFont = this.getFont();
        JRXmlLoader jRXmlLoader = (JRXmlLoader)this.digester.peek(this.digester.getCount() - 1);
        JasperDesign jasperDesign = (JasperDesign)this.digester.peek(this.digester.getCount() - 2);
        if (attributes.getValue(ATTRIBUTE_reportFont) != null) {
            Map map = jasperDesign.getFontsMap();
            if (!map.containsKey(attributes.getValue(ATTRIBUTE_reportFont))) {
                jRXmlLoader.addError(new Exception("Unknown report font : " + attributes.getValue(ATTRIBUTE_reportFont)));
            }
            jRFont.setReportFont((JRReportFont)map.get(attributes.getValue(ATTRIBUTE_reportFont)));
        }
        if (attributes.getValue(ATTRIBUTE_fontName) != null) {
            jRFont.setFontName(attributes.getValue(ATTRIBUTE_fontName));
        }
        if (attributes.getValue(ATTRIBUTE_isBold) != null) {
            jRFont.setBold(Boolean.valueOf(attributes.getValue(ATTRIBUTE_isBold)));
        }
        if (attributes.getValue(ATTRIBUTE_isItalic) != null) {
            jRFont.setItalic(Boolean.valueOf(attributes.getValue(ATTRIBUTE_isItalic)));
        }
        if (attributes.getValue(ATTRIBUTE_isUnderline) != null) {
            jRFont.setUnderline(Boolean.valueOf(attributes.getValue(ATTRIBUTE_isUnderline)));
        }
        if (attributes.getValue(ATTRIBUTE_isStrikeThrough) != null) {
            jRFont.setStrikeThrough(Boolean.valueOf(attributes.getValue(ATTRIBUTE_isStrikeThrough)));
        }
        if (attributes.getValue(ATTRIBUTE_size) != null) {
            jRFont.setFontSize(Integer.parseInt(attributes.getValue(ATTRIBUTE_size)));
        }
        if (attributes.getValue(ATTRIBUTE_pdfFontName) != null) {
            jRFont.setPdfFontName(attributes.getValue(ATTRIBUTE_pdfFontName));
        }
        if (attributes.getValue(ATTRIBUTE_pdfEncoding) != null) {
            jRFont.setPdfEncoding(attributes.getValue(ATTRIBUTE_pdfEncoding));
        }
        if (attributes.getValue(ATTRIBUTE_isPdfEmbedded) != null) {
            jRFont.setPdfEmbedded(Boolean.valueOf(attributes.getValue(ATTRIBUTE_isPdfEmbedded)));
        }
        return jRFont;
    }

    public static class ChartFontFactory
    extends JRFontFactory {
        @Override
        public JRFont getFont() {
            return new JRDesignFont();
        }
    }

    public static class TextElementFontFactory
    extends JRFontFactory {
        @Override
        public JRFont getFont() {
            return (JRFont)this.digester.peek();
        }
    }
}

